/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import com.neeve.pkt.PktBody;
import com.neeve.pkt.PktHeader;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderFixed;
import java.util.Properties;

public final class PktSubheaderRR
extends PktSubheaderFixed {
    private static final long REQUEST_MASK = Long.MIN_VALUE;
    private static final long REQUEST_CODE_MASK = 0x3FFFFFFFFFFFFFFL;
    private static final long REPLY_FAIL_MASK = 0L;
    private static final long REPLY_ERRORCODE_MASK = 0x3FFFFFFFFFFFFFFL;
    private static final long REPLY_SUCCESS_MASK = 0x400000000000000L;
    private static final long REPLY_COUNT_MASK = 288230375614840832L;
    private static final long REPLY_NUM_MASK = 0x1FFFFFFFL;
    private static final int REPLY_NUM_BITCOUNT = 29;
    private final int CORRID_POS;
    private final int CODE_POS;

    private PktSubheaderRR(Properties props) {
        super(1, false, 16);
        this.CORRID_POS = 1;
        this.CODE_POS = this.CORRID_POS + 8;
    }

    public static PktBody create(Properties props) {
        return new PktSubheaderRR(props);
    }

    public static PktBody create() {
        return PktSubheaderRR.create(null);
    }

    public static final int getSerializedLength(long addr, int offset) {
        return 17;
    }

    public static boolean prepareReply(PktPacket request, PktPacket reply, int replyCount, int replyNum) {
        PktHeader requestHeader = request.getHeader();
        PktHeader replyHeader = reply.getHeader();
        PktSubheaderRR subheaderRRRequest = requestHeader.getRRSubheader();
        if (subheaderRRRequest != null) {
            PktSubheaderRR subheaderRRReply = replyHeader.activateRRSubheader(false);
            subheaderRRReply.setCorrelationId(subheaderRRRequest.getCorrelationId());
            subheaderRRReply.setReplyWithCountAndNum(replyCount, replyNum);
            return true;
        }
        return false;
    }

    public static boolean prepareReply(PktPacket request, PktPacket reply, long errorCode) {
        PktHeader requestHeader = request.getHeader();
        PktHeader replyHeader = reply.getHeader();
        PktSubheaderRR subheaderRRRequest = requestHeader.getRRSubheader();
        if (subheaderRRRequest != null) {
            PktSubheaderRR subheaderRRReply = replyHeader.activateRRSubheader(false);
            subheaderRRReply.setCorrelationId(subheaderRRRequest.getCorrelationId());
            subheaderRRReply.setReplyWithError(errorCode);
            return true;
        }
        return false;
    }

    public final void setCorrelationId(long corrid) {
        this.buffer.putLong(this.CORRID_POS, corrid);
    }

    public final long getCorrelationId() {
        return this.buffer.getLong(this.CORRID_POS);
    }

    public final void setRequest(long requestCode) {
        long code = Long.MIN_VALUE;
        this.buffer.putLong(this.CODE_POS, code |= requestCode & 0x3FFFFFFFFFFFFFFL);
    }

    public final boolean isRequest() {
        return (this.buffer.getLong(this.CODE_POS) & Long.MIN_VALUE) == Long.MIN_VALUE;
    }

    public final long getRequestCode() {
        if (!this.isRequest()) {
            throw new IllegalStateException("packet is not a request");
        }
        return this.buffer.getLong(this.CODE_POS) & 0x3FFFFFFFFFFFFFFL;
    }

    public final void setReplyWithError(long errorCode) {
        long code = 0L;
        this.buffer.putLong(this.CODE_POS, code |= errorCode & 0x3FFFFFFFFFFFFFFL);
    }

    public final void setReplyWithCountAndNum(int replyCount, int replyNum) {
        long code = 0x400000000000000L;
        code |= ((long)replyCount & 0xFFFFFFFFFFFFFFFFL) << 29;
        this.buffer.putLong(this.CODE_POS, code |= (long)replyNum);
    }

    public final boolean isReply() {
        return !this.isRequest();
    }

    public final boolean isReplySuccess() {
        if (!this.isReply()) {
            throw new IllegalStateException("packet is not a reply");
        }
        return (this.buffer.getLong(this.CODE_POS) & 0x400000000000000L) == 0x400000000000000L;
    }

    public final long getReplyErrorCode() {
        if (this.isReplySuccess()) {
            throw new IllegalStateException("packet is not a failure reply");
        }
        return this.buffer.getLong(this.CODE_POS) & 0x3FFFFFFFFFFFFFFL;
    }

    public final int getReplyCount() {
        if (!this.isReplySuccess()) {
            throw new IllegalStateException("packet is a failure reply");
        }
        return (int)((this.buffer.getLong(this.CODE_POS) & 0x3FFFFFFE0000000L) >>> 29);
    }

    public final int getReplyNum() {
        if (!this.isReplySuccess()) {
            throw new IllegalStateException("packet is a failure reply");
        }
        return (int)(this.buffer.getLong(this.CODE_POS) & 0x1FFFFFFFL);
    }

    public final String toString() {
        if (this.isRequest()) {
            return "rr{" + this.getCorrelationId() + " req " + this.getRequestCode() + "}";
        }
        if (this.isReplySuccess()) {
            return "rr{" + this.getCorrelationId() + " rep(s)<" + this.getReplyNum() + " of " + this.getReplyCount() + ">}";
        }
        return "rr{" + this.getCorrelationId() + " rep(f)<" + this.getReplyErrorCode() + ">}";
    }

    public final boolean equals(Object obj) {
        return this.isRequest() == ((PktSubheaderRR)((Object)obj)).isRequest() && this.getCorrelationId() == ((PktSubheaderRR)((Object)obj)).getCorrelationId();
    }

    public final int hashCode() {
        return (int)this.getCorrelationId();
    }
}

