/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.pkt;

import com.neeve.io.IOBuffer;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSerializable;
import com.neeve.trace.Tracer;
import java.nio.ByteBuffer;

public final class PktSerializer {
    private final PktSerializable.SerializeContext serializeContext = PktSerializable.SerializeContext.create();
    private final PktSerializable.DeserializeContext deserializeContext = PktSerializable.DeserializeContext.create();

    private PktSerializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void serialize(PktPacket packet, IOBuffer buffer, Tracer trace) {
        try {
            packet.serialize(this.serializeContext.addBuffer(buffer), trace);
        }
        finally {
            this.serializeContext.dropBuffers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PktPacket deserialize(ByteBuffer buffer, Tracer trace) {
        this.deserializeContext.setBuffer(buffer.slice());
        try {
            PktPacket pktPacket = PktFactory.getInstance().createPacket(this.deserializeContext.reset(), trace);
            return pktPacket;
        }
        finally {
            this.deserializeContext.setBuffer(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PktPacket deserialize(ByteBuffer buffer, boolean slice, Tracer trace) {
        this.deserializeContext.setBuffer(slice ? buffer.slice() : buffer);
        try {
            PktPacket pktPacket = PktFactory.getInstance().createPacket(this.deserializeContext.reset(), trace);
            return pktPacket;
        }
        finally {
            this.deserializeContext.setBuffer(null);
        }
    }

    public static final PktSerializer create() {
        return new PktSerializer();
    }
}

