/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import cern.colt.function.LongObjectProcedure;
import cern.colt.map.OpenLongObjectHashMap;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxTimeoutException;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkFlushInProgressException;
import com.neeve.link.ELnkInvalidStateException;
import com.neeve.link.ELnkNotJoinedException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ELnkOpRequestFailedException;
import com.neeve.link.ELnkOpTimeoutException;
import com.neeve.link.ELnkReadNotOperationalException;
import com.neeve.link.ELnkSenderInvalidStateException;
import com.neeve.link.ILnkEndpoint;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.ILnkRootEndpoint;
import com.neeve.link.LnkObject;
import com.neeve.link.LnkRequest;
import com.neeve.pkt.PktPacket;
import com.neeve.pkt.PktSubheaderRR;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlReadWriteLock;
import java.util.concurrent.atomic.AtomicLong;

public final class LnkSender
extends LnkObject {
    private final ILnkPeerEndpoint pep;
    private final ILnkEventHandler eventHandler;
    private final OpenLongObjectHashMap requestTable;
    private final UtlReadWriteLock requestTableLock;
    private final Object chainHandler;
    private final Stats stats;
    private State state;

    private LnkSender(ILnkPeerEndpoint pep) throws ELnkException {
        super(null);
        this.threaded = pep.getRootEndpoint().getThreadingModel() != ILnkRootEndpoint.ThreadingModel.strw;
        this.pep = pep;
        this.eventHandler = new EventHandler();
        this.requestTable = new OpenLongObjectHashMap();
        this.requestTableLock = UtlReadWriteLock.create((String)"lnksndreqtbl");
        this.chainHandler = this.pep.getHandlerChain().get(this.eventHandler);
        this.stats = new Stats();
        this.state = State.CLOSED;
    }

    private final LnkRequest addRequest(LnkRequest request) {
        if (this.threaded) {
            this.requestTableLock.getWriteLockUninterrupted();
        }
        try {
            this.requestTable.put(request.getCorrelationId(), (Object)request);
            LnkRequest lnkRequest = request;
            return lnkRequest;
        }
        finally {
            if (this.threaded) {
                this.requestTableLock.releaseLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LnkRequest getRequest(long corrid, boolean destructive) {
        if (this.threaded) {
            if (destructive) {
                this.requestTableLock.getWriteLockUninterrupted();
            } else {
                this.requestTableLock.getReadLockUninterrupted();
            }
        }
        try {
            LnkRequest request = (LnkRequest)this.requestTable.get(corrid);
            if (request != null && destructive) {
                this.requestTable.removeKey(corrid);
            }
            LnkRequest lnkRequest = request;
            return lnkRequest;
        }
        finally {
            if (this.threaded) {
                this.requestTableLock.releaseLock();
            }
        }
    }

    private final void removeRequest(long corrid) {
        if (this.threaded) {
            this.requestTableLock.getWriteLockUninterrupted();
        }
        try {
            this.requestTable.removeKey(corrid);
        }
        finally {
            if (this.threaded) {
                this.requestTableLock.releaseLock();
            }
        }
    }

    final ILnkPeerEndpoint getLink() {
        return this.pep;
    }

    public static LnkSender create(ILnkPeerEndpoint pep) throws ELnkException {
        return new LnkSender(pep);
    }

    public final LnkRequest createRequest(PktPacket packet) {
        return new LnkRequest(this, packet, this.tracer);
    }

    public final void open() throws ELnkException {
        if (this.state != State.CLOSED) {
            throw new ELnkSenderInvalidStateException("open", this.state.toString());
        }
        this.pep.getHandlerChain().push(this.chainHandler);
        this.state = State.OPEN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UtlList sendSync(LnkRequest request, int timeout) throws ELnkException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (this.state == State.OPEN) {
            if (this.pep.getContainer() != null) {
                if (this.pep.isReadOperational()) {
                    if (this.tracer.debug) {
                        this.tracer.log("Preparing request for sending...", Tracer.Level.DEBUG);
                    }
                    request.setActive(this.pep.getContainer().getCurrentReader(), true);
                    if (this.tracer.debug) {
                        this.tracer.log("Adding request to request table..." + request, Tracer.Level.DEBUG);
                    }
                    this.addRequest(request);
                    if (this.tracer.debug) {
                        this.tracer.log("Sending request.." + request, Tracer.Level.DEBUG);
                    }
                    try {
                        this.stats.numRequestsSent.incrementAndGet();
                        this.pep.enque((short)-1, request.getPacket(), null, 16);
                        if (this.pep.getContainer().getCurrentReader() != null) {
                            this.pep.getRootEndpoint().scheduleRead();
                        }
                    }
                    catch (ELnkInvalidStateException e) {
                        this.removeRequest(request.getCorrelationId());
                        this.stats.numRequestsSent.decrementAndGet();
                        throw e;
                    }
                    catch (ELnkNotJoinedException e) {
                        this.removeRequest(request.getCorrelationId());
                        this.stats.numRequestsSent.decrementAndGet();
                        throw e;
                    }
                    catch (ELnkFlushInProgressException e) {
                        this.removeRequest(request.getCorrelationId());
                        this.stats.numRequestsSent.decrementAndGet();
                        throw e;
                    }
                    catch (ELnkOpFailedException e) {
                        this.removeRequest(request.getCorrelationId());
                        this.stats.numRequestsSent.decrementAndGet();
                        throw e;
                    }
                    catch (RuntimeException e) {
                        this.stats.numRequestsSent.decrementAndGet();
                        throw e;
                    }
                    if (request.getDispatcher() != null) {
                        try {
                            if (this.tracer.debug) {
                                this.tracer.log("Waiting for reply [sender is a reader thread <" + request.getDispatcher() + ">].", Tracer.Level.DEBUG);
                            }
                            UtlList replies = (UtlList)request.getDispatcher().run(timeout <= 0 ? -1 : timeout, request.getCompletionChecker());
                            if (this.tracer.debug) {
                                this.tracer.log("Received replies (count=" + replies.count() + ")", Tracer.Level.DEBUG);
                            }
                            return replies;
                        }
                        catch (EEmxTimeoutException e) {
                            if (this.tracer.debug) {
                                this.tracer.log("Request timed out.", Tracer.Level.DEBUG);
                            }
                            throw new ELnkOpTimeoutException();
                        }
                        catch (EEmxException e) {
                            Throwable t;
                            if (this.tracer.debug) {
                                this.tracer.log("Request failed [" + e.toString() + "]", Tracer.Level.DEBUG);
                            }
                            if ((t = e.getCause()) == null) {
                                throw new ELnkOpFailedException((Throwable)((Object)e));
                            }
                            if (t instanceof ELnkOpFailedException) {
                                throw (ELnkOpFailedException)((Object)t);
                            }
                            throw new ELnkOpFailedException(t);
                        }
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("Waiting for reply [sender is not a reader thread].", Tracer.Level.DEBUG);
                    }
                    LnkRequest lnkRequest = request;
                    synchronized (lnkRequest) {
                        while (!request.getCompletionChecker().isDone()) {
                            try {
                                request.wait(timeout <= 0 ? 0L : (long)timeout);
                                if (request.getCompletionChecker().isDone()) continue;
                                if (this.tracer.debug) {
                                    this.tracer.log("Request timed out.", Tracer.Level.DEBUG);
                                }
                                throw new ELnkOpTimeoutException();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                        }
                    }
                    if (request.getResult().getStatus() != null) {
                        if (this.tracer.debug) {
                            this.tracer.log("Request failed [" + request.getResult().getStatus().toString() + "]", Tracer.Level.DEBUG);
                        }
                        throw request.getResult().getStatus();
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("Received replies (count=" + request.getResult().getReplies().count() + ")", Tracer.Level.DEBUG);
                    }
                    return request.getResult().getReplies();
                }
                throw new ELnkReadNotOperationalException();
            }
            throw new ELnkSenderInvalidStateException("sync send", "link not managed by a container");
        }
        throw new ELnkSenderInvalidStateException("sync send", this.state.toString());
    }

    public final void sendPipelined(LnkRequest request, ILnkPeerEndpoint.FlushContext flushContext, int flags) throws ELnkException {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (this.state == State.OPEN) {
            if (this.tracer.debug) {
                this.tracer.log("Preparing request for sending...", Tracer.Level.DEBUG);
            }
            request.setActive(this.pep.getContainer().getCurrentReader(), false);
            if (this.tracer.debug) {
                this.tracer.log("Adding request to request table..." + request, Tracer.Level.DEBUG);
            }
            this.addRequest(request);
            if (this.tracer.debug) {
                this.tracer.log("Sending request (pipelined)...", Tracer.Level.DEBUG);
            }
            try {
                this.stats.numRequestsSent.incrementAndGet();
                this.pep.enque((short)-1, request.getPacket(), flushContext, flags);
            }
            catch (ELnkInvalidStateException e) {
                this.removeRequest(request.getCorrelationId());
                this.stats.numRequestsSent.decrementAndGet();
                throw e;
            }
            catch (ELnkNotJoinedException e) {
                this.removeRequest(request.getCorrelationId());
                this.stats.numRequestsSent.decrementAndGet();
                throw e;
            }
            catch (ELnkFlushInProgressException e) {
                this.removeRequest(request.getCorrelationId());
                this.stats.numRequestsSent.decrementAndGet();
                throw e;
            }
            catch (ELnkOpFailedException e) {
                this.removeRequest(request.getCorrelationId());
                this.stats.numRequestsSent.decrementAndGet();
                throw e;
            }
            catch (RuntimeException e) {
                this.stats.numRequestsSent.decrementAndGet();
                throw e;
            }
        } else {
            throw new ELnkSenderInvalidStateException("pipelined send", this.state.toString());
        }
    }

    public final void sendStreaming(PktPacket packet, ILnkPeerEndpoint.FlushContext flushContext, int flags) throws ELnkException {
        if (this.state != State.OPEN) {
            throw new ELnkSenderInvalidStateException("streaming send", this.state.toString());
        }
        this.pep.enque((short)-1, packet, flushContext, flags);
    }

    public final void close() {
        if (this.state == State.OPEN) {
            try {
                this.pep.getHandlerChain().pop(this.chainHandler);
            }
            catch (ELnkNotJoinedException e) {
                this.tracer.log("Received 'not joined' exception when popping off event handler from handler chain. Ignoring.", Tracer.Level.DIAGNOSE);
            }
        }
    }

    private final class EventHandler
    implements ILnkEventHandler {
        private EventHandler() {
        }

        private final void chainOnwards(IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
            if (((LnkSender)LnkSender.this).tracer.debug) {
                LnkSender.this.tracer.log("Dispatching event <type=" + type + " data=" + data + "> to next handler in chain.", Tracer.Level.DEBUG);
            }
            ILnkEventHandler handler = null;
            try {
                handler = LnkSender.this.pep.getHandlerChain().next(LnkSender.this.chainHandler);
            }
            catch (ELnkNotJoinedException e) {
                LnkSender.this.tracer.log("Received 'not joined' exception when getting next handler in chain.", Tracer.Level.SEVERE);
            }
            if (handler != null) {
                handler.onEvent(dispatcher, ep, type, data);
            } else if (((LnkSender)LnkSender.this).tracer.debug) {
                LnkSender.this.tracer.log("Cannot dispatch. Last handler in chain.", Tracer.Level.DEBUG);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onEvent(final IEmxDispatcher dispatcher, ILnkEndpoint ep, int type, Object data) {
            boolean chainOnwards = true;
            if (type == 5) {
                if (((LnkSender)LnkSender.this).tracer.debug) {
                    LnkSender.this.tracer.log("Received packet " + data, Tracer.Level.DEBUG);
                }
                if (((LnkSender)LnkSender.this).stats.numRequestsSent.get() > ((LnkSender)LnkSender.this).stats.numRepliesReceived) {
                    PktPacket packet = (PktPacket)((Object)data);
                    PktSubheaderRR subheaderRR = packet.getHeader().getRRSubheader();
                    if (subheaderRR != null && subheaderRR.isReply()) {
                        LnkRequest request;
                        boolean complete;
                        boolean bl = complete = !subheaderRR.isReplySuccess() || subheaderRR.getReplyNum() == subheaderRR.getReplyCount();
                        if (((LnkSender)LnkSender.this).tracer.debug) {
                            LnkSender.this.tracer.log("Request complete =  " + complete, Tracer.Level.DEBUG);
                        }
                        if ((request = LnkSender.this.getRequest(subheaderRR.getCorrelationId(), complete)) != null) {
                            if (((LnkSender)LnkSender.this).tracer.debug) {
                                LnkSender.this.tracer.log("Received packet is a reply to request. Processing...", Tracer.Level.DEBUG);
                            }
                            chainOnwards = false;
                            if (subheaderRR.isReplySuccess() && subheaderRR.getReplyNum() == 1) {
                                request.getResult().replyCount = subheaderRR.getReplyCount();
                            }
                            request.onReply(packet);
                            if (complete) {
                                ELnkOpRequestFailedException completionStatus;
                                ++((LnkSender)LnkSender.this).stats.numRepliesReceived;
                                ELnkOpRequestFailedException eLnkOpRequestFailedException = complete ? (!subheaderRR.isReplySuccess() ? new ELnkOpRequestFailedException(subheaderRR.getReplyErrorCode()) : null) : (completionStatus = null);
                                if (!request.onComplete(dispatcher, (Exception)((Object)completionStatus))) {
                                    if (((LnkSender)LnkSender.this).tracer.debug) {
                                        LnkSender.this.tracer.log("Dispatching REQUEST_COMPLETE event...", Tracer.Level.DEBUG);
                                    }
                                    this.chainOnwards(dispatcher, ep, 10, request);
                                }
                            }
                        } else if (((LnkSender)LnkSender.this).tracer.debug) {
                            LnkSender.this.tracer.log("Received packet is not a reply to a registered request.", Tracer.Level.DEBUG);
                        }
                        chainOnwards = false;
                    } else if (((LnkSender)LnkSender.this).tracer.debug) {
                        LnkSender.this.tracer.log("Received packet is NOT a reply to request.", Tracer.Level.DEBUG);
                    }
                } else if (((LnkSender)LnkSender.this).tracer.debug) {
                    LnkSender.this.tracer.log("No outstanding requests.", Tracer.Level.DEBUG);
                }
            } else if (type == 6) {
                UtlList list = (UtlList)data;
                if (((LnkSender)LnkSender.this).tracer.debug) {
                    LnkSender.this.tracer.log("Received packet list. Dispatching each packet in list [size=" + list.count() + "].", Tracer.Level.DEBUG);
                }
                for (UtlListElement element = list.first(); element != null && ((LnkSender)LnkSender.this).stats.numRequestsSent.get() > ((LnkSender)LnkSender.this).stats.numRepliesReceived; element = element.next()) {
                    UtlListElement current = element;
                    PktPacket packet = (PktPacket)current;
                    PktSubheaderRR subheaderRR = packet.getHeader().getRRSubheader();
                    if (subheaderRR == null || !subheaderRR.isReply()) continue;
                    current.unlink();
                    this.onEvent(dispatcher, ep, 5, current);
                }
                chainOnwards = list.count() > 0;
            } else if (type == 8) {
                if (LnkSender.this.threaded) {
                    LnkSender.this.requestTableLock.getWriteLockUninterrupted();
                }
                try {
                    if (((LnkSender)LnkSender.this).tracer.debug) {
                        LnkSender.this.tracer.log("Link has failed. Completing all requests with 'link failure' exception.", Tracer.Level.DEBUG);
                    }
                    ELnkOpFailedException completionStatus = new ELnkOpFailedException("link has failed");
                    LnkSender.this.requestTable.forEachPair(new LongObjectProcedure((Exception)((Object)completionStatus)){
                        final /* synthetic */ Exception val$completionStatus;
                        {
                            this.val$completionStatus = exception;
                        }

                        public final boolean apply(long first, Object second) {
                            LnkRequest request = (LnkRequest)second;
                            request.onComplete(dispatcher, this.val$completionStatus);
                            return true;
                        }
                    });
                    LnkSender.this.requestTable.clear();
                }
                finally {
                    if (LnkSender.this.threaded) {
                        LnkSender.this.requestTableLock.releaseLock();
                    }
                }
            }
            if (chainOnwards) {
                this.chainOnwards(dispatcher, ep, type, data);
            }
        }
    }

    public static final class Stats {
        public AtomicLong numRequestsSent = new AtomicLong();
        public long numRepliesReceived;

        Stats() {
        }
    }

    public static enum State {
        OPEN,
        CLOSED;

    }
}

