/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.link;

import com.neeve.emx.IEmxDispatcher;
import com.neeve.link.ELnkAlreadyJoinedException;
import com.neeve.link.ELnkAlreadyPresentException;
import com.neeve.link.ELnkException;
import com.neeve.link.ELnkFlushInProgressException;
import com.neeve.link.ELnkInvalidStateException;
import com.neeve.link.ELnkMaxUsersReachedException;
import com.neeve.link.ELnkNotCompatibleException;
import com.neeve.link.ELnkNotJoinedException;
import com.neeve.link.ELnkNotOwnerException;
import com.neeve.link.ELnkOpFailedException;
import com.neeve.link.ELnkPrivateException;
import com.neeve.link.ELnkReadOperationalException;
import com.neeve.link.ILnkEventHandler;
import com.neeve.link.ILnkEventHandlerCore;
import com.neeve.link.ILnkMessage;
import com.neeve.link.ILnkPeerEndpoint;
import com.neeve.link.ILnkPeerEndpointCore;
import com.neeve.link.ILnkRootEndpoint;
import com.neeve.link.LnkContainer;
import com.neeve.link.LnkObject;
import com.neeve.link.LnkRegistry;
import com.neeve.pkt.PktPacket;
import com.neeve.root.RootConfig;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlList;
import com.neeve.util.UtlListElement;
import com.neeve.util.UtlProps;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class LnkPeerEndpoint
extends LnkObject
implements ILnkPeerEndpoint {
    private final ILnkPeerEndpointCore pep;
    private final String name;
    private final String type;
    private final boolean privte;
    private final int maxUsers;
    private final Date whenCreated;
    private final User[] users;
    private final WrappedEndpointEventHandler handler;
    private final EventHandlerChain eventHandlerChain;
    private volatile boolean flgFlushPendingAsyncCompletion;
    private volatile int numUsers;
    private volatile int numUsersWaitingOnAsyncFlushCompletion;
    private volatile boolean flgForceFailed;
    private volatile ILnkPeerEndpoint.State state;
    private volatile LnkContainer container;
    private SequenceNumSpace snoSpace;
    private Object attachment;

    private LnkPeerEndpoint(RootConfig.ObjectConfig config, ILnkPeerEndpointCore pep, HashMap<String, Object> props, String type) throws ELnkException {
        super(config);
        this.pep = pep;
        this.type = type;
        this.privte = UtlProps.getValue(props, (String)"private", (boolean)false);
        this.maxUsers = Math.min(Math.max(UtlProps.getValue(props, (String)"maxusers", (int)256), 1), 256);
        this.name = UtlProps.getValue(props, (String)"name", null);
        this.whenCreated = new Date();
        this.users = new User[256];
        this.handler = new WrappedEndpointEventHandler();
        this.eventHandlerChain = new EventHandlerChain(this);
        this.threaded = this.getRootEndpoint().getThreadingModel() != ILnkRootEndpoint.ThreadingModel.strw;
        this.state = ILnkPeerEndpoint.State.CONNECTED;
        this.snoSpace = new SequenceNumSpace();
        if (!this.privte) {
            String containerName = UtlProps.getValue(props, (String)"container", null);
            if (containerName != null && (this.container = LnkRegistry.getInstance().getContainer(containerName)) != null) {
                try {
                    this.container.addLink(this);
                }
                catch (ELnkAlreadyPresentException e) {
                    throw new ELnkException("link '" + this.getName() + "' already present in container '" + containerName + "'");
                }
                catch (ELnkReadOperationalException e) {
                    throw new ELnkException("link '" + this.getName() + "' read is operational");
                }
                catch (ELnkNotCompatibleException e) {
                    throw new ELnkException("link '" + this.getName() + "' is not compatible with container '" + containerName + "'");
                }
            } else if (containerName != null) {
                throw new ELnkException("invalid link container '" + containerName + "'");
            }
        }
        this.pep.setEventHandler(this.handler);
        if (this.tracer.debug) {
            this.tracer.log(this + " Peer endpoint create complete", Tracer.Level.DEBUG);
        }
    }

    public static ILnkPeerEndpoint create(RootConfig.ObjectConfig config, ILnkPeerEndpointCore pep, HashMap<String, Object> props, String type) throws ELnkException {
        return new LnkPeerEndpoint(config, pep, props, type);
    }

    private final short validateAndResolveLtp(short ltp) {
        if (ltp < -1 || ltp > 255) {
            throw new IllegalArgumentException("LTP must be between -1 and 255 both inclusive");
        }
        return ltp == -1 ? this.getLtp() : ltp;
    }

    private final void onEventPacket(IEmxDispatcher dispatcher, Object data) {
        if (this.state == ILnkPeerEndpoint.State.CONNECTED) {
            PktPacket packet = (PktPacket)((Object)data);
            short ltp = packet.getHeader().getDestPort();
            User user = this.users[ltp];
            if (user != null) {
                user.handler.get().onEvent(dispatcher, this, 5, data);
            }
        } else {
            if (this.state == ILnkPeerEndpoint.State.CLOSED || this.state == ILnkPeerEndpoint.State.FAILED) {
                throw new InternalError("Received PACKET event in " + (Object)((Object)this.state) + " state!");
            }
            if (this.tracer.debug) {
                this.tracer.log(this + " Discarding inbound packet [state=" + (Object)((Object)this.state) + "]", Tracer.Level.DEBUG);
            }
        }
    }

    private final void onEventPacketList(IEmxDispatcher dispatcher, Object data) {
        if (this.state == ILnkPeerEndpoint.State.CONNECTED) {
            if (this.maxUsers == 1) {
                if (this.tracer.debug) {
                    this.tracer.log(this + " Dispatching packet list as is.", Tracer.Level.DEBUG);
                }
                for (int i = 0; i < this.users.length; ++i) {
                    User user = this.users[i];
                    if (user == null) continue;
                    user.handler.get().onEvent(dispatcher, this, 6, data);
                    break;
                }
            } else {
                UtlListElement element;
                if (this.tracer.debug) {
                    this.tracer.log(this + " Dispatching individual packets from received packet list.", Tracer.Level.DEBUG);
                }
                UtlList list = (UtlList)data;
                while ((element = list.first()) != null) {
                    element.unlink();
                    if (this.state != ILnkPeerEndpoint.State.CONNECTED) continue;
                    this.onEventPacket(dispatcher, element);
                }
            }
        } else {
            if (this.state == ILnkPeerEndpoint.State.CLOSED || this.state == ILnkPeerEndpoint.State.FAILED) {
                throw new InternalError("Received PACKET LIST event in " + (Object)((Object)this.state) + " state!");
            }
            if (this.tracer.debug) {
                this.tracer.log(this + " Discarding inbound packet list [state=" + (Object)((Object)this.state) + "]", Tracer.Level.DEBUG);
            }
        }
    }

    private final void onEventMessage(IEmxDispatcher dispatcher, Object data) {
        if (this.state == ILnkPeerEndpoint.State.CONNECTED) {
            PktPacket packet = ((ILnkMessage)data).getPacket();
            short ltp = packet.getHeader().getDestPort();
            User user = this.users[ltp];
            if (user != null) {
                user.handler.get().onEvent(dispatcher, this, 11, data);
            }
        } else {
            if (this.state == ILnkPeerEndpoint.State.CLOSED || this.state == ILnkPeerEndpoint.State.FAILED) {
                throw new InternalError("Received MESSAGE event in " + (Object)((Object)this.state) + " state!");
            }
            if (this.tracer.debug) {
                this.tracer.log(this + " Discarding inbound message [state=" + (Object)((Object)this.state) + "]", Tracer.Level.DEBUG);
            }
        }
    }

    private final void onEventMessageList(IEmxDispatcher dispatcher, Object data) {
        if (this.state == ILnkPeerEndpoint.State.CONNECTED) {
            if (this.maxUsers == 1) {
                if (this.tracer.debug) {
                    this.tracer.log(this + " Dispatching message list as is.", Tracer.Level.DEBUG);
                }
                for (int i = 0; i < this.users.length; ++i) {
                    User user = this.users[i];
                    if (user == null) continue;
                    user.handler.get().onEvent(dispatcher, this, 12, data);
                    break;
                }
            } else {
                UtlListElement element;
                if (this.tracer.debug) {
                    this.tracer.log(this + " Dispatching individual messages from received message list.", Tracer.Level.DEBUG);
                }
                UtlList list = (UtlList)data;
                while ((element = list.first()) != null) {
                    element.unlink();
                    if (this.state != ILnkPeerEndpoint.State.CONNECTED) continue;
                    this.onEventMessage(dispatcher, element);
                }
            }
        } else {
            if (this.state == ILnkPeerEndpoint.State.CLOSED || this.state == ILnkPeerEndpoint.State.FAILED) {
                throw new InternalError("Received MESSAGE LIST event in " + (Object)((Object)this.state) + " state!");
            }
            if (this.tracer.debug) {
                this.tracer.log(this + " Discarding inbound message list [state=" + (Object)((Object)this.state) + "]", Tracer.Level.DEBUG);
            }
        }
    }

    private final void onEventFlushCompleteUnprotected(IEmxDispatcher dispatcher, Object data) {
        if (this.state == ILnkPeerEndpoint.State.CONNECTED || this.state == ILnkPeerEndpoint.State.CLOSING) {
            ILnkPeerEndpoint.AsynchronousFlushContext flushContext = (ILnkPeerEndpoint.AsynchronousFlushContext)data;
            if (this.tracer.debug) {
                this.tracer.log(this + " Received flush completion event [flushContext=" + flushContext + "]...", Tracer.Level.DEBUG);
            }
            this.flgFlushPendingAsyncCompletion = false;
            int numWaitingUsers = this.numUsersWaitingOnAsyncFlushCompletion;
            this.numUsersWaitingOnAsyncFlushCompletion = 0;
            if (this.tracer.debug) {
                this.tracer.log(this + " Dispatching flush completion event to users [numWaitingUsers=" + numWaitingUsers + "]...", Tracer.Level.DEBUG);
            }
            int i = 0;
            while (numWaitingUsers > 0) {
                if (this.users[i] != null && this.users[i].pendingFlushContext != null) {
                    ILnkPeerEndpoint.AsynchronousFlushContext userFlushContext = this.users[i].pendingFlushContext;
                    this.users[i].pendingFlushContext = null;
                    if (userFlushContext != flushContext) {
                        userFlushContext.inProgress = false;
                        userFlushContext.syncComplete = false;
                        userFlushContext.status = flushContext.status;
                    }
                    try {
                        this.users[i].handler.get().onEvent(dispatcher, this, 7, userFlushContext);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    --numWaitingUsers;
                }
                ++i;
            }
            if (this.state == ILnkPeerEndpoint.State.CLOSING) {
                if (this.tracer.debug) {
                    this.tracer.log(this + " Close waiting for flush completion. Closing...", Tracer.Level.DEBUG);
                }
                this.closeFinal();
            }
        } else {
            if (this.state == ILnkPeerEndpoint.State.CLOSED) {
                throw new InternalError("Received FLUSH COMPLETION event in CLOSED state!");
            }
            if (this.tracer.debug) {
                this.tracer.log(this + " Discarding flush completion event [state=" + (Object)((Object)this.state) + "]", Tracer.Level.DEBUG);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onEventFlushComplete(IEmxDispatcher dispatcher, Object data) {
        if (this.threaded) {
            LnkPeerEndpoint lnkPeerEndpoint = this;
            synchronized (lnkPeerEndpoint) {
                this.onEventFlushCompleteUnprotected(dispatcher, data);
            }
        } else {
            this.onEventFlushCompleteUnprotected(dispatcher, data);
        }
    }

    private final void onEventFailure(IEmxDispatcher dispatcher, Object data) {
        if (this.state == ILnkPeerEndpoint.State.CONNECTED) {
            this.state = ILnkPeerEndpoint.State.FAILED;
            for (int i = 0; i < this.users.length; ++i) {
                User user = this.users[i];
                if (user == null) continue;
                user.handler.get().onEvent(dispatcher, this, 8, data);
            }
        } else {
            if (this.state == ILnkPeerEndpoint.State.CLOSED) {
                throw new InternalError("Received FAILURE event in CLOSED state!");
            }
            if (this.tracer.debug) {
                this.tracer.log(this + " Discarding failure event [state=" + (Object)((Object)this.state) + "]", Tracer.Level.DEBUG);
            }
        }
    }

    private final void onEventClosure(IEmxDispatcher dispatcher, Object data) {
        if (this.state == ILnkPeerEndpoint.State.CLOSING || this.state == ILnkPeerEndpoint.State.FAILED) {
            if (this.tracer.debug) {
                this.tracer.log(this + " Received closure event. Marking endpoint as closed.", Tracer.Level.DEBUG);
            }
            this.state = ILnkPeerEndpoint.State.CLOSED;
            if (this.container != null) {
                try {
                    this.container.removeLink(this.getName(), 1);
                }
                catch (ELnkReadOperationalException e) {
                    throw new InternalError("Received an 'read operational' exception when removing a closed link from container!");
                }
            }
        } else {
            throw new InternalError("Received CLOSURE event in " + (Object)((Object)this.state) + " state!");
        }
    }

    private final void onEventOther(IEmxDispatcher dispatcher, Object data) {
    }

    private final void closeFinal() {
        block2: {
            try {
                this.pep.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                if (!this.tracer.debug) break block2;
                this.tracer.log(this + " Failure in closing wrapped endpoint [error=" + e.toString() + "].", Tracer.Level.DEBUG);
            }
        }
    }

    private final void updatePendingFlushContexts(short ltp, boolean syncFlush, ILnkPeerEndpoint.FlushContext flushContext) throws ELnkFlushInProgressException {
        if (!syncFlush && this.users[ltp].pendingFlushContext == null) {
            ILnkPeerEndpoint.AsynchronousFlushContext userFlushContext = this.users[ltp].pendingFlushContext = (ILnkPeerEndpoint.AsynchronousFlushContext)flushContext;
            if (!userFlushContext.inProgress) {
                userFlushContext.inProgress = true;
                userFlushContext.syncComplete = false;
                userFlushContext.status = null;
            }
            ++this.numUsersWaitingOnAsyncFlushCompletion;
        } else {
            throw new ELnkFlushInProgressException();
        }
    }

    private final void setContainerUnprotected(LnkContainer newContainer) throws ELnkInvalidStateException, ELnkPrivateException, ELnkReadOperationalException, ELnkNotCompatibleException {
        if (this.tracer.debug) {
            this.tracer.log(this + " Migrating to container " + (Object)((Object)newContainer) + "...", Tracer.Level.DEBUG);
        }
        if (this.state == ILnkPeerEndpoint.State.CONNECTED || this.state == ILnkPeerEndpoint.State.FAILED) {
            if (newContainer != this.container) {
                if (!this.privte) {
                    if (this.container != null && this.container.removeLink(this.getName(), 0) != this) {
                        throw new InternalError("Removal of link from container removed a different link!");
                    }
                    try {
                        if (newContainer != null) {
                            newContainer.addLink(this);
                        }
                        this.container = newContainer;
                    }
                    catch (ELnkAlreadyPresentException e) {
                        throw new InternalError("Received an 'already present' exception when adding link to new container!");
                    }
                    catch (ELnkReadOperationalException e) {
                        throw new InternalError("Received an 'read operational' exception when adding link to new container!");
                    }
                    catch (ELnkNotCompatibleException e) {
                        try {
                            this.container.addLink(this);
                        }
                        catch (Exception e1) {
                            throw new InternalError("Received exception [" + e1.toString() + "] when readding endpoint to container on migrate failure!");
                        }
                        throw e;
                    }
                }
                if (this.tracer.debug) {
                    this.tracer.log(this + " Endpoint is private. Cannot migrate.", Tracer.Level.DEBUG);
                }
                throw new ELnkPrivateException();
            }
        } else {
            if (this.tracer.debug) {
                this.tracer.log(this + " Invalid state on container migrate [state=" + (Object)((Object)this.state) + "].", Tracer.Level.DEBUG);
            }
            throw new ELnkInvalidStateException("set container", this.state.toString());
        }
    }

    private final int getEnqueuedSizeUnprotected() throws ELnkInvalidStateException {
        if (this.state == ILnkPeerEndpoint.State.CONNECTED || this.state == ILnkPeerEndpoint.State.FAILED) {
            return this.pep.getEnqueuedSize();
        }
        throw new ELnkInvalidStateException("set event handler", this.state.toString());
    }

    private final boolean isJoinedUnprotected(short ltp) {
        short resolvedLtp = this.validateAndResolveLtp(ltp);
        return this.users[resolvedLtp] != null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void joinUnprotected(short ltp, ILnkEventHandler handler) throws ELnkInvalidStateException, ELnkAlreadyJoinedException, ELnkMaxUsersReachedException {
        short resolvedLtp = this.validateAndResolveLtp(ltp);
        if (this.tracer.debug) {
            this.tracer.log(this + " User [ltp=" + resolvedLtp + "] is joining...", Tracer.Level.DEBUG);
        }
        if (this.state == ILnkPeerEndpoint.State.CONNECTED) {
            if (this.users[resolvedLtp] != null) {
                if (!this.tracer.debug) throw new ELnkAlreadyJoinedException(resolvedLtp);
                this.tracer.log(this + " User already joined.", Tracer.Level.DEBUG);
                throw new ELnkAlreadyJoinedException(resolvedLtp);
            }
            if (this.numUsers >= this.maxUsers) {
                if (!this.tracer.debug) throw new ELnkMaxUsersReachedException();
                this.tracer.log(this + " Max users already reached [max=" + this.maxUsers + "].", Tracer.Level.DEBUG);
                throw new ELnkMaxUsersReachedException();
            }
            if (resolvedLtp != this.getLtp()) {
                this.pep.join(resolvedLtp);
            }
            this.users[resolvedLtp] = new User(ltp, handler);
            ++this.numUsers;
            if (resolvedLtp == this.getLtp()) {
                this.eventHandlerChain.open(handler);
            }
            if (!this.tracer.debug) return;
            this.tracer.log(this + " User [ltp=" + resolvedLtp + "] has joined.", Tracer.Level.DEBUG);
            return;
        }
        if (this.state != ILnkPeerEndpoint.State.FAILED) {
            if (!this.tracer.debug) throw new ELnkInvalidStateException("join", this.state.toString());
            this.tracer.log(this + " Invalid state on join [state=" + (Object)((Object)this.state) + "].", Tracer.Level.DEBUG);
            throw new ELnkInvalidStateException("join", this.state.toString());
        }
        if (!this.tracer.debug) return;
        this.tracer.log(this + " Endpoint has failed.", Tracer.Level.DEBUG);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void leaveUnprotected(short ltp, int flags) throws ELnkInvalidStateException, ELnkNotJoinedException, ELnkFlushInProgressException, ELnkOpFailedException {
        boolean flgSuppressClose;
        short resolvedLtp = this.validateAndResolveLtp(ltp);
        boolean flgAllowFlushPending = (flags & 1) == 1;
        boolean bl = flgSuppressClose = (flags & 2) == 2;
        if (this.tracer.debug) {
            this.tracer.log(this + " User [ltp=" + resolvedLtp + "] is leaving...", Tracer.Level.DEBUG);
        }
        if (this.state != ILnkPeerEndpoint.State.CONNECTED && this.state != ILnkPeerEndpoint.State.FAILED) {
            if (!this.tracer.debug) throw new ELnkInvalidStateException("leave", this.state.toString());
            this.tracer.log(this + " Invalid state on leave [state=" + (Object)((Object)this.state) + "].", Tracer.Level.DEBUG);
            throw new ELnkInvalidStateException("leave", this.state.toString());
        }
        if (this.users[resolvedLtp] == null) {
            if (!this.tracer.debug) throw new ELnkNotJoinedException(resolvedLtp);
            this.tracer.log(this + " User not joined.", Tracer.Level.DEBUG);
            throw new ELnkNotJoinedException(resolvedLtp);
        }
        if (!flgAllowFlushPending && this.users[resolvedLtp].pendingFlushContext != null) {
            if (!this.tracer.debug) throw new ELnkFlushInProgressException();
            this.tracer.log(this + " Flush pending async completion.", Tracer.Level.DEBUG);
            throw new ELnkFlushInProgressException();
        }
        if (this.users[resolvedLtp].pendingFlushContext != null) {
            --this.numUsersWaitingOnAsyncFlushCompletion;
        }
        this.users[resolvedLtp] = null;
        --this.numUsers;
        if (resolvedLtp != this.getLtp()) {
            this.pep.leave(resolvedLtp);
        }
        if (resolvedLtp == this.getLtp()) {
            this.eventHandlerChain.close();
        }
        if (!flgSuppressClose) {
            this.closeUnprotected(resolvedLtp, false);
        }
        if (!this.tracer.debug) return;
        this.tracer.log(this + " User [ltp=" + resolvedLtp + "] has left.", Tracer.Level.DEBUG);
    }

    private final boolean enqueUnprotected(short ltp, PktPacket packet, ILnkPeerEndpoint.FlushContext flushContext, int flags) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkNotJoinedException, ELnkFlushInProgressException, ELnkOpFailedException {
        ILnkPeerEndpoint.State state;
        boolean flgFlushForce;
        short resolvedLtp = this.validateAndResolveLtp(ltp);
        boolean syncBlockingFlush = flushContext == null || flushContext.flushMode == ILnkPeerEndpoint.FlushContext.FlushMode.SYNC_BLOCKING;
        boolean syncNonBlockingFlush = flushContext != null && flushContext.flushMode == ILnkPeerEndpoint.FlushContext.FlushMode.SYNC_NON_BLOCKING;
        boolean syncFlush = syncBlockingFlush || syncNonBlockingFlush;
        boolean flgFlushSuppress = (flags & 8) == 8;
        boolean bl = flgFlushForce = !flgFlushSuppress && (flags & 0x10) == 16;
        if (this.tracer.debug) {
            this.tracer.log(this + " Enqueuing packet [packet=" + (Object)((Object)packet) + " flushSuppress=" + flgFlushSuppress + " syncFlush=" + syncFlush + "]...", Tracer.Level.DEBUG);
        }
        if ((state = this.state) == ILnkPeerEndpoint.State.CONNECTED) {
            if (this.users[resolvedLtp] != null) {
                if (!this.flgFlushPendingAsyncCompletion) {
                    boolean flushed = false;
                    if (!this.flgForceFailed) {
                        if (flgFlushForce) {
                            flags |= 8;
                        }
                        flags &= 0xFFFFFFEF;
                        if (packet.getHeader().getSrcPort() == 0) {
                            packet.getHeader().setSrcPort(this.getLtp());
                        }
                        if (packet.getHeader().getDestPort() == 0) {
                            packet.getHeader().setDestPort(this.pep.getPeerLtp());
                        }
                        if (!(flushed = this.pep.enque(packet, flushContext, flags)) && flgFlushForce) {
                            if (this.tracer.debug) {
                                this.tracer.log(this + " Enque did not auto-flush and force flush is set. Flushing....", Tracer.Level.DEBUG);
                            }
                            this.pep.flush(flushContext);
                            flushed = true;
                        }
                        if (flushed && !syncFlush && ((ILnkPeerEndpoint.AsynchronousFlushContext)flushContext).inProgress) {
                            if (this.tracer.debug) {
                                this.tracer.log(this + " Enque did auto-flush, flush is async and flushing pending completion. Recording flush context.", Tracer.Level.DEBUG);
                            }
                            this.flgFlushPendingAsyncCompletion = true;
                            this.updatePendingFlushContexts(resolvedLtp, syncFlush, flushContext);
                        }
                    } else if (this.tracer.debug) {
                        this.tracer.log(this + " Endpoint has been force failed. Ignoring enque request.", Tracer.Level.DEBUG);
                    }
                    if (this.tracer.debug) {
                        this.tracer.log(this + " Enque complete [flushed=" + flushed + "].", Tracer.Level.DEBUG);
                    }
                    return flushed;
                }
                if (this.tracer.debug) {
                    this.tracer.log(this + " Flush pending asynchronous completion. Recording flush context.", Tracer.Level.DEBUG);
                }
                this.updatePendingFlushContexts(resolvedLtp, syncFlush, flushContext);
                return true;
            }
            if (this.tracer.debug) {
                this.tracer.log(this + " User not joined.", Tracer.Level.DEBUG);
            }
            throw new ELnkNotJoinedException(resolvedLtp);
        }
        if (state != ILnkPeerEndpoint.State.FAILED) {
            if (this.tracer.debug) {
                this.tracer.log(this + " Invalid state on enque [state=" + (Object)((Object)state) + "].", Tracer.Level.DEBUG);
            }
            throw new ELnkInvalidStateException("enque", state.toString());
        }
        if (this.tracer.debug) {
            this.tracer.log(this + " Endpoint has failed.", Tracer.Level.DEBUG);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void flushUnprotected(short ltp, ILnkPeerEndpoint.FlushContext flushContext) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkNotJoinedException, ELnkFlushInProgressException, ELnkOpFailedException {
        boolean syncFlush;
        short resolvedLtp = this.validateAndResolveLtp(ltp);
        boolean syncBlockingFlush = flushContext == null || flushContext.flushMode == ILnkPeerEndpoint.FlushContext.FlushMode.SYNC_BLOCKING;
        boolean syncNonBlockingFlush = flushContext != null && flushContext.flushMode == ILnkPeerEndpoint.FlushContext.FlushMode.SYNC_NON_BLOCKING;
        boolean bl = syncFlush = syncBlockingFlush || syncNonBlockingFlush;
        if (this.tracer.debug) {
            this.tracer.log(this + " Flushing endpoint [syncFlush=" + syncFlush + "]...", Tracer.Level.DEBUG);
        }
        if (this.state == ILnkPeerEndpoint.State.CONNECTED) {
            if (this.users[resolvedLtp] == null) {
                if (!this.tracer.debug) throw new ELnkNotJoinedException(resolvedLtp);
                this.tracer.log(this + " User not joined.", Tracer.Level.DEBUG);
                throw new ELnkNotJoinedException(resolvedLtp);
            }
            if (!this.flgFlushPendingAsyncCompletion) {
                if (this.flgForceFailed) {
                    if (!this.tracer.debug) return;
                    this.tracer.log(this + " Endpoint has been force failed. Ignoring flush request.", Tracer.Level.DEBUG);
                    return;
                }
                this.pep.flush(flushContext);
                if (!syncFlush && ((ILnkPeerEndpoint.AsynchronousFlushContext)flushContext).inProgress) {
                    if (this.tracer.debug) {
                        this.tracer.log(this + " Flush is async and flushing pending completion. Recording flush context.", Tracer.Level.DEBUG);
                    }
                    this.flgFlushPendingAsyncCompletion = true;
                    this.updatePendingFlushContexts(resolvedLtp, syncFlush, flushContext);
                }
                if (!this.tracer.debug) return;
                this.tracer.log(this + " Flush complete.", Tracer.Level.DEBUG);
                return;
            }
            if (this.tracer.debug) {
                this.tracer.log(this + " Flush pending asynchronous completion. Recording flush context.", Tracer.Level.DEBUG);
            }
            this.updatePendingFlushContexts(resolvedLtp, syncFlush, flushContext);
            return;
        }
        if (this.state != ILnkPeerEndpoint.State.FAILED) {
            if (!this.tracer.debug) throw new ELnkInvalidStateException("flush", this.state.toString());
            this.tracer.log(this + " Invalid state on flush [state=" + (Object)((Object)this.state) + "].", Tracer.Level.DEBUG);
            throw new ELnkInvalidStateException("flush", this.state.toString());
        }
        if (!this.tracer.debug) return;
        this.tracer.log(this + " Endpoint has failed.", Tracer.Level.DEBUG);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void failUnprotected(Exception e) throws ELnkInvalidStateException, ELnkOpFailedException {
        if (this.tracer.debug) {
            this.tracer.log(this + " Failing endpoint <endpoint=" + this + "> [e=" + e.toString() + "]...", Tracer.Level.DEBUG);
        }
        if (this.state == ILnkPeerEndpoint.State.CONNECTED) {
            if (this.isReadOperational()) {
                this.flgForceFailed = true;
                if (!this.tracer.debug) return;
                this.tracer.log(this + " Fail complete.", Tracer.Level.DEBUG);
                return;
            }
            if (!this.tracer.debug) throw new ELnkInvalidStateException("set event handler", "read not started");
            this.tracer.log(this + " Invalid state on fail [read is not operational].", Tracer.Level.DEBUG);
            throw new ELnkInvalidStateException("set event handler", "read not started");
        }
        if (this.state != ILnkPeerEndpoint.State.FAILED) {
            if (!this.tracer.debug) throw new ELnkInvalidStateException("fail", this.state.toString());
            this.tracer.log(this + " Invalid state on fail [state=" + (Object)((Object)this.state) + "].", Tracer.Level.DEBUG);
            throw new ELnkInvalidStateException("fail", this.state.toString());
        }
        if (!this.tracer.debug) return;
        this.tracer.log(this + " Endpoint already failed.", Tracer.Level.DEBUG);
    }

    private final void closeUnprotected(short ltp, boolean flgLeave) throws ELnkOpFailedException {
        if (this.tracer.debug) {
            this.tracer.log(this + " Closing endpoint [ltp=" + ltp + " leave=" + flgLeave + "]...", Tracer.Level.DEBUG);
        }
        if (this.state != ILnkPeerEndpoint.State.CLOSING && this.state != ILnkPeerEndpoint.State.CLOSED) {
            int i;
            if (flgLeave) {
                try {
                    this.leave(ltp, 3);
                }
                catch (ELnkNotJoinedException eLnkNotJoinedException) {
                }
                catch (ELnkFlushInProgressException e) {
                    throw new InternalError("leave reported 'flush in progress' when explictly asked to allow flush to be pending");
                }
            }
            for (i = 0; i < this.users.length && this.users[i] == null; ++i) {
            }
            if (i == this.users.length) {
                if (this.tracer.debug) {
                    this.tracer.log(this + " All endpoint users have left. Proceeding to close...", Tracer.Level.DEBUG);
                }
                this.state = ILnkPeerEndpoint.State.CLOSING;
                if (!this.flgFlushPendingAsyncCompletion) {
                    if (this.tracer.debug) {
                        this.tracer.log(this + " Flush not pending async completion. Closing...", Tracer.Level.DEBUG);
                    }
                    this.closeFinal();
                } else if (this.tracer.debug) {
                    this.tracer.log(this + " Flush still pending async completion. Waiting for flush to complete before closing.", Tracer.Level.DEBUG);
                }
            } else if (this.tracer.debug) {
                this.tracer.log(this + " Some users are still joined. Not closing now.", Tracer.Level.DEBUG);
            }
        } else if (this.tracer.debug) {
            this.tracer.log(this + " Endpoint already closing or closed [state=" + (Object)((Object)this.state) + "].", Tracer.Level.DEBUG);
        }
    }

    final ILnkEventHandler swap(ILnkEventHandler handler) throws ELnkInvalidStateException, ELnkNotJoinedException {
        if (this.tracer.debug) {
            this.tracer.log(this + " End user [ltp=" + this.getLtp() + "] is swapping handlers.", Tracer.Level.DEBUG);
        }
        if (this.state == ILnkPeerEndpoint.State.CONNECTED || this.state == ILnkPeerEndpoint.State.FAILED) {
            if (this.users[this.getLtp()] != null) {
                if (this.tracer.debug) {
                    this.tracer.log(this + " End user [ltp=" + this.getLtp() + "] has swapped handlers", Tracer.Level.DEBUG);
                }
                return this.users[this.getLtp()].handler.getAndSet(handler);
            }
            if (this.tracer.debug) {
                this.tracer.log(this + " End user not joined.", Tracer.Level.DEBUG);
            }
            throw new ELnkNotJoinedException(this.getLtp());
        }
        if (this.tracer.debug) {
            this.tracer.log(this + " Invalid state on swap [state=" + (Object)((Object)this.state) + "].", Tracer.Level.DEBUG);
        }
        throw new ELnkInvalidStateException("swap", this.state.toString());
    }

    @Override
    public final void setAttachment(Object object) {
        this.attachment = object;
    }

    @Override
    public final Object getAttachment() {
        return this.attachment;
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : this.pep.getName();
    }

    @Override
    public String getNameInternal() {
        return this.pep.getName();
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public short getLtp() {
        return this.pep.getLtp();
    }

    @Override
    public final Date getWhenCreated() {
        return this.whenCreated;
    }

    @Override
    public final ILnkPeerEndpoint.State getState() {
        return this.state;
    }

    @Override
    public final long getNextSequenceNum() {
        return this.snoSpace.next();
    }

    @Override
    public final ILnkPeerEndpoint.EventHandlerChain getHandlerChain() {
        return this.eventHandlerChain;
    }

    @Override
    public final boolean isGroupEndpoint() {
        return this.pep.isGroupEndpoint();
    }

    @Override
    public final boolean isRootEndpoint() {
        return this.pep.isRootEndpoint();
    }

    @Override
    public final ILnkRootEndpoint getRootEndpoint() {
        return this.pep.getRootEndpoint();
    }

    @Override
    public final boolean isReadOperational() {
        return this.pep.getRootEndpoint().isReadOperational();
    }

    @Override
    public final LnkContainer getContainer() {
        return this.container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setContainer(LnkContainer container) throws ELnkInvalidStateException, ELnkPrivateException, ELnkReadOperationalException, ELnkNotCompatibleException {
        if (this.threaded) {
            LnkPeerEndpoint lnkPeerEndpoint = this;
            synchronized (lnkPeerEndpoint) {
                this.setContainerUnprotected(container);
            }
        } else {
            this.setContainerUnprotected(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getEnqueuedSize() throws ELnkInvalidStateException {
        if (this.threaded) {
            LnkPeerEndpoint lnkPeerEndpoint = this;
            synchronized (lnkPeerEndpoint) {
                return this.getEnqueuedSizeUnprotected();
            }
        }
        return this.getEnqueuedSizeUnprotected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean isJoined(short ltp) {
        if (this.threaded) {
            LnkPeerEndpoint lnkPeerEndpoint = this;
            synchronized (lnkPeerEndpoint) {
                return this.isJoinedUnprotected(ltp);
            }
        }
        return this.isJoinedUnprotected(ltp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void join(short ltp, ILnkEventHandler handler) throws ELnkInvalidStateException, ELnkAlreadyJoinedException, ELnkMaxUsersReachedException {
        if (this.threaded) {
            LnkPeerEndpoint lnkPeerEndpoint = this;
            synchronized (lnkPeerEndpoint) {
                EventHandlerChain eventHandlerChain = this.eventHandlerChain;
                synchronized (eventHandlerChain) {
                    this.joinUnprotected(ltp, handler);
                }
            }
        }
        this.joinUnprotected(ltp, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void leave(short ltp, int flags) throws ELnkInvalidStateException, ELnkFlushInProgressException, ELnkNotJoinedException, ELnkOpFailedException {
        if (this.threaded) {
            LnkPeerEndpoint lnkPeerEndpoint = this;
            synchronized (lnkPeerEndpoint) {
                EventHandlerChain eventHandlerChain = this.eventHandlerChain;
                synchronized (eventHandlerChain) {
                    this.leaveUnprotected(ltp, flags);
                }
            }
        }
        this.leaveUnprotected(ltp, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean enque(short ltp, PktPacket packet, ILnkPeerEndpoint.FlushContext flushContext, int flags) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkNotJoinedException, ELnkFlushInProgressException, ELnkOpFailedException {
        if (this.threaded) {
            LnkPeerEndpoint lnkPeerEndpoint = this;
            synchronized (lnkPeerEndpoint) {
                return this.enqueUnprotected(ltp, packet, flushContext, flags);
            }
        }
        return this.enqueUnprotected(ltp, packet, flushContext, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush(short ltp, ILnkPeerEndpoint.FlushContext flushContext) throws ELnkInvalidStateException, ELnkNotOwnerException, ELnkNotJoinedException, ELnkFlushInProgressException, ELnkOpFailedException {
        if (this.threaded) {
            LnkPeerEndpoint lnkPeerEndpoint = this;
            synchronized (lnkPeerEndpoint) {
                this.flushUnprotected(ltp, flushContext);
            }
        } else {
            this.flushUnprotected(ltp, flushContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void fail(Exception e) throws ELnkInvalidStateException, ELnkOpFailedException {
        if (this.threaded) {
            LnkPeerEndpoint lnkPeerEndpoint = this;
            synchronized (lnkPeerEndpoint) {
                this.failUnprotected(e);
            }
        } else {
            this.failUnprotected(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close(short ltp) throws ELnkOpFailedException {
        if (this.threaded) {
            LnkPeerEndpoint lnkPeerEndpoint = this;
            synchronized (lnkPeerEndpoint) {
                this.closeUnprotected(ltp, true);
            }
        } else {
            this.closeUnprotected(ltp, true);
        }
    }

    public final String toString() {
        return "[" + this.getName() + " '" + this.getType() + "' ltp=" + this.getLtp() + " " + (Object)((Object)this.state) + "]";
    }

    private final class EventHandlerChain
    implements ILnkPeerEndpoint.EventHandlerChain {
        private final LnkPeerEndpoint pep;
        private final UtlList list;
        private final boolean threaded;
        private boolean flgOpen;

        EventHandlerChain(LnkPeerEndpoint pep) {
            this.pep = pep;
            this.list = UtlList.create();
            this.threaded = pep.getRootEndpoint().getThreadingModel() != ILnkRootEndpoint.ThreadingModel.strw;
        }

        private final Handler getUnprotected(ILnkEventHandler eventHandler) throws ELnkNotJoinedException {
            if (this.flgOpen) {
                return new Handler(eventHandler);
            }
            throw new ELnkNotJoinedException(this.pep.getLtp());
        }

        private final void pushUnprotected(Handler handler) throws ELnkNotJoinedException {
            if (this.flgOpen) {
                if (handler.isLinked()) {
                    throw new IllegalArgumentException("handler already belongs to a chain");
                }
            } else {
                throw new ELnkNotJoinedException(this.pep.getLtp());
            }
            this.list.prepend((UtlListElement)handler);
            this.pep.swap(handler.eventHandler);
        }

        private final ILnkEventHandler nextUnprotected(Handler handler) throws ELnkNotJoinedException {
            if (this.flgOpen) {
                if (handler.head != this.list) {
                    throw new IllegalArgumentException("handler does not belong to the chain");
                }
                return handler.head == this.list ? ((Handler)handler.next()).eventHandler : null;
            }
            throw new ELnkNotJoinedException(this.pep.getLtp());
        }

        private final void popUnprotected(Handler handler) throws ELnkNotJoinedException {
            if (this.flgOpen) {
                if (handler.head != this.list) {
                    throw new IllegalArgumentException("handler does not belong to the chain");
                }
                if (handler == this.list.first()) {
                    handler.unlink();
                    this.pep.swap(((Handler)this.list.first()).eventHandler);
                } else {
                    handler.unlink();
                }
            } else {
                throw new ELnkNotJoinedException(this.pep.getLtp());
            }
        }

        private final int countUnprotected() {
            return this.list.count();
        }

        final void open(ILnkEventHandler eventHandler) {
            this.flgOpen = true;
            try {
                this.list.append((UtlListElement)this.getUnprotected(eventHandler));
                if (this.list.count() != 1) {
                    throw new InternalError("Handler chain list size != 1 on open! [size=" + this.list.count() + "]");
                }
            }
            catch (ELnkNotJoinedException e) {
                throw new InternalError("Received 'not joined' exception when open() is called from join()!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final Object get(ILnkEventHandler eventHandler) throws ELnkNotJoinedException {
            try {
                if (this.threaded) {
                    EventHandlerChain eventHandlerChain = this;
                    synchronized (eventHandlerChain) {
                        return this.getUnprotected(eventHandler);
                    }
                }
                return this.getUnprotected(eventHandler);
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Specified object is not a chain handler");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void push(Object handler) throws ELnkNotJoinedException {
            block6: {
                try {
                    if (this.threaded) {
                        EventHandlerChain eventHandlerChain = this;
                        synchronized (eventHandlerChain) {
                            this.pushUnprotected((Handler)((Object)handler));
                            break block6;
                        }
                    }
                    this.pushUnprotected((Handler)((Object)handler));
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Specified object is not a chain handler");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final ILnkEventHandler next(Object handler) throws ELnkNotJoinedException {
            try {
                if (this.threaded) {
                    EventHandlerChain eventHandlerChain = this;
                    synchronized (eventHandlerChain) {
                        return this.nextUnprotected((Handler)((Object)handler));
                    }
                }
                return this.nextUnprotected((Handler)((Object)handler));
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException("Specified object is not a chain handler");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void pop(Object handler) throws ELnkNotJoinedException {
            block6: {
                try {
                    if (this.threaded) {
                        EventHandlerChain eventHandlerChain = this;
                        synchronized (eventHandlerChain) {
                            this.popUnprotected((Handler)((Object)handler));
                            break block6;
                        }
                    }
                    this.popUnprotected((Handler)((Object)handler));
                }
                catch (ClassCastException e) {
                    throw new IllegalArgumentException("Specified object is not a chain handler");
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final int count() {
            if (this.threaded) {
                EventHandlerChain eventHandlerChain = this;
                synchronized (eventHandlerChain) {
                    return this.countUnprotected();
                }
            }
            return this.countUnprotected();
        }

        final void close() {
            this.flgOpen = false;
            this.list.clear();
        }

        private final class Handler
        extends UtlListElement {
            final ILnkEventHandler eventHandler;

            Handler(ILnkEventHandler eventHandler) {
                this.eventHandler = eventHandler;
            }
        }
    }

    private final class WrappedEndpointEventHandler
    implements ILnkEventHandlerCore {
        private WrappedEndpointEventHandler() {
        }

        @Override
        public final void onEvent(IEmxDispatcher dispatcher, int type, Object data) {
            switch (type) {
                case 5: {
                    LnkPeerEndpoint.this.onEventPacket(dispatcher, data);
                    break;
                }
                case 6: {
                    LnkPeerEndpoint.this.onEventPacketList(dispatcher, data);
                    break;
                }
                case 11: {
                    LnkPeerEndpoint.this.onEventMessage(dispatcher, data);
                    break;
                }
                case 12: {
                    LnkPeerEndpoint.this.onEventMessageList(dispatcher, data);
                    break;
                }
                case 7: {
                    LnkPeerEndpoint.this.onEventFlushComplete(dispatcher, data);
                    break;
                }
                case 8: {
                    LnkPeerEndpoint.this.onEventFailure(dispatcher, data);
                    break;
                }
                case 9: {
                    LnkPeerEndpoint.this.onEventClosure(dispatcher, data);
                    break;
                }
                default: {
                    LnkPeerEndpoint.this.onEventOther(dispatcher, data);
                }
            }
        }
    }

    private final class User {
        final short ltp;
        final AtomicReference<ILnkEventHandler> handler;
        ILnkPeerEndpoint.AsynchronousFlushContext pendingFlushContext;

        User(short ltp, ILnkEventHandler handler) {
            this.ltp = ltp;
            this.handler = new AtomicReference<ILnkEventHandler>(handler);
            this.pendingFlushContext = null;
        }
    }

    private final class SequenceNumSpace {
        private final AtomicLong sno1;
        private long sno2;

        SequenceNumSpace() {
            if (LnkPeerEndpoint.this.threaded) {
                this.sno1 = new AtomicLong(1L);
                this.sno2 = 1L;
            } else {
                this.sno1 = null;
                this.sno2 = 1L;
            }
        }

        final long next() {
            if (LnkPeerEndpoint.this.threaded) {
                return this.sno1.getAndIncrement();
            }
            return this.sno2++;
        }
    }
}

