/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.test.unit;

import com.neeve.ci.XRuntime;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxInvalidStateException;
import com.neeve.emx.EEmxNwLnkOpFailedException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.EmxNwLnkOpWaitCond;
import com.neeve.emx.IEmxNwConnectReadyEvent;
import com.neeve.emx.IEmxNwLnkClientEndpoint;
import com.neeve.emx.IEmxNwLnkPeerEndpoint;
import com.neeve.emx.IEmxNwLnkServerEndpoint;
import com.neeve.emx.test.unit.EmxNwLnkEndpointTest;
import org.junit.Ignore;
import org.junit.Test;

public final class EmxNwLnkClientEndpointTest
extends EmxNwLnkEndpointTest {
    static IEmxNwLnkPeerEndpoint connect(IEmxNwLnkClientEndpoint cep, EmxNwLnkOpWaitCond waitCond) throws Exception {
        IEmxNwLnkPeerEndpoint pep = null;
        while ((pep = cep.connect(waitCond)) == null) {
        }
        return pep;
    }

    static IEmxNwConnectReadyEvent prepareNwConnectReadyEvent(IEmxNwLnkClientEndpoint cep) throws Exception {
        EmxNwLnkOpWaitCond waitCond = new EmxNwLnkOpWaitCond();
        IEmxNwLnkPeerEndpoint pep = cep.connect(waitCond);
        if (pep != null) {
            pep.close();
            EmxNwLnkClientEndpointTest.testFailure((String)"Unable to prepare a network connect ready event!");
        }
        return (IEmxNwConnectReadyEvent)waitCond.list().get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void testConnect(IEmxNwLnkClientEndpoint cep, String desc, Exception exp) throws Exception {
        IEmxNwLnkPeerEndpoint pep;
        block7: {
            pep = null;
            try {
                EmxNwLnkOpWaitCond waitCond = new EmxNwLnkOpWaitCond();
                pep = EmxNwLnkClientEndpointTest.connect(cep, waitCond);
                if (exp == null) {
                    if (waitCond.list().size() > 0) {
                        EmxNwLnkClientEndpointTest.testFailure((String)"Connect returned successfully but a wait condition was still reported!");
                    }
                    EmxNwLnkClientEndpointTest.testSuccess((String)("Client endpoint connected successfully [desc=" + desc + "]"));
                    break block7;
                }
                EmxNwLnkClientEndpointTest.testFailure((String)("Client endpoint connect [desc=" + desc + "] reported 'connect success' when it should have failed! [exp=" + exp.getClass().getName() + "]"));
            }
            catch (Exception e) {
                block8: {
                    try {
                        if (exp != null && exp.getClass().isInstance(e)) {
                            EmxNwLnkClientEndpointTest.testSuccess((String)("Client endpoint connect [desc=" + desc + "] successfully threw exception [" + e.toString() + "]"));
                            break block8;
                        }
                        EmxNwLnkClientEndpointTest.testFailure((String)("Client endpoint connect [desc=" + desc + "] threw incorrect exception [exp=" + (exp != null ? exp.getClass().getName() : "null") + " actual=" + e.toString() + "]"));
                    }
                    catch (Throwable throwable) {
                        EmxNwLnkClientEndpointTest.testClose(pep, null);
                        throw throwable;
                    }
                }
                EmxNwLnkClientEndpointTest.testClose(pep, null);
            }
        }
        EmxNwLnkClientEndpointTest.testClose(pep, null);
    }

    private static void testFailure(String s, Throwable e) {
        System.out.println("FAIL [" + s + ": " + e + "]");
        throw new Error(s, e);
    }

    private void testCreateDiffLocalAddr(EmxFactory.EmxImpl impl, String desc1, String desc2) throws Exception {
        IEmxNwLnkClientEndpoint cep1 = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc1, null);
        IEmxNwLnkClientEndpoint cep2 = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc2, null);
        EmxNwLnkClientEndpointTest.testClose(cep1, null);
        EmxNwLnkClientEndpointTest.testClose(cep2, null);
    }

    private void testCreateSameLocalAddr(EmxFactory.EmxImpl impl, String desc1, String desc2) throws Exception {
        IEmxNwLnkClientEndpoint cep1 = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc1, null);
        try {
            IEmxNwLnkClientEndpoint cep2 = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc2, null);
            cep2.close();
        }
        catch (EEmxException e) {
            EmxNwLnkClientEndpointTest.testSuccess((String)("Client endpoint creation with already assigned local address successfully threw exception [" + e.toString() + "]"));
        }
        EmxNwLnkClientEndpointTest.testClose(cep1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnect(EmxFactory.EmxImpl impl, String desc, Exception exp) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        try {
            EmxNwLnkClientEndpointTest.testConnect(cep, desc, exp);
            if (exp != null) {
                EmxNwLnkClientEndpointTest.testConnect(cep, desc, exp);
            }
        }
        finally {
            EmxNwLnkClientEndpointTest.testClose(cep, null);
        }
    }

    private void testConnectSuccess(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        EmxNwLnkClientEndpointTest.testClose(cep, (Exception)((Object)new EEmxInvalidStateException("", "")));
        EmxNwLnkClientEndpointTest.testClose(sep, null);
    }

    private void testConnectAfterSuccessfulConnect(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, (Exception)((Object)new EEmxInvalidStateException("", "")));
        EmxNwLnkClientEndpointTest.testClose(cep, (Exception)((Object)new EEmxInvalidStateException("", "")));
        EmxNwLnkClientEndpointTest.testClose(sep, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnectAfterUnsuccessfulConnects(int numUnsuccessfulConnects, EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = null;
        for (int i = 0; i < numUnsuccessfulConnects; ++i) {
            EmxNwLnkClientEndpointTest.testConnect(cep, desc, (Exception)((Object)new EEmxNwLnkOpFailedException("")));
        }
        sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        try {
            try {
                EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
            }
            finally {
                EmxNwLnkClientEndpointTest.testClose(cep, (Exception)((Object)new EEmxInvalidStateException("", "")));
            }
        }
        finally {
            EmxNwLnkClientEndpointTest.testClose(sep, null);
        }
    }

    private void testConnectAfterClose(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testClose(cep, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, (Exception)((Object)new EEmxInvalidStateException("", "")));
    }

    private void testCloseAfterUnsuccessfulConnect(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, (Exception)((Object)new EEmxNwLnkOpFailedException("")));
        EmxNwLnkClientEndpointTest.testClose(cep, null);
    }

    private void testCloseAfterSuccessfulConnect(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        IEmxNwLnkServerEndpoint sep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testConnect(cep, desc, null);
        EmxNwLnkClientEndpointTest.testClose(cep, (Exception)((Object)new EEmxInvalidStateException("", "")));
        EmxNwLnkClientEndpointTest.testClose(sep, null);
    }

    private void testCloseAfterClose(EmxFactory.EmxImpl impl, String desc) throws Exception {
        IEmxNwLnkClientEndpoint cep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        EmxNwLnkClientEndpointTest.testClose(cep, null);
        EmxNwLnkClientEndpointTest.testClose(cep, null);
    }

    @Test
    public void testCreateInvalidDescContent() {
        try {
            this.testCreateInvalidDescContent(0, EmxFactory.EmxImpl.NIO, "tcp://localhost:4400&localifaddr=1.0.0.0");
            this.testCreateInvalidDescContent(0, EmxFactory.EmxImpl.NIO, "tcp://localhost:4400&localport=-1");
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure("Unhandled exception", e);
        }
    }

    @Test
    public void testCreateDiffLocalAddr() {
        try {
            this.testCreateDiffLocalAddr(EmxFactory.EmxImpl.NIO, "tcp://localhost:4405", "tcp://localhost:4405");
            this.testCreateDiffLocalAddr(EmxFactory.EmxImpl.NIO, "tcp://localhost:4406&localport=4407", "tcp://localhost:44060&localport=4408");
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure("Unhandled exception", e);
        }
    }

    @Test
    public void testCreateSameLocalAddr() {
        try {
            this.testCreateSameLocalAddr(EmxFactory.EmxImpl.NIO, "tcp://localhost:4402&localport=4403", "tcp://localhost:4402&localport=4403");
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testPropsSet() {
        try {
            this.testTCPAndSocketPropsOnEndpoint(0, EmxFactory.EmxImpl.NIO, "tcp://localhost:4402");
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    @Ignore(value="Ingoring as it causes problems in subsequent tests and is inconsistent across platforms")
    public void testConnectInvalidAddress() {
        try {
            if (!XRuntime.getValue((String)"nv.ec2.skipincompatibletests", (boolean)false)) {
                this.testConnect(EmxFactory.EmxImpl.NIO, "tcp://192.100.100.800:4400", new RuntimeException());
            }
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testConnectNoServer() {
        try {
            this.testConnect(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400", (Exception)((Object)new EEmxNwLnkOpFailedException("")));
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testConnectSuccess() {
        try {
            this.testConnectSuccess(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testConnectAfterSuccessfulConnect() {
        try {
            this.testConnectAfterSuccessfulConnect(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testConnectAfterUnsuccessfulConnect() {
        try {
            this.testConnectAfterUnsuccessfulConnects(1, EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testConnectAfter2UnsuccessfulConnects() {
        try {
            this.testConnectAfterUnsuccessfulConnects(2, EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testConnectAfter3UnsuccessfulConnects() {
        try {
            this.testConnectAfterUnsuccessfulConnects(3, EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testConnectAfterClose() {
        try {
            this.testConnectAfterClose(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCloseAfterUnsuccessfulConnect() {
        try {
            this.testCloseAfterUnsuccessfulConnect(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCloseAfterSuccessfulConnect() {
        try {
            this.testCloseAfterSuccessfulConnect(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCloseAfterClose() {
        try {
            this.testCloseAfterClose(EmxFactory.EmxImpl.NIO, "tcp://localhost:4400");
        }
        catch (Exception e) {
            EmxNwLnkClientEndpointTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }
}

