/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx.test.unit;

import com.neeve.emx.EEmxNwLnkDescriptorFormatException;
import com.neeve.emx.EEmxNwLnkInvalidTypeException;
import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxAlarmEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxNwLnkClientEndpoint;
import com.neeve.emx.IEmxNwLnkServerEndpoint;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.test.UnitTest;
import org.junit.Test;

public final class EmxFactoryTest
extends UnitTest {
    private void testDispatcherCreate(EmxFactory.EmxImpl impl, String className) throws Exception {
        IEmxDispatcher dispatcher = EmxFactory.getInstance().createDispatcher(impl, "name", null);
        if (dispatcher.getClass().getName().compareToIgnoreCase(className) != 0) {
            EmxFactoryTest.testFailure((String)("Created dispatcher class is incorrect [exp=" + className + " actual=" + dispatcher.getClass().getName() + "]"));
        }
    }

    private void testAlarmEventCreateInvalidInterval(EmxFactory.EmxImpl impl, int interval) {
        try {
            EmxFactory.getInstance().createAlarmEvent(impl, null, interval);
            EmxFactoryTest.testFailure((String)("Invalid interval [" + interval + "] resulted in a successful alarm event creation!"));
        }
        catch (IllegalArgumentException e) {
            EmxFactoryTest.testSuccess((String)("Alarm endpoint creation received exception [" + e.getMessage() + "] when creating with invalid interval [" + interval + "]"));
        }
    }

    private void testAlarmEventCreate(EmxFactory.EmxImpl impl, String className) {
        IEmxAlarmEvent event = EmxFactory.getInstance().createAlarmEvent(impl, null, 0);
        if (event.getClass().getName().compareToIgnoreCase(className) != 0) {
            EmxFactoryTest.testFailure((String)("Created alarm event class is incorrect [exp=" + className + " actual=" + event.getClass().getName() + "]"));
        }
    }

    private void testUserEventCreate(EmxFactory.EmxImpl impl, String className) {
        IEmxUserEvent event = EmxFactory.getInstance().createUserEvent(impl, null);
        if (event.getClass().getName().compareToIgnoreCase(className) != 0) {
            EmxFactoryTest.testFailure((String)("Created user event class is incorrect [exp=" + className + " actual=" + event.getClass().getName() + "]"));
        }
    }

    private void testNwLnkClientEpCreateInvalidDesc(EmxFactory.EmxImpl impl, String desc) throws Exception {
        try {
            IEmxNwLnkClientEndpoint ep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
            ep.close();
            EmxFactoryTest.testFailure((String)("Invalid descriptor '" + desc + "' resulted in a successful client endpoint creation!"));
        }
        catch (EEmxNwLnkDescriptorFormatException e) {
            EmxFactoryTest.testSuccess((String)("Client endpoint creation received exception [" + e.getMessage() + "] when creating with invalid descriptor '" + desc + "'"));
        }
    }

    private void testNwLnkClientEpCreateInvalidType(EmxFactory.EmxImpl impl, String desc) throws Exception {
        try {
            IEmxNwLnkClientEndpoint ep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
            ep.close();
            EmxFactoryTest.testFailure((String)("Invalid type in descriptor '" + desc + "' resulted in a successful client endpoint creation!"));
        }
        catch (EEmxNwLnkInvalidTypeException e) {
            EmxFactoryTest.testSuccess((String)("Client endpoint creation received exception [" + e.getMessage() + "] when creating with descriptor with invalid link type'" + desc + "'"));
        }
    }

    private void testNwLnkClientEpCreateInvalidConfig(EmxFactory.EmxImpl impl, String desc) throws Exception {
        try {
            IEmxNwLnkClientEndpoint ep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
            ep.close();
            EmxFactoryTest.testFailure((String)("Invalid config in descriptor '" + desc + "' resulted in a successful client endpoint creation!"));
        }
        catch (EEmxNwLnkDescriptorFormatException e) {
            EmxFactoryTest.testSuccess((String)("Client endpoint creation received exception [" + e.getMessage() + "] when creating with invalid config in descriptor '" + desc + "'"));
        }
    }

    private void testNwLnkClientEpCreateValid(EmxFactory.EmxImpl impl, String desc, String className) throws Exception {
        IEmxNwLnkClientEndpoint ep = EmxFactory.getInstance().createNwLnkClientEndpoint(impl, desc, null);
        ep.close();
        if (ep.getClass().getName().compareToIgnoreCase(className) != 0) {
            EmxFactoryTest.testFailure((String)("Created network link client endpoint class is incorrect [exp=" + className + " actual=" + ep.getClass().getName() + "]"));
        }
    }

    private void testNwLnkServerEpCreateInvalidDesc(EmxFactory.EmxImpl impl, String desc) throws Exception {
        try {
            IEmxNwLnkServerEndpoint ep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
            ep.close();
            EmxFactoryTest.testFailure((String)("Invalid descriptor '" + desc + "' resulted in a successful server endpoint creation!"));
        }
        catch (EEmxNwLnkDescriptorFormatException e) {
            EmxFactoryTest.testSuccess((String)("Server endpoint creation received exception [" + e.getMessage() + "] when creating with invalid descriptor '" + desc + "'"));
        }
    }

    private void testNwLnkServerEpCreateInvalidType(EmxFactory.EmxImpl impl, String desc) throws Exception {
        try {
            IEmxNwLnkServerEndpoint ep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
            ep.close();
            EmxFactoryTest.testFailure((String)("Invalid type in descriptor '" + desc + "' resulted in a successful server endpoint creation!"));
        }
        catch (EEmxNwLnkInvalidTypeException e) {
            EmxFactoryTest.testSuccess((String)("Server endpoint creation received exception [" + e.getMessage() + "] when creating with descriptor with invalid link type'" + desc + "'"));
        }
    }

    private void testNwLnkServerEpCreateInvalidConfig(EmxFactory.EmxImpl impl, String desc) throws Exception {
        try {
            IEmxNwLnkServerEndpoint ep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
            ep.close();
            EmxFactoryTest.testFailure((String)("Invalid config in descriptor '" + desc + "' resulted in a successful server endpoint creation!"));
        }
        catch (EEmxNwLnkDescriptorFormatException e) {
            EmxFactoryTest.testSuccess((String)("Server endpoint creation received exception [" + e.getMessage() + "] when creating with invalid config in descriptor '" + desc + "'"));
        }
    }

    private void testNwLnkServerEpCreateValid(EmxFactory.EmxImpl impl, String desc, String className) throws Exception {
        IEmxNwLnkServerEndpoint ep = EmxFactory.getInstance().createNwLnkServerEndpoint(impl, desc, null);
        ep.close();
        if (ep.getClass().getName().compareToIgnoreCase(className) != 0) {
            EmxFactoryTest.testFailure((String)("Created network link server endpoint class is incorrect [exp=" + className + " actual=" + ep.getClass().getName() + "]"));
        }
    }

    @Test
    public void testDefImpl() {
        System.setProperty("nv.emx.impl", "nio");
        try {
            if (EmxFactory.getInstance().getDefaultEmxImpl() != EmxFactory.EmxImpl.NIO) {
                EmxFactoryTest.testFailure((String)"Invalid default EMX impl returned for nv.emx.impl=default");
            }
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateDispatcherDefaultImpl() {
        try {
            this.testDispatcherCreate(EmxFactory.EmxImpl.DEFAULT, "com.neeve.emx.nio.EmxNioDispatcher");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateDispatcherNIOImpl() {
        try {
            this.testDispatcherCreate(EmxFactory.EmxImpl.NIO, "com.neeve.emx.nio.EmxNioDispatcher");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateNegativeIntervalAlarmEventDefaultImpl() {
        try {
            this.testAlarmEventCreateInvalidInterval(EmxFactory.EmxImpl.DEFAULT, -1);
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateNegativeIntervalAlarmEventNIOImpl() {
        try {
            this.testAlarmEventCreateInvalidInterval(EmxFactory.EmxImpl.NIO, -1);
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateAlarmEventDefaultImpl() {
        try {
            this.testAlarmEventCreate(EmxFactory.EmxImpl.DEFAULT, "com.neeve.emx.nio.EmxNioAlarmEvent");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateAlarmEventNIOImpl() {
        try {
            this.testAlarmEventCreate(EmxFactory.EmxImpl.NIO, "com.neeve.emx.nio.EmxNioAlarmEvent");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateUserEventDefaultImpl() {
        try {
            this.testUserEventCreate(EmxFactory.EmxImpl.DEFAULT, "com.neeve.emx.nio.EmxNioUserEvent");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateUserEventNIOImpl() {
        try {
            this.testUserEventCreate(EmxFactory.EmxImpl.NIO, "com.neeve.emx.nio.EmxNioUserEvent");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateInvDescNwLnkClientEpDefaultImpl() {
        try {
            this.testNwLnkClientEpCreateInvalidDesc(EmxFactory.EmxImpl.DEFAULT, "xxx");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateInvDescNwLnkClientEpNIOImpl() {
        try {
            this.testNwLnkClientEpCreateInvalidDesc(EmxFactory.EmxImpl.NIO, "xxx");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateInvTypeNwLnkClientEpDefaultImpl() {
        try {
            this.testNwLnkClientEpCreateInvalidType(EmxFactory.EmxImpl.DEFAULT, "xxx://config");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateInvTypeNwLnkClientEpNIOImpl() {
        try {
            this.testNwLnkClientEpCreateInvalidType(EmxFactory.EmxImpl.NIO, "xxx://config");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateInvConfigNwLnkClientEpDefaultImpl() {
        try {
            this.testNwLnkClientEpCreateInvalidConfig(EmxFactory.EmxImpl.DEFAULT, "tcp://");
            this.testNwLnkClientEpCreateInvalidConfig(EmxFactory.EmxImpl.DEFAULT, "tcp://addr&a");
            this.testNwLnkClientEpCreateInvalidConfig(EmxFactory.EmxImpl.DEFAULT, "tcp://addr&a=");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateInvConfigNwLnkClientEpNIOImpl() {
        try {
            this.testNwLnkClientEpCreateInvalidConfig(EmxFactory.EmxImpl.NIO, "tcp://");
            this.testNwLnkClientEpCreateInvalidConfig(EmxFactory.EmxImpl.NIO, "tcp://addr&a");
            this.testNwLnkClientEpCreateInvalidConfig(EmxFactory.EmxImpl.NIO, "tcp://addr&a=");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateTcpNwLnkClientEpDefaultImpl() {
        try {
            this.testNwLnkClientEpCreateValid(EmxFactory.EmxImpl.DEFAULT, "tcp://localhost:2501", "com.neeve.emx.nio.tcp.EmxNioTcpNwLnkClientEndpoint");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateTcpNwLnkClientEpNIOImpl() {
        try {
            this.testNwLnkClientEpCreateValid(EmxFactory.EmxImpl.NIO, "tcp://localhost:2501", "com.neeve.emx.nio.tcp.EmxNioTcpNwLnkClientEndpoint");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateInvDescNwLnkServerEpDefaultImpl() {
        try {
            this.testNwLnkServerEpCreateInvalidDesc(EmxFactory.EmxImpl.DEFAULT, "xxx");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateInvDescNwLnkServerEpNIOImpl() {
        try {
            this.testNwLnkServerEpCreateInvalidDesc(EmxFactory.EmxImpl.NIO, "xxx");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateInvTypeNwLnkServerEpDefaultImpl() {
        try {
            this.testNwLnkServerEpCreateInvalidType(EmxFactory.EmxImpl.DEFAULT, "xxx://config");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateInvTypeNwLnkServerEpNIOImpl() {
        try {
            this.testNwLnkServerEpCreateInvalidType(EmxFactory.EmxImpl.NIO, "xxx://config");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateInvConfigNwLnkServerEpDefaultImpl() {
        try {
            this.testNwLnkServerEpCreateInvalidConfig(EmxFactory.EmxImpl.DEFAULT, "tcp://");
            this.testNwLnkServerEpCreateInvalidConfig(EmxFactory.EmxImpl.DEFAULT, "tcp://addr&a");
            this.testNwLnkServerEpCreateInvalidConfig(EmxFactory.EmxImpl.DEFAULT, "tcp://addr&a=");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateInvConfigNwLnkServerEpNIOImpl() {
        try {
            this.testNwLnkServerEpCreateInvalidConfig(EmxFactory.EmxImpl.NIO, "tcp://");
            this.testNwLnkServerEpCreateInvalidConfig(EmxFactory.EmxImpl.NIO, "tcp://addr&a");
            this.testNwLnkServerEpCreateInvalidConfig(EmxFactory.EmxImpl.NIO, "tcp://addr&a=");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateTcpNwLnkServerEpDefaultImpl() {
        try {
            this.testNwLnkServerEpCreateValid(EmxFactory.EmxImpl.DEFAULT, "tcp://localhost:2501", "com.neeve.emx.nio.tcp.EmxNioTcpNwLnkServerEndpoint");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }

    @Test
    public void testCreateTcpNwLnkServerEpNIOImpl() {
        try {
            this.testNwLnkServerEpCreateValid(EmxFactory.EmxImpl.NIO, "tcp://localhost:2501", "com.neeve.emx.nio.tcp.EmxNioTcpNwLnkServerEndpoint");
        }
        catch (Exception e) {
            EmxFactoryTest.testFailure((String)("Unhandled exception [" + e + "]"));
        }
    }
}

