/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx;

import com.neeve.emx.EEmxException;
import com.neeve.emx.EmxNwLnk;
import com.neeve.emx.EmxObject;
import com.neeve.io.IOBuffer;
import com.neeve.util.UtlBuffer;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;

public abstract class EmxNwLnkReader
extends EmxObject
implements Runnable {
    public static final int INBUF_SIZE_DEFAULT = 8192;
    public static final int MAXINBUF_SIZE_DEFAULT = 131072;
    private int inbufSize;
    private int maxInbufSize;
    protected final AtomicReference<Thread> runner;
    protected final Callback cb;
    protected volatile boolean stopped = false;

    protected EmxNwLnkReader(Callback cb) {
        if (cb == null) {
            throw new IllegalArgumentException("callback cannot be null");
        }
        this.cb = cb;
        this.runner = new AtomicReference();
        this.inbufSize = 8192;
        this.maxInbufSize = 131072;
    }

    protected abstract void doRunPrepare();

    protected abstract void doRun();

    protected abstract void doUnblock();

    protected final boolean readAndDispatch(EmxNwLnk link) throws EEmxException {
        IOBuffer iobuf = link.getReadBuffer();
        if (iobuf == null) {
            iobuf = IOBuffer.createNative((int)this.inbufSize).setNoWipe();
            link.setReadBuffer(iobuf);
        }
        ByteBuffer bytebuf = iobuf.getBufferUnsafe();
        if (link.read() > 0) {
            bytebuf.flip();
            int length = bytebuf.remaining();
            bytebuf.clear();
            int used = this.cb.handleReadData(link, iobuf, length);
            int remaining = length - used;
            if (length == this.inbufSize && (used == 0 || this.inbufSize < this.maxInbufSize)) {
                this.inbufSize *= 2;
                System.out.println("resized input buffer to " + this.inbufSize);
            }
            IOBuffer iobuf2 = IOBuffer.createNative((int)this.inbufSize).setNoWipe();
            ByteBuffer bytebuf2 = iobuf2.getBufferUnsafe();
            if (used < length) {
                UtlBuffer.copy((ByteBuffer)bytebuf, (int)used, (ByteBuffer)bytebuf2, (int)0, (int)remaining);
                bytebuf2.position(remaining);
            }
            iobuf = iobuf2;
            link.setReadBuffer(iobuf);
            return true;
        }
        return false;
    }

    public final EmxNwLnkReader setInbufSize(int val) {
        this.inbufSize = val;
        return this;
    }

    public final int getInbufSize() {
        return this.inbufSize;
    }

    public final EmxNwLnkReader setMaxInbufSize(int val) {
        this.maxInbufSize = val;
        return this;
    }

    public final int getMaxInbufSize() {
        return this.maxInbufSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void waitForStart() {
        AtomicReference<Thread> atomicReference = this.runner;
        synchronized (atomicReference) {
            while (this.runner.get() == null) {
                try {
                    this.runner.wait();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        this.doRunPrepare();
        AtomicReference<Thread> atomicReference = this.runner;
        synchronized (atomicReference) {
            this.runner.set(Thread.currentThread());
            this.runner.notifyAll();
        }
        try {
            this.doRun();
        }
        finally {
            this.runner.set(null);
        }
    }

    public final void stop() {
        this.stopped = true;
        Thread runner = this.runner.get();
        if (runner != null) {
            this.doUnblock();
            while (true) {
                try {
                    runner.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public static interface Callback {
        public int handleReadData(EmxNwLnk var1, IOBuffer var2, int var3);

        public void handleLinkClosure(EmxNwLnk var1);

        public void handleLinkFailure(EmxNwLnk var1, Throwable var2);
    }
}

