/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.emx;

import com.neeve.ci.XRuntime;
import com.neeve.emx.EEmxException;
import com.neeve.emx.EEmxNwLnkDescriptorFormatException;
import com.neeve.emx.EEmxNwLnkInvalidTypeException;
import com.neeve.emx.EmxObject;
import com.neeve.emx.IEmxAlarmEvent;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxNwLnkClientEndpoint;
import com.neeve.emx.IEmxNwLnkEndpoint;
import com.neeve.emx.IEmxNwLnkServerEndpoint;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.emx.nio.EmxNioAlarmEvent;
import com.neeve.emx.nio.EmxNioDispatcher;
import com.neeve.emx.nio.EmxNioUserEvent;
import com.neeve.emx.nio.tcp.EmxNioTcpNwLnkClientEndpoint;
import com.neeve.emx.nio.tcp.EmxNioTcpNwLnkServerEndpoint;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlProps;
import java.util.HashMap;
import java.util.Properties;

public final class EmxFactory
extends EmxObject {
    private static EmxFactory instance = new EmxFactory();
    private EmxImpl defImpl;

    private EmxFactory() {
        String defImplStr = UtlProps.getValue((Properties)XRuntime.getProps(), (String)"nv.emx.impl", (String)EmxImpl.NIO.toString());
        try {
            this.defImpl = EmxImpl.valueOf(defImplStr.toUpperCase());
            if (this.defImpl == EmxImpl.DEFAULT) {
                this.defImpl = EmxImpl.NIO;
            }
        }
        catch (IllegalArgumentException e) {
            this.defImpl = EmxImpl.NIO;
        }
        this.tracer.setLevel(XRuntime.getProps(), "nv.emx.factory.trace");
    }

    public static EmxFactory getInstance() {
        return instance;
    }

    private final UtlAddressDescriptor parseDescriptor(String descriptorStr, HashMap<String, Object> props) throws EEmxNwLnkDescriptorFormatException {
        if (descriptorStr == null) {
            throw new IllegalArgumentException();
        }
        try {
            return UtlAddressDescriptor.parse((String)descriptorStr, props);
        }
        catch (IllegalArgumentException e) {
            throw new EEmxNwLnkDescriptorFormatException(descriptorStr);
        }
    }

    public final EmxImpl getDefaultEmxImpl() {
        return this.defImpl;
    }

    public final IEmxDispatcher createDispatcher(EmxImpl impl, String name, IEmxDispatcher.Params params) throws EEmxException {
        EmxImpl resImpl = impl;
        if (resImpl == EmxImpl.DEFAULT) {
            resImpl = this.defImpl;
        }
        switch (resImpl) {
            case NIO: {
                return new EmxNioDispatcher(name, params == null ? IEmxDispatcher.Params.create() : (IEmxDispatcher.Params)params.clone());
            }
        }
        throw new IllegalArgumentException("Unknown EMX implementaiton [" + (Object)((Object)resImpl) + "]");
    }

    public final IEmxUserEvent createUserEvent(EmxImpl impl, IEmxEventHandler handler) {
        EmxImpl resImpl = impl;
        if (resImpl == EmxImpl.DEFAULT) {
            resImpl = this.defImpl;
        }
        switch (resImpl) {
            case NIO: {
                return new EmxNioUserEvent(handler);
            }
        }
        throw new IllegalArgumentException("Unknown EMX implementaiton [" + (Object)((Object)resImpl) + "]");
    }

    public final IEmxAlarmEvent createAlarmEvent(EmxImpl impl, IEmxEventHandler handler, int interval) {
        EmxImpl resImpl = impl;
        if (resImpl == EmxImpl.DEFAULT) {
            resImpl = this.defImpl;
        }
        switch (resImpl) {
            case NIO: {
                return new EmxNioAlarmEvent(handler, interval);
            }
        }
        throw new IllegalArgumentException("Unknown EMX implementaiton [" + (Object)((Object)resImpl) + "]");
    }

    public final IEmxNwLnkEndpoint createNwLnkEndpoint(boolean client, EmxImpl impl, UtlAddressDescriptor descriptor) throws EEmxNwLnkInvalidTypeException, EEmxException {
        EmxImpl resImpl = impl;
        if (resImpl == EmxImpl.DEFAULT) {
            resImpl = this.defImpl;
        }
        switch (resImpl) {
            case NIO: {
                if (descriptor.type.compareToIgnoreCase("tcp") == 0) {
                    return client ? EmxNioTcpNwLnkClientEndpoint.create(descriptor) : EmxNioTcpNwLnkServerEndpoint.create(descriptor);
                }
                throw new EEmxNwLnkInvalidTypeException(descriptor.type);
            }
        }
        throw new IllegalArgumentException("Unknown EMX implementaiton [" + (Object)((Object)resImpl) + "]");
    }

    public final IEmxNwLnkEndpoint createNwLnkEndpoint(boolean client, EmxImpl impl, String descriptorStr, HashMap<String, Object> props) throws EEmxNwLnkDescriptorFormatException, EEmxNwLnkInvalidTypeException, EEmxException {
        return this.createNwLnkEndpoint(client, impl, this.parseDescriptor(descriptorStr, props));
    }

    public final IEmxNwLnkClientEndpoint createNwLnkClientEndpoint(EmxImpl impl, String descriptorStr, HashMap<String, Object> props) throws EEmxNwLnkDescriptorFormatException, EEmxNwLnkInvalidTypeException, EEmxException {
        return (IEmxNwLnkClientEndpoint)this.createNwLnkEndpoint(true, impl, descriptorStr, props);
    }

    public final IEmxNwLnkClientEndpoint createNwLnkClientEndpoint(EmxImpl impl, UtlAddressDescriptor descriptor) throws EEmxNwLnkDescriptorFormatException, EEmxNwLnkInvalidTypeException, EEmxException {
        return (IEmxNwLnkClientEndpoint)this.createNwLnkEndpoint(true, impl, descriptor);
    }

    public final IEmxNwLnkServerEndpoint createNwLnkServerEndpoint(EmxImpl impl, String descriptorStr, HashMap<String, Object> props) throws EEmxNwLnkDescriptorFormatException, EEmxNwLnkInvalidTypeException, EEmxException {
        return (IEmxNwLnkServerEndpoint)this.createNwLnkEndpoint(false, impl, descriptorStr, props);
    }

    public final IEmxNwLnkServerEndpoint createNwLnkServerEndpoint(EmxImpl impl, UtlAddressDescriptor descriptor) throws EEmxNwLnkDescriptorFormatException, EEmxNwLnkInvalidTypeException, EEmxException {
        return (IEmxNwLnkServerEndpoint)this.createNwLnkEndpoint(false, impl, descriptor);
    }

    public static enum EmxImpl {
        DEFAULT,
        NIO;

    }
}

