/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.link;

import com.neeve.server.link.SrvLinkClient;
import com.neeve.server.link.SrvLinkObject;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlReadWriteLock;
import java.util.HashMap;

final class SrvLinkClientCollection
extends SrvLinkObject {
    private final UtlReadWriteLock lock = UtlReadWriteLock.create((String)"clientcolllock");
    private final HashMap<String, SrvLinkClient> clients = new HashMap();

    SrvLinkClientCollection() {
    }

    private final void addClientUnprotected(SrvLinkClient client) {
        if (this.tracer.debug) {
            this.tracer.log("Adding client [" + (Object)((Object)client) + "] to inbound client collection", Tracer.Level.DEBUG);
        }
        this.clients.put(client.getName(), client);
    }

    private final SrvLinkClient getClientUnprotected(String name) {
        return this.clients.get(name);
    }

    private final SrvLinkClient removeClientUnprotected(String name) {
        SrvLinkClient client = this.clients.get(name);
        if (client != null) {
            if (this.tracer.debug) {
                this.tracer.log("Removing client [" + (Object)((Object)client) + "] from inbound client collection", Tracer.Level.DEBUG);
            }
            this.clients.remove(name);
        }
        return client;
    }

    private final void acquireReadLock(UtlReadWriteLock lock) {
        lock.getReadLockUninterrupted();
    }

    private final void acquireWriteLock(UtlReadWriteLock lock) {
        lock.getWriteLockUninterrupted();
    }

    private final void releaseLock(UtlReadWriteLock lock) {
        lock.releaseLock();
    }

    public final void addClient(SrvLinkClient client) {
        if (this.threaded) {
            this.acquireWriteLock(this.lock);
            try {
                this.addClientUnprotected(client);
            }
            finally {
                this.releaseLock(this.lock);
            }
        } else {
            this.addClientUnprotected(client);
        }
    }

    public final SrvLinkClient getClient(String name) {
        if (this.threaded) {
            this.acquireReadLock(this.lock);
            try {
                SrvLinkClient srvLinkClient = this.getClientUnprotected(name);
                return srvLinkClient;
            }
            finally {
                this.releaseLock(this.lock);
            }
        }
        return this.getClientUnprotected(name);
    }

    public final SrvLinkClient removeClient(String name) {
        if (this.threaded) {
            this.acquireWriteLock(this.lock);
            try {
                SrvLinkClient srvLinkClient = this.removeClientUnprotected(name);
                return srvLinkClient;
            }
            finally {
                this.releaseLock(this.lock);
            }
        }
        return this.removeClientUnprotected(name);
    }
}

