/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.server.controller;

import cern.colt.function.IntObjectProcedure;
import cern.colt.function.ObjectProcedure;
import cern.colt.list.DoubleArrayList;
import cern.colt.list.ObjectArrayList;
import cern.colt.map.OpenIntObjectHashMap;
import com.neeve.aep.AepBusManager;
import com.neeve.aep.AepBusManagerStats;
import com.neeve.aep.AepEngine;
import com.neeve.aep.IAepBusManagerStats;
import com.neeve.aep.IAepEngineStats;
import com.neeve.ci.XRuntime;
import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.daemon.config.IDmnConfigDescriptor;
import com.neeve.daemon.controller.DmnController;
import com.neeve.daemon.thread.DmnThreadManager;
import com.neeve.discovery.DiscoveryCacheFactory;
import com.neeve.discovery.EDiscoveryException;
import com.neeve.discovery.IDiscoveryCache;
import com.neeve.event.IEventMultiplexerStats;
import com.neeve.lang.XCollection;
import com.neeve.lang.XCollectionIterator;
import com.neeve.lang.XIndexedList;
import com.neeve.lang.XIntLinkedHashMap;
import com.neeve.lang.XIntMap;
import com.neeve.lang.XIterator;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.memory.MemoryStats;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreBindingStats;
import com.neeve.ods.IStorePersister;
import com.neeve.ods.IStorePersisterStats;
import com.neeve.ods.IStoreSender;
import com.neeve.ods.IStoreSenderStats;
import com.neeve.ods.StoreObjectFactoryRegistry;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogCopyableNode;
import com.neeve.rog.IRogMessage;
import com.neeve.rog.log.RogLog;
import com.neeve.server.app.ISrvAppServerStopper;
import com.neeve.server.app.ISrvAppWatcher;
import com.neeve.server.app.SrvAppLoader;
import com.neeve.server.app.SrvAppManager;
import com.neeve.server.config.SrvConfigDescriptor;
import com.neeve.server.controller.SrvControllerAdminApp;
import com.neeve.server.controller.SrvControllerAdminClient;
import com.neeve.server.controller.SrvControllerConfig;
import com.neeve.server.controller.SrvControllerFileSystemAccessor;
import com.neeve.server.link.SrvLinkInboundManager;
import com.neeve.server.mon.SrvMonAdminClientStats;
import com.neeve.server.mon.SrvMonAppBusBindingInfo;
import com.neeve.server.mon.SrvMonAppBusBindingState;
import com.neeve.server.mon.SrvMonAppBusBindingStats;
import com.neeve.server.mon.SrvMonAppBusChannelInfo;
import com.neeve.server.mon.SrvMonAppClientInfo;
import com.neeve.server.mon.SrvMonAppEngineStats;
import com.neeve.server.mon.SrvMonAppEventMultiplexerFeederQueueStats;
import com.neeve.server.mon.SrvMonAppEventMultiplexerStats;
import com.neeve.server.mon.SrvMonAppFlowInfo;
import com.neeve.server.mon.SrvMonAppHAPolicy;
import com.neeve.server.mon.SrvMonAppInfo;
import com.neeve.server.mon.SrvMonAppMessageLoggerStats;
import com.neeve.server.mon.SrvMonAppRole;
import com.neeve.server.mon.SrvMonAppState;
import com.neeve.server.mon.SrvMonAppStats;
import com.neeve.server.mon.SrvMonAppStoreBindingICRSenderStats;
import com.neeve.server.mon.SrvMonAppStoreBindingPersisterStats;
import com.neeve.server.mon.SrvMonAppStoreBindingRole;
import com.neeve.server.mon.SrvMonAppStoreBindingState;
import com.neeve.server.mon.SrvMonAppStoreBindingStats;
import com.neeve.server.mon.SrvMonAppStoreICRRole;
import com.neeve.server.mon.SrvMonDisruptorClaimStrategy;
import com.neeve.server.mon.SrvMonDisruptorStats;
import com.neeve.server.mon.SrvMonDisruptorWaitStrategy;
import com.neeve.server.mon.SrvMonFactory;
import com.neeve.server.mon.SrvMonHeartbeatMessage;
import com.neeve.server.mon.SrvMonIntHistogram;
import com.neeve.server.mon.SrvMonIntSeries;
import com.neeve.server.mon.SrvMonLongHistogram;
import com.neeve.server.mon.SrvMonLongSeries;
import com.neeve.server.mon.SrvMonMsgTypeStats;
import com.neeve.server.mon.SrvMonPoolStats;
import com.neeve.server.mon.SrvMonSeriesType;
import com.neeve.server.mon.SrvMonSysDiskStats;
import com.neeve.server.mon.SrvMonSysGCCollectorStats;
import com.neeve.server.mon.SrvMonSysGCStats;
import com.neeve.server.mon.SrvMonSysIndividualThreadStats;
import com.neeve.server.mon.SrvMonSysJITStats;
import com.neeve.server.mon.SrvMonSysMemoryIOBufCounters;
import com.neeve.server.mon.SrvMonSysMemoryNativeCounters;
import com.neeve.server.mon.SrvMonSysMemoryOffHeapUsage;
import com.neeve.server.mon.SrvMonSysMemoryStats;
import com.neeve.server.mon.SrvMonSysMemoryUsage;
import com.neeve.server.mon.SrvMonSysStats;
import com.neeve.server.mon.SrvMonSysThreadStats;
import com.neeve.server.mon.SrvMonUserCounterStat;
import com.neeve.server.mon.SrvMonUserGaugeStat;
import com.neeve.server.mon.SrvMonUserSeriesStat;
import com.neeve.server.mon.SrvMonUserStats;
import com.neeve.server.mon.cnc.ISrvMonTrace;
import com.neeve.server.mon.cnc.SrvMonGetLoadedAppsRequest;
import com.neeve.server.mon.cnc.SrvMonGetLoadedAppsResponse;
import com.neeve.server.mon.cnc.SrvMonGetTraceHistoryRequest;
import com.neeve.server.mon.cnc.SrvMonGetTraceHistoryResponse;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandRequest;
import com.neeve.server.mon.cnc.SrvMonInvokeCommandResponse;
import com.neeve.server.mon.cnc.SrvMonListCommandsRequest;
import com.neeve.server.mon.cnc.SrvMonReturnType;
import com.neeve.server.mon.cnc.SrvMonStartAppWatchCommand;
import com.neeve.server.mon.cnc.SrvMonStartTraceWatchRequest;
import com.neeve.server.mon.cnc.SrvMonStartTraceWatchResponse;
import com.neeve.server.mon.cnc.SrvMonStopAppWatchCommand;
import com.neeve.server.mon.cnc.SrvMonStopTraceWatchRequest;
import com.neeve.server.mon.cnc.SrvMonStopTraceWatchResponse;
import com.neeve.server.mon.cnc.SrvMonTrace;
import com.neeve.server.mon.cnc.SrvMonTraceLevel;
import com.neeve.server.mon.cnc.SrvMonTraceRecord;
import com.neeve.server.mon.cnc.SrvMonXvmInfoRequest;
import com.neeve.server.mon.cnc.SrvMonXvmInfoResponse;
import com.neeve.server.mon.common.ISrvMonEvent;
import com.neeve.server.mon.common.SrvMonXvmHeader;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingCreatedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingDestroyedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingDownMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingOpenFailedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingOpenedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingOpeningMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppBusBindingStateChangeMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppChannelDownMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppChannelUpMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppClientConnectMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppClientDisconnectMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineActiveMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineStartedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppEngineStoppedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppFlowCreateMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppLoadedMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppStateChangeMessage;
import com.neeve.server.mon.lifecycle.SrvMonAppUnloadedMessage;
import com.neeve.server.mon.util.SrvMonHeartbeatTracer;
import com.neeve.server.mon.util.SrvMonUtil;
import com.neeve.server.thread.SrvThreadManager;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.stats.IStats;
import com.neeve.trace.TraceHistoryHandler;
import com.neeve.trace.TraceLoggerFactory;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlPoolRegistry;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlThread;
import com.neeve.util.UtlThrowable;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.HdrHistogram.IntCountsHistogram;

public final class SrvController
extends DmnController
implements ISrvAppServerStopper {
    private final String DISCOVERY_CACHE_SERVER_ENTITY_TYPE = "Server";
    private final String DISCOVERY_CACHE_APP_ENTITY_TYPE = "Application";
    private static final Map<SrvConfigDescriptor, SrvController> controllers;
    private static final String HOSTNAME_NOT_AVAILABLE_STR = "???";
    private static final XString HOSTNAME_NOT_AVAILABLE;
    private static final String ADDRESS_NOT_AVAILABLE_STR = "";
    private static final XString ADDRESS_NOT_AVAILABLE;
    private final TraceWatcher traceWatcher;
    private final SrvConfigDescriptor configDescriptor;
    private final SrvThreadManager threadManager;
    private final SrvAppManager appManager;
    private final SrvLinkInboundManager linkInboundManager;
    private final Set<SrvControllerAdminClient> traceWatchers;
    private final Set<SrvControllerAdminClient> appWatchers;
    private final XLinkedHashMap<String, SrvMonAppInfo> appsInfo;
    private final IDiscoveryCache discoveryCache;
    private final Tracer packetTracer;
    private final StatsRunner statsRunner;
    private final RogLog heartbeatLog;
    private final Tracer heartbeatTracer;
    private final SrvMonHeartbeatTracer heartbeatTracerFormatter;
    private final boolean smaTraceEnabled;
    private final boolean smaHeartbeatsEnabled;
    private final Tracer commandTracer;
    private final PoolWatcher poolWatcher;
    private final XString hostname;
    private final XString address;
    private final XString systemName;
    private final XString systemVersion;
    private final SrvMonXvmHeader xvmMessageHeader = SrvMonXvmHeader.create();
    private List<UtlAddressDescriptor> advertisementDescriptorSet;
    private ObjectArrayList pools;
    private Object bootstrapConfigurer;
    private volatile long loadTime;
    private ExecutorService commandExecutorService;
    private volatile SrvControllerAdminApp adminApp;
    private long traceRecordSequenceNumber = 0L;

    private SrvController(SrvConfigDescriptor configDescriptor) {
        super(SrvControllerConfig.getConfig());
        this.traceWatcher = new TraceWatcher(configDescriptor.getMaxTraceHistory());
        if (configDescriptor.getAdmin().getSma().isEnabled()) {
            this.smaTraceEnabled = configDescriptor.getAdmin().getSma().getTraceChannel().isEnabled();
            this.smaHeartbeatsEnabled = configDescriptor.getAdmin().getSma().getHeartbeatChannel().isEnabled();
        } else {
            this.smaTraceEnabled = false;
            this.smaHeartbeatsEnabled = false;
        }
        this.tracer.log(configDescriptor.toString(), Tracer.Level.CONFIG);
        this.configDescriptor = configDescriptor;
        this.threadManager = SrvThreadManager.create(configDescriptor.getName());
        this.appManager = SrvAppManager.create(this.configDescriptor, this.threadManager, new AppWatcher(), this);
        this.linkInboundManager = SrvLinkInboundManager.create(this.configDescriptor, this.threadManager, this.appManager);
        this.traceWatchers = new HashSet<SrvControllerAdminClient>();
        this.appWatchers = new HashSet<SrvControllerAdminClient>();
        this.appsInfo = new XLinkedHashMap();
        String discoveryDescriptor = configDescriptor.getDiscoveryDescriptor();
        try {
            if (discoveryDescriptor == null) {
                this.discoveryCache = DiscoveryCacheFactory.getInstance().createCache(DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR);
                this.tracer.log("Opened server discovery cache (default): '" + UtlAddressDescriptor.parse((String)DiscoveryCacheFactory.DEFAULT_CACHE_DESCRIPTOR, null).toPasswordSanitizedFullString() + "'", Tracer.Level.INFO);
            } else {
                this.discoveryCache = DiscoveryCacheFactory.getInstance().createCache(discoveryDescriptor);
                this.tracer.log("Opened server discovery cache (configured): '" + UtlAddressDescriptor.parse((String)discoveryDescriptor, null).toPasswordSanitizedFullString() + "'", Tracer.Level.INFO);
            }
        }
        catch (EDiscoveryException e) {
            throw new RuntimeException("Unable to open server discovery cache '" + UtlAddressDescriptor.parse((String)discoveryDescriptor, null).toPasswordSanitizedFullString() + "'", e);
        }
        this.hostname = XString.create((String)XRuntime.getLocalHostNameForDisplay((String)HOSTNAME_NOT_AVAILABLE_STR));
        this.address = XString.create((String)XRuntime.getLocalHostAddressForDisplay((String)ADDRESS_NOT_AVAILABLE_STR));
        this.systemName = configDescriptor.getSystemName() != null ? XString.create((String)configDescriptor.getSystemName()) : null;
        this.systemVersion = configDescriptor.getSystemVersion() != null ? XString.create((String)configDescriptor.getSystemVersion()) : null;
        this.xvmMessageHeader.setXvmName(configDescriptor.getName());
        this.xvmMessageHeader.setSystemNameFrom(this.systemName);
        this.xvmMessageHeader.setSystemVersionFrom(this.systemVersion);
        this.xvmMessageHeader.sync();
        this.xvmMessageHeader.setAsReadOnly();
        this.packetTracer = Tracer.get((String)"nv.packet");
        ConfigRepositoryFactory.getInstance().getDefaultRepository();
        if (configDescriptor.getHeartbeats().isEnabled()) {
            this.tracer.log("Heartbeats sent by this server will use hostname " + this.hostname.getValue(), Tracer.Level.INFO);
            try {
                if (UtlProps.getValue((Properties)configDescriptor.getHeartbeatLoggingProperties(), (String)"enabled", (boolean)false)) {
                    Properties propsCopy = new Properties(configDescriptor.getHeartbeatLoggingProperties());
                    if (UtlProps.getValue((Properties)propsCopy, (String)"initialLogLength", null) == null) {
                        propsCopy.put("initialLogLength", "0");
                    }
                    if (UtlProps.getValue((Properties)propsCopy, (String)"storeRoot", null) == null) {
                        propsCopy.put("storeRoot", XRuntime.getDataDirectory() + "/server-hearbeats/");
                    }
                    propsCopy.setProperty("administrative", "true");
                    propsCopy.setProperty("autoRepair", "true");
                    StoreObjectFactoryRegistry.getInstance().registerIfNoConflict(SrvMonFactory.class.getName());
                    this.heartbeatLog = RogLog.create((String)(configDescriptor.getName() + "-heartbeats"), (Properties)propsCopy);
                    this.heartbeatLog.setIsPureMessageLogger(true);
                    this.heartbeatLog.backupLog(true);
                    this.heartbeatLog.setErrorHandler(new IStorePersister.ErrorHandler(){

                        public void onError(Exception cause) {
                            SrvController.this.tracer.log("Error in hearbeat logger: " + UtlThrowable.prepareStackTrace((Throwable)cause) + " ... closing", Tracer.Level.SEVERE);
                            SrvController.this.closeHeartbeatLog();
                        }
                    });
                } else {
                    this.heartbeatLog = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error opening heartbeat log: " + e.getMessage(), e);
            }
            SrvMonHeartbeatTracer srvMonHeartbeatTracer = this.heartbeatTracerFormatter = configDescriptor.getHeartbeatTracing().isEnabled() ? new SrvMonHeartbeatTracer() : null;
            if (this.heartbeatTracerFormatter != null) {
                SrvConfigDescriptor.HeartbeatTracing tracingConfig = configDescriptor.getHeartbeatTracing();
                this.heartbeatTracerFormatter.setTraceAdminClientStats(tracingConfig.isTraceAdminClientStats());
                this.heartbeatTracerFormatter.setTraceAppStats(tracingConfig.isTraceAppStats());
                this.heartbeatTracerFormatter.setTracePoolStats(tracingConfig.isTracePoolStats());
                this.heartbeatTracerFormatter.setTraceSysStats(tracingConfig.isTraceSysStats());
                this.heartbeatTracerFormatter.setTraceThreadStats(tracingConfig.isTraceThreadStats());
                this.heartbeatTracerFormatter.setTraceUserStats(tracingConfig.isTraceUserStats());
                this.heartbeatTracer = Tracer.get((String)"nv.server.heartbeat");
            } else {
                this.heartbeatTracer = null;
            }
            this.statsRunner = new StatsRunner(this);
        } else {
            this.heartbeatLog = null;
            this.heartbeatTracerFormatter = null;
            this.heartbeatTracer = null;
            this.statsRunner = null;
        }
        this.commandTracer = Tracer.get((String)"nv.server.commmand");
        this.poolWatcher = new PoolWatcher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final SrvController getInstance(SrvConfigDescriptor configDescriptor) {
        SrvController controller;
        Map<SrvConfigDescriptor, SrvController> map = controllers;
        synchronized (map) {
            controller = controllers.get(configDescriptor);
            if (controller == null) {
                controller = new SrvController(configDescriptor);
                controllers.put(configDescriptor, controller);
            }
        }
        return controller;
    }

    public void setBootstrapConfigurer(Object configurer) {
        this.bootstrapConfigurer = configurer;
    }

    public Object getBootstrapConfigurer() {
        return this.bootstrapConfigurer;
    }

    private final void openHeartbeatLog() throws Exception {
        if (this.heartbeatLog != null) {
            this.tracer.log("Opening heartbeat log...", Tracer.Level.INFO);
            this.heartbeatLog.open();
        }
    }

    private final void closeHeartbeatLog() {
        if (this.heartbeatLog != null && this.heartbeatLog.isOpen()) {
            try {
                this.tracer.log("Closing heartbeat log...", Tracer.Level.INFO);
                this.heartbeatLog.flush(true);
                this.heartbeatLog.close();
            }
            catch (Throwable thrown) {
                this.tracer.log("Error closing heartbeat log: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
            }
        }
    }

    final Tracer getPacketTracer() {
        return this.packetTracer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onTrace(LogRecord record) {
        if (this.traceWatchers != null) {
            SrvMonTraceRecord traceRecord;
            Set<SrvControllerAdminClient> set = this.traceWatchers;
            synchronized (set) {
                SrvControllerAdminApp adminApp = this.adminApp;
                if (this.smaTraceEnabled && adminApp != null || !this.traceWatchers.isEmpty()) {
                    traceRecord = this.populateTraceRecord(record, SrvMonTraceRecord.create());
                    traceRecord.setTraceSeqNo(this.traceRecordSequenceNumber++);
                    traceRecord.lendXvmHeader(this.xvmMessageHeader);
                } else {
                    traceRecord = null;
                }
                for (SrvControllerAdminClient client : this.traceWatchers) {
                    client.publishTraceRecord(traceRecord.copy());
                }
            }
            if (this.smaTraceEnabled && this.adminApp != null) {
                this.adminApp.publishTraceRecord(traceRecord);
            } else if (traceRecord != null) {
                traceRecord.dispose();
            }
        }
    }

    private final SrvMonAppInfo createMonApp(SrvAppLoader loader) {
        SrvMonAppInfo appInfo = SrvMonAppInfo.create();
        appInfo.setName(loader.getAppName());
        appInfo.setVersion(loader.getAppVersion());
        appInfo.setJarVersionString(loader.getAppJarVersion());
        appInfo.setState(SrvMonAppState.Loaded);
        return appInfo;
    }

    final SrvMonXvmHeader getXvmMessageHeader() {
        return this.xvmMessageHeader;
    }

    final Map<String, SrvMonAppInfo> getAppsInfo() {
        return this.appsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onPoolAdded(UtlPool<?> pool) {
        ObjectArrayList objectArrayList = this.pools;
        synchronized (objectArrayList) {
            this.pools.add(pool);
        }
        if (this.statsRunner != null) {
            this.statsRunner.onPoolAdded(pool);
        }
        if (this.tracer.debug) {
            this.tracer.log("[POOL ACTIVATE] {type='" + pool.type() + "', name='" + pool.name() + "'}", Tracer.Level.DEBUG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onPoolRemoved(UtlPool<?> pool) {
        ObjectArrayList objectArrayList = this.pools;
        synchronized (objectArrayList) {
            this.pools.delete(pool, false);
        }
        if (this.statsRunner != null) {
            this.statsRunner.onPoolRemoved(pool);
        }
        if (this.tracer.debug) {
            this.tracer.log("[POOL DEACTIVATE] {type='" + pool.type() + "', name='" + pool.name() + "'}", Tracer.Level.DEBUG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppLoaded(SrvAppLoader loader) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = this.createMonApp(loader);
            appInfo.setLoadedTimeAsTimestamp(System.currentTimeMillis());
            this.appsInfo.put((Object)loader.getAppName(), (Object)appInfo);
            SrvMonAppLoadedMessage message = SrvMonAppLoadedMessage.create();
            message.setAppInfo(appInfo.copy());
            message.setEventTimestampAsTimestamp(appInfo.getLoadedTimeAsTimestamp());
            message.setEventSource("xvm");
            this.dispatchLifecycleEvent(message);
        }
    }

    final void onAppInitialized(SrvAppLoader loader, long timestamp) {
        if (this.statsRunner != null) {
            this.statsRunner.onAppInitialized(loader);
        }
        this.onAppStateChange(loader.getAppName(), timestamp, SrvMonAppState.Initialized);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppStateChange(String appName, long timestamp, SrvMonAppState newState) {
        SrvAppLoader loader;
        if (newState == SrvMonAppState.Active) {
            if (this.advertisementDescriptorSet.size() > 0) {
                this.discoveryCache.add("Application", appName, this.advertisementDescriptorSet);
            }
        } else if (newState == SrvMonAppState.Stopped) {
            if (this.adminApp != null && "admin".equalsIgnoreCase(appName)) {
                this.adminApp = null;
            }
            if (!this.discoveryCache.closed()) {
                this.discoveryCache.remove("Application", appName);
            }
        }
        SrvMonAppRole role = null;
        SrvMonAppHAPolicy haPolicy = null;
        if (this.appManager.isStarted() && (loader = this.appManager.getAppLoader(appName)) != null) {
            role = SrvMonAppRole.Standalone;
            AepEngine engine = loader.getAppEngine();
            if (engine != null) {
                IStoreBinding binding = engine.getStore();
                if (binding != null && binding.getState() != IStoreBinding.State.Closed) {
                    try {
                        switch (binding.getRole()) {
                            case Backup: {
                                role = SrvMonAppRole.Backup;
                                break;
                            }
                            case Primary: {
                                role = SrvMonAppRole.Primary;
                                break;
                            }
                        }
                    }
                    catch (Throwable thrown) {
                        this.tracer.log("Error fetching app store binding state: " + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.WARNING);
                    }
                }
                if (this.adminApp == null && "admin".equalsIgnoreCase(loader.getAppName()) && newState == SrvMonAppState.Started) {
                    this.adminApp = (SrvControllerAdminApp)((Object)loader.getAppMain());
                }
                switch (loader.getAppEngine().getHAPolicy()) {
                    case EventSourcing: {
                        haPolicy = SrvMonAppHAPolicy.EventSourcing;
                        break;
                    }
                    case StateReplication: {
                        haPolicy = SrvMonAppHAPolicy.StateReplication;
                        break;
                    }
                }
            }
        }
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)appName);
            appInfo.setState(newState);
            appInfo.setRole(role);
            appInfo.setHAPolicy(haPolicy);
            SrvMonAppStateChangeMessage message = SrvMonAppStateChangeMessage.create();
            message.setEventSource(appInfo.getName());
            message.setEventTimestampAsTimestamp(timestamp);
            message.setAppState(appInfo.getState());
            this.dispatchLifecycleEvent(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppBusBindingCreated(SrvMonAppBusBindingCreatedMessage message) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)message.getEventSource());
            SrvMonAppBusBindingInfo busBindingInfo = (SrvMonAppBusBindingInfo)message.getBusBindingInfo().clone();
            if (SrvMonUtil.addMonAppBusBindingInfo(appInfo, busBindingInfo)) {
                this.dispatchLifecycleEvent(message.copy());
            } else {
                this.tracer.log("App '" + message.getEventSource() + "' has exceeded the monitoring storage quota for bus bindings. Some app bus bindings will not be reported in a app watcher monitoring stream.", Tracer.Level.WARNING);
                busBindingInfo.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppBusBindingStateChange(String appName, String busBindingName, SrvMonAppBusBindingState newState) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)appName);
            if (SrvMonUtil.updateMonAppBusBindingState(appInfo, busBindingName, newState)) {
                SrvMonAppBusBindingStateChangeMessage message = SrvMonAppBusBindingStateChangeMessage.create();
                message.setEventSource(appName);
                message.setBusBindingName(busBindingName);
                message.setBusBindingState(newState);
                this.dispatchLifecycleEvent(message);
            } else {
                this.tracer.log("New state ('" + (Object)((Object)newState) + "') reported for binding to bus '" + busBindingName + "' in app '" + appName + "' but no bus with that name exists for that app!", Tracer.Level.WARNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppBusBindingDestroyed(SrvMonAppBusBindingDestroyedMessage message) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)message.getEventSource());
            if (SrvMonUtil.removeMonAppBusBindingInfo(appInfo, message.getBusBindingName())) {
                this.dispatchLifecycleEvent(message.copy());
            } else {
                this.tracer.log("Binding to bus '" + message.getBusBindingName() + "' in app '" + message.getEventSource() + "' was reported as destroyed but no bus with that name exists for that app!", Tracer.Level.WARNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppChannelUp(SrvMonAppChannelUpMessage message) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)message.getEventSource());
            SrvMonAppBusChannelInfo busChannelInfo = SrvMonUtil.createMonAppBusChannelInfo(message.getChannelName(), message.getIsJoined());
            if (SrvMonUtil.addMonAppBusChannelInfo(appInfo, message.getBusBindingName(), busChannelInfo)) {
                this.dispatchLifecycleEvent(message.copy());
            } else {
                this.tracer.log("App '" + message.getChannelName() + "' has exceeded the monitoring storage quota for channels in bus '" + message.getBusBindingName() + "'. Some app channels will not be reported in a app watcher monitoring stream.", Tracer.Level.WARNING);
                busChannelInfo.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppChannelDown(SrvMonAppChannelDownMessage message) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)message.getEventSource());
            if (appInfo != null) {
                if (SrvMonUtil.removeMonAppBusChannelInfo(appInfo, message.getBusBindingName(), message.getChannelName())) {
                    this.dispatchLifecycleEvent(message.copy());
                } else {
                    this.tracer.log("Received a channel closed event for a non-existent channel (app=" + message.getEventSource() + ", bus=" + message.getBusBindingName() + ", channel=" + message.getChannelName() + ")!", Tracer.Level.WARNING);
                }
            } else {
                this.tracer.log("Received a closed channel event for a non-existent app '" + message.getEventSource() + "'!", Tracer.Level.WARNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppClientConnected(String appName, String clientName) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)appName);
            SrvMonAppClientInfo clientInfo = SrvMonUtil.createMonAppClientInfo(clientName);
            if (SrvMonUtil.addMonAppClientInfo(appInfo, clientInfo)) {
                SrvMonAppClientConnectMessage message = SrvMonAppClientConnectMessage.create();
                message.setEventSource(appName);
                message.lendClientInfo(clientInfo);
                this.dispatchLifecycleEvent(message);
            } else {
                this.tracer.log("App '" + appName + "' has exceeded the monitoring storage quota for clients. Some app clients will not be reported in a app watcher monitoring stream.", Tracer.Level.WARNING);
                clientInfo.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppClientDisconnected(String appName, String clientName) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)appName);
            if (SrvMonUtil.removeMonAppClientInfo(appInfo, clientName)) {
                SrvMonAppClientDisconnectMessage message = SrvMonAppClientDisconnectMessage.create();
                message.setEventSource(appName);
                message.setClientName(clientName);
                this.dispatchLifecycleEvent(message);
            } else {
                this.tracer.log("Received a disconnected client event for a non-existent client (app=" + appInfo.getName() + ", client=" + clientName + ")!", Tracer.Level.WARNING);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppFlowCreated(String appName, long timestamp, int flowid) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.get((Object)appName);
            SrvMonAppFlowInfo flowInfo = SrvMonUtil.createMonAppFlowInfo(flowid);
            if (SrvMonUtil.addMonAppFlowInfo(appInfo, flowInfo)) {
                SrvMonAppFlowCreateMessage message = SrvMonAppFlowCreateMessage.create();
                message.setEventSource(appName);
                message.setEventTimestampAsTimestamp(timestamp);
                message.lendFlowInfo(flowInfo);
                this.dispatchLifecycleEvent(message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppUnloaded(String appName, long timestamp) {
        this.onAppStateChange(appName, timestamp, SrvMonAppState.Unloaded);
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            SrvMonAppInfo appInfo = (SrvMonAppInfo)this.appsInfo.remove((Object)appName);
            if (appInfo != null) {
                SrvMonAppUnloadedMessage message = SrvMonAppUnloadedMessage.create();
                message.setEventSource(appName);
                message.setEventTimestampAsTimestamp(timestamp);
                this.dispatchLifecycleEvent(message);
            }
            if (this.statsRunner != null) {
                this.statsRunner.onAppUnloaded(appName);
            }
            if (this.adminApp != null && "admin".equalsIgnoreCase(appName)) {
                this.adminApp = null;
            }
        }
    }

    final void onClientConnect(SrvControllerAdminApp.AdminClientContext client) {
        if (this.statsRunner != null) {
            this.statsRunner.onAdminClientConnected(client);
        }
    }

    final void onSrvMonListCommandsRequest(SrvControllerAdminApp.AdminClientContext client, SrvMonListCommandsRequest command) throws Exception {
        client.sendResponse(command, this.appManager.issueGetCommands(command));
    }

    final void onSrvMonXvmInfoRequest(SrvControllerAdminApp.AdminClientContext client, SrvMonXvmInfoRequest command) {
        SrvMonXvmInfoResponse response = SrvMonXvmInfoResponse.create();
        response.lendXvmHeader(this.xvmMessageHeader);
        response.setSystemNameFrom(this.systemName);
        response.setSystemVersionFrom(this.systemVersion);
        response.setXvmAdminVersion("5");
        client.sendResponse(command, response);
    }

    final void onSrvMonStartTraceWatchRequest(SrvControllerAdminClient client, SrvMonStartTraceWatchRequest command) {
        this.onTraceWatchStart(client);
        client.sendResponse(command, SrvMonStartTraceWatchResponse.create());
    }

    final void onSrvMonStopTraceWatchRequest(SrvControllerAdminClient client, SrvMonStopTraceWatchRequest command) {
        this.onTraceWatchStop(client);
        client.sendResponse(command, SrvMonStopTraceWatchResponse.create());
    }

    final void onSrvMonStartAppWatchCommand(SrvControllerAdminClient client, SrvMonStartAppWatchCommand command) {
        this.onAppWatchStart(client);
    }

    final void onSrvMonStopAppWatchCommand(SrvControllerAdminClient client, SrvMonStopAppWatchCommand command) {
        this.onAppWatchStop(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onSrvMonGetLoadedAppsRequest(SrvControllerAdminApp.AdminClientContext client, SrvMonGetLoadedAppsRequest command) {
        SrvMonGetLoadedAppsResponse response = SrvMonGetLoadedAppsResponse.create();
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            for (SrvMonAppInfo appInfo : this.appsInfo.values()) {
                response.addLoadedApps(appInfo.copy());
            }
            client.sendResponse(command, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onSrvMonGetTraceHistoryRequest(SrvControllerAdminApp.AdminClientContext client, SrvMonGetTraceHistoryRequest command) {
        SrvMonGetTraceHistoryResponse response = SrvMonGetTraceHistoryResponse.create();
        Object object = this.traceWatcher.history().getHistoryLock();
        synchronized (object) {
            for (LogRecord record : this.traceWatcher.history()) {
                response.addTraceRecords(this.populateTraceRecord(record, SrvMonTrace.create()));
            }
            response.setTraceSeqNo(this.traceRecordSequenceNumber);
            client.sendResponse(command, response);
        }
    }

    final void onSrvMonInvokeCommandRequest(final SrvControllerAdminApp.AdminClientContext client, final SrvMonInvokeCommandRequest invokeRequest) throws Exception {
        String appName;
        if (this.tracer.isEnabled(Tracer.Level.VERBOSE)) {
            this.tracer.log("Invoking admin command '" + invokeRequest.getCommandName() + "' [target=" + invokeRequest.getTarget() + ", args=" + Arrays.asList(invokeRequest.getParametersEmptyIfNull()) + "]", Tracer.Level.VERBOSE);
        }
        if ((appName = invokeRequest.getTarget()) == null) {
            throw new Exception("appName must be set for invoke command request");
        }
        final String commandName = invokeRequest.getCommandName();
        if (commandName == null) {
            throw new Exception("command must be set for invoke command request");
        }
        if ("server".equals(appName)) {
            appName = "admin";
        }
        final String[] parameters = invokeRequest.getParametersEmptyIfNull();
        if (appName.equals("admin")) {
            if (commandName.compareToIgnoreCase("app_ping") == 0) {
                if (parameters.length == 1) {
                    boolean loaded = this.appManager.isAppLoaded(parameters[0]);
                    SrvMonInvokeCommandResponse response = SrvMonInvokeCommandResponse.create();
                    response.setReturnType(SrvMonReturnType.BOOLEAN);
                    response.setBooleanReturnValue(loaded);
                    client.sendResponse(invokeRequest, response);
                    return;
                }
                throw new Exception("command syntax error: app_ping <appName>");
            }
            if (commandName.compareToIgnoreCase("get_admin_compat_level") == 0) {
                SrvMonInvokeCommandResponse response = SrvMonInvokeCommandResponse.create();
                this.appManager.issueAppCommandUnsafe("admin", commandName, parameters, response);
                client.sendResponse(invokeRequest, response);
                return;
            }
            if (client instanceof SrvControllerAdminClient) {
                if (commandName.compareToIgnoreCase("start_trace_watch") == 0) {
                    ((SrvControllerAdminClient)client).setUseAdmTraceRecords(false);
                    this.onTraceWatchStart((SrvControllerAdminClient)client);
                    return;
                }
                if (commandName.compareToIgnoreCase("stop_trace_watch") == 0) {
                    this.onTraceWatchStop((SrvControllerAdminClient)client);
                    return;
                }
                if (commandName.compareToIgnoreCase("start_app_watch") == 0) {
                    this.onAppWatchStart((SrvControllerAdminClient)client);
                    return;
                }
                if (commandName.compareToIgnoreCase("stop_app_watch") == 0) {
                    this.onAppWatchStop((SrvControllerAdminClient)client);
                    return;
                }
            }
        }
        if (this.commandTracer.isEnabled(Tracer.Level.INFO)) {
            this.commandTracer.log("Admin Client '" + client.getClientName(invokeRequest) + "' is invoking '" + invokeRequest.getCommandName() + "' on '" + invokeRequest.getTarget() + "' with parameters " + Arrays.asList(invokeRequest.getParametersEmptyIfNull()), Tracer.Level.INFO);
        }
        if (this.commandExecutorService != null) {
            final String fixedAppName = appName;
            final PktPacket requestPacket = (PktPacket)invokeRequest.getAttachment();
            if (requestPacket != null) {
                requestPacket.acquire();
            }
            invokeRequest.acquire();
            this.commandExecutorService.execute(new Runnable(){

                @Override
                public void run() {
                    SrvMonInvokeCommandResponse response = SrvMonInvokeCommandResponse.create();
                    try {
                        SrvController.this.appManager.issueAppCommandUnsafe(fixedAppName, commandName, parameters, response);
                        client.sendResponse(invokeRequest, response);
                    }
                    catch (Exception e) {
                        client.sendErrorResponse(invokeRequest, e);
                    }
                    finally {
                        invokeRequest.dispose();
                        if (requestPacket != null) {
                            requestPacket.dispose();
                        }
                    }
                }
            });
        } else {
            SrvMonInvokeCommandResponse response = SrvMonInvokeCommandResponse.create();
            try {
                this.appManager.issueAppCommandUnsafe(appName, commandName, parameters, response);
                client.sendResponse(invokeRequest, response);
            }
            catch (Exception e) {
                client.sendErrorResponse(invokeRequest, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onTraceWatchStart(SrvControllerAdminClient client) {
        this.tracer.log("Client '" + client.getName() + "' has started a trace watch [ADM=" + client.getUseAdmTraceRecords() + "]", Tracer.Level.INFO);
        SrvControllerAdminClient srvControllerAdminClient = client;
        synchronized (srvControllerAdminClient) {
            Object object = this.traceWatcher.history().getHistoryLock();
            synchronized (object) {
                Set<SrvControllerAdminClient> set = this.traceWatchers;
                synchronized (set) {
                    this.traceWatchers.add(client);
                }
                for (LogRecord record : this.traceWatcher.history()) {
                    SrvMonTraceRecord traceRecord = this.populateTraceRecord(record, SrvMonTraceRecord.create());
                    traceRecord.lendXvmHeader(this.getXvmMessageHeader());
                    client.publishTraceRecord(traceRecord);
                }
                client.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onTraceWatchStop(SrvControllerAdminClient client) {
        this.tracer.log("Client '" + client.getName() + "' has stopped a trace watch", Tracer.Level.INFO);
        Set<SrvControllerAdminClient> set = this.traceWatchers;
        synchronized (set) {
            this.traceWatchers.remove(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppWatchStart(SrvControllerAdminClient client) {
        this.tracer.log("Client '" + client.getName() + "' has started a app watch", Tracer.Level.INFO);
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            Set<SrvControllerAdminClient> set = this.appWatchers;
            synchronized (set) {
                this.appWatchers.add(client);
                for (SrvMonAppInfo appInfo : this.appsInfo.values()) {
                    SrvMonAppLoadedMessage message = SrvMonAppLoadedMessage.create();
                    message.lendXvmHeader(this.xvmMessageHeader);
                    message.setEventSource("xvm");
                    message.setEventTimestampAsTimestamp(appInfo.getLoadedTimeAsTimestamp());
                    message.setAppInfo(appInfo.copy());
                    client.publishEvent(message, false, false);
                }
                client.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onAppWatchStop(SrvControllerAdminClient client) {
        this.tracer.log("Client '" + client.getName() + "' has stopped a app watch", Tracer.Level.INFO);
        Set<SrvControllerAdminClient> set = this.appWatchers;
        synchronized (set) {
            this.appWatchers.remove(client);
        }
    }

    final void onClientDisconnect(SrvControllerAdminApp.AdminClientContext client) {
        if (client instanceof SrvControllerAdminClient) {
            this.onTraceWatchStop((SrvControllerAdminClient)client);
            this.onAppWatchStop((SrvControllerAdminClient)client);
        }
        if (this.statsRunner != null) {
            this.statsRunner.onAdminClientDisconnected(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final <MessageType extends IRogMessage & IRogCopyableNode<? extends IRogMessage>> void dispatchLifecycleEvent(MessageType message) {
        ((ISrvMonEvent)message).lendXvmHeader(this.xvmMessageHeader);
        Set<SrvControllerAdminClient> set = this.appWatchers;
        synchronized (set) {
            for (SrvControllerAdminClient client : this.appWatchers) {
                client.publishEvent((IRogMessage)((IRogCopyableNode<? extends IRogMessage>)message).copy(), true, false);
            }
        }
        SrvControllerAdminApp adminApp = this.adminApp;
        if (adminApp != null) {
            adminApp.publishEvent(message);
        } else {
            message.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void onHeartbeat(long statsCollectionStartWallTime, long statsCollectionStartTime, long statsCollectionEndTime, SrvMonSysStats sysStats, XIndexedList<SrvMonPoolStats> poolStats, XIndexedList<SrvMonAdminClientStats> adminClientStats, XIndexedList<SrvMonAppStats> appsStats, SrvMonAppMessageLoggerStats heartbeatLoggerStats) {
        XLinkedHashMap<String, SrvMonAppInfo> xLinkedHashMap = this.appsInfo;
        synchronized (xLinkedHashMap) {
            XIterator appsInfoIt = this.appsInfo.reuseableValueIterator();
            while (appsInfoIt.hasNext()) {
                ((SrvMonAppInfo)appsInfoIt.next()).acquire();
            }
            SrvMonHeartbeatMessage message = SrvMonUtil.prepareMonHeartbeatMessage(statsCollectionStartWallTime, statsCollectionStartTime, statsCollectionStartTime, this.getConfigDescriptor().getName(), sysStats, poolStats, adminClientStats, (XCollection<SrvMonAppInfo>)this.appsInfo.values(), appsStats);
            message.setHeartbeatLoggerStats(heartbeatLoggerStats);
            message.setSystemNameFrom(this.systemName);
            message.setSystemVersionFrom(this.systemVersion);
            message.lendXvmHeader(this.xvmMessageHeader);
            message.setLoadedTimeAsTimestamp(this.loadTime);
            message.setServerHostNameFrom(this.hostname);
            try {
                SrvControllerAdminApp adminApp;
                Set<SrvControllerAdminClient> set = this.appWatchers;
                synchronized (set) {
                    for (SrvControllerAdminClient client : this.appWatchers) {
                        try {
                            client.publishHeartbeat(message.copy());
                        }
                        catch (Throwable e) {
                            StringBuilder sb = new StringBuilder();
                            sb.append("Heartbeat message enque to watching client faulted with error [" + e.toString() + "].\n");
                            sb.append("Stack trace:\n");
                            sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                            this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                        }
                    }
                }
                if (this.smaHeartbeatsEnabled && (adminApp = this.adminApp) != null) {
                    SrvMonHeartbeatMessage toPublish = message.copy();
                    try {
                        adminApp.publishHeartbeat(toPublish);
                    }
                    catch (Exception e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Heartbeat message publish over SMA faulted with error [" + e.toString() + "].\n");
                        sb.append("Stack trace:\n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                        this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    }
                }
                if (this.heartbeatTracerFormatter != null) {
                    StringBuilder sb = new StringBuilder();
                    try {
                        this.heartbeatTracerFormatter.printStats(message, sb);
                        this.heartbeatTracer.log(sb.toString(), Tracer.Level.INFO);
                    }
                    catch (Exception e) {
                        this.heartbeatTracer.log("Error in heartbeat tracer: " + UtlThrowable.prepareStackTrace((Throwable)e) + " ... closing", Tracer.Level.SEVERE);
                    }
                }
                if (this.heartbeatLog != null && this.heartbeatLog.isOpen()) {
                    SrvMonHeartbeatMessage toLog = message.copy();
                    try {
                        this.heartbeatLog.log((IRogMessage)toLog, true);
                        this.heartbeatLog.flush(false);
                        toLog.dispose();
                    }
                    catch (Exception e) {
                        this.tracer.log("Error in hearbeat logger: " + UtlThrowable.prepareStackTrace((Throwable)e) + " ... closing", Tracer.Level.SEVERE);
                        this.closeHeartbeatLog();
                    }
                }
                XIterator appsInfos = this.appsInfo.reuseableValueIterator();
                while (appsInfos.hasNext()) {
                    try {
                        SrvMonAppInfo appInfo = (SrvMonAppInfo)appsInfos.next();
                        switch (appInfo.getState()) {
                            case Active: 
                            case Loaded: 
                            case Started: {
                                this.appManager.dispatchEventToApp(appInfo.getName(), message);
                                break;
                            }
                        }
                    }
                    catch (Throwable e) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Heartbeat message dispatch faulted with error [" + e.toString() + "].\n");
                        sb.append("Stack trace:\n");
                        sb.append(UtlThrowable.prepareStackTrace((Throwable)e));
                        this.tracer.log(sb.toString(), Tracer.Level.WARNING);
                    }
                }
            }
            finally {
                message.dispose();
            }
        }
    }

    public final SrvAppManager getAppManager() {
        return this.appManager;
    }

    @Override
    protected final IDmnConfigDescriptor getConfigDescriptor() {
        return this.configDescriptor;
    }

    @Override
    protected final DmnThreadManager getThreadManager() {
        return this.threadManager;
    }

    @Override
    protected final void doInit() throws Exception {
        if (this.statsRunner != null) {
            this.openHeartbeatLog();
        }
    }

    @Override
    protected final void doStart() throws Exception {
        if (XRuntime.getValue((String)"nv.server.backgroundcommandinvocation", (boolean)true)) {
            this.commandExecutorService = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable runnable) {
                    Thread thread = new Thread(runnable, "X-Server-CommandExecutor");
                    thread.setDaemon(false);
                    thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                        @Override
                        public void uncaughtException(Thread thread, Throwable throwable) {
                            SrvController.this.tracer.log("Uncaught exception in command executor thread: " + UtlThrowable.prepareStackTrace((Throwable)throwable), Tracer.Level.WARNING);
                        }
                    });
                    return thread;
                }
            });
        }
        this.tracer.log("Starting the pool watch...", Tracer.Level.INFO);
        this.pools = UtlPoolRegistry.getInstance().getValues((UtlPoolRegistry.EventHandler)this.poolWatcher);
        this.pools.forEach(new ObjectProcedure(){

            public final boolean apply(Object element) {
                UtlPool pool = (UtlPool)element;
                if (((SrvController)SrvController.this).tracer.debug) {
                    SrvController.this.tracer.log("[POOL ACTIVATE*] {type='" + pool.type() + "', name='" + pool.name() + "'}", Tracer.Level.DEBUG);
                }
                if (SrvController.this.statsRunner != null) {
                    SrvController.this.statsRunner.onPoolAdded(pool);
                }
                return true;
            }
        });
        this.tracer.log("Starting the link manager...", Tracer.Level.INFO);
        this.advertisementDescriptorSet = this.linkInboundManager.start();
        this.tracer.log("Starting server advertisements...", Tracer.Level.INFO);
        this.tracer.log("...advertisement descriptor set", Tracer.Level.INFO);
        if (this.advertisementDescriptorSet.size() > 0) {
            for (UtlAddressDescriptor descriptor : this.advertisementDescriptorSet) {
                this.tracer.log("......" + descriptor.toString(), Tracer.Level.INFO);
            }
            this.discoveryCache.add("Server", this.configDescriptor.getName(), this.advertisementDescriptorSet);
        } else {
            this.tracer.log("...empty.", Tracer.Level.INFO);
        }
        this.tracer.log("Starting the application manager...", Tracer.Level.INFO);
        this.appManager.start();
        this.loadTime = System.currentTimeMillis();
        if (this.statsRunner != null) {
            this.tracer.log("Starting the statistics runner...", Tracer.Level.INFO);
            this.statsRunner.start();
        }
        if (this.systemName == null) {
            this.tracer.log("Server (NAME=" + this.configDescriptor.getName() + ") startup complete.", Tracer.Level.INFO);
        } else {
            this.tracer.log("Server (NAME=" + this.configDescriptor.getName() + ", SYSTEM=" + this.systemName.getValue() + (this.systemVersion != null ? " v" + this.systemVersion.getValue() : ADDRESS_NOT_AVAILABLE_STR) + ") startup complete.", Tracer.Level.INFO);
        }
    }

    @Override
    protected final void doStop() {
        if (this.statsRunner != null) {
            this.tracer.log("Stopping the statistics runner...", Tracer.Level.INFO);
            this.statsRunner.shutdown();
        }
        this.tracer.log("Stopping the link manager...", Tracer.Level.INFO);
        this.linkInboundManager.stop();
        if (this.commandExecutorService != null) {
            this.tracer.log("Stopping the command executor thread...", Tracer.Level.INFO);
            try {
                this.commandExecutorService.shutdown();
                if (!this.commandExecutorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    this.commandExecutorService.shutdownNow();
                    if (!this.commandExecutorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                        this.tracer.log("Timed out waiting for the command executor thread to terminate", Tracer.Level.WARNING);
                    }
                }
            }
            catch (InterruptedException e) {
                this.tracer.log("Interrupted while waiting for the command executor thread to terminate", Tracer.Level.WARNING);
                Thread.currentThread().interrupt();
            }
        }
        this.tracer.log("Stopping the application manager...", Tracer.Level.INFO);
        this.appManager.stop();
        this.tracer.log("Stopping server advertisements...", Tracer.Level.INFO);
        if (this.advertisementDescriptorSet.size() > 0) {
            this.discoveryCache.remove("Server", this.configDescriptor.getName());
        }
        this.tracer.log("Stopping the pool watch...", Tracer.Level.INFO);
        UtlPoolRegistry.getInstance().removeHandler((UtlPoolRegistry.EventHandler)this.poolWatcher);
    }

    @Override
    protected final void doClose() throws Exception {
        if (this.statsRunner != null) {
            this.closeHeartbeatLog();
        }
        if (this.discoveryCache != null) {
            this.tracer.log("Closing server discovery cache...", Tracer.Level.INFO);
            this.discoveryCache.close();
        }
        if (this.systemName == null) {
            this.tracer.log("Server (NAME=" + this.configDescriptor.getName() + ") shutdown complete.", Tracer.Level.INFO);
        } else {
            this.tracer.log("Server (NAME=" + this.configDescriptor.getName() + ", SYSTEM=" + this.systemName.getValue() + (this.systemVersion != null ? " v" + this.systemVersion.getValue() : ADDRESS_NOT_AVAILABLE_STR) + ") shutdown complete.", Tracer.Level.INFO);
        }
    }

    void doRestart() throws Exception {
        super.restart();
    }

    void doKill() throws Exception {
        super.kill();
    }

    private final <T extends ISrvMonTrace> T populateTraceRecord(LogRecord record, T admTraceRecord) {
        admTraceRecord.setProcessId(XRuntime.getPid());
        if (!this.address.equals((Object)ADDRESS_NOT_AVAILABLE)) {
            admTraceRecord.setHostAddressFrom(this.address);
        }
        if (!this.hostname.equals((Object)HOSTNAME_NOT_AVAILABLE)) {
            admTraceRecord.setHostNameFrom(this.hostname);
        }
        admTraceRecord.setXvmName(this.configDescriptor.getName());
        admTraceRecord.setTrace(record.getMessage());
        admTraceRecord.setTimestamp(record.getMillis());
        admTraceRecord.setThreadId(record.getThreadID());
        admTraceRecord.setTracerName(record.getLoggerName());
        Level level = record.getLevel();
        if (level == Level.OFF) {
            admTraceRecord.setLevel(SrvMonTraceLevel.OFF);
        } else if (level == Level.SEVERE) {
            admTraceRecord.setLevel(SrvMonTraceLevel.SEVERE);
        } else if (level == Level.WARNING) {
            admTraceRecord.setLevel(SrvMonTraceLevel.WARNING);
        } else if (level == Level.INFO) {
            admTraceRecord.setLevel(SrvMonTraceLevel.INFO);
        } else if (level == Level.CONFIG) {
            admTraceRecord.setLevel(SrvMonTraceLevel.CONFIG);
        } else if (level == Level.FINE) {
            admTraceRecord.setLevel(SrvMonTraceLevel.FINE);
        } else if (level == Level.FINER) {
            admTraceRecord.setLevel(SrvMonTraceLevel.FINER);
        } else if (level == Level.FINEST) {
            admTraceRecord.setLevel(SrvMonTraceLevel.FINEST);
        } else if (level == Level.ALL) {
            admTraceRecord.setLevel(SrvMonTraceLevel.ALL);
        } else {
            admTraceRecord.setLevel(SrvMonTraceLevel.UNKNOWN);
        }
        return admTraceRecord;
    }

    static {
        HOSTNAME_NOT_AVAILABLE = XString.create((String)HOSTNAME_NOT_AVAILABLE_STR);
        ADDRESS_NOT_AVAILABLE = XString.create((String)ADDRESS_NOT_AVAILABLE_STR);
        controllers = new HashMap<SrvConfigDescriptor, SrvController>();
    }

    public static final class StatsRunner
    extends Thread {
        private final SrvController controller;
        private final Sys sys;
        private final Pools pools;
        private final Threads threads;
        private final AdminClients adminClients;
        private final Apps apps;
        private final long statsInterval;
        private final WeakHashMap<Thread, XString> threadNameCache = new WeakHashMap();
        private final boolean seriesCollectionEnabled;
        private final IntHistogramComputer intervalIntSeriesComputer;
        private final LongHistogramComputer intervalLongSeriesComputer;
        private final DoubleArrayList tempSeriesCollectorArray = new DoubleArrayList();
        private final XLinkedHashMap<IStats.Series, IntSeriesCollector> intSeriesCollectors = new XLinkedHashMap();
        private final XLinkedHashMap<IStats.Series, LongSeriesCollector> longSeriesCollectors = new XLinkedHashMap();
        private final Object processingCriticalSection = new Object();
        private final SrvConfigDescriptor.Heartbeats config;
        private long lastThreadNameCacheCleanup = -1L;
        private boolean done;
        private static final long billion = 1000000000L;
        private static final long million = 1000000L;
        private static final long hunthou = 100000L;
        private static final long thou = 1000L;

        StatsRunner(SrvController controller) {
            this.config = controller.configDescriptor.getHeartbeats();
            this.setName("X-Server-" + controller.getConfigDescriptor().getName() + "-StatsRunner");
            this.controller = controller;
            this.sys = new Sys(this);
            this.pools = new Pools(this.config.isCollectPoolStats(), this.config.isCollectAllPoolStats(), controller.configDescriptor.getHeartbeats().getPoolDepletionThreshold());
            this.threads = new Threads();
            this.adminClients = new AdminClients();
            this.apps = new Apps(this);
            this.statsInterval = this.config.getInterval() * 1000L;
            this.seriesCollectionEnabled = this.config.isCollectSeriesStats();
            this.intervalIntSeriesComputer = new IntHistogramComputer();
            this.intervalLongSeriesComputer = new LongHistogramComputer();
        }

        private final XString lookupThreadName(Thread thread) {
            XString name = this.threadNameCache.get(thread);
            if (name == null) {
                name = XString.create((String)thread.getName(), (boolean)true, (boolean)false);
                this.threadNameCache.put(thread, name);
            }
            if (this.lastThreadNameCacheCleanup == -1L) {
                this.lastThreadNameCacheCleanup = System.currentTimeMillis();
            }
            if (this.threadNameCache.size() > 100 && this.lastThreadNameCacheCleanup - System.currentTimeMillis() > 60000L) {
                Iterator<Thread> cachedThreads = this.threadNameCache.keySet().iterator();
                while (cachedThreads.hasNext()) {
                    Thread candidate = cachedThreads.next();
                    if (candidate == null || candidate.isAlive()) continue;
                    cachedThreads.remove();
                }
            }
            return name;
        }

        private static final String counterToStr(long val) {
            if (val >= 1000000000L) {
                return String.format("%.1f", (double)val / 1.0E9) + "B";
            }
            if (val >= 1000000L) {
                return String.format("%.1f", (double)val / 1000000.0) + "M";
            }
            if (val >= 100000L) {
                return String.format("%d", val / 1000L) + "K";
            }
            return String.format("%d", val);
        }

        private static final String rateToStr(double val) {
            if (val >= 1.0E9) {
                return String.format("%.2f", val / 1.0E9) + "B";
            }
            if (val >= 1000000.0) {
                return String.format("%.2f", val / 1000000.0) + "M";
            }
            if (val >= 100000.0) {
                return String.format("%d", (long)val / 1000L) + "K";
            }
            if (val >= 1000.0) {
                return String.format("%.1f", val / 1000.0) + "K";
            }
            return String.format("%d", (long)val);
        }

        private final SrvMonIntSeries collectIntSeriesStats(IStats.Series series) {
            if (this.seriesCollectionEnabled && series != null) {
                IntSeriesCollector collector = (IntSeriesCollector)this.intSeriesCollectors.get((Object)series);
                if (collector == null) {
                    collector = new IntSeriesCollector(series, this.tempSeriesCollectorArray, this.controller.configDescriptor.getHeartbeats().isCollectSeriesDatapoints());
                    this.intSeriesCollectors.put((Object)series, (Object)collector);
                }
                try {
                    return collector.collect(this.intervalIntSeriesComputer);
                }
                catch (Throwable e) {
                    this.controller.tracer.log("Exception encountered while collecting series (int) stats: " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                    return null;
                }
            }
            return null;
        }

        private final SrvMonLongSeries collectLongSeriesStats(IStats.Series series) {
            if (this.seriesCollectionEnabled && series != null) {
                LongSeriesCollector collector = (LongSeriesCollector)this.longSeriesCollectors.get((Object)series);
                if (collector == null) {
                    collector = new LongSeriesCollector(series, this.tempSeriesCollectorArray, this.controller.configDescriptor.getHeartbeats().isCollectSeriesDatapoints());
                    this.longSeriesCollectors.put((Object)series, (Object)collector);
                }
                try {
                    return collector.collect(this.intervalLongSeriesComputer);
                }
                catch (Throwable e) {
                    this.controller.tracer.log("Exception encountered while collecting series (long) stats: " + UtlThrowable.prepareStackTrace((Throwable)e), Tracer.Level.WARNING);
                    return null;
                }
            }
            return null;
        }

        private final SrvMonAppMessageLoggerStats populateMessageLoggerStats(IStorePersisterStats loggerStats) {
            if (loggerStats != null) {
                SrvMonAppMessageLoggerStats monLoggerStats = SrvMonAppMessageLoggerStats.create();
                monLoggerStats.setNumMessagesRecorded(loggerStats.getNumSendsRecorded());
                monLoggerStats.setNumCommits(loggerStats.getNumCommits());
                monLoggerStats.setNumForks(loggerStats.getNumForks());
                monLoggerStats.setDetachedPersist(loggerStats.isDetached());
                if (monLoggerStats.getDetachedPersist()) {
                    SrvMonDisruptorStats disruptorStats = SrvMonDisruptorStats.create();
                    disruptorStats.setCapacity(loggerStats.getDisruptorCapacity());
                    disruptorStats.setRemaining(loggerStats.getDisruptorRemaining());
                    disruptorStats.setClaimStrategy(this.toDisruptorClaimStrategy(loggerStats.getDisruptorClaimStrategy()));
                    disruptorStats.setWaitStrategy(this.toDisruptorWaitStrategy(loggerStats.getDisruptorWaitStrategy()));
                    disruptorStats.setOfferToPollLatencies(this.collectIntSeriesStats((IStats.Series)loggerStats.getOfferToPollLatencies()));
                    monLoggerStats.setDisruptorStats(disruptorStats);
                }
                monLoggerStats.setFileSize(loggerStats.getFileSize());
                monLoggerStats.setFileSizeUsed(loggerStats.getFileSizeUsed());
                return monLoggerStats;
            }
            return null;
        }

        private final SrvMonDisruptorClaimStrategy toDisruptorClaimStrategy(String claimStrategyStr) {
            try {
                return SrvMonDisruptorClaimStrategy.valueOf(claimStrategyStr);
            }
            catch (Throwable e) {
                return SrvMonDisruptorClaimStrategy.Unknown;
            }
        }

        private final SrvMonDisruptorWaitStrategy toDisruptorWaitStrategy(String waitStrategyStr) {
            try {
                return SrvMonDisruptorWaitStrategy.valueOf(waitStrategyStr);
            }
            catch (Throwable e) {
                return SrvMonDisruptorWaitStrategy.Unknown;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void shutdown() {
            Object object = this.processingCriticalSection;
            synchronized (object) {
                this.done = true;
                this.interrupt();
            }
            while (true) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }

        final void onPoolAdded(UtlPool<?> pool) {
            this.pools.onPoolAdded(pool);
        }

        final void onPoolRemoved(UtlPool<?> pool) {
            this.pools.onPoolRemoved(pool);
        }

        final void onAppInitialized(SrvAppLoader appLoader) {
            this.apps.onAppInitialized(appLoader);
        }

        final void onAppUnloaded(String appName) {
            this.apps.onAppUnloaded(appName);
        }

        final void onAdminClientConnected(SrvControllerAdminApp.AdminClientContext client) {
            this.adminClients.onAdminClientConnected(client);
        }

        final void onAdminClientDisconnected(SrvControllerAdminApp.AdminClientContext client) {
            this.adminClients.onAdminClientDisconnected(client);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            UtlThread.setDefaultCPUAffinityMask();
            XIndexedList poolStats = new XIndexedList();
            XIndexedList adminClientStats = new XIndexedList();
            XIndexedList appStats = new XIndexedList();
            long nextHeartbeat = System.currentTimeMillis() + this.statsInterval;
            UtlThread.ThreadStats threadStats = UtlThread.registerOrGetThreadStats((Thread)Thread.currentThread());
            try {
                while (!this.done) {
                    try {
                        threadStats.preWait();
                        Thread.sleep(Math.max(0L, nextHeartbeat - System.currentTimeMillis()));
                        threadStats.postWait();
                        nextHeartbeat = System.currentTimeMillis() + this.statsInterval;
                        Object object = this.processingCriticalSection;
                        synchronized (object) {
                            if (!this.done) {
                                try {
                                    int appCount;
                                    long wallTime = System.currentTimeMillis();
                                    long ts1 = System.nanoTime();
                                    SrvMonSysStats sysStats = this.sys.createForHeartbeat();
                                    Map<String, SrvMonAppInfo> map = this.controller.getAppsInfo();
                                    synchronized (map) {
                                        appCount = this.controller.getAppsInfo().size();
                                    }
                                    this.pools.createForHeartbeat((XIndexedList<SrvMonPoolStats>)poolStats);
                                    this.adminClients.createForHeartbeat((XIndexedList<SrvMonAdminClientStats>)adminClientStats);
                                    this.apps.createForHeartbeat((XIndexedList<SrvMonAppStats>)appStats);
                                    SrvMonAppMessageLoggerStats heartbeatLoggerStats = null;
                                    if (this.controller.heartbeatLog != null && this.controller.heartbeatLog.isOpen()) {
                                        heartbeatLoggerStats = this.populateMessageLoggerStats(this.controller.heartbeatLog.getStats());
                                    }
                                    long ts2 = System.nanoTime();
                                    this.sys.print(wallTime, this.controller.getConfigDescriptor().getName(), XRuntime.getPid(), appCount, sysStats, ts2 - ts1);
                                    this.threads.print(sysStats);
                                    this.pools.print((XIndexedList<SrvMonPoolStats>)poolStats);
                                    this.adminClients.print((XIndexedList<SrvMonAdminClientStats>)adminClientStats);
                                    this.apps.print((XIndexedList<SrvMonAppStats>)appStats, wallTime);
                                    this.controller.onHeartbeat(wallTime, ts1, ts2, sysStats, (XIndexedList<SrvMonPoolStats>)poolStats, (XIndexedList<SrvMonAdminClientStats>)adminClientStats, (XIndexedList<SrvMonAppStats>)appStats, heartbeatLoggerStats);
                                }
                                catch (Throwable e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    finally {
                        poolStats.clear();
                        adminClientStats.clear();
                        appStats.clear();
                    }
                }
                return;
            }
            finally {
                UtlThread.deregister((Thread)Thread.currentThread());
            }
        }

        public static final void formatForPrint(CharSequence prefix, CharSequence name, SrvMonIntSeries timings, StringBuilder sb) {
            sb.append(prefix).append("[").append(name).append("(sno=");
            sb.append(timings.getLastSequenceNumber()).append(", ");
            sb.append("#points=").append(timings.getNumDataPoints()).append(", ");
            sb.append("#skipped=").append(timings.getSkippedDatapoints()).append(")\n");
            SrvMonIntHistogram computed = timings.getIntervalStats();
            sb.append(prefix).append("...").append(name).append("(interval): [");
            if (computed != null) {
                sb.append("sample=").append(computed.getSampleSize());
                sb.append(", min=").append(computed.getMinimum());
                sb.append(" max=").append(computed.getMaximum());
                sb.append(" mean=").append(computed.getMean());
                sb.append(" median=").append(computed.getMedian());
                sb.append(" 75%ile=").append(computed.getPct75());
                sb.append(" 90%ile=").append(computed.getPct90());
                sb.append(" 99%ile=").append(computed.getPct99());
                sb.append(" 99.9%ile=").append(computed.getPct999());
                sb.append(" 99.99%ile=").append(computed.getPct9999());
            } else {
                sb.append("none reported");
            }
            sb.append("]\n");
            computed = timings.getRunningStats();
            sb.append(prefix).append("...").append(name).append(" (running): [");
            if (computed != null) {
                sb.append("sample=").append(computed.getSampleSize());
                sb.append(", min=").append(computed.getMinimum());
                sb.append(" max=").append(computed.getMaximum());
                sb.append(" mean=").append(computed.getMean());
                sb.append(" median=").append(computed.getMedian());
                sb.append(" 75%ile=").append(computed.getPct75());
                sb.append(" 90%ile=").append(computed.getPct90());
                sb.append(" 99%ile=").append(computed.getPct99());
                sb.append(" 99.9%ile=").append(computed.getPct999());
                sb.append(" 99.99%ile=").append(computed.getPct9999());
            } else {
                sb.append("none reported");
            }
            sb.append("]\n");
        }

        public static final class Apps {
            private final XLinkedHashMap<String, AppStats> appsStats = new XLinkedHashMap();
            private final XIndexedList<IEventMultiplexerStats.IFeederQueueStats> feederQueueStatsCollector = new XIndexedList();
            private final XIndexedList<IAepBusManagerStats> busManagerStatsCollector = new XIndexedList();
            private final MsgTypeStatsCollector msgTypeStatsCollector = new MsgTypeStatsCollector();
            private final int inactiveMessageTypeStatsInclusionFrequency;
            private final Tracer tracer = Tracer.get((String)"nv.server.stats.app");
            private final Tracer userstatsTracer = Tracer.get((String)"nv.server.stats.userstats");
            private final StringBuilder sb = new StringBuilder();
            private final StatsRunner statsRunner;
            private int inactiveMessageTypeStatsInclusionCountdown = 1;

            @Deprecated
            public Apps() {
                this(null);
            }

            public Apps(StatsRunner statsRunner) {
                this.statsRunner = statsRunner;
                this.inactiveMessageTypeStatsInclusionFrequency = statsRunner != null ? statsRunner.config.getInactiveMessageTypeStatsInclusionFrequency() : 1;
                this.inactiveMessageTypeStatsInclusionCountdown = this.inactiveMessageTypeStatsInclusionFrequency;
            }

            private final SrvMonDisruptorClaimStrategy toDisruptorClaimStrategy(String claimStrategyStr) {
                try {
                    return SrvMonDisruptorClaimStrategy.valueOf(claimStrategyStr);
                }
                catch (Throwable e) {
                    return SrvMonDisruptorClaimStrategy.Unknown;
                }
            }

            private final SrvMonDisruptorWaitStrategy toDisruptorWaitStrategy(String waitStrategyStr) {
                try {
                    return SrvMonDisruptorWaitStrategy.valueOf(waitStrategyStr);
                }
                catch (Throwable e) {
                    return SrvMonDisruptorWaitStrategy.Unknown;
                }
            }

            private final void populateEngineStats(IAepEngineStats engineStats, SrvMonAppStats appStats) {
                SrvMonAppEngineStats monEngineStats = SrvMonAppEngineStats.create();
                monEngineStats.setNumFlows(engineStats.getNumFlows());
                monEngineStats.setNumMsgsRcvdBestEffort(engineStats.getNumMsgsRcvdBestEffort());
                monEngineStats.setNumMsgsRcvdGuaranteed(engineStats.getNumMsgsRcvdGuaranteed());
                monEngineStats.setNumMsgsFiltered(engineStats.getNumMsgsFiltered());
                monEngineStats.setNumMsgsSourced(engineStats.getNumMsgsSourced());
                monEngineStats.setNumDupMsgsRcvd(engineStats.getNumDupMsgsRcvd());
                monEngineStats.setNumMsgsSentBestEffort(engineStats.getNumMsgsSentBestEffort());
                monEngineStats.setNumMsgsSentGuaranteed(engineStats.getNumMsgsSentGuaranteed());
                monEngineStats.setNumMsgsResent(engineStats.getNumMsgsResent());
                monEngineStats.setNumEventsRcvd(engineStats.getNumEventsRcvd());
                monEngineStats.setNumEventsProcessed(engineStats.getNumEventsProcessed());
                monEngineStats.setNumFlowEventsRcvd(engineStats.getNumFlowEventsRcvd());
                monEngineStats.setNumFlowEventsProcSuccess(engineStats.getNumFlowEventsProcSuccess());
                monEngineStats.setNumFlowEventsProcFail(engineStats.getNumFlowEventsProcFail());
                monEngineStats.setNumFlowEventsProcComplete(engineStats.getNumFlowEventsProcComplete());
                monEngineStats.setNumTransactions(engineStats.getNumTransactions());
                monEngineStats.setNumCommitsStarted(engineStats.getNumCommitsStarted());
                monEngineStats.setNumCommitsCompleted(engineStats.getNumCommitsCompleted());
                monEngineStats.setNumSendCommitsStarted(engineStats.getNumSendCommitsStarted());
                monEngineStats.setNumSendCommitsCompleted(engineStats.getNumSendCommitsCompleted());
                monEngineStats.setSendCommitCompletionQueueSize(engineStats.getSendCommitCompletionQueueSize());
                monEngineStats.setNumStoreCommitsStarted(engineStats.getNumStoreCommitsStarted());
                monEngineStats.setNumStoreCommitsCompleted(engineStats.getNumStoreCommitsCompleted());
                monEngineStats.setStoreCommitCompletionQueueSize(engineStats.getStoreCommitCompletionQueueSize());
                monEngineStats.setNumRollbacks(engineStats.getNumRollbacks());
                monEngineStats.setNumPartialRollbacks(engineStats.getNumPartialRollbacks());
                monEngineStats.setBackupOutboundQueueSize(engineStats.getBackupOutboundQueueSize());
                monEngineStats.setBackupOutboundLogQueueSize(engineStats.getBackupOutboundLogQueueSize());
                monEngineStats.setOutboundSno(engineStats.getOutboundSequenceNumber());
                monEngineStats.setOutboundStableSno(engineStats.getOutboundStableSequenceNumber());
                monEngineStats.setCommitEpilogueLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getCommitEpilogueLatencies()));
                monEngineStats.setCommitFullLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getCommitFullLatencies()));
                monEngineStats.setCommitPrologueLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getCommitPrologueLatencies()));
                monEngineStats.setCommitSendLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getCommitSendLatencies()));
                monEngineStats.setCommitStartLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getCommitStartLatencies()));
                monEngineStats.setCommitStoreLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getCommitStoreLatencies()));
                monEngineStats.setCommitTransitionLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getCommitTransitionLatencies()));
                monEngineStats.setInAckLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getInAckLatencies()));
                monEngineStats.setInOutLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getInOutLatencies()));
                monEngineStats.setMsgPreProcLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getMsgPreProcessingLatencies()));
                monEngineStats.setMsgProcessingLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getMsgProcessingLatencies()));
                monEngineStats.setMsgFilteringLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getMsgFilteringLatencies()));
                monEngineStats.setMsgSendCoreLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getMsgSendCoreLatencies()));
                monEngineStats.setMsgSendLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getMsgSendLatencies()));
                monEngineStats.setTransactionLeg1ProcessingTimes(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getTransactionLeg1ProcessingTimes()));
                monEngineStats.setTransactionLeg2ProcessingTimes(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getTransactionLeg2ProcessingTimes()));
                monEngineStats.setTransactionLeg3ProcessingTimes(this.statsRunner.collectIntSeriesStats((IStats.Series)engineStats.getTransactionLeg3ProcessingTimes()));
                if (this.statsRunner.config.isIncludeMessageTypeStats()) {
                    this.msgTypeStatsCollector.collect(engineStats.getMessageTypeStatsTable(), monEngineStats);
                }
                this.populateUserStats(engineStats, appStats, monEngineStats);
                SrvMonAppEventMultiplexerStats monEventMultiplexerStats = SrvMonAppEventMultiplexerStats.create();
                IEventMultiplexerStats eventMultiplexerStats = engineStats.getEventMultiplexerStats();
                if (eventMultiplexerStats != null) {
                    monEventMultiplexerStats.setLastDecongested(eventMultiplexerStats.getLastDecongested());
                    monEventMultiplexerStats.setMaxConcurrency(eventMultiplexerStats.getMaxConcurrency());
                    monEventMultiplexerStats.setScheduleQueueSize(eventMultiplexerStats.getScheduleQueueSize());
                    SrvMonDisruptorStats monDisruptorStats = SrvMonDisruptorStats.create();
                    monDisruptorStats.setCapacity(eventMultiplexerStats.getCapacity());
                    monDisruptorStats.setRemaining(eventMultiplexerStats.getCapacityRemaining());
                    monDisruptorStats.setClaimStrategy(this.toDisruptorClaimStrategy(eventMultiplexerStats.getClaimStrategy()));
                    monDisruptorStats.setWaitStrategy(this.toDisruptorWaitStrategy(eventMultiplexerStats.getWaitStrategy()));
                    monDisruptorStats.setOfferToPollLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)eventMultiplexerStats.getOfferToPollLatencies()));
                    monEventMultiplexerStats.setDisruptorStats(monDisruptorStats);
                    this.feederQueueStatsCollector.clear();
                    eventMultiplexerStats.getFeederQueueStats(this.feederQueueStatsCollector);
                    for (int i = 0; i < this.feederQueueStatsCollector.size(); ++i) {
                        SrvMonAppEventMultiplexerFeederQueueStats stat = SrvMonAppEventMultiplexerFeederQueueStats.create();
                        Thread owner = ((IEventMultiplexerStats.IFeederQueueStats)this.feederQueueStatsCollector.get(i)).getOwner();
                        if (owner != null) {
                            if (this.statsRunner != null) {
                                stat.lendOwner(this.statsRunner.lookupThreadName(owner));
                            } else {
                                stat.setOwner(owner.getName());
                            }
                            stat.setSize(((IEventMultiplexerStats.IFeederQueueStats)this.feederQueueStatsCollector.get(i)).getSize());
                            stat.setDecongestCount(((IEventMultiplexerStats.IFeederQueueStats)this.feederQueueStatsCollector.get(i)).getDecongestCount());
                            stat.setOfferToPollLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)((IEventMultiplexerStats.IFeederQueueStats)this.feederQueueStatsCollector.get(i)).getOfferToPollLatencies()));
                        }
                        monEventMultiplexerStats.addFeederQueueStats(stat);
                    }
                }
                appStats.setEventMultiplexerStats(monEventMultiplexerStats);
                this.populateInboundMessageLoggerStats(engineStats, monEngineStats);
                this.populateOutboundMessageLoggerStats(engineStats, monEngineStats);
                this.populatePerTransactionStatsLoggerStats(engineStats, monEngineStats);
                appStats.setEngineStats(monEngineStats);
            }

            private final SrvMonAppStoreBindingRole toStoreBindingRole(IStoreBinding.Role role) {
                if (role != null) {
                    switch (role) {
                        case Primary: {
                            return SrvMonAppStoreBindingRole.Primary;
                        }
                        case Backup: {
                            return SrvMonAppStoreBindingRole.Backup;
                        }
                    }
                    return SrvMonAppStoreBindingRole.Unknown;
                }
                return null;
            }

            private final SrvMonAppStoreICRRole toStoreICRRole(IStoreBinding.InterClusterReplicationRole interClusterReplicationRole) {
                if (interClusterReplicationRole == null) {
                    return SrvMonAppStoreICRRole.None;
                }
                switch (interClusterReplicationRole) {
                    case Sender: {
                        return SrvMonAppStoreICRRole.Sender;
                    }
                    case StandaloneReceiver: {
                        return SrvMonAppStoreICRRole.StandaloneReceiver;
                    }
                }
                return SrvMonAppStoreICRRole.None;
            }

            private final SrvMonAppStoreBindingState toStoreBindingState(IStoreBinding.State state) {
                if (state != null) {
                    switch (state) {
                        case Opening: {
                            return SrvMonAppStoreBindingState.Opening;
                        }
                        case Open: {
                            return SrvMonAppStoreBindingState.Open;
                        }
                        case Failed: {
                            return SrvMonAppStoreBindingState.Failed;
                        }
                        case Closed: {
                            return SrvMonAppStoreBindingState.Closed;
                        }
                    }
                    return SrvMonAppStoreBindingState.Unknown;
                }
                return null;
            }

            private final void populateStoreBindingPersisterStats(IStoreBindingStats storeBindingStats, SrvMonAppStoreBindingStats stats) {
                IStorePersisterStats persisterStats = storeBindingStats.getPersisterStats();
                if (persisterStats != null) {
                    SrvMonAppStoreBindingPersisterStats monPersisterStats = SrvMonAppStoreBindingPersisterStats.create();
                    monPersisterStats.setNumPutsRecorded(persisterStats.getNumPutsRecorded());
                    monPersisterStats.setNumUpdatesRecorded(persisterStats.getNumUpdatesRecorded());
                    monPersisterStats.setNumRemovesRecorded(persisterStats.getNumRemovesRecorded());
                    monPersisterStats.setNumSendsRecorded(persisterStats.getNumSendsRecorded());
                    monPersisterStats.setNumCommits(persisterStats.getNumCommits());
                    monPersisterStats.setNumForks(persisterStats.getNumForks());
                    monPersisterStats.setDetachedPersist(persisterStats.isDetached());
                    if (monPersisterStats.getDetachedPersist()) {
                        SrvMonDisruptorStats disruptorStats = SrvMonDisruptorStats.create();
                        disruptorStats.setCapacity(persisterStats.getDisruptorCapacity());
                        disruptorStats.setRemaining(persisterStats.getDisruptorRemaining());
                        disruptorStats.setClaimStrategy(this.toDisruptorClaimStrategy(persisterStats.getDisruptorClaimStrategy()));
                        disruptorStats.setWaitStrategy(this.toDisruptorWaitStrategy(persisterStats.getDisruptorWaitStrategy()));
                        disruptorStats.setOfferToPollLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)persisterStats.getOfferToPollLatencies()));
                        monPersisterStats.setDisruptorStats(disruptorStats);
                    }
                    monPersisterStats.setFileSize(persisterStats.getFileSize());
                    monPersisterStats.setFileSizeUsed(persisterStats.getFileSizeUsed());
                    stats.setPersisterStats(monPersisterStats);
                }
            }

            private final void populateStoreBindingICRSenderStats(IStoreBindingStats storeBindingStats, SrvMonAppStoreBindingStats stats) {
                IStoreSenderStats senderStats = storeBindingStats.getICRSenderStats();
                if (senderStats != null) {
                    SrvMonAppStoreBindingICRSenderStats monSenderStats = SrvMonAppStoreBindingICRSenderStats.create();
                    monSenderStats.setNumPutsRecorded(senderStats.getNumPutsRecorded());
                    monSenderStats.setNumUpdatesRecorded(senderStats.getNumUpdatesRecorded());
                    monSenderStats.setNumRemovesRecorded(senderStats.getNumRemovesRecorded());
                    monSenderStats.setNumSendsRecorded(senderStats.getNumSendsRecorded());
                    monSenderStats.setNumCommits(senderStats.getNumCommits());
                    monSenderStats.setNumForks(senderStats.getNumForks());
                    monSenderStats.setDetachedSend(senderStats.isDetached());
                    if (monSenderStats.getDetachedSend()) {
                        SrvMonDisruptorStats disruptorStats = SrvMonDisruptorStats.create();
                        disruptorStats.setCapacity(senderStats.getDisruptorCapacity());
                        disruptorStats.setRemaining(senderStats.getDisruptorRemaining());
                        disruptorStats.setClaimStrategy(this.toDisruptorClaimStrategy(senderStats.getDisruptorClaimStrategy()));
                        disruptorStats.setWaitStrategy(this.toDisruptorWaitStrategy(senderStats.getDisruptorWaitStrategy()));
                        disruptorStats.setOfferToPollLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)senderStats.getOfferToPollLatencies()));
                        monSenderStats.setDisruptorStats(disruptorStats);
                    }
                    stats.setICRSenderStats(monSenderStats);
                }
            }

            private final void populateInboundMessageLoggerStats(IAepEngineStats engineStats, SrvMonAppEngineStats stats) {
                SrvMonAppMessageLoggerStats monLoggerStats = this.statsRunner.populateMessageLoggerStats(engineStats.getInboundMessageLoggerStats());
                stats.setInboundMessageLoggerStats(monLoggerStats);
            }

            private final void populateOutboundMessageLoggerStats(IAepEngineStats engineStats, SrvMonAppEngineStats stats) {
                SrvMonAppMessageLoggerStats monLoggerStats = this.statsRunner.populateMessageLoggerStats(engineStats.getOutboundMessageLoggerStats());
                stats.setOutboundMessageLoggerStats(monLoggerStats);
            }

            private final void populatePerTransactionStatsLoggerStats(IAepEngineStats engineStats, SrvMonAppEngineStats stats) {
                SrvMonAppMessageLoggerStats monLoggerStats = this.statsRunner.populateMessageLoggerStats(engineStats.getPerTransactionStatsLoggerStats());
                stats.setPerTransactionStatsLoggerStats(monLoggerStats);
            }

            private final void populateStoreBindingStats(IStoreBindingStats storeBindingStats, SrvMonAppStats appStats) {
                if (storeBindingStats != null) {
                    SrvMonAppStoreBindingStats monStoreBindingStats = SrvMonAppStoreBindingStats.create();
                    monStoreBindingStats.setRole(this.toStoreBindingRole(storeBindingStats.getRole()));
                    monStoreBindingStats.setICRRole(this.toStoreICRRole(storeBindingStats.getBinding().getInterClusterReplicationRole()));
                    monStoreBindingStats.setState(this.toStoreBindingState(storeBindingStats.getState()));
                    monStoreBindingStats.setSize(storeBindingStats.getBinding().sizeUnprotected());
                    monStoreBindingStats.setDataSize(storeBindingStats.getDataSize());
                    monStoreBindingStats.setNumCommitsSent(storeBindingStats.getNumCommitsSent());
                    monStoreBindingStats.setNumCommitEntriesSent(storeBindingStats.getNumCommitEntriesSent());
                    monStoreBindingStats.setNumCommitsReceived(storeBindingStats.getNumCommitsReceived());
                    monStoreBindingStats.setNumCommitEntriesReceived(storeBindingStats.getNumCommitEntriesReceived());
                    monStoreBindingStats.setNumCommitCompletionsSent(storeBindingStats.getNumCommitCompletionsSent());
                    monStoreBindingStats.setNumCommitCompletionsReceived(storeBindingStats.getNumCommitCompletionsReceived());
                    monStoreBindingStats.setCommitLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)storeBindingStats.getCommitLatencies()));
                    monStoreBindingStats.setCommitQueueSize(this.statsRunner.collectIntSeriesStats(storeBindingStats.getCommitQueueSizes()));
                    monStoreBindingStats.setDeserializeLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)storeBindingStats.getDeserializeLatencies()));
                    monStoreBindingStats.setIcrSendLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)storeBindingStats.getIcrSendLatencies()));
                    monStoreBindingStats.setIndexLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)storeBindingStats.getIndexLatencies()));
                    monStoreBindingStats.setPersistLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)storeBindingStats.getPersisterLatencies()));
                    monStoreBindingStats.setSerializeLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)storeBindingStats.getSerializeLatencies()));
                    monStoreBindingStats.setSerializeToPersistLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)storeBindingStats.getSerializeToPersistLatencies()));
                    monStoreBindingStats.setSerializeToWireLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)storeBindingStats.getSerializeToWireLatencies()));
                    monStoreBindingStats.setWireLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)storeBindingStats.getWireLatencies()));
                    monStoreBindingStats.setWireToDeserializeLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)storeBindingStats.getWireToDeserializeLatencies()));
                    this.populateStoreBindingPersisterStats(storeBindingStats, monStoreBindingStats);
                    this.populateStoreBindingICRSenderStats(storeBindingStats, monStoreBindingStats);
                    appStats.setStoreBindingStats(monStoreBindingStats);
                }
            }

            private final void populateBusManagerStats(List<IAepBusManagerStats> busManagersStats, SrvMonAppStats appStats) {
                for (int i = 0; i < busManagersStats.size(); ++i) {
                    IAepBusManagerStats busManagerStats = busManagersStats.get(i);
                    SrvMonAppBusBindingStats stats = SrvMonAppBusBindingStats.create();
                    stats.setBusBindingName(busManagerStats.getBusManager().getBusDescriptor().getName());
                    stats.setInternal(busManagerStats.getBusManager().isInternal());
                    stats.setNumMsgsRcvd(busManagerStats.getNumMsgsRcvd());
                    stats.setNumMsgsInBatchesRcvd(busManagerStats.getNumMsgsInBatchesRcvd());
                    stats.setNumMsgBatchesRcvd(busManagerStats.getNumMsgBatchesRcvd());
                    stats.setNumAcksSent(busManagerStats.getNumAcksSent());
                    stats.setNumMsgsEnqueued(busManagerStats.getNumMsgsEnqueued());
                    stats.setNumMsgsSent(busManagerStats.getNumMsgsSent());
                    stats.setNumFlushesSync(busManagerStats.getNumFlushesSync());
                    stats.setNumMsgsFlushedSync(busManagerStats.getNumMsgsFlushedSync());
                    stats.setNumFlushesAsync(busManagerStats.getNumFlushesAsync());
                    stats.setNumAsyncFlushCompletions(busManagerStats.getNumAsyncFlushCompletions());
                    stats.setNumMsgsFlushedAsync(busManagerStats.getNumMsgsFlushedAsync());
                    stats.setNumStabilityRcvd(busManagerStats.getNumStabilityRcvd());
                    stats.setNumStabilityInBatchesRcvd(busManagerStats.getNumStabilityInBatchesRcvd());
                    stats.setNumStabilityBatchesRcvd(busManagerStats.getNumStabilityBatchesRcvd());
                    stats.setNumPacketsRcvd(busManagerStats.getNumPacketsRcvd());
                    stats.setNumCommits(busManagerStats.getNumCommits());
                    stats.setNumRollbacks(busManagerStats.getNumRollbacks());
                    stats.setNumPartialRollbacks(busManagerStats.getNumPartialRollbacks());
                    stats.setNumClients(busManagerStats.getNumClients());
                    stats.setNumChannelsUp(busManagerStats.getNumChannelsUp());
                    stats.setNumBindingFailures(busManagerStats.getNumBindingFailures());
                    stats.setDetachedCommit(busManagerStats.isDetachedCommit());
                    MessageLatencyManager lm = busManagerStats.getLatencyManager();
                    if (lm != null) {
                        stats.setCreateToSendLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)lm.getCreateToSendLatencies()));
                        stats.setDeserializeLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)lm.getDeserializeLatencies()));
                        stats.setDeserializeToReceiveLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)lm.getDeserializeToReceiveLatencies()));
                        stats.setOriginToReceiveLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)lm.getOriginToReceiveLatencies()));
                        stats.setSendToPollLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)lm.getSendToPollLatencies()));
                        stats.setSendToSerializeLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)lm.getSendToSerializeLatencies()));
                        stats.setSerializeLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)lm.getSerializeLatencies()));
                        stats.setSerializeToWireLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)lm.getSerializeToWireLatencies()));
                        stats.setWireSendLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)lm.getWireSendLatencies()));
                        stats.setWireLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)lm.getWireLatencies()));
                        stats.setWireToDeserializeLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)lm.getWireToDeserializeLatencies()));
                        stats.setWireToWireLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)lm.getWireToWireLatencies()));
                    }
                    if (stats.getDetachedCommit()) {
                        SrvMonDisruptorStats disruptorStats = SrvMonDisruptorStats.create();
                        disruptorStats.setCapacity(busManagerStats.getDisruptorCapacity());
                        disruptorStats.setRemaining(busManagerStats.getDisruptorRemaining());
                        disruptorStats.setClaimStrategy(this.toDisruptorClaimStrategy(busManagerStats.getDisruptorClaimStrategy()));
                        disruptorStats.setWaitStrategy(this.toDisruptorWaitStrategy(busManagerStats.getDisruptorWaitStrategy()));
                        disruptorStats.setOfferToPollLatencies(this.statsRunner.collectIntSeriesStats((IStats.Series)busManagerStats.getDisruptorOfferToPollLatencies()));
                        stats.setDisruptorStats(disruptorStats);
                    }
                    appStats.addBusBindingStats(stats);
                }
            }

            private final void populateUserStats(IAepEngineStats engineStats, SrvMonAppStats stats, SrvMonAppEngineStats monEngineStats) {
                List userGauges;
                List userCounters;
                SrvMonUserStats userStats = null;
                List userLatencies = engineStats.getUserSeriesStats();
                if (!userLatencies.isEmpty() && this.statsRunner.seriesCollectionEnabled) {
                    if (userStats == null) {
                        userStats = SrvMonUserStats.create();
                    }
                    for (int i = 0; i < userLatencies.size(); ++i) {
                        IStats.Series recorded = (IStats.Series)userLatencies.get(i);
                        SrvMonUserSeriesStat stat = SrvMonUserSeriesStat.create();
                        stat.lendName(recorded.getNameAsRaw());
                        stat.setSeriesType(SrvMonSeriesType.LONG);
                        stat.setLongSeries(this.statsRunner.collectLongSeriesStats(recorded));
                        userStats.addSeries(stat);
                    }
                }
                if (!(userCounters = engineStats.getUserCounterStats()).isEmpty()) {
                    if (userStats == null) {
                        userStats = SrvMonUserStats.create();
                    }
                    for (int i = 0; i < userCounters.size(); ++i) {
                        IStats.Counter recorded = (IStats.Counter)userCounters.get(i);
                        SrvMonUserCounterStat stat = SrvMonUserCounterStat.create();
                        stat.lendName(recorded.getNameAsRaw());
                        stat.setCount(recorded.getCount());
                        userStats.addCounters(stat);
                    }
                }
                if (!(userGauges = engineStats.getUserGaugeStats()).isEmpty()) {
                    if (userStats == null) {
                        userStats = SrvMonUserStats.create();
                    }
                    for (int i = 0; i < userGauges.size(); ++i) {
                        IStats.Gauge recorded = (IStats.Gauge)userGauges.get(i);
                        SrvMonUserGaugeStat stat = SrvMonUserGaugeStat.create();
                        stat.lendName(recorded.getNameAsRaw());
                        SrvMonUtil.addGaugeValue(stat, recorded);
                        userStats.addGauges(stat);
                    }
                }
                stats.setUserStats(userStats);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final AppStats getAppStats(SrvMonAppStats stats, long collectionTime) {
                XLinkedHashMap<String, AppStats> xLinkedHashMap = this.appsStats;
                synchronized (xLinkedHashMap) {
                    AppStats appStats = (AppStats)this.appsStats.get((Object)stats.getAppName());
                    if (appStats == null) {
                        appStats = new AppStats(stats, collectionTime);
                        this.appsStats.put((Object)stats.getAppName(), (Object)appStats);
                    }
                    return appStats;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final void createForHeartbeat(XIndexedList<SrvMonAppStats> statsList) {
                XLinkedHashMap<String, AppStats> xLinkedHashMap = this.appsStats;
                synchronized (xLinkedHashMap) {
                    XIterator appsStatsIt = this.appsStats.reuseableValueIterator();
                    --this.inactiveMessageTypeStatsInclusionCountdown;
                    while (appsStatsIt.hasNext()) {
                        AppStats appStats = (AppStats)appsStatsIt.next();
                        SrvMonAppStats stats = SrvMonAppStats.create();
                        stats.setAppName(appStats.appLoader.getAppName());
                        IAepEngineStats engineStats = appStats.appLoader.getAppEngine().getStats();
                        this.populateEngineStats(engineStats, stats);
                        this.populateStoreBindingStats(engineStats.getStoreBindingStats(), stats);
                        this.busManagerStatsCollector.clear();
                        engineStats.getBusManagerStats(this.busManagerStatsCollector);
                        this.populateBusManagerStats((List<IAepBusManagerStats>)this.busManagerStatsCollector, stats);
                        statsList.add((Object)stats);
                    }
                    if (this.inactiveMessageTypeStatsInclusionCountdown <= 0) {
                        this.inactiveMessageTypeStatsInclusionCountdown = this.inactiveMessageTypeStatsInclusionFrequency;
                    }
                }
            }

            final void print(XIndexedList<SrvMonAppStats> appStats, long collectionTime) {
                if (this.tracer.debug) {
                    this.sb.setLength(0);
                    this.sb.append("\n");
                    if (appStats.size() > 0) {
                        for (int i = 0; i < appStats.size(); ++i) {
                            this.formatForPrint(null, null, (SrvMonAppStats)appStats.get(i), collectionTime, this.sb);
                        }
                        this.tracer.log(this.sb.toString(), Tracer.Level.DEBUG);
                    } else {
                        this.sb.append("...<no apps>").append("\n");
                    }
                    this.tracer.log(this.sb.toString(), Tracer.Level.DEBUG);
                } else if (this.userstatsTracer.debug) {
                    this.sb.setLength(0);
                    this.sb.append("\n");
                    if (appStats.size() > 0) {
                        for (int i = 0; i < appStats.size(); ++i) {
                            this.formatForPrint(EntityType.UserStat, null, (SrvMonAppStats)appStats.get(i), collectionTime, this.sb);
                        }
                    } else {
                        this.sb.append("...<no user stats>").append("\n");
                    }
                    this.userstatsTracer.log(this.sb.toString(), Tracer.Level.DEBUG);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final void onAppInitialized(SrvAppLoader appLoader) {
                XLinkedHashMap<String, AppStats> xLinkedHashMap = this.appsStats;
                synchronized (xLinkedHashMap) {
                    this.appsStats.put((Object)appLoader.getAppName(), (Object)new AppStats(appLoader));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final void onAppUnloaded(String appName) {
                XLinkedHashMap<String, AppStats> xLinkedHashMap = this.appsStats;
                synchronized (xLinkedHashMap) {
                    this.appsStats.remove((Object)appName);
                }
            }

            public final StringBuilder formatForPrint(EntityType entityType, String entityName, SrvMonAppStats stats, long collectionTime, StringBuilder sb) {
                return this.getAppStats(stats, collectionTime).formatForPrint(entityType, entityName, stats, collectionTime, sb);
            }

            private final class AppStats {
                private final SrvAppLoader appLoader;
                private final NumberFormat format;
                private EngineStats engineStats;
                private StoreBindingStats storeBindingStats;
                private Map<String, BusBindingStats> busBindingsStats = new HashMap<String, BusBindingStats>();
                private long startTime;
                private long stampTime;

                AppStats(SrvAppLoader appLoader) {
                    this.format = NumberFormat.getInstance();
                    this.format.setMaximumFractionDigits(2);
                    this.appLoader = appLoader;
                    this.stampTime = this.startTime = System.currentTimeMillis();
                    this.init(appLoader);
                }

                AppStats(SrvMonAppStats stats, long collectionTime) {
                    this.format = NumberFormat.getInstance();
                    this.format.setMaximumFractionDigits(2);
                    this.appLoader = null;
                    this.stampTime = this.startTime = collectionTime;
                    this.refresh(stats);
                }

                private final void init(SrvAppLoader appLoader) {
                    AepEngine engine = appLoader.getAppEngine();
                    this.engineStats = new EngineStats(engine);
                    if (engine.getStore() != null) {
                        this.storeBindingStats = new StoreBindingStats(engine.getStore());
                    }
                    for (AepBusManager busManager : engine.getBusManagers()) {
                        this.busBindingsStats.put(busManager.getBusDescriptor().getName(), new BusBindingStats(busManager));
                    }
                }

                private final void refresh(SrvMonAppStats stats) {
                }

                private final void stamp(SrvMonAppStats stats) {
                    SrvMonAppBusBindingStats[] monBusBindingsStats;
                    if (stats.getEngineStats() != null) {
                        if (this.engineStats == null) {
                            this.engineStats = new EngineStats(stats.getEngineStats());
                        }
                        this.engineStats.stamp(stats.getEngineStats());
                    }
                    if (stats.getStoreBindingStats() != null) {
                        if (this.storeBindingStats == null) {
                            this.storeBindingStats = new StoreBindingStats(stats.getStoreBindingStats());
                        }
                        this.storeBindingStats.stamp(stats.getStoreBindingStats());
                    }
                    if ((monBusBindingsStats = stats.getBusBindingStats()) != null) {
                        for (SrvMonAppBusBindingStats monBusBindingStats : monBusBindingsStats) {
                            BusBindingStats busBindingStats = this.busBindingsStats.get(monBusBindingStats.getBusBindingName());
                            if (busBindingStats == null) {
                                busBindingStats = new BusBindingStats(monBusBindingStats);
                                this.busBindingsStats.put(monBusBindingStats.getBusBindingName(), busBindingStats);
                            }
                            busBindingStats.stamp(monBusBindingStats);
                        }
                    }
                    this.refresh(stats);
                }

                private final void formatForPrint(EntityType entityType, String entityName, SrvMonAppStats stats, long deltaTime, long totalTime, StringBuilder sb) {
                    switch (entityType) {
                        case Engine: {
                            sb.append("\n[App (").append((CharSequence)stats.getAppNameUnsafe()).append(") Engine Stats]\n");
                            if (this.engineStats != null) {
                                this.engineStats.formatForPrint(deltaTime, totalTime, sb);
                                SrvMonAppEventMultiplexerStats mxStats = stats.getEventMultiplexerStats();
                                sb.append("[Event Multiplexer (").append((CharSequence)stats.getAppNameUnsafe()).append("))\n");
                                if (mxStats != null) {
                                    sb.append("...");
                                    this.formatForPrint(mxStats.getDisruptorStats(), sb);
                                    sb.append("\n");
                                    sb.append("Schedule Queue (size=").append(mxStats.hasScheduleQueueSize() ? Integer.valueOf(mxStats.getScheduleQueueSize()) : "?").append(")").append("\n");
                                    this.formatForPrint(mxStats, mxStats.getFeederQueueStats(), sb);
                                    sb.append("\n");
                                }
                                this.formatForPrint(EntityType.UserStat, null, stats, deltaTime, totalTime, sb);
                                break;
                            }
                            sb.append("...no engine!\n");
                            break;
                        }
                        case EventMultiplexer: {
                            break;
                        }
                        case StoreBinding: {
                            sb.append("\n[App (").append((CharSequence)stats.getAppNameUnsafe()).append(") Store Binding Stats]").append("\n");
                            if (this.storeBindingStats != null) {
                                this.storeBindingStats.formatForPrint(entityType, stats.getStoreBindingStats(), deltaTime, totalTime, sb);
                                break;
                            }
                            sb.append("...no store\n");
                            break;
                        }
                        case StoreBindingPersister: {
                            sb.append("\n[App (").append((CharSequence)stats.getAppNameUnsafe()).append(") Store Binding Persister Stats]").append("\n");
                            if (this.storeBindingStats != null) {
                                this.storeBindingStats.formatForPrint(entityType, stats.getStoreBindingStats(), deltaTime, totalTime, sb);
                                break;
                            }
                            sb.append("...no store\n");
                            break;
                        }
                        case StoreBindingICRSender: {
                            sb.append("\n[App (").append((CharSequence)stats.getAppNameUnsafe()).append(") Store Binding ICR Sender Stats]").append("\n");
                            if (this.storeBindingStats != null) {
                                this.storeBindingStats.formatForPrint(entityType, stats.getStoreBindingStats(), deltaTime, totalTime, sb);
                                break;
                            }
                            sb.append("...no store\n");
                            break;
                        }
                        case BusBinding: {
                            sb.append("\n[App (").append((CharSequence)stats.getAppNameUnsafe()).append(")  Bus Binding (" + entityName + ")]").append("\n");
                            SrvMonAppBusBindingStats monBusBindingStats = null;
                            if (stats.getBusBindingStats() != null) {
                                for (SrvMonAppBusBindingStats s : stats.getBusBindingStats()) {
                                    if (!entityName.equals(s.getBusBindingName())) continue;
                                    monBusBindingStats = s;
                                    break;
                                }
                            }
                            if (monBusBindingStats != null) {
                                if (this.busBindingsStats.get(entityName) != null) {
                                    sb.append("<");
                                    boolean isDetached = monBusBindingStats.getDetachedCommit();
                                    sb.append(isDetached ? "Detached" : "Attached");
                                    if (isDetached) {
                                        this.formatForPrint(monBusBindingStats.getDisruptorStats(), sb.append(" ,"));
                                    }
                                    sb.append(">").append("\n");
                                    this.busBindingsStats.get(entityName).formatForPrint(deltaTime, totalTime, sb);
                                    break;
                                }
                                sb.append("...no bus binding '" + entityName + "'").append("\n");
                                break;
                            }
                            sb.append("...no bus binding '" + entityName + "' (in supplied stats!)\n");
                            break;
                        }
                        case UserStat: {
                            if (entityName == null) {
                                sb.append("\n[App (").append((CharSequence)stats.getAppNameUnsafe()).append(") User Stats]\n");
                            }
                            boolean found = false;
                            SrvMonUserStats userStats = stats.getUserStats();
                            if (userStats != null) {
                                XIterator<SrvMonUserCounterStat> counters = stats.getUserStats().getCountersIterator();
                                if (entityName == null && counters.hasNext()) {
                                    sb.append("...Counters {\n");
                                }
                                while (counters.hasNext()) {
                                    SrvMonUserCounterStat counter = (SrvMonUserCounterStat)counters.next();
                                    if (entityName == null) {
                                        sb.append("......");
                                    }
                                    if (entityName != null && counter.getNameUnsafe().compareTo((CharSequence)entityName) != 0) continue;
                                    sb.append((CharSequence)counter.getNameUnsafe()).append(": ").append(counter.getCount()).append("\n");
                                    found = true;
                                }
                                if (entityName == null && counters.toFirst().hasNext()) {
                                    sb.append("...}\n");
                                }
                                XIterator<SrvMonUserGaugeStat> gauges = stats.getUserStats().getGaugesIterator();
                                if (entityName == null && gauges.hasNext()) {
                                    sb.append("...Gauges{\n");
                                }
                                while (gauges.hasNext()) {
                                    SrvMonUserGaugeStat gauge = (SrvMonUserGaugeStat)gauges.next();
                                    if (entityName == null) {
                                        sb.append("......");
                                    }
                                    if (entityName != null && gauge.getNameUnsafe().compareTo((CharSequence)entityName) != 0) continue;
                                    sb.append((CharSequence)gauge.getNameUnsafe()).append(": ").append(SrvMonUtil.getGaugeValue(gauge)).append("\n");
                                    found = true;
                                }
                                if (entityName == null && gauges.toFirst().hasNext()) {
                                    sb.append("...}\n");
                                }
                                XIterator<SrvMonUserSeriesStat> userSeries = stats.getUserStats().getSeriesIterator();
                                if (entityName == null && userSeries.hasNext()) {
                                    sb.append("...Series{\n");
                                }
                                while (userSeries.hasNext()) {
                                    SrvMonUserSeriesStat series = (SrvMonUserSeriesStat)userSeries.next();
                                    if (entityName != null && series.getNameUnsafe().compareTo((CharSequence)entityName) != 0) continue;
                                    StatsRunner.formatForPrint(entityName == null ? "......" : SrvController.ADDRESS_NOT_AVAILABLE_STR, series.getName(), series.getIntSeries(), sb);
                                    found = true;
                                }
                                if (entityName == null && userSeries.toFirst().hasNext()) {
                                    sb.append("...}\n");
                                }
                            }
                            if (found) break;
                            if (entityName == null) {
                                sb.append("...no user stats.\n");
                                break;
                            }
                            sb.append("...no '").append(entityName).append("' stat found!\n");
                            break;
                        }
                    }
                }

                final void formatForPrint(SrvMonDisruptorStats stats, StringBuilder sb) {
                    sb.append("Disruptor {");
                    if (stats != null) {
                        int capacity = stats.getCapacity();
                        int remaining = stats.getRemaining();
                        int used = capacity - remaining;
                        int usagePct = used * 100 / capacity;
                        sb.append("[").append(this.format.format(used)).append(" of ").append(this.format.format(capacity)).append("] ").append(usagePct).append("%").append(" (").append((Object)stats.getClaimStrategy()).append(", ").append((Object)stats.getWaitStrategy()).append(")");
                    } else {
                        sb.append("?");
                    }
                    sb.append("}");
                }

                final void formatForPrint(SrvMonAppEventMultiplexerStats mxStats, SrvMonAppEventMultiplexerFeederQueueStats[] stats, StringBuilder sb) {
                    sb.append("Feeder Queues (max=").append(mxStats.hasMaxConcurrency() ? Integer.valueOf(mxStats.getMaxConcurrency()) : "?");
                    sb.append(",lastDecongest=").append(mxStats.hasLastDecongested() ? Integer.valueOf(mxStats.getLastDecongested()) : "?").append("){");
                    if (stats != null) {
                        for (int i = 0; i < stats.length; ++i) {
                            if (stats[i] != null && stats[i].hasOwner()) {
                                XString owner = stats[i].getOwnerUnsafe();
                                int size = stats[i].getSize();
                                int decongestCount = stats[i].getDecongestCount();
                                sb.append("\n......").append((CharSequence)owner).append(": size=").append(size).append(", decongestCount=").append(decongestCount);
                                continue;
                            }
                            sb.append("...?");
                        }
                    }
                    sb.append("\n...}");
                }

                final StringBuilder formatForPrint(EntityType entityType, String entityName, SrvMonAppStats stats, long collectionTime, StringBuilder sb) {
                    long deltaTime = collectionTime - this.stampTime;
                    long totalTime = collectionTime - this.startTime;
                    this.stamp(stats);
                    this.stampTime = collectionTime;
                    if (deltaTime > 0L && totalTime > 0L) {
                        if (entityType != null) {
                            this.formatForPrint(entityType, entityName, stats, deltaTime, totalTime, sb);
                        } else {
                            this.formatForPrint(EntityType.Engine, null, stats, deltaTime, totalTime, sb);
                            this.formatForPrint(EntityType.StoreBinding, null, stats, deltaTime, totalTime, sb);
                            this.formatForPrint(EntityType.StoreBindingPersister, null, stats, deltaTime, totalTime, sb);
                            this.formatForPrint(EntityType.StoreBindingICRSender, null, stats, deltaTime, totalTime, sb);
                            for (String busBindingName : this.busBindingsStats.keySet()) {
                                this.formatForPrint(EntityType.BusBinding, busBindingName, stats, deltaTime, totalTime, sb);
                            }
                        }
                    }
                    return sb;
                }

                private final class BusBindingStats {
                    private long numMsgsRcvdLast;
                    private long numMsgsInBatchesRcvdLast;
                    private long numMsgBatchesRcvdLast;
                    private long numMsgsEnqueuedLast;
                    private long numMsgsSentLast;
                    private long numFlushesSyncLast;
                    private long numMsgsFlushedSyncLast;
                    private long numFlushesAsyncLast;
                    private long numMsgsFlushedAsyncLast;
                    private long numStabilityRcvdLast;
                    private long numStabilityInBatchesRcvdLast;
                    private long numStabilityBatchesRcvdLast;
                    private long numPacketsRcvdLast;
                    private long numCommitsLast;
                    private long numMsgsRcvdCurrent;
                    private long numMsgsInBatchesRcvdCurrent;
                    private long numMsgBatchesRcvdCurrent;
                    private long numMsgsEnqueuedCurrent;
                    private long numMsgsSentCurrent;
                    private long numFlushesSyncCurrent;
                    private long numMsgsFlushedSyncCurrent;
                    private long numFlushesAsyncCurrent;
                    private long numMsgsFlushedAsyncCurrent;
                    private long numStabilityRcvdCurrent;
                    private long numStabilityInBatchesRcvdCurrent;
                    private long numStabilityBatchesRcvdCurrent;
                    private long numPacketsRcvdCurrent;
                    private long numCommitsCurrent;
                    private long numRollbacksCurrent;
                    private int numClientsCurrent;
                    private int numChannelsUpCurrent;
                    private int numBindingFailuresCurrent;

                    BusBindingStats(AepBusManager busManager) {
                        this.init(busManager);
                    }

                    BusBindingStats(SrvMonAppBusBindingStats stats) {
                        this.refresh(stats);
                    }

                    private final void formatHeader1ForPrint(StringBuilder sb) {
                        sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s", "MRCV", "RATE", "DRATE", "MRCVI", "RATE", "DRATE", "MRCVB", "RATE", "DRATE", "MENQ", "RATE", "DRATE", "MSND", "RATE", "DRATE", "FLS", "RATE", "DRATE", "MFLS", "RATE", "DRATE", "FLA", "RATE", "DRATE", "MFLA", "RATE", "DRATE")).append("\n");
                    }

                    private final void formatHeader2ForPrint(StringBuilder sb) {
                        sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s", "STB", "RATE", "DRATE", "STBIB", "RATE", "DRATE", "STBB", "RATE", "DRATE", "PRCV", "RATE", "DRATE", "COM", "RATE", "DRATE", "RLBK", "CLNTS", "CHNLS", "FAILS")).append("\n");
                    }

                    private final void init(AepBusManager busManager) {
                        AepBusManagerStats stats = busManager.getStats();
                        this.numMsgsRcvdCurrent = stats.getNumMsgsRcvd();
                        this.numMsgsInBatchesRcvdCurrent = stats.getNumMsgsInBatchesRcvd();
                        this.numMsgBatchesRcvdCurrent = stats.getNumMsgBatchesRcvd();
                        this.numMsgsEnqueuedCurrent = stats.getNumMsgsEnqueued();
                        this.numMsgsSentCurrent = stats.getNumMsgsSent();
                        this.numFlushesSyncCurrent = stats.getNumFlushesSync();
                        this.numMsgsFlushedSyncCurrent = stats.getNumMsgsFlushedSync();
                        this.numFlushesAsyncCurrent = stats.getNumFlushesAsync();
                        this.numMsgsFlushedAsyncCurrent = stats.getNumMsgsFlushedAsync();
                        this.numStabilityRcvdCurrent = stats.getNumStabilityRcvd();
                        this.numStabilityInBatchesRcvdCurrent = stats.getNumStabilityInBatchesRcvd();
                        this.numStabilityBatchesRcvdCurrent = stats.getNumStabilityBatchesRcvd();
                        this.numPacketsRcvdCurrent = stats.getNumPacketsRcvd();
                        this.numCommitsCurrent = stats.getNumCommits();
                        this.numRollbacksCurrent = stats.getNumRollbacks();
                        this.numClientsCurrent = stats.getNumClients();
                        this.numChannelsUpCurrent = stats.getNumChannelsUp();
                        this.numBindingFailuresCurrent = stats.getNumBindingFailures();
                    }

                    private final void refresh(SrvMonAppBusBindingStats stats) {
                        this.numMsgsRcvdCurrent = stats.getNumMsgsRcvd();
                        this.numMsgsInBatchesRcvdCurrent = stats.getNumMsgsInBatchesRcvd();
                        this.numMsgBatchesRcvdCurrent = stats.getNumMsgBatchesRcvd();
                        this.numMsgsEnqueuedCurrent = stats.getNumMsgsEnqueued();
                        this.numMsgsSentCurrent = stats.getNumMsgsSent();
                        this.numFlushesSyncCurrent = stats.getNumFlushesSync();
                        this.numMsgsFlushedSyncCurrent = stats.getNumMsgsFlushedSync();
                        this.numFlushesAsyncCurrent = stats.getNumFlushesAsync();
                        this.numMsgsFlushedAsyncCurrent = stats.getNumMsgsFlushedAsync();
                        this.numStabilityRcvdCurrent = stats.getNumStabilityRcvd();
                        this.numStabilityInBatchesRcvdCurrent = stats.getNumStabilityInBatchesRcvd();
                        this.numStabilityBatchesRcvdCurrent = stats.getNumStabilityBatchesRcvd();
                        this.numPacketsRcvdCurrent = stats.getNumPacketsRcvd();
                        this.numCommitsCurrent = stats.getNumCommits();
                        this.numRollbacksCurrent = stats.getNumRollbacks();
                        this.numClientsCurrent = stats.getNumClients();
                        this.numChannelsUpCurrent = stats.getNumChannelsUp();
                        this.numBindingFailuresCurrent = stats.getNumBindingFailures();
                    }

                    final void stamp(SrvMonAppBusBindingStats stats) {
                        this.numMsgsRcvdLast = this.numMsgsRcvdCurrent;
                        this.numMsgsInBatchesRcvdLast = this.numMsgsInBatchesRcvdCurrent;
                        this.numMsgBatchesRcvdLast = this.numMsgBatchesRcvdCurrent;
                        this.numMsgsEnqueuedLast = this.numMsgsEnqueuedCurrent;
                        this.numMsgsSentLast = this.numMsgsSentCurrent;
                        this.numFlushesSyncLast = this.numFlushesSyncCurrent;
                        this.numMsgsFlushedSyncLast = this.numMsgsFlushedSyncCurrent;
                        this.numFlushesAsyncLast = this.numFlushesAsyncCurrent;
                        this.numMsgsFlushedAsyncLast = this.numMsgsFlushedAsyncCurrent;
                        this.numStabilityRcvdLast = this.numStabilityRcvdCurrent;
                        this.numStabilityInBatchesRcvdLast = this.numStabilityInBatchesRcvdCurrent;
                        this.numStabilityBatchesRcvdLast = this.numStabilityBatchesRcvdCurrent;
                        this.numPacketsRcvdLast = this.numPacketsRcvdCurrent;
                        this.numCommitsLast = this.numCommitsCurrent;
                        this.refresh(stats);
                    }

                    final void formatForPrint(long deltaTime, long totalTime, StringBuilder sb) {
                        double msgRecvRate = (double)this.numMsgsRcvdCurrent * 1000.0 / (double)totalTime;
                        double deltaMsgRecvRate = (double)(this.numMsgsRcvdCurrent - this.numMsgsRcvdLast) * 1000.0 / (double)deltaTime;
                        double msgInBatchRecvRate = (double)this.numMsgsInBatchesRcvdCurrent * 1000.0 / (double)totalTime;
                        double deltaMsgInBatchRecvRate = (double)(this.numMsgsInBatchesRcvdCurrent - this.numMsgsInBatchesRcvdLast) * 1000.0 / (double)deltaTime;
                        double msgBatchRecvRate = (double)this.numMsgBatchesRcvdCurrent * 1000.0 / (double)totalTime;
                        double deltaMsgBatchRecvRate = (double)(this.numMsgBatchesRcvdCurrent - this.numMsgBatchesRcvdLast) * 1000.0 / (double)deltaTime;
                        double msgEnqueRate = (double)this.numMsgsEnqueuedCurrent * 1000.0 / (double)totalTime;
                        double deltaMsgEnqueRate = (double)(this.numMsgsEnqueuedCurrent - this.numMsgsEnqueuedLast) * 1000.0 / (double)deltaTime;
                        double msgSendRate = (double)this.numMsgsSentCurrent * 1000.0 / (double)totalTime;
                        double deltaMsgSendRate = (double)(this.numMsgsSentCurrent - this.numMsgsSentLast) * 1000.0 / (double)deltaTime;
                        double syncFlushRate = (double)this.numFlushesSyncCurrent * 1000.0 / (double)totalTime;
                        double deltaSyncFlushRate = (double)(this.numFlushesSyncCurrent - this.numFlushesSyncLast) * 1000.0 / (double)deltaTime;
                        double msgsSyncFlushRate = (double)this.numMsgsFlushedSyncCurrent * 1000.0 / (double)totalTime;
                        double deltaMsgsSyncFlushRate = (double)(this.numMsgsFlushedSyncCurrent - this.numMsgsFlushedSyncLast) * 1000.0 / (double)deltaTime;
                        double asyncFlushRate = (double)this.numFlushesAsyncCurrent * 1000.0 / (double)totalTime;
                        double deltaAsyncFlushRate = (double)(this.numFlushesAsyncCurrent - this.numFlushesAsyncLast) * 1000.0 / (double)deltaTime;
                        double msgsAsyncFlushRate = (double)this.numMsgsFlushedAsyncCurrent * 1000.0 / (double)totalTime;
                        double deltaMsgsAsyncFlushRate = (double)(this.numMsgsFlushedAsyncCurrent - this.numMsgsFlushedAsyncLast) * 1000.0 / (double)deltaTime;
                        double stabilityRecvRate = (double)this.numStabilityRcvdCurrent * 1000.0 / (double)totalTime;
                        double deltaStabilityRecvRate = (double)(this.numStabilityRcvdCurrent - this.numStabilityRcvdLast) * 1000.0 / (double)deltaTime;
                        double stabilityInBatchRecvRate = (double)this.numStabilityInBatchesRcvdCurrent * 1000.0 / (double)totalTime;
                        double deltaStabilityInBatchRecvRate = (double)(this.numStabilityInBatchesRcvdCurrent - this.numStabilityInBatchesRcvdLast) * 1000.0 / (double)deltaTime;
                        double stabilityBatchRecvRate = (double)this.numStabilityBatchesRcvdCurrent * 1000.0 / (double)totalTime;
                        double deltaStabilityBatchRecvRate = (double)(this.numStabilityBatchesRcvdCurrent - this.numStabilityBatchesRcvdLast) * 1000.0 / (double)deltaTime;
                        double packetRecvRate = (double)this.numPacketsRcvdCurrent * 1000.0 / (double)totalTime;
                        double deltaPacketRecvRate = (double)(this.numPacketsRcvdCurrent - this.numPacketsRcvdLast) * 1000.0 / (double)deltaTime;
                        double commitRate = (double)this.numCommitsCurrent * 1000.0 / (double)totalTime;
                        double deltaCommitRate = (double)(this.numCommitsCurrent - this.numCommitsLast) * 1000.0 / (double)deltaTime;
                        this.formatHeader1ForPrint(sb);
                        sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s", StatsRunner.counterToStr(this.numMsgsRcvdCurrent), StatsRunner.rateToStr(msgRecvRate), StatsRunner.rateToStr(deltaMsgRecvRate), StatsRunner.counterToStr(this.numMsgsInBatchesRcvdCurrent), StatsRunner.rateToStr(msgInBatchRecvRate), StatsRunner.rateToStr(deltaMsgInBatchRecvRate), StatsRunner.counterToStr(this.numMsgBatchesRcvdCurrent), StatsRunner.rateToStr(msgBatchRecvRate), StatsRunner.rateToStr(deltaMsgBatchRecvRate), StatsRunner.counterToStr(this.numMsgsEnqueuedCurrent), StatsRunner.rateToStr(msgEnqueRate), StatsRunner.rateToStr(deltaMsgEnqueRate), StatsRunner.counterToStr(this.numMsgsSentCurrent), StatsRunner.rateToStr(msgSendRate), StatsRunner.rateToStr(deltaMsgSendRate), StatsRunner.counterToStr(this.numFlushesSyncCurrent), StatsRunner.rateToStr(syncFlushRate), StatsRunner.rateToStr(deltaSyncFlushRate), StatsRunner.counterToStr(this.numMsgsFlushedSyncCurrent), StatsRunner.rateToStr(msgsSyncFlushRate), StatsRunner.rateToStr(deltaMsgsSyncFlushRate), StatsRunner.counterToStr(this.numFlushesAsyncCurrent), StatsRunner.rateToStr(asyncFlushRate), StatsRunner.rateToStr(deltaAsyncFlushRate), StatsRunner.counterToStr(this.numMsgsFlushedAsyncCurrent), StatsRunner.rateToStr(msgsAsyncFlushRate), StatsRunner.rateToStr(deltaMsgsAsyncFlushRate))).append("\n");
                        this.formatHeader2ForPrint(sb);
                        sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s", StatsRunner.counterToStr(this.numStabilityRcvdCurrent), StatsRunner.rateToStr(stabilityRecvRate), StatsRunner.rateToStr(deltaStabilityRecvRate), StatsRunner.counterToStr(this.numStabilityInBatchesRcvdCurrent), StatsRunner.rateToStr(stabilityInBatchRecvRate), StatsRunner.rateToStr(deltaStabilityInBatchRecvRate), StatsRunner.counterToStr(this.numStabilityBatchesRcvdCurrent), StatsRunner.rateToStr(stabilityBatchRecvRate), StatsRunner.rateToStr(deltaStabilityBatchRecvRate), StatsRunner.counterToStr(this.numPacketsRcvdCurrent), StatsRunner.rateToStr(packetRecvRate), StatsRunner.rateToStr(deltaPacketRecvRate), StatsRunner.counterToStr(this.numCommitsCurrent), StatsRunner.rateToStr(commitRate), StatsRunner.rateToStr(deltaCommitRate), this.numRollbacksCurrent, this.numClientsCurrent, this.numChannelsUpCurrent, this.numBindingFailuresCurrent)).append("\n");
                    }
                }

                private final class StoreBindingStats {
                    private long numCommitsSentLast;
                    private long numCommitEntriesSentLast;
                    private long numCommitsReceivedLast;
                    private long numCommitEntriesReceivedLast;
                    private long numCommitCompletionsSentLast;
                    private long numCommitCompletionsReceivedLast;
                    private int sizeCurrent;
                    private long numCommitsSentCurrent;
                    private long numCommitEntriesSentCurrent;
                    private long numCommitsReceivedCurrent;
                    private long numCommitEntriesReceivedCurrent;
                    private long numCommitCompletionsSentCurrent;
                    private long numCommitCompletionsReceivedCurrent;
                    private PersisterStats persisterStats;
                    private ICRSenderStats icrSenderStats;

                    StoreBindingStats(IStoreBinding binding) {
                        this.init(binding);
                    }

                    StoreBindingStats(SrvMonAppStoreBindingStats stats) {
                        this.refresh(stats);
                    }

                    private final void formatHeaderForPrint(StringBuilder sb) {
                        sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s", "CSND", "RATE", "DRATE", "CESND", "RATE", "DRATE", "CRCV", "RATE", "DRATE", "CERCV", "RATE", "DRATE", "CCSND", "RATE", "DRATE", "CCRCV", "RATE", "DRATE", "SIZE")).append("\n");
                    }

                    private final void init(IStoreBinding storeBinding) {
                        IStoreBindingStats stats = storeBinding.getStats();
                        this.sizeCurrent = storeBinding.size();
                        this.numCommitsSentCurrent = stats.getNumCommitsSent();
                        this.numCommitEntriesSentCurrent = stats.getNumCommitEntriesSent();
                        this.numCommitsReceivedCurrent = stats.getNumCommitsReceived();
                        this.numCommitEntriesReceivedCurrent = stats.getNumCommitEntriesReceived();
                        this.numCommitCompletionsSentCurrent = stats.getNumCommitCompletionsSent();
                        this.numCommitCompletionsReceivedCurrent = stats.getNumCommitCompletionsReceived();
                        this.persisterStats = storeBinding.getPersister() != null ? new PersisterStats(storeBinding.getPersister()) : null;
                        this.icrSenderStats = storeBinding.getICRSender() != null ? new ICRSenderStats(storeBinding.getICRSender()) : null;
                    }

                    private final void refresh(SrvMonAppStoreBindingStats stats) {
                        this.sizeCurrent = stats.getSize();
                        this.numCommitsSentCurrent = stats.getNumCommitsSent();
                        this.numCommitEntriesSentCurrent = stats.getNumCommitEntriesSent();
                        this.numCommitsReceivedCurrent = stats.getNumCommitsReceived();
                        this.numCommitEntriesReceivedCurrent = stats.getNumCommitEntriesReceived();
                        this.numCommitCompletionsSentCurrent = stats.getNumCommitCompletionsSent();
                        this.numCommitCompletionsReceivedCurrent = stats.getNumCommitCompletionsReceived();
                    }

                    final void stamp(SrvMonAppStoreBindingStats stats) {
                        this.numCommitsSentLast = this.numCommitsSentCurrent;
                        this.numCommitEntriesSentLast = this.numCommitEntriesSentCurrent;
                        this.numCommitsReceivedLast = this.numCommitsReceivedCurrent;
                        this.numCommitEntriesReceivedLast = this.numCommitEntriesReceivedCurrent;
                        this.numCommitCompletionsSentLast = this.numCommitCompletionsSentCurrent;
                        this.numCommitCompletionsReceivedLast = this.numCommitCompletionsReceivedCurrent;
                        this.refresh(stats);
                        if (stats.getPersisterStats() != null) {
                            if (this.persisterStats == null) {
                                this.persisterStats = new PersisterStats(stats.getPersisterStats());
                            }
                            this.persisterStats.stamp(stats.getPersisterStats());
                        }
                        if (stats.getICRSenderStats() != null) {
                            if (this.icrSenderStats == null) {
                                this.icrSenderStats = new ICRSenderStats(stats.getICRSenderStats());
                            }
                            this.icrSenderStats.stamp(stats.getICRSenderStats());
                        }
                    }

                    private final void formatForPrint(long deltaTime, long totalTime, StringBuilder sb) {
                        double commitSendRate = (double)this.numCommitsSentCurrent * 1000.0 / (double)totalTime;
                        double deltaCommitSendRate = (double)(this.numCommitsSentCurrent - this.numCommitsSentLast) * 1000.0 / (double)deltaTime;
                        double commitEntriesSendRate = (double)this.numCommitEntriesSentCurrent * 1000.0 / (double)totalTime;
                        double deltaCommitEntriesSendRate = (double)(this.numCommitEntriesSentCurrent - this.numCommitEntriesSentLast) * 1000.0 / (double)deltaTime;
                        double commitReceiveRate = (double)this.numCommitsReceivedCurrent * 1000.0 / (double)totalTime;
                        double deltaCommitReceiveRate = (double)(this.numCommitsReceivedCurrent - this.numCommitsReceivedLast) * 1000.0 / (double)deltaTime;
                        double commitEntryReceiveRate = (double)this.numCommitEntriesReceivedCurrent * 1000.0 / (double)totalTime;
                        double deltaCommitEntryReceiveRate = (double)(this.numCommitEntriesReceivedCurrent - this.numCommitEntriesReceivedLast) * 1000.0 / (double)deltaTime;
                        double commitCompletionSendRate = (double)this.numCommitCompletionsSentCurrent * 1000.0 / (double)totalTime;
                        double deltaCommitCompletionSendRate = (double)(this.numCommitCompletionsSentCurrent - this.numCommitCompletionsSentLast) * 1000.0 / (double)deltaTime;
                        double commitCompletionReceiveRate = (double)this.numCommitCompletionsReceivedCurrent * 1000.0 / (double)totalTime;
                        double deltaCommitCompletionReceiveRate = (double)(this.numCommitCompletionsReceivedCurrent - this.numCommitCompletionsReceivedLast) * 1000.0 / (double)deltaTime;
                        this.formatHeaderForPrint(sb);
                        sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s", StatsRunner.counterToStr(this.numCommitsSentCurrent), StatsRunner.rateToStr(commitSendRate), StatsRunner.rateToStr(deltaCommitSendRate), StatsRunner.counterToStr(this.numCommitEntriesSentCurrent), StatsRunner.rateToStr(commitEntriesSendRate), StatsRunner.rateToStr(deltaCommitEntriesSendRate), StatsRunner.counterToStr(this.numCommitsReceivedCurrent), StatsRunner.rateToStr(commitReceiveRate), StatsRunner.rateToStr(deltaCommitReceiveRate), StatsRunner.counterToStr(this.numCommitEntriesReceivedCurrent), StatsRunner.rateToStr(commitEntryReceiveRate), StatsRunner.rateToStr(deltaCommitEntryReceiveRate), StatsRunner.counterToStr(this.numCommitCompletionsSentCurrent), StatsRunner.rateToStr(commitCompletionSendRate), StatsRunner.rateToStr(deltaCommitCompletionSendRate), StatsRunner.counterToStr(this.numCommitCompletionsReceivedCurrent), StatsRunner.rateToStr(commitCompletionReceiveRate), StatsRunner.rateToStr(deltaCommitCompletionReceiveRate), StatsRunner.counterToStr(this.sizeCurrent))).append("\n");
                    }

                    final void formatForPrint(EntityType entityType, SrvMonAppStoreBindingStats stats, long deltaTime, long totalTime, StringBuilder sb) {
                        switch (entityType) {
                            case StoreBinding: {
                                this.formatForPrint(deltaTime, totalTime, sb);
                                break;
                            }
                            case StoreBindingPersister: {
                                sb.append("<");
                                if (stats != null && stats.getPersisterStats() != null) {
                                    SrvMonAppStoreBindingPersisterStats monPersisterStats = stats.getPersisterStats();
                                    boolean isDetached = monPersisterStats.getDetachedPersist();
                                    sb.append(isDetached ? "Detached" : "Attached");
                                    if (isDetached) {
                                        AppStats.this.formatForPrint(monPersisterStats.getDisruptorStats(), sb.append(" ,"));
                                    }
                                } else {
                                    sb.append("?");
                                }
                                sb.append(">").append("\n");
                                if (this.persisterStats != null) {
                                    this.persisterStats.formatForPrint(deltaTime, totalTime, sb);
                                    break;
                                }
                                sb.append("...no persister").append("\n");
                                break;
                            }
                            case StoreBindingICRSender: {
                                sb.append("<");
                                if (stats != null && stats.getICRSenderStats() != null) {
                                    SrvMonAppStoreBindingICRSenderStats monSenderStats = stats.getICRSenderStats();
                                    boolean isDetached = monSenderStats.getDetachedSend();
                                    sb.append(isDetached ? "Detached" : "Attached");
                                    if (isDetached) {
                                        AppStats.this.formatForPrint(monSenderStats.getDisruptorStats(), sb.append(" ,"));
                                    }
                                } else {
                                    sb.append("?");
                                }
                                sb.append(">").append("\n");
                                if (this.icrSenderStats != null) {
                                    this.icrSenderStats.formatForPrint(deltaTime, totalTime, sb);
                                    break;
                                }
                                sb.append("...no ICR sender").append("\n");
                                break;
                            }
                        }
                    }

                    private final class ICRSenderStats {
                        private long numPutsRecordedLast;
                        private long numUpdatesRecordedLast;
                        private long numRemovesRecordedLast;
                        private long numSendsRecordedLast;
                        private long numCommitsLast;
                        private long numPutsRecordedCurrent;
                        private long numUpdatesRecordedCurrent;
                        private long numRemovesRecordedCurrent;
                        private long numSendsRecordedCurrent;
                        private long numCommitsCurrent;

                        ICRSenderStats(IStoreSender sender) {
                            this.init(sender);
                        }

                        ICRSenderStats(SrvMonAppStoreBindingICRSenderStats stats) {
                            this.refresh(stats);
                        }

                        private final void formatHeaderForPrint(StringBuilder sb) {
                            sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s", "PUT", "RATE", "DRATE", "UPD", "RATE", "DRATE", "REM", "RATE", "DRATE", "SEND", "RATE", "DRATE", "COM", "RATE", "DRATE")).append("\n");
                        }

                        private final void init(IStoreSender sender) {
                            IStoreSenderStats stats = sender.getStats();
                            this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                            this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                            this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                            this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                            this.numCommitsCurrent = stats.getNumCommits();
                        }

                        private final void refresh(SrvMonAppStoreBindingICRSenderStats stats) {
                            this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                            this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                            this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                            this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                            this.numCommitsCurrent = stats.getNumCommits();
                        }

                        final void stamp(SrvMonAppStoreBindingICRSenderStats stats) {
                            this.numPutsRecordedLast = this.numPutsRecordedCurrent;
                            this.numUpdatesRecordedLast = this.numUpdatesRecordedCurrent;
                            this.numRemovesRecordedLast = this.numRemovesRecordedCurrent;
                            this.numSendsRecordedLast = this.numSendsRecordedCurrent;
                            this.numCommitsLast = this.numCommitsCurrent;
                            this.refresh(stats);
                        }

                        final void formatForPrint(long deltaTime, long totalTime, StringBuilder sb) {
                            double putRecordRate = (double)this.numPutsRecordedCurrent * 1000.0 / (double)totalTime;
                            double deltaPutRecordRate = (double)(this.numPutsRecordedCurrent - this.numPutsRecordedLast) * 1000.0 / (double)deltaTime;
                            double updateRecordRate = (double)this.numUpdatesRecordedCurrent * 1000.0 / (double)totalTime;
                            double deltaUpdateRecordRate = (double)(this.numUpdatesRecordedCurrent - this.numUpdatesRecordedLast) * 1000.0 / (double)deltaTime;
                            double removeRecordRate = (double)this.numRemovesRecordedCurrent * 1000.0 / (double)totalTime;
                            double deltaRemoveRecordRate = (double)(this.numRemovesRecordedCurrent - this.numRemovesRecordedLast) * 1000.0 / (double)deltaTime;
                            double sendRecordRate = (double)this.numSendsRecordedCurrent * 1000.0 / (double)totalTime;
                            double deltaSendRecordRate = (double)(this.numSendsRecordedCurrent - this.numSendsRecordedLast) * 1000.0 / (double)deltaTime;
                            double commitRate = (double)this.numCommitsCurrent * 1000.0 / (double)totalTime;
                            double deltaCommitRate = (double)(this.numCommitsCurrent - this.numCommitsLast) * 1000.0 / (double)deltaTime;
                            this.formatHeaderForPrint(sb);
                            sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s", StatsRunner.counterToStr(this.numPutsRecordedCurrent), StatsRunner.rateToStr(putRecordRate), StatsRunner.rateToStr(deltaPutRecordRate), StatsRunner.counterToStr(this.numUpdatesRecordedCurrent), StatsRunner.rateToStr(updateRecordRate), StatsRunner.rateToStr(deltaUpdateRecordRate), StatsRunner.counterToStr(this.numRemovesRecordedCurrent), StatsRunner.rateToStr(removeRecordRate), StatsRunner.rateToStr(deltaRemoveRecordRate), StatsRunner.counterToStr(this.numSendsRecordedCurrent), StatsRunner.rateToStr(sendRecordRate), StatsRunner.rateToStr(deltaSendRecordRate), StatsRunner.counterToStr(this.numCommitsCurrent), StatsRunner.rateToStr(commitRate), StatsRunner.rateToStr(deltaCommitRate))).append("\n");
                        }
                    }

                    private final class PersisterStats {
                        private long numPutsRecordedLast;
                        private long numUpdatesRecordedLast;
                        private long numRemovesRecordedLast;
                        private long numSendsRecordedLast;
                        private long numCommitsLast;
                        private long numPutsRecordedCurrent;
                        private long numUpdatesRecordedCurrent;
                        private long numRemovesRecordedCurrent;
                        private long numSendsRecordedCurrent;
                        private long numCommitsCurrent;

                        PersisterStats(IStorePersister persister) {
                            this.init(persister);
                        }

                        PersisterStats(SrvMonAppStoreBindingPersisterStats stats) {
                            this.refresh(stats);
                        }

                        private final void formatHeaderForPrint(StringBuilder sb) {
                            sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s", "PUT", "RATE", "DRATE", "UPD", "RATE", "DRATE", "REM", "RATE", "DRATE", "SEND", "RATE", "DRATE", "COM", "RATE", "DRATE")).append("\n");
                        }

                        private final void init(IStorePersister persister) {
                            IStorePersisterStats stats = persister.getStats();
                            this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                            this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                            this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                            this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                            this.numCommitsCurrent = stats.getNumCommits();
                        }

                        private final void refresh(SrvMonAppStoreBindingPersisterStats stats) {
                            this.numPutsRecordedCurrent = stats.getNumPutsRecorded();
                            this.numUpdatesRecordedCurrent = stats.getNumUpdatesRecorded();
                            this.numRemovesRecordedCurrent = stats.getNumRemovesRecorded();
                            this.numSendsRecordedCurrent = stats.getNumSendsRecorded();
                            this.numCommitsCurrent = stats.getNumCommits();
                        }

                        final void stamp(SrvMonAppStoreBindingPersisterStats stats) {
                            this.numPutsRecordedLast = this.numPutsRecordedCurrent;
                            this.numUpdatesRecordedLast = this.numUpdatesRecordedCurrent;
                            this.numRemovesRecordedLast = this.numRemovesRecordedCurrent;
                            this.numSendsRecordedLast = this.numSendsRecordedCurrent;
                            this.numCommitsLast = this.numCommitsCurrent;
                            this.refresh(stats);
                        }

                        final void formatForPrint(long deltaTime, long totalTime, StringBuilder sb) {
                            double putRecordRate = (double)this.numPutsRecordedCurrent * 1000.0 / (double)totalTime;
                            double deltaPutRecordRate = (double)(this.numPutsRecordedCurrent - this.numPutsRecordedLast) * 1000.0 / (double)deltaTime;
                            double updateRecordRate = (double)this.numUpdatesRecordedCurrent * 1000.0 / (double)totalTime;
                            double deltaUpdateRecordRate = (double)(this.numUpdatesRecordedCurrent - this.numUpdatesRecordedLast) * 1000.0 / (double)deltaTime;
                            double removeRecordRate = (double)this.numRemovesRecordedCurrent * 1000.0 / (double)totalTime;
                            double deltaRemoveRecordRate = (double)(this.numRemovesRecordedCurrent - this.numRemovesRecordedLast) * 1000.0 / (double)deltaTime;
                            double sendRecordRate = (double)this.numSendsRecordedCurrent * 1000.0 / (double)totalTime;
                            double deltaSendRecordRate = (double)(this.numSendsRecordedCurrent - this.numSendsRecordedLast) * 1000.0 / (double)deltaTime;
                            double commitRate = (double)this.numCommitsCurrent * 1000.0 / (double)totalTime;
                            double deltaCommitRate = (double)(this.numCommitsCurrent - this.numCommitsLast) * 1000.0 / (double)deltaTime;
                            this.formatHeaderForPrint(sb);
                            sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s", StatsRunner.counterToStr(this.numPutsRecordedCurrent), StatsRunner.rateToStr(putRecordRate), StatsRunner.rateToStr(deltaPutRecordRate), StatsRunner.counterToStr(this.numUpdatesRecordedCurrent), StatsRunner.rateToStr(updateRecordRate), StatsRunner.rateToStr(deltaUpdateRecordRate), StatsRunner.counterToStr(this.numRemovesRecordedCurrent), StatsRunner.rateToStr(removeRecordRate), StatsRunner.rateToStr(deltaRemoveRecordRate), StatsRunner.counterToStr(this.numSendsRecordedCurrent), StatsRunner.rateToStr(sendRecordRate), StatsRunner.rateToStr(deltaSendRecordRate), StatsRunner.counterToStr(this.numCommitsCurrent), StatsRunner.rateToStr(commitRate), StatsRunner.rateToStr(deltaCommitRate))).append("\n");
                        }
                    }
                }

                private final class EngineStats {
                    private long numMsgsRcvdBestEffortLast;
                    private long numMsgsRcvdGuaranteedLast;
                    private long numMsgsSentBestEffortLast;
                    private long numMsgsSentGuaranteedLast;
                    private long numEventsRcvdLast;
                    private long numFlowEventsRcvdLast;
                    private long numTransactionsLast;
                    private long numMsgsRcvdBestEffortCurrent;
                    private long numMsgsRcvdGuaranteedCurrent;
                    private long numMsgsSentBestEffortCurrent;
                    private long numMsgsSentGuaranteedCurrent;
                    private long numEventsRcvdCurrent;
                    private long numFlowEventsRcvdCurrent;
                    private long numFlowEventsProcSuccessCurrent;
                    private long numTransactionsCurrent;
                    private long numCommitsStartedCurrent;
                    private long numRollbacksCurrent;

                    EngineStats(AepEngine engine) {
                        this.init(engine);
                    }

                    EngineStats(SrvMonAppEngineStats stats) {
                        this.refresh(stats);
                    }

                    private final void formatHeaderForPrint(StringBuilder sb) {
                        sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-6s %-6s", "MRCV", "RATE", "DRATE", "MRCVB", "RATE", "DRATE", "MRCVG", "RATE", "DRATE", "MSND", "RATE", "DRATE", "MSNDB", "RATE", "DRATE", "MSNDG", "RATE", "DRATE", "EVNT", "RATE", "DRATE", "FEVNT", "RATE", "DRATE", "TXN", "RATE", "DRATE", "TXNSZ", "RLBK")).append("\n");
                    }

                    private final void init(AepEngine engine) {
                        IAepEngineStats engineStats = engine.getStats();
                        this.numMsgsRcvdBestEffortCurrent = engineStats.getNumMsgsRcvdBestEffort();
                        this.numMsgsRcvdGuaranteedCurrent = engineStats.getNumMsgsRcvdGuaranteed();
                        this.numMsgsSentBestEffortCurrent = engineStats.getNumMsgsSentBestEffort();
                        this.numMsgsSentGuaranteedCurrent = engineStats.getNumMsgsSentGuaranteed();
                        this.numEventsRcvdCurrent = engineStats.getNumEventsRcvd();
                        this.numFlowEventsRcvdCurrent = engineStats.getNumFlowEventsRcvd();
                        this.numFlowEventsProcSuccessCurrent = engineStats.getNumFlowEventsProcSuccess();
                        this.numTransactionsCurrent = engineStats.getNumTransactions();
                        this.numCommitsStartedCurrent = engineStats.getNumCommitsStarted();
                        this.numRollbacksCurrent = engineStats.getNumRollbacks();
                    }

                    private final void refresh(SrvMonAppEngineStats stats) {
                        this.numMsgsRcvdBestEffortCurrent = stats.getNumMsgsRcvdBestEffort();
                        this.numMsgsRcvdGuaranteedCurrent = stats.getNumMsgsRcvdGuaranteed();
                        this.numMsgsSentBestEffortCurrent = stats.getNumMsgsSentBestEffort();
                        this.numMsgsSentGuaranteedCurrent = stats.getNumMsgsSentGuaranteed();
                        this.numEventsRcvdCurrent = stats.getNumEventsRcvd();
                        this.numFlowEventsRcvdCurrent = stats.getNumFlowEventsRcvd();
                        this.numFlowEventsProcSuccessCurrent = stats.getNumFlowEventsProcSuccess();
                        this.numTransactionsCurrent = stats.getNumTransactions();
                        this.numCommitsStartedCurrent = stats.getNumCommitsStarted();
                        this.numRollbacksCurrent = stats.getNumRollbacks();
                    }

                    final void stamp(SrvMonAppEngineStats stats) {
                        this.numMsgsRcvdBestEffortLast = this.numMsgsRcvdBestEffortCurrent;
                        this.numMsgsRcvdGuaranteedLast = this.numMsgsRcvdGuaranteedCurrent;
                        this.numMsgsSentBestEffortLast = this.numMsgsSentBestEffortCurrent;
                        this.numMsgsSentGuaranteedLast = this.numMsgsSentGuaranteedCurrent;
                        this.numEventsRcvdLast = this.numEventsRcvdCurrent;
                        this.numFlowEventsRcvdLast = this.numFlowEventsRcvdCurrent;
                        this.numTransactionsLast = this.numTransactionsCurrent;
                        this.refresh(stats);
                    }

                    final void formatForPrint(long deltaTime, long totalTime, StringBuilder sb) {
                        long numMsgsRcvd = this.numMsgsRcvdBestEffortCurrent + this.numMsgsRcvdGuaranteedCurrent;
                        long numMsgsRcvdLast = this.numMsgsRcvdBestEffortLast + this.numMsgsRcvdGuaranteedLast;
                        double msgRecvRate = (double)numMsgsRcvd * 1000.0 / (double)totalTime;
                        double deltaMsgRecvRate = (double)(numMsgsRcvd - numMsgsRcvdLast) * 1000.0 / (double)deltaTime;
                        double bestEffortMsgRecvRate = (double)this.numMsgsRcvdBestEffortCurrent * 1000.0 / (double)totalTime;
                        double deltaBestEffortMsgRecvRate = (double)(this.numMsgsRcvdBestEffortCurrent - this.numMsgsRcvdBestEffortLast) * 1000.0 / (double)deltaTime;
                        double guaranteedMsgRecvRate = (double)this.numMsgsRcvdGuaranteedCurrent * 1000.0 / (double)totalTime;
                        double deltaGuaranteedMsgRecvRate = (double)(this.numMsgsRcvdGuaranteedCurrent - this.numMsgsRcvdGuaranteedLast) * 1000.0 / (double)deltaTime;
                        long numMsgsSent = this.numMsgsSentBestEffortCurrent + this.numMsgsSentGuaranteedCurrent;
                        long numMsgsSentLast = this.numMsgsSentBestEffortLast + this.numMsgsSentGuaranteedLast;
                        double msgSendRate = (double)numMsgsSent * 1000.0 / (double)totalTime;
                        double deltaMsgSendRate = (double)(numMsgsSent - numMsgsSentLast) * 1000.0 / (double)deltaTime;
                        double bestEffortMsgSendRate = (double)this.numMsgsSentBestEffortCurrent * 1000.0 / (double)totalTime;
                        double deltaBestEffortMsgSendRate = (double)(this.numMsgsSentBestEffortCurrent - this.numMsgsSentBestEffortLast) * 1000.0 / (double)deltaTime;
                        double guaranteedMsgSendRate = (double)this.numMsgsSentGuaranteedCurrent * 1000.0 / (double)totalTime;
                        double deltaGuaranteedMsgSendRate = (double)(this.numMsgsSentGuaranteedCurrent - this.numMsgsSentGuaranteedLast) * 1000.0 / (double)deltaTime;
                        double eventRecvRate = (double)this.numEventsRcvdCurrent * 1000.0 / (double)totalTime;
                        double deltaEventRecvRate = (double)(this.numEventsRcvdCurrent - this.numEventsRcvdLast) * 1000.0 / (double)deltaTime;
                        double flowEventRecvRate = (double)this.numFlowEventsRcvdCurrent * 1000.0 / (double)totalTime;
                        double deltaFlowEventRecvRate = (double)(this.numFlowEventsRcvdCurrent - this.numFlowEventsRcvdLast) * 1000.0 / (double)deltaTime;
                        double txnRate = (double)this.numTransactionsCurrent * 1000.0 / (double)totalTime;
                        double deltaTxnRate = (double)(this.numTransactionsCurrent - this.numTransactionsLast) * 1000.0 / (double)deltaTime;
                        long avgNumFlowEventsPerTransaction = this.numCommitsStartedCurrent == 0L ? 0L : this.numFlowEventsProcSuccessCurrent / this.numCommitsStartedCurrent;
                        this.formatHeaderForPrint(sb);
                        sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-6d %-6d", StatsRunner.counterToStr(numMsgsRcvd), StatsRunner.rateToStr(msgRecvRate), StatsRunner.rateToStr(deltaMsgRecvRate), StatsRunner.counterToStr(this.numMsgsRcvdBestEffortCurrent), StatsRunner.rateToStr(bestEffortMsgRecvRate), StatsRunner.rateToStr(deltaBestEffortMsgRecvRate), StatsRunner.counterToStr(this.numMsgsRcvdGuaranteedCurrent), StatsRunner.rateToStr(guaranteedMsgRecvRate), StatsRunner.rateToStr(deltaGuaranteedMsgRecvRate), StatsRunner.counterToStr(numMsgsSent), StatsRunner.rateToStr(msgSendRate), StatsRunner.rateToStr(deltaMsgSendRate), StatsRunner.counterToStr(this.numMsgsSentBestEffortCurrent), StatsRunner.rateToStr(bestEffortMsgSendRate), StatsRunner.rateToStr(deltaBestEffortMsgSendRate), StatsRunner.counterToStr(this.numMsgsSentGuaranteedCurrent), StatsRunner.rateToStr(guaranteedMsgSendRate), StatsRunner.rateToStr(deltaGuaranteedMsgSendRate), StatsRunner.counterToStr(this.numEventsRcvdCurrent), StatsRunner.rateToStr(eventRecvRate), StatsRunner.rateToStr(deltaEventRecvRate), StatsRunner.counterToStr(this.numFlowEventsRcvdCurrent), StatsRunner.rateToStr(flowEventRecvRate), StatsRunner.rateToStr(deltaFlowEventRecvRate), StatsRunner.counterToStr(this.numTransactionsCurrent), StatsRunner.rateToStr(txnRate), StatsRunner.rateToStr(deltaTxnRate), avgNumFlowEventsPerTransaction, this.numRollbacksCurrent)).append("\n");
                    }
                }
            }

            private final class MsgTypeStatsCollector {
                private XIntLinkedHashMap<MsgTypeStats> msgTypeStats = new XIntLinkedHashMap();
                private XIntLinkedHashMap<IAepEngineStats.IMessageTypeStats> copiedEngineStatsTable = new XIntLinkedHashMap();
                private final IntObjectProcedure msgTypeStatsCopier = new IntObjectProcedure(){

                    public final boolean apply(int key, Object stats) {
                        MsgTypeStatsCollector.this.copiedEngineStatsTable.put(key, (Object)((IAepEngineStats.IMessageTypeStats)stats));
                        return true;
                    }
                };

                private MsgTypeStatsCollector() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void collect(OpenIntObjectHashMap engineMessageTypeStats, SrvMonAppEngineStats monAppStats) {
                    if (engineMessageTypeStats == null) {
                        return;
                    }
                    this.copiedEngineStatsTable.clear();
                    OpenIntObjectHashMap openIntObjectHashMap = engineMessageTypeStats;
                    synchronized (openIntObjectHashMap) {
                        engineMessageTypeStats.forEachPair(this.msgTypeStatsCopier);
                    }
                    XCollectionIterator it = this.copiedEngineStatsTable.reuseableEntryIterator();
                    while (it.hasNext()) {
                        XIntMap.Entry entry = (XIntMap.Entry)it.next();
                        MsgTypeStats stats = (MsgTypeStats)this.msgTypeStats.get(entry.getKey());
                        if (stats == null) {
                            stats = new MsgTypeStats((IAepEngineStats.IMessageTypeStats)entry.getValue());
                            this.msgTypeStats.put(entry.getKey(), (Object)stats);
                        }
                        stats.collectCurrentValues((IAepEngineStats.IMessageTypeStats)entry.getValue());
                    }
                    XIterator statsIt = this.msgTypeStats.reuseableValueIterator();
                    while (statsIt.hasNext()) {
                        MsgTypeStats typeStats = (MsgTypeStats)statsIt.next();
                        typeStats.computeAndInclude(monAppStats, Apps.this.inactiveMessageTypeStatsInclusionCountdown == 0);
                    }
                }
            }

            private final class MsgTypeStats {
                final XString name;
                final short factoryid;
                final short typeid;
                private long numMsgsRcvdBestEffortLast;
                private long numMsgsRcvdGuaranteedLast;
                private long numMsgsSourcedLast;
                private long numMsgsSentBestEffortLast;
                private long numMsgsSentGuaranteedLast;
                private long numMsgsFilteredLast;
                private long numDupMsgsRcvdLast;
                private long numMsgsResentLast;
                private long numMsgsRcvdBestEffortCurrent;
                private long numMsgsRcvdGuaranteedCurrent;
                private long numMsgsSourcedCurrent;
                private long numMsgsSentBestEffortCurrent;
                private long numMsgsSentGuaranteedCurrent;
                private long numMsgsFilteredCurrent;
                private long numDupMsgsRcvdCurrent;
                private long numMsgsResentCurrent;
                private SrvMonIntSeries messageCreateToOfferLatencies;
                private SrvMonIntSeries messageOfferToPollLatencies;
                private SrvMonIntSeries messageFilteringLatencies;
                private SrvMonIntSeries messagePreProcessingLatencies;
                private SrvMonIntSeries messageProcessingLatencies;

                MsgTypeStats(IAepEngineStats.IMessageTypeStats engineMsgTypeStats) {
                    this.name = XString.create((String)engineMsgTypeStats.getMessageTypeName(), (boolean)true, (boolean)true);
                    this.typeid = engineMsgTypeStats.getMessageTypeId();
                    this.factoryid = engineMsgTypeStats.getMessageFactoryId();
                }

                final void collectCurrentValues(IAepEngineStats.IMessageTypeStats engineMsgTypeStats) {
                    this.numDupMsgsRcvdCurrent = engineMsgTypeStats.getNumDupMsgsRcvd();
                    this.numMsgsFilteredCurrent = engineMsgTypeStats.getNumMsgsFiltered();
                    this.numMsgsRcvdBestEffortCurrent = engineMsgTypeStats.getNumMsgsRcvdBestEffort();
                    this.numMsgsRcvdGuaranteedCurrent = engineMsgTypeStats.getNumMsgsRcvdGuaranteed();
                    this.numMsgsResentCurrent = engineMsgTypeStats.getNumMsgsResent();
                    this.numMsgsSentBestEffortCurrent = engineMsgTypeStats.getNumMsgsSentBestEffort();
                    this.numMsgsSentGuaranteedCurrent = engineMsgTypeStats.getNumMsgsSentGuaranteed();
                    this.numMsgsSourcedCurrent = engineMsgTypeStats.getNumMsgsSourced();
                    this.messageCreateToOfferLatencies = Apps.this.statsRunner.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgCreateToOfferLatencies());
                    this.messageOfferToPollLatencies = Apps.this.statsRunner.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgOfferToPollLatencies());
                    this.messageFilteringLatencies = Apps.this.statsRunner.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgFilteringLatencies());
                    this.messagePreProcessingLatencies = Apps.this.statsRunner.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgPreProcessingLatencies());
                    this.messageProcessingLatencies = Apps.this.statsRunner.collectIntSeriesStats((IStats.Series)engineMsgTypeStats.getMsgProcessingLatencies());
                }

                public void computeAndInclude(SrvMonAppEngineStats monAppStats, boolean includeInactive) {
                    if (!includeInactive && this.numMsgsRcvdBestEffortLast == this.numMsgsRcvdBestEffortCurrent && this.numMsgsRcvdGuaranteedLast == this.numMsgsRcvdGuaranteedCurrent && this.numMsgsSourcedLast == this.numMsgsSourcedCurrent && this.numMsgsSentBestEffortLast == this.numMsgsSentBestEffortCurrent && this.numMsgsSentGuaranteedLast == this.numMsgsSentGuaranteedCurrent && this.numMsgsFilteredLast == this.numMsgsFilteredCurrent && this.numDupMsgsRcvdLast == this.numDupMsgsRcvdCurrent && this.numMsgsResentLast == this.numMsgsResentCurrent) {
                        if (this.messageCreateToOfferLatencies != null) {
                            this.messageCreateToOfferLatencies.dispose();
                            this.messageCreateToOfferLatencies = null;
                        }
                        if (this.messageOfferToPollLatencies != null) {
                            this.messageOfferToPollLatencies.dispose();
                            this.messageOfferToPollLatencies = null;
                        }
                        if (this.messagePreProcessingLatencies != null) {
                            this.messagePreProcessingLatencies.dispose();
                            this.messagePreProcessingLatencies = null;
                        }
                        if (this.messageFilteringLatencies != null) {
                            this.messageFilteringLatencies.dispose();
                            this.messageFilteringLatencies = null;
                        }
                        if (this.messageFilteringLatencies != null) {
                            this.messageFilteringLatencies.dispose();
                            this.messageFilteringLatencies = null;
                        }
                        return;
                    }
                    SrvMonMsgTypeStats monStats = SrvMonMsgTypeStats.create();
                    monStats.lendMessageTypeName(this.name);
                    monStats.setMessageFactoryId(this.factoryid);
                    monStats.setMessageTypeId(this.typeid);
                    monStats.setNumDupMsgsRcvd(this.numDupMsgsRcvdCurrent);
                    monStats.setNumMsgsFiltered(this.numMsgsFilteredCurrent);
                    monStats.setNumMsgsRcvdBestEffort(this.numMsgsRcvdBestEffortCurrent);
                    monStats.setNumMsgsRcvdGuaranteed(this.numMsgsRcvdGuaranteedCurrent);
                    monStats.setNumMsgsResent(this.numMsgsResentCurrent);
                    monStats.setNumMsgsSentBestEffort(this.numMsgsSentBestEffortCurrent);
                    monStats.setNumMsgsSentGuaranteed(this.numMsgsSentGuaranteedCurrent);
                    monStats.setNumMsgsSourced(this.numMsgsSourcedCurrent);
                    monStats.setMsgCreateToOfferLatencies(this.messageCreateToOfferLatencies);
                    monStats.setMsgOfferToPollLatencies(this.messageOfferToPollLatencies);
                    monStats.setMsgFilteringLatencies(this.messageFilteringLatencies);
                    monStats.setMsgPreProcessingLatencies(this.messagePreProcessingLatencies);
                    monStats.setMsgProcessingLatencies(this.messageProcessingLatencies);
                    monAppStats.addMsgTypeStats(monStats);
                    this.numMsgsRcvdBestEffortLast = this.numMsgsRcvdBestEffortCurrent;
                    this.numMsgsRcvdGuaranteedLast = this.numMsgsRcvdGuaranteedCurrent;
                    this.numMsgsSourcedLast = this.numMsgsSourcedCurrent;
                    this.numMsgsSentBestEffortLast = this.numMsgsSentBestEffortCurrent;
                    this.numMsgsSentGuaranteedLast = this.numMsgsSentGuaranteedCurrent;
                    this.numMsgsFilteredLast = this.numMsgsFilteredCurrent;
                    this.numDupMsgsRcvdLast = this.numDupMsgsRcvdCurrent;
                    this.numMsgsResentLast = this.numMsgsResentCurrent;
                    this.messageCreateToOfferLatencies = null;
                    this.messageOfferToPollLatencies = null;
                    this.messageFilteringLatencies = null;
                    this.messagePreProcessingLatencies = null;
                    this.messageProcessingLatencies = null;
                }
            }

            public static enum EntityType {
                Engine,
                UserStat,
                EventMultiplexer,
                StoreBinding,
                StoreBindingPersister,
                StoreBindingICRSender,
                BusBinding;

            }
        }

        public static final class AdminClients {
            private final XLinkedHashMap<String, SrvControllerAdminApp.AdminClientContext.Stats> adminClientsStats = new XLinkedHashMap();
            private final Tracer tracer = Tracer.get((String)"nv.server.stats.adminclient");
            private final StringBuilder sb = new StringBuilder();

            private final void formatHeaderForPrint(StringBuilder sb) {
                sb.append(String.format("%-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-8s %-8s %s", "LSENT", "TSENT", "TDROP", "HSENT", "HDROP", "FSCHD", "FEXEC", "OQCAP", "OQSIZ", "OQCNT", "OQFSIZ", "OQFCNT", "NAME")).append("\n");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final void createForHeartbeat(XIndexedList<SrvMonAdminClientStats> statsList) {
                XLinkedHashMap<String, SrvControllerAdminApp.AdminClientContext.Stats> xLinkedHashMap = this.adminClientsStats;
                synchronized (xLinkedHashMap) {
                    XIterator adminClientStatsIt = this.adminClientsStats.reuseableValueIterator();
                    while (adminClientStatsIt.hasNext()) {
                        SrvControllerAdminApp.AdminClientContext.Stats adminClientStats = (SrvControllerAdminApp.AdminClientContext.Stats)adminClientStatsIt.next();
                        if (adminClientStats == null && this.tracer.debug) {
                            this.tracer.log("NULL ADMIN STAT DETECTED IN ADMINCLIENTSTATS MAP", Tracer.Level.DEBUG);
                            continue;
                        }
                        SrvMonAdminClientStats stats = SrvMonAdminClientStats.create();
                        stats.setName(adminClientStats.getClient().getName());
                        stats.setLifecyclesSent(adminClientStats.getEventsSent());
                        stats.setTracesSent(adminClientStats.getTracesSent());
                        stats.setTracesDropped(adminClientStats.getTracesDropped());
                        stats.setHeartbeatsSent(adminClientStats.getHeartbeatsSent());
                        stats.setHeartbeatsDropped(adminClientStats.getHeartbeatsDropped());
                        stats.setFlushesScheduled(adminClientStats.getFlushesScheduled());
                        stats.setFlushesExecuted(adminClientStats.getFlushesExecuted());
                        stats.setOutboundQueueCapacity(adminClientStats.getOutboundQueueCapacity());
                        stats.setOutboundQueueSize(adminClientStats.getOutboundQueueSize());
                        stats.setOutboundQueueCount(adminClientStats.getOutboundQueueCount());
                        stats.setOutboundQueueFlushSize(adminClientStats.getOutboundQueueFlushSize());
                        stats.setOutboundQueueFlushCount(adminClientStats.getOutboundQueueFlushCount());
                        statsList.add((Object)stats);
                    }
                }
            }

            final void print(XIndexedList<SrvMonAdminClientStats> adminClientStats) {
                if (this.tracer.debug) {
                    this.sb.setLength(0);
                    this.sb.append("\n");
                    this.sb.append("[AdminClient Stats]").append("\n");
                    this.tracer.log(this.formatForPrint((XIterator<SrvMonAdminClientStats>)adminClientStats.reusableIterator(), this.sb).toString(), Tracer.Level.DEBUG);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final void onAdminClientConnected(SrvControllerAdminApp.AdminClientContext client) {
                XLinkedHashMap<String, SrvControllerAdminApp.AdminClientContext.Stats> xLinkedHashMap = this.adminClientsStats;
                synchronized (xLinkedHashMap) {
                    this.adminClientsStats.put((Object)client.getName(), (Object)client.getStats());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final void onAdminClientDisconnected(SrvControllerAdminApp.AdminClientContext client) {
                XLinkedHashMap<String, SrvControllerAdminApp.AdminClientContext.Stats> xLinkedHashMap = this.adminClientsStats;
                synchronized (xLinkedHashMap) {
                    this.adminClientsStats.remove((Object)client.getName());
                }
            }

            public final StringBuilder formatForPrint(XIterator<SrvMonAdminClientStats> stats, StringBuilder sb) {
                this.formatHeaderForPrint(sb);
                if (!stats.hasNext()) {
                    return sb;
                }
                while (stats.hasNext()) {
                    SrvMonAdminClientStats stat = (SrvMonAdminClientStats)stats.next();
                    sb.append(String.format("%-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-7s %-8s %-8s %s", StatsRunner.counterToStr(stat.getLifecyclesSent()), StatsRunner.counterToStr(stat.getTracesSent()), StatsRunner.counterToStr(stat.getTracesDropped()), StatsRunner.counterToStr(stat.getHeartbeatsSent()), StatsRunner.counterToStr(stat.getHeartbeatsDropped()), StatsRunner.counterToStr(stat.getFlushesScheduled()), StatsRunner.counterToStr(stat.getFlushesExecuted()), StatsRunner.counterToStr(stat.getOutboundQueueCapacity()), StatsRunner.counterToStr(stat.getOutboundQueueSize()), StatsRunner.counterToStr(stat.getOutboundQueueCount()), StatsRunner.counterToStr(stat.getOutboundQueueFlushSize()), StatsRunner.counterToStr(stat.getOutboundQueueFlushCount()), stat.getName())).append("\n");
                }
                return sb;
            }
        }

        public static final class Pools {
            private final XLinkedHashMap<String, PoolStats> poolsStats = new XLinkedHashMap();
            private final ObjectArrayList poolStatsHolder = new ObjectArrayList(4096);
            private final Tracer tracer;
            private final StringBuilder sb;
            private final boolean enabled;
            private final boolean collectAll;
            private final float depletionThreshold;

            public Pools() {
                this(XRuntime.getValue((String)"nv.server.stats.pool.enable", (boolean)true), XRuntime.getValue((String)"nv.server.stats.pool.collectAll", (boolean)false), XRuntime.getValue((String)"nv.server.stats.pool.depletionThreshold", (float)1.0f));
            }

            public Pools(boolean enabled, boolean collectAll, float poolDepletionThreshold) {
                this.enabled = enabled;
                this.tracer = Tracer.get((String)"nv.server.stats.pool");
                this.sb = new StringBuilder();
                float value = poolDepletionThreshold;
                if (value <= 0.0f) {
                    value = 101.0f;
                }
                this.collectAll = collectAll;
                this.depletionThreshold = value;
            }

            private final void formatHeaderForPrint(StringBuilder sb) {
                sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %s", "PUT", "DPUT", "GET", "DGET", "HIT", "DHIT", "MISS", "DMISS", "GROW", "DGROW", "EVIC", "DEVIC", "DWSH", "DDWSH", "PRE", "SIZE", "CAP", "MAX", "NAME")).append("\n");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final void createForHeartbeat(XIndexedList<SrvMonPoolStats> statsList) {
                if (!this.enabled) {
                    return;
                }
                this.poolStatsHolder.clear();
                XLinkedHashMap<String, PoolStats> xLinkedHashMap = this.poolsStats;
                synchronized (xLinkedHashMap) {
                    XIterator poolStatsIt = this.poolsStats.reuseableValueIterator();
                    while (poolStatsIt.hasNext()) {
                        PoolStats poolStats = (PoolStats)poolStatsIt.next();
                        if (poolStats == null && this.tracer.debug) {
                            this.tracer.log("NULL POOL STAT DETECTED IN POOLSTATS MAP", Tracer.Level.DEBUG);
                            continue;
                        }
                        if (poolStats.pool == null && this.tracer.debug) {
                            this.tracer.log("NULL POOL IN POOLS STATS DETECTED IN POOLSTATS MAP", Tracer.Level.DEBUG);
                            continue;
                        }
                        this.poolStatsHolder.add((Object)poolStats);
                    }
                }
                for (int i = 0; i < this.poolStatsHolder.size(); ++i) {
                    PoolStats poolStats = (PoolStats)this.poolStatsHolder.get(i);
                    if (poolStats.pool == null && this.tracer.debug) {
                        this.tracer.log("NULL POOL IN POOLS STATS DETECTED IN POOLSTATS MAP", Tracer.Level.DEBUG);
                        continue;
                    }
                    try {
                        UtlPool.Stats corePoolStats = poolStats.pool.stats();
                        long putsCurrent = corePoolStats.puts();
                        long getsCurrent = corePoolStats.gets();
                        long hitsCurrent = corePoolStats.hits();
                        long missesCurrent = corePoolStats.misses();
                        long growthsCurrent = corePoolStats.growths();
                        long evictsCurrent = corePoolStats.evicts();
                        long dwashesCurrent = corePoolStats.detachedWashes();
                        int size = poolStats.pool.size();
                        int capacity = poolStats.pool.capacity();
                        int preallocated = corePoolStats.preallocated();
                        int maxCapacity = poolStats.pool.params().getMaxCapacity();
                        if (this.collectAll || poolStats.isAtOrBelowDepletionThreshold(size) || missesCurrent - poolStats.missesLast > 0L || size > poolStats.sizeHighaterMark || evictsCurrent - poolStats.evictsLast > 0L) {
                            SrvMonPoolStats stats = SrvMonPoolStats.create();
                            stats.setPuts(putsCurrent);
                            stats.setGets(getsCurrent);
                            stats.setHits(hitsCurrent);
                            stats.setMisses(missesCurrent);
                            stats.setGrowths(growthsCurrent);
                            stats.setEvicts(evictsCurrent);
                            stats.setDetachedWashes(dwashesCurrent);
                            stats.setPreallocated(preallocated);
                            stats.setSize(size);
                            stats.setCapacity(capacity);
                            stats.setMaxCapacity(maxCapacity);
                            stats.setKey(poolStats.pool.key());
                            statsList.add((Object)stats);
                        }
                        poolStats.stamp(putsCurrent, getsCurrent, hitsCurrent, missesCurrent, growthsCurrent, evictsCurrent, dwashesCurrent, size);
                        continue;
                    }
                    catch (IllegalStateException e) {
                        if (poolStats.pool == null || poolStats.pool.isClosed()) continue;
                        throw e;
                    }
                }
            }

            final void print(XIndexedList<SrvMonPoolStats> poolStats) {
                if (this.tracer.debug) {
                    this.sb.setLength(0);
                    this.sb.append("\n");
                    this.sb.append("[Pool Stats]").append("\n");
                    if (!this.enabled) {
                        this.tracer.log("POOL STATS...DISABLED", Tracer.Level.DEBUG);
                        return;
                    }
                    this.tracer.log(this.formatForPrint((XIterator<SrvMonPoolStats>)poolStats.reusableIterator(), this.sb).toString(), Tracer.Level.DEBUG);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final void onPoolAdded(UtlPool<?> pool) {
                if (!this.enabled) {
                    return;
                }
                XLinkedHashMap<String, PoolStats> xLinkedHashMap = this.poolsStats;
                synchronized (xLinkedHashMap) {
                    this.poolsStats.put((Object)pool.key(), (Object)new PoolStats(pool));
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            final void onPoolRemoved(UtlPool<?> pool) {
                if (!this.enabled) {
                    return;
                }
                XLinkedHashMap<String, PoolStats> xLinkedHashMap = this.poolsStats;
                synchronized (xLinkedHashMap) {
                    this.poolsStats.remove((Object)pool.key());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final StringBuilder formatForPrint(XIterator<SrvMonPoolStats> stats, StringBuilder sb) {
                if (!this.enabled) {
                    sb.append("...DISABLED");
                    return sb;
                }
                this.formatHeaderForPrint(sb);
                if (!stats.hasNext()) {
                    return sb;
                }
                XLinkedHashMap<String, PoolStats> xLinkedHashMap = this.poolsStats;
                synchronized (xLinkedHashMap) {
                    while (stats.hasNext()) {
                        SrvMonPoolStats stat = (SrvMonPoolStats)stats.next();
                        PoolStats poolStats = (PoolStats)this.poolsStats.get((Object)stat.getKey());
                        if (poolStats == null) {
                            poolStats = new PoolStats(stat);
                            this.poolsStats.put((Object)stat.getKey(), (Object)poolStats);
                        }
                        long putsCurrent = stat.getPuts();
                        long getsCurrent = stat.getGets();
                        long hitsCurrent = stat.getHits();
                        long missesCurrent = stat.getMisses();
                        long growthsCurrent = stat.getGrowths();
                        long evictsCurrent = stat.getEvicts();
                        long dwashesCurrent = stat.getDetachedWashes();
                        int sizeCurrent = stat.getSize();
                        int capacityCurrent = stat.getCapacity();
                        sb.append(String.format("%-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %-5s %s", StatsRunner.counterToStr(putsCurrent), StatsRunner.counterToStr(putsCurrent - poolStats.putsLast), StatsRunner.counterToStr(getsCurrent), StatsRunner.counterToStr(getsCurrent - poolStats.getsLast), StatsRunner.counterToStr(hitsCurrent), StatsRunner.counterToStr(hitsCurrent - poolStats.hitsLast), StatsRunner.counterToStr(missesCurrent), StatsRunner.counterToStr(missesCurrent - poolStats.missesLast), StatsRunner.counterToStr(growthsCurrent), StatsRunner.counterToStr(growthsCurrent - poolStats.growthsLast), StatsRunner.counterToStr(evictsCurrent), StatsRunner.counterToStr(evictsCurrent - poolStats.evictsLast), StatsRunner.counterToStr(dwashesCurrent), StatsRunner.counterToStr(dwashesCurrent - poolStats.dwashesLast), StatsRunner.counterToStr(stat.getPreallocated()), StatsRunner.counterToStr(sizeCurrent), StatsRunner.counterToStr(capacityCurrent), StatsRunner.counterToStr(stat.getMaxCapacity()), stat.getKey())).append("\n");
                        poolStats.stamp(putsCurrent, getsCurrent, hitsCurrent, missesCurrent, growthsCurrent, evictsCurrent, dwashesCurrent, stat.getSize());
                    }
                }
                return sb;
            }

            private final class PoolStats {
                private final UtlPool<?> pool;
                final int depletionThresholdDecrement;
                private long putsLast;
                private long getsLast;
                private long hitsLast;
                private long missesLast;
                private long growthsLast;
                private long evictsLast;
                private long dwashesLast;
                private int nextDepletionThreshold = -1;
                private int sizeHighaterMark = -1;

                PoolStats(UtlPool<?> pool) {
                    this.pool = pool;
                    UtlPool.Stats stats = this.pool.stats();
                    this.stamp(stats.puts(), stats.gets(), stats.hits(), stats.misses(), stats.growths(), stats.evicts(), stats.detachedWashes(), pool.size());
                    if (stats.preallocated() > 0 && pool.size() > 0 && Pools.this.depletionThreshold <= 100.0f) {
                        this.depletionThresholdDecrement = (int)((float)stats.preallocated() * Pools.this.depletionThreshold / 100.0f);
                        this.nextDepletionThreshold = Math.max(0, stats.preallocated() - this.depletionThresholdDecrement);
                    } else {
                        this.depletionThresholdDecrement = 0;
                        this.nextDepletionThreshold = -1;
                    }
                }

                PoolStats(SrvMonPoolStats stats) {
                    this.pool = null;
                    this.stamp(stats.getPuts(), stats.getGets(), stats.getHits(), stats.getMisses(), stats.getGrowths(), stats.getEvicts(), stats.getDetachedWashes(), stats.getSize());
                    if (stats.getPreallocated() > 0 && stats.getSize() > 0 && Pools.this.depletionThreshold <= 100.0f) {
                        this.depletionThresholdDecrement = (int)((float)stats.getPreallocated() * Pools.this.depletionThreshold / 100.0f);
                        this.nextDepletionThreshold = Math.max(0, stats.getPreallocated() - this.depletionThresholdDecrement);
                    } else {
                        this.depletionThresholdDecrement = 0;
                        this.nextDepletionThreshold = -1;
                    }
                }

                final void stamp(long puts, long gets, long hits, long misses, long growths, long evicts, long dwashes, int size) {
                    this.putsLast = puts;
                    this.getsLast = gets;
                    this.hitsLast = hits;
                    this.missesLast = misses;
                    this.growthsLast = growths;
                    this.evictsLast = evicts;
                    this.dwashesLast = dwashes;
                    if (this.isAtOrBelowDepletionThreshold(size)) {
                        while (this.nextDepletionThreshold >= size) {
                            this.nextDepletionThreshold -= this.depletionThresholdDecrement;
                        }
                    }
                    this.sizeHighaterMark = Math.max(size, this.sizeHighaterMark);
                }

                final boolean isAtOrBelowDepletionThreshold(int size) {
                    if (this.depletionThresholdDecrement > 0) {
                        return size <= this.nextDepletionThreshold;
                    }
                    return false;
                }
            }
        }

        public static final class Threads
        extends SrvMonHeartbeatTracer.Threads {
            private final Tracer tracer = Tracer.get((String)"nv.server.stats.thread");
            private final StringBuilder sb = new StringBuilder();

            final void print(SrvMonSysStats stats) {
                if (this.tracer.debug) {
                    this.sb.setLength(0);
                    this.sb.append("\n");
                    this.sb.append("[Thread Stats]").append("\n");
                    this.tracer.log(this.formatForPrint(stats, this.sb).toString(), Tracer.Level.DEBUG);
                }
            }
        }

        public static final class Sys {
            private final MemoryMXBean memoryBean;
            private final OperatingSystemMXBean osBean;
            private final SunOperatingSystemMXBean sunOsBean;
            private final ThreadMXBean threadBean;
            private final CompilationMXBean jitBean;
            private final Tracer tracer;
            private final StringBuilder sb;
            private final Method zgThreadAccessor;
            private Field zgCharArrayThreadNameField;
            private Field zgStringThreadNameField;
            private final StatsRunner statsRunner;
            private final SrvControllerFileSystemAccessor.FileRoot[] fileRoots;
            private final boolean collectIndividualThreadStats;
            private final boolean collectNonZGStats;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Sys(StatsRunner statsRunner) {
                boolean zgThreadStats;
                block15: {
                    this.statsRunner = statsRunner;
                    this.tracer = Tracer.get((String)"nv.server.stats.sys");
                    this.memoryBean = ManagementFactory.getMemoryMXBean();
                    this.osBean = ManagementFactory.getOperatingSystemMXBean();
                    this.threadBean = ManagementFactory.getThreadMXBean();
                    zgThreadStats = true;
                    Method zgThreadAccessorCandidate = null;
                    try {
                        try {
                            zgThreadAccessorCandidate = this.threadBean.getClass().getDeclaredMethod("getThreads", new Class[0]);
                        }
                        catch (NoSuchMethodException e) {
                            zgThreadAccessorCandidate = this.threadBean.getClass().getSuperclass().getDeclaredMethod("getThreads", new Class[0]);
                        }
                        if (!zgThreadAccessorCandidate.getReturnType().equals(Thread[].class)) {
                            throw new Exception("Unexpected return type on native ThreadMX bean accessor '" + zgThreadAccessorCandidate + "'");
                        }
                        zgThreadAccessorCandidate.setAccessible(true);
                        ((Thread[])zgThreadAccessorCandidate.invoke((Object)this.threadBean, new Object[0])).hashCode();
                        this.zgThreadAccessor = zgThreadAccessorCandidate;
                        zgThreadStats &= this.zgThreadAccessor != null;
                    }
                    catch (Throwable thrown) {
                        try {
                            zgThreadAccessorCandidate = null;
                            this.tracer.log("Couldn't load zero garbage ThreadMXBean accessor: " + thrown.toString() + " ... Server stats will produce garbage!", Tracer.Level.WARNING);
                            this.zgThreadAccessor = zgThreadAccessorCandidate;
                            zgThreadStats &= this.zgThreadAccessor != null;
                        }
                        catch (Throwable throwable) {
                            this.zgThreadAccessor = zgThreadAccessorCandidate;
                            zgThreadStats &= this.zgThreadAccessor != null;
                            throw throwable;
                        }
                    }
                    Field zgThreadNameFieldCandidate = null;
                    try {
                        Object testGet;
                        zgThreadNameFieldCandidate = Thread.class.getDeclaredField("name");
                        if (zgThreadNameFieldCandidate.getType() == char[].class) {
                            zgThreadNameFieldCandidate.setAccessible(true);
                            testGet = (char[])zgThreadNameFieldCandidate.get(Thread.currentThread());
                            if (testGet == null) {
                                throw new Exception("Failed to get thread name via reflection (null)");
                            }
                            this.zgCharArrayThreadNameField = zgThreadNameFieldCandidate;
                            break block15;
                        }
                        if (zgThreadNameFieldCandidate.getType() == String.class) {
                            zgThreadNameFieldCandidate.setAccessible(true);
                            testGet = (String)zgThreadNameFieldCandidate.get(Thread.currentThread());
                            if (testGet == null) {
                                throw new Exception("Failed to get thread name via reflection (null)");
                            }
                            this.zgStringThreadNameField = zgThreadNameFieldCandidate;
                            break block15;
                        }
                        throw new Exception("Unexpected field type for '" + zgThreadNameFieldCandidate + "'");
                    }
                    catch (Throwable thrown) {
                        zgThreadNameFieldCandidate = null;
                        this.tracer.log("Couldn't load zero garbage thread name accessor: " + thrown.getMessage() + " ... Server stats may not register updated thread names.", Tracer.Level.WARNING);
                    }
                }
                this.jitBean = ManagementFactory.getCompilationMXBean();
                this.sb = new StringBuilder();
                this.collectNonZGStats = statsRunner.config.isCollectNonZGStats();
                SunOperatingSystemMXBean sunOsMbean = null;
                try {
                    sunOsMbean = (SunOperatingSystemMXBean)Class.forName("com.neeve.server.controller.SrvControllerSunOsMbeanAccessor").newInstance();
                }
                catch (Throwable thrown) {
                    this.tracer.log("Sun os mbean not available (" + thrown.getMessage() + ") some processor and memory system stats will not be available.", Tracer.Level.WARNING);
                }
                this.sunOsBean = sunOsMbean;
                this.fileRoots = this.collectNonZGStats ? SrvControllerFileSystemAccessor.getEnhancedFileRootsIfAvailable() : SrvControllerFileSystemAccessor.getStandardFileRoots();
                this.tracer.log("ZERO GARBAGE THREAD STATS ARE....." + (zgThreadStats ? "AVAILABLE" : "UNAVAILABLE"), Tracer.Level.CONFIG);
                this.tracer.log("SYSTEM DISK STATS ARE............." + (SrvControllerFileSystemAccessor.areEnhandedFileSystemRootsAvailable() ? "AVAILABLE" : "UNAVAILABLE"), Tracer.Level.CONFIG);
                this.tracer.log("SYSTEM MEM STATS ARE.............." + (this.sunOsBean != null ? "AVAILABLE" : "UNAVAILABLE"), Tracer.Level.CONFIG);
                this.tracer.log("ENHANCED CPU STATS ARE............" + (this.sunOsBean != null && this.sunOsBean.enhancedProcessorLoadStatsAvailable() ? "AVAILABLE" : "UNAVAILABLE"), Tracer.Level.CONFIG);
                this.tracer.log("NON ZERO GARBAGE STATS ARE........" + (this.collectNonZGStats ? "ENABLED" : "DISABLED"), Tracer.Level.CONFIG);
                this.collectIndividualThreadStats = statsRunner.config.isCollectIndividualThreadStats();
            }

            private final void populateSystemInfo(SrvMonSysStats stats) {
                stats.setAvailableProcessors(this.osBean.getAvailableProcessors());
                stats.setSystemLoadAverage(this.osBean.getSystemLoadAverage());
                if (this.sunOsBean != null && this.collectNonZGStats && this.sunOsBean.enhancedProcessorLoadStatsAvailable()) {
                    stats.setProcessCpuLoad(this.sunOsBean.getProcessCpuLoad());
                    stats.setSystemCpuLoad(this.sunOsBean.getSystemCpuLoad());
                }
            }

            private final void populateMemoryInfo(SrvMonSysStats stats) {
                SrvMonSysMemoryStats sysMemoryStats = SrvMonSysMemoryStats.create();
                MemoryStats memoryStats = MemoryStats.getInstance();
                SrvMonSysMemoryUsage heapUsage = SrvMonSysMemoryUsage.create();
                MemoryUsage beanHeapUsage = this.memoryBean.getHeapMemoryUsage();
                heapUsage.setInit(beanHeapUsage.getInit());
                heapUsage.setUsed(beanHeapUsage.getUsed());
                heapUsage.setCommitted(beanHeapUsage.getCommitted());
                heapUsage.setMax(beanHeapUsage.getMax());
                sysMemoryStats.setHeapUsage(heapUsage);
                SrvMonSysMemoryUsage nonHeapUsage = SrvMonSysMemoryUsage.create();
                MemoryUsage beanNonHeapUsage = this.memoryBean.getNonHeapMemoryUsage();
                nonHeapUsage.setInit(beanNonHeapUsage.getInit());
                nonHeapUsage.setUsed(beanNonHeapUsage.getUsed());
                nonHeapUsage.setCommitted(beanNonHeapUsage.getCommitted());
                nonHeapUsage.setMax(beanNonHeapUsage.getMax());
                sysMemoryStats.setNonHeapUsage(nonHeapUsage);
                SrvMonSysMemoryOffHeapUsage offHeapUsage = SrvMonSysMemoryOffHeapUsage.create();
                offHeapUsage.setUsedTotal(memoryStats.getOffHeapMemoryUsedPooled() + memoryStats.getOffHeapMemoryUsedLive());
                offHeapUsage.setUsedLive(memoryStats.getOffHeapMemoryUsedLive());
                offHeapUsage.setUsedPooled(memoryStats.getOffHeapMemoryUsedPooled());
                sysMemoryStats.setOffHeapUsage(offHeapUsage);
                SrvMonSysMemoryNativeCounters nativeCounters = SrvMonSysMemoryNativeCounters.create();
                nativeCounters.setAllocCount(memoryStats.getNativeStatsCounters().getAllocCount());
                nativeCounters.setAllocBytes(memoryStats.getNativeStatsCounters().getAllocBytes());
                nativeCounters.setReallocCount(memoryStats.getNativeStatsCounters().getReallocCount());
                nativeCounters.setReallocBytes(memoryStats.getNativeStatsCounters().getReallocBytes());
                nativeCounters.setFreeCount(memoryStats.getNativeStatsCounters().getFreeCount());
                nativeCounters.setFreeBytes(memoryStats.getNativeStatsCounters().getFreeBytes());
                sysMemoryStats.setNativeCounters(nativeCounters);
                SrvMonSysMemoryIOBufCounters iobufCounters = SrvMonSysMemoryIOBufCounters.create();
                iobufCounters.setDirectBufferAllocCount(memoryStats.getIOBufferStatsCounters().getDirectBufferAllocCount());
                iobufCounters.setDirectBufferAllocBytes(memoryStats.getIOBufferStatsCounters().getDirectBufferAllocBytes());
                iobufCounters.setDirectBufferPoolAllocCount(memoryStats.getIOBufferStatsCounters().getDirectBufferPoolAllocCount());
                iobufCounters.setDirectBufferPoolAllocBytes(memoryStats.getIOBufferStatsCounters().getDirectBufferPoolAllocBytes());
                iobufCounters.setDirectBufferGCDisposeCount(memoryStats.getIOBufferStatsCounters().getDirectBufferGCDisposeCount());
                iobufCounters.setDirectBufferGCDisposeBytes(memoryStats.getIOBufferStatsCounters().getDirectBufferGCDisposeBytes());
                iobufCounters.setDirectBufferPoolDisposeCount(memoryStats.getIOBufferStatsCounters().getDirectBufferPoolDisposeCount());
                iobufCounters.setDirectBufferPoolDisposeBytes(memoryStats.getIOBufferStatsCounters().getDirectBufferPoolDisposeBytes());
                iobufCounters.setDirectBufferPoolLeakCount(memoryStats.getIOBufferStatsCounters().getDirectBufferPoolLeakCount());
                iobufCounters.setDirectBufferPoolLeakBytes(memoryStats.getIOBufferStatsCounters().getDirectBufferPoolLeakBytes());
                sysMemoryStats.setIobufCounters(iobufCounters);
                if (this.sunOsBean != null) {
                    sysMemoryStats.setCommittedVirtualMemorySize(this.sunOsBean.getCommittedVirtualMemorySize());
                    sysMemoryStats.setFreePhysicalMemorySize(this.sunOsBean.getFreePhysicalMemorySize());
                    sysMemoryStats.setFreeSwapSpaceSize(this.sunOsBean.getFreeSwapSpaceSize());
                    sysMemoryStats.setTotalPhysicalMemorySize(this.sunOsBean.getTotalPhysicalMemorySize());
                    sysMemoryStats.setTotalSwapSpaceSize(this.sunOsBean.getTotalSwapSpaceSize());
                }
                stats.setMemoryStats(sysMemoryStats);
            }

            private final void populateThreadInfo(SrvMonSysStats sysStats) {
                SrvMonSysThreadStats threadStats = SrvMonSysThreadStats.create();
                threadStats.setThreadCount(this.threadBean.getThreadCount());
                threadStats.setDaemonThreadCount(this.threadBean.getDaemonThreadCount());
                threadStats.setPeakThreadCount(this.threadBean.getPeakThreadCount());
                if (this.collectIndividualThreadStats) {
                    Thread[] threads = null;
                    try {
                        threads = (Thread[])this.zgThreadAccessor.invoke((Object)this.threadBean, (Object[])null);
                    }
                    catch (Throwable thrown) {
                        this.tracer.log("Error getting MX Bean threads: " + thrown.getMessage(), Tracer.Level.WARNING);
                    }
                    if (threads != null) {
                        for (int i = 0; i < threads.length; ++i) {
                            String stringName;
                            char[] charArrayName;
                            SrvMonSysIndividualThreadStats individualThreadStats;
                            block23: {
                                individualThreadStats = SrvMonSysIndividualThreadStats.create();
                                individualThreadStats.setId(threads[i].getId());
                                charArrayName = null;
                                stringName = null;
                                if (this.zgCharArrayThreadNameField != null) {
                                    try {
                                        charArrayName = (char[])this.zgCharArrayThreadNameField.get(threads[i]);
                                    }
                                    catch (Throwable thrown) {
                                        if (this.tracer.debug) {
                                            this.tracer.log("Error getting thread name" + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.DEBUG);
                                        }
                                        break block23;
                                    }
                                }
                                if (this.zgStringThreadNameField != null) {
                                    try {
                                        stringName = (String)this.zgStringThreadNameField.get(threads[i]);
                                    }
                                    catch (Throwable thrown) {
                                        if (!this.tracer.debug) break block23;
                                        this.tracer.log("Error getting thread name" + UtlThrowable.prepareStackTrace((Throwable)thrown), Tracer.Level.DEBUG);
                                    }
                                }
                            }
                            XString tName = this.statsRunner.lookupThreadName(threads[i]);
                            if (charArrayName != null && tName.length() != charArrayName.length || stringName != null && tName.length() != stringName.length()) {
                                this.statsRunner.threadNameCache.remove(threads[i]);
                                tName = this.statsRunner.lookupThreadName(threads[i]);
                            }
                            individualThreadStats.setNameFrom(tName);
                            Thread.State state = threads[i].getState();
                            individualThreadStats.setState(state.toString());
                            if (threads[i].isAlive() && state != Thread.State.NEW) {
                                long cpuTime = this.threadBean.getThreadCpuTime(threads[i].getId());
                                long userTime = this.threadBean.getThreadUserTime(threads[i].getId());
                                long collectTime = System.nanoTime();
                                if (cpuTime > 0L) {
                                    individualThreadStats.setCpuTime(cpuTime);
                                }
                                if (userTime > 0L) {
                                    individualThreadStats.setUsrTime(userTime);
                                }
                                individualThreadStats.setCollectTime(collectTime);
                            } else {
                                individualThreadStats.setCollectTime(System.nanoTime());
                            }
                            UtlThread.ThreadStats stats = UtlThread.getThreadStats((Thread)threads[i]);
                            if (stats != null) {
                                individualThreadStats.setAffinity(stats.getAffinityString());
                                long waitCount = stats.getWaitCount();
                                if (waitCount > 0L) {
                                    individualThreadStats.setWaitTime(stats.getWaitTime());
                                    individualThreadStats.setWaitCount(waitCount);
                                }
                            }
                            threadStats.addIndividualThreadStats(individualThreadStats);
                        }
                    } else {
                        long[] ids = this.threadBean.getAllThreadIds();
                        for (int i = 0; i < ids.length; ++i) {
                            SrvMonSysIndividualThreadStats individualThreadStats = SrvMonSysIndividualThreadStats.create();
                            individualThreadStats.setId(ids[i]);
                            ThreadInfo tinfo = this.threadBean.getThreadInfo(ids[i]);
                            individualThreadStats.setName(tinfo != null ? tinfo.getThreadName() : "<defunct>");
                            individualThreadStats.setState(tinfo != null ? tinfo.getThreadState().toString() : "<unavailable>");
                            long cpuTime = this.threadBean.getThreadCpuTime(ids[i]);
                            long userTime = this.threadBean.getThreadUserTime(ids[i]);
                            long collectTime = System.nanoTime();
                            if (cpuTime > 0L) {
                                individualThreadStats.setCpuTime(cpuTime);
                            }
                            if (userTime > 0L) {
                                individualThreadStats.setUsrTime(userTime);
                            }
                            individualThreadStats.setCollectTime(collectTime);
                            threadStats.addIndividualThreadStats(individualThreadStats);
                        }
                    }
                }
                sysStats.setThreadStats(threadStats);
            }

            private final void populateJITInfo(SrvMonSysStats stats) {
                SrvMonSysJITStats jitStats = SrvMonSysJITStats.create();
                jitStats.setName(this.jitBean.getName());
                jitStats.setTotalCompilationTime(this.jitBean.isCompilationTimeMonitoringSupported() ? this.jitBean.getTotalCompilationTime() : -1L);
                stats.setJitStats(jitStats);
            }

            private final void populateGCInfo(SrvMonSysStats sysStats) {
                SrvMonSysGCStats gcStats = SrvMonSysGCStats.create();
                List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
                for (int i = 0; i < gcBeans.size(); ++i) {
                    GarbageCollectorMXBean gcBean = gcBeans.get(i);
                    SrvMonSysGCCollectorStats stats = SrvMonSysGCCollectorStats.create();
                    stats.setCollectorName(gcBean.getName());
                    stats.setCollectionCount(gcBean.getCollectionCount());
                    stats.setCollectionTime(gcBean.getCollectionTime());
                    gcStats.addCollectorsStats(stats);
                }
                sysStats.setGcStats(gcStats);
            }

            private final void populateDiskInfo(SrvMonSysStats sysStats) {
                for (int i = 0; i < this.fileRoots.length; ++i) {
                    SrvMonSysDiskStats diskStats = SrvMonSysDiskStats.create();
                    diskStats.setRootPath(this.fileRoots[i].getPath());
                    diskStats.setTotalSpace(this.fileRoots[i].getTotalSpace());
                    diskStats.setUsableSpace(this.fileRoots[i].getUsableSpace());
                    diskStats.setFreeSpace(this.fileRoots[i].getFreeSpace());
                    sysStats.addDiskStats(diskStats);
                }
            }

            final SrvMonSysStats createForHeartbeat() {
                SrvMonSysStats stats = SrvMonSysStats.create();
                this.populateSystemInfo(stats);
                this.populateMemoryInfo(stats);
                this.populateThreadInfo(stats);
                this.populateJITInfo(stats);
                this.populateGCInfo(stats);
                this.populateDiskInfo(stats);
                return stats;
            }

            final void print(long collectionStartWallTime, String serverName, String serverPid, int appCount, SrvMonSysStats stats, long collectionElapsedTime) {
                if (this.tracer.debug) {
                    this.sb.setLength(0);
                    this.sb.append("\n");
                    this.sb.append("[System Stats]").append("\n");
                    this.tracer.log(SrvMonHeartbeatTracer.Sys.formatForPrint(collectionStartWallTime, serverName, serverPid, appCount, stats, collectionElapsedTime, this.sb).toString(), Tracer.Level.DEBUG);
                }
            }

            public static final void formatGeneralInfoForPrint(long collectionStartWallTime, String serverName, String serverPid, int appCount, long collectionElapsedTime, StringBuilder sb) {
                SrvMonHeartbeatTracer.Sys.formatGeneralInfoForPrint(collectionStartWallTime, serverName, serverPid, appCount, collectionElapsedTime, sb);
            }

            public static final void formatSystemInfoForPrint(SrvMonSysStats stats, StringBuilder sb) {
                SrvMonHeartbeatTracer.Sys.formatSystemInfoForPrint(stats, sb);
            }

            public static final void formatMemoryInfoForPrint(SrvMonSysStats stats, StringBuilder sb) {
                SrvMonHeartbeatTracer.Sys.formatMemoryInfoForPrint(stats, sb);
            }

            public static final void formatThreadInfoForPrint(SrvMonSysStats stats, StringBuilder sb) {
                SrvMonHeartbeatTracer.Sys.formatThreadInfoForPrint(stats, sb);
            }

            public static final void formatDiskInfoForPrint(SrvMonSysStats stats, StringBuilder sb) {
                SrvMonHeartbeatTracer.Sys.formatDiskInfoForPrint(stats, sb);
            }

            public static final void formatJITInfoForPrint(SrvMonSysStats stats, StringBuilder sb) {
                SrvMonHeartbeatTracer.Sys.formatJITInfoForPrint(stats, sb);
            }

            public static final void formatGCInfoForPrint(SrvMonSysStats stats, StringBuilder sb) {
                SrvMonHeartbeatTracer.Sys.formatGCInfoForPrint(stats, sb);
            }

            public static final StringBuilder formatForPrint(long collectionStartWallTime, String serverName, String serverPid, int appCount, SrvMonSysStats stats, long collectionElapsedTime, StringBuilder sb) {
                Sys.formatGeneralInfoForPrint(collectionStartWallTime, serverName, serverPid, appCount, collectionElapsedTime, sb);
                Sys.formatSystemInfoForPrint(stats, sb);
                Sys.formatMemoryInfoForPrint(stats, sb);
                Sys.formatDiskInfoForPrint(stats, sb);
                Sys.formatThreadInfoForPrint(stats, sb);
                Sys.formatJITInfoForPrint(stats, sb);
                Sys.formatGCInfoForPrint(stats, sb);
                return sb;
            }

            public static interface SunOperatingSystemMXBean {
                public long getCommittedVirtualMemorySize();

                public long getTotalSwapSpaceSize();

                public long getFreeSwapSpaceSize();

                public long getFreePhysicalMemorySize();

                public long getTotalPhysicalMemorySize();

                public long getProcessCpuTime();

                public double getProcessCpuLoad();

                public double getSystemCpuLoad();

                public boolean enhancedProcessorLoadStatsAvailable();
            }
        }
    }

    private final class AppWatcher
    implements ISrvAppWatcher {
        private AppWatcher() {
        }

        @Override
        public final void onAppLoaded(SrvAppLoader loader) {
            SrvController.this.onAppLoaded(loader);
        }

        @Override
        public final void onAppInitialized(SrvAppLoader loader, long timestamp) {
            SrvController.this.onAppInitialized(loader, timestamp);
        }

        @Override
        public final void onAppStarted(SrvMonAppEngineStartedMessage message) {
            SrvController.this.onAppStateChange(message.getEventSource(), message.getEventTimestampAsTimestamp(), SrvMonAppState.Started);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppActive(SrvMonAppEngineActiveMessage message) {
            SrvController.this.onAppStateChange(message.getEventSource(), message.getEventTimestampAsTimestamp(), SrvMonAppState.Active);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppBusBindingCreated(SrvMonAppBusBindingCreatedMessage message) {
            SrvController.this.onAppBusBindingCreated(message);
        }

        @Override
        public final void onAppBusBindingOpening(SrvMonAppBusBindingOpeningMessage message) {
            SrvController.this.onAppBusBindingStateChange(message.getEventSource(), message.getBusBindingName(), SrvMonAppBusBindingState.Opening);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppBusBindingOpened(SrvMonAppBusBindingOpenedMessage message) {
            SrvController.this.onAppBusBindingStateChange(message.getEventSource(), message.getBusBindingName(), SrvMonAppBusBindingState.Opened);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppBusBindingOpenFailed(SrvMonAppBusBindingOpenFailedMessage message) {
            SrvController.this.onAppBusBindingStateChange(message.getEventSource(), message.getBusBindingName(), SrvMonAppBusBindingState.Failed);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppBusBindingFailed(SrvMonAppBusBindingDownMessage message) {
            SrvController.this.onAppBusBindingStateChange(message.getEventSource(), message.getBusBindingName(), SrvMonAppBusBindingState.Failed);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppBusBindingDestroyed(SrvMonAppBusBindingDestroyedMessage message) {
            SrvController.this.onAppBusBindingDestroyed(message);
        }

        @Override
        public final void onAppChannelUp(SrvMonAppChannelUpMessage message) {
            SrvController.this.onAppChannelUp(message);
        }

        @Override
        public final void onAppChannelDown(SrvMonAppChannelDownMessage message) {
            SrvController.this.onAppChannelDown(message);
        }

        @Override
        public final void onAppFlowCreated(String appName, long timestamp, int flowid) {
            SrvController.this.onAppFlowCreated(appName, timestamp, flowid);
        }

        @Override
        public final void onAppClientConnected(String appName, String clientName) {
            SrvController.this.onAppClientConnected(appName, clientName);
        }

        @Override
        public final void onAppClientDisconnected(String appName, String clientName) {
            SrvController.this.onAppClientDisconnected(appName, clientName);
        }

        @Override
        public final void onAppStopped(SrvMonAppEngineStoppedMessage message) {
            SrvController.this.onAppStateChange(message.getEventSource(), message.getEventTimestampAsTimestamp(), SrvMonAppState.Stopped);
            SrvController.this.dispatchLifecycleEvent(message.copy());
        }

        @Override
        public final void onAppUnloaded(String appName, long timestamp) {
            SrvController.this.onAppUnloaded(appName, timestamp);
        }

        @Override
        public <E extends IRogMessage & IRogCopyableNode<? extends IRogMessage>> void onAppMonEvent(String appName, E monEvent) {
            if (appName != "admin") {
                SrvController.this.dispatchLifecycleEvent((IRogMessage)((IRogCopyableNode<? extends IRogMessage>)monEvent).copy());
            }
        }
    }

    private final class TraceWatcher
    extends Handler {
        private final TraceHistoryHandler history;
        private volatile boolean inTraceWatcher;

        TraceWatcher(int maxHistory) {
            this.history = TraceHistoryHandler.create((Handler)this, (int)maxHistory);
            TraceLoggerFactory.getInstance().registerWatcher((Handler)this.history);
        }

        final TraceHistoryHandler history() {
            return this.history;
        }

        @Override
        public final void publish(LogRecord record) {
            if (!this.inTraceWatcher) {
                this.inTraceWatcher = true;
                try {
                    SrvController.this.onTrace(record);
                }
                finally {
                    this.inTraceWatcher = false;
                }
            }
        }

        @Override
        public final void flush() {
        }

        @Override
        public final void close() {
        }
    }

    private final class PoolWatcher
    implements UtlPoolRegistry.EventHandler {
        private PoolWatcher() {
        }

        public final void onPoolAdded(UtlPool<?> pool) {
            SrvController.this.onPoolAdded(pool);
        }

        public final void onPoolRemoved(UtlPool<?> pool) {
            SrvController.this.onPoolRemoved(pool);
        }
    }

    public static final class LongHistogramComputer {
        public final IntCountsHistogram histogram;
        public int sampleSize = 0;
        public long maxValue = 0L;
        public long minValue = Long.MAX_VALUE;
        public double mean = 0.0;
        public int samplesOverMax = 0;
        public int samplesUnderMin = 0;

        public LongHistogramComputer() {
            this.histogram = new IntCountsHistogram(Long.MAX_VALUE, 3);
        }

        public void addValue(long value) {
            ++this.sampleSize;
            this.minValue = Math.min(this.minValue, value);
            this.maxValue = Math.max(this.maxValue, value);
            this.mean = this.sampleSize == 1 ? (double)value : this.mean * (double)(this.sampleSize - 1) / (double)this.sampleSize + (double)value / (double)this.sampleSize;
            if (value > this.histogram.getHighestTrackableValue()) {
                value = this.histogram.getHighestTrackableValue();
                ++this.samplesOverMax;
            }
            if (value < 0L) {
                value = 0L;
                ++this.samplesUnderMin;
            }
            this.histogram.recordValue(value);
        }

        public final void reset() {
            if (this.sampleSize == 0) {
                return;
            }
            this.sampleSize = 0;
            this.mean = 0.0;
            this.samplesOverMax = 0;
            this.samplesUnderMin = 0;
            this.maxValue = 0L;
            this.minValue = Long.MAX_VALUE;
            this.histogram.reset();
        }

        public SrvMonLongHistogram computeHistogramData(boolean nullIfNoSamples) {
            if (nullIfNoSamples && this.sampleSize == 0) {
                return null;
            }
            SrvMonLongHistogram data = SrvMonLongHistogram.create();
            data.setSampleSize(this.sampleSize);
            if (this.sampleSize > 0) {
                data.setSamplesOverMax(this.samplesOverMax);
                data.setSamplesUnderMin(this.samplesUnderMin);
                data.setMean((long)this.mean);
                data.setMaximum(this.maxValue);
                data.setMinimum(this.minValue);
                data.setMedian(this.histogram.getValueAtPercentile(50.0));
                data.setPct75(this.histogram.getValueAtPercentile(75.0));
                data.setPct90(this.histogram.getValueAtPercentile(90.0));
                data.setPct99(this.histogram.getValueAtPercentile(99.0));
                data.setPct999(this.histogram.getValueAtPercentile(99.9));
                data.setPct9999(this.histogram.getValueAtPercentile(99.99));
            }
            return data;
        }
    }

    public static final class LongSeriesCollector
    implements IStats.Series.Collector {
        final IStats.Series series;
        final LongHistogramComputer runningCollector;
        final DoubleArrayList tempArray;
        final boolean collectRaw;
        long skippedSeqNos = 0L;
        long lastSeqNo = 0L;
        LongHistogramComputer intervalCollector;
        SrvMonLongSeries timings;

        public LongSeriesCollector(IStats.Series series, DoubleArrayList tempArray, boolean collectRaw) {
            this.series = series;
            this.tempArray = tempArray;
            this.collectRaw = collectRaw;
            this.runningCollector = new LongHistogramComputer();
        }

        public final void reset() {
            this.runningCollector.reset();
            this.lastSeqNo = 0L;
            this.skippedSeqNos = 0L;
        }

        public SrvMonLongSeries collect(LongHistogramComputer intervalCollector) {
            if (this.series.sequenceNumber() < this.lastSeqNo) {
                this.reset();
            }
            SrvMonLongSeries timings = SrvMonLongSeries.create();
            intervalCollector.reset();
            this.intervalCollector = intervalCollector;
            this.timings = timings;
            long prevLastSeqNo = this.lastSeqNo;
            long seqNo = this.series.get((IStats.Series.Collector)this, this.tempArray, this.lastSeqNo + 1L);
            long skipped = 0L;
            if (seqNo > 0L) {
                skipped = seqNo - (prevLastSeqNo + 1L);
                this.skippedSeqNos += skipped;
            }
            timings.setLastSequenceNumber(this.lastSeqNo);
            timings.setNumDataPoints((int)(this.lastSeqNo - prevLastSeqNo - skipped));
            timings.setIntervalStats(intervalCollector.computeHistogramData(true));
            timings.setRunningStats(this.runningCollector.computeHistogramData(false));
            timings.setSkippedDatapoints(this.skippedSeqNos);
            this.timings = null;
            this.intervalCollector = null;
            return timings;
        }

        public void report(double[] values, int offset, int length) {
        }

        public void add(long sequenceNumber, double value) {
            this.runningCollector.addValue((long)value);
            this.intervalCollector.addValue((long)value);
            if (this.collectRaw) {
                this.timings.addDataPoints((long)value);
            }
            this.lastSeqNo = sequenceNumber;
        }
    }

    public static final class IntHistogramComputer {
        public final IntCountsHistogram histogram;
        public int sampleSize = 0;
        public int maxValue = 0;
        public int minValue = Integer.MAX_VALUE;
        public float mean = 0.0f;
        public int samplesOverMax = 0;
        public int samplesUnderMin = 0;

        public IntHistogramComputer() {
            this.histogram = new IntCountsHistogram(Integer.MAX_VALUE, 3);
        }

        public void addValue(int value) {
            ++this.sampleSize;
            this.minValue = Math.min(this.minValue, value);
            this.maxValue = Math.max(this.maxValue, value);
            this.mean = this.sampleSize == 1 ? (float)value : this.mean * (float)(this.sampleSize - 1) / (float)this.sampleSize + (float)value / (float)this.sampleSize;
            if ((long)value > this.histogram.getHighestTrackableValue()) {
                value = (int)this.histogram.getHighestTrackableValue();
                ++this.samplesOverMax;
            }
            if (value < 0) {
                value = 0;
                ++this.samplesUnderMin;
            }
            this.histogram.recordValue((long)value);
        }

        public final void reset() {
            if (this.sampleSize == 0) {
                return;
            }
            this.sampleSize = 0;
            this.mean = 0.0f;
            this.samplesOverMax = 0;
            this.samplesUnderMin = 0;
            this.maxValue = 0;
            this.minValue = Integer.MAX_VALUE;
            this.histogram.reset();
        }

        public SrvMonIntHistogram computeHistogramData(boolean nullIfNoSamples) {
            if (nullIfNoSamples && this.sampleSize == 0) {
                return null;
            }
            SrvMonIntHistogram data = SrvMonIntHistogram.create();
            data.setSampleSize(this.sampleSize);
            if (this.sampleSize > 0) {
                data.setSamplesOverMax(this.samplesOverMax);
                data.setSamplesUnderMin(this.samplesUnderMin);
                data.setMean((int)this.mean);
                data.setMaximum(this.maxValue);
                data.setMinimum(this.minValue);
                data.setMedian((int)this.histogram.getValueAtPercentile(50.0));
                data.setPct75((int)this.histogram.getValueAtPercentile(75.0));
                data.setPct90((int)this.histogram.getValueAtPercentile(90.0));
                data.setPct99((int)this.histogram.getValueAtPercentile(99.0));
                data.setPct999((int)this.histogram.getValueAtPercentile(99.9));
                data.setPct9999((int)this.histogram.getValueAtPercentile(99.99));
            }
            return data;
        }
    }

    public static final class IntSeriesCollector
    implements IStats.Series.Collector {
        final IStats.Series series;
        final IntHistogramComputer runningCollector;
        final DoubleArrayList tempArray;
        final boolean collectRaw;
        long skippedSeqNos = 0L;
        long lastSeqNo = 0L;
        IntHistogramComputer intervalCollector;
        SrvMonIntSeries timings;

        public IntSeriesCollector(IStats.Series series, DoubleArrayList tempArray, boolean collectRaw) {
            this.series = series;
            this.tempArray = tempArray;
            this.collectRaw = collectRaw;
            this.runningCollector = new IntHistogramComputer();
        }

        public final void reset() {
            this.runningCollector.reset();
            this.lastSeqNo = 0L;
            this.skippedSeqNos = 0L;
        }

        public SrvMonIntSeries collect(IntHistogramComputer intervalCollector) {
            if (this.series.sequenceNumber() < this.lastSeqNo) {
                this.reset();
            }
            SrvMonIntSeries timings = SrvMonIntSeries.create();
            intervalCollector.reset();
            this.intervalCollector = intervalCollector;
            this.timings = timings;
            long prevLastSeqNo = this.lastSeqNo;
            long seqNo = this.series.get((IStats.Series.Collector)this, this.tempArray, this.lastSeqNo + 1L);
            long skipped = 0L;
            if (seqNo > 0L) {
                skipped = seqNo - (prevLastSeqNo + 1L);
                this.skippedSeqNos += skipped;
            }
            timings.setLastSequenceNumber(this.lastSeqNo);
            timings.setNumDataPoints((int)(this.lastSeqNo - prevLastSeqNo - skipped));
            timings.setIntervalStats(intervalCollector.computeHistogramData(true));
            timings.setRunningStats(this.runningCollector.computeHistogramData(false));
            timings.setSkippedDatapoints(this.skippedSeqNos);
            this.timings = null;
            this.intervalCollector = null;
            return timings;
        }

        public void report(double[] values, int offset, int length) {
        }

        public void add(long sequenceNumber, double value) {
            this.runningCollector.addValue((int)value);
            this.intervalCollector.addValue((int)value);
            if (this.collectRaw) {
                this.timings.addDataPoints((int)value);
            }
            this.lastSeqNo = sequenceNumber;
        }
    }
}

