/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.daemon.thread;

import com.neeve.emx.EmxFactory;
import com.neeve.emx.IEmxDispatcher;
import com.neeve.emx.IEmxEvent;
import com.neeve.emx.IEmxEventHandler;
import com.neeve.emx.IEmxUserEvent;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlThread;

public final class DmnThread
implements Runnable {
    private final Thread thread;
    private final IEmxDispatcher dispatcher;
    private final Tracer tracer;
    private final ShutdownEventHandler shutdownEventHandler;
    private volatile boolean isStarted;
    private volatile boolean go;
    private volatile boolean done;
    private long cpuAffinityMask = -1L;

    public DmnThread(String name, Thread thread, Tracer tracer) throws Exception {
        if (tracer == null) {
            throw new IllegalArgumentException("tracer cannot be null");
        }
        this.tracer = tracer;
        this.thread = thread != null ? thread : new Thread(this);
        this.thread.setName(name);
        if (this.thread != thread) {
            this.thread.setDaemon(true);
        }
        this.dispatcher = EmxFactory.getInstance().createDispatcher(EmxFactory.EmxImpl.DEFAULT, name, IEmxDispatcher.Params.create((boolean)false, (boolean)true));
        this.shutdownEventHandler = new ShutdownEventHandler();
        tracer.log("Thread [" + this.dispatcher.getName() + "] created.", Tracer.Level.DEBUG);
    }

    final boolean isCurrentThread() {
        return this.thread == Thread.currentThread();
    }

    final void setCPUAffinityMask(long mask) {
        this.cpuAffinityMask = mask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void start() {
        this.thread.start();
        DmnThread dmnThread = this;
        synchronized (dmnThread) {
            while (!this.isStarted()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    final boolean isStarted() {
        return this.isStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void go() {
        DmnThread dmnThread = this;
        synchronized (dmnThread) {
            this.go = true;
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void stop() {
        this.done = true;
        DmnThread dmnThread = this;
        synchronized (dmnThread) {
            if (!this.go) {
                this.go = true;
                this.notify();
            } else {
                IEmxUserEvent userEvent = EmxFactory.getInstance().createUserEvent(EmxFactory.EmxImpl.DEFAULT, (IEmxEventHandler)this.shutdownEventHandler);
                this.dispatcher.schedUserEv(userEvent);
            }
        }
        if (!this.isCurrentThread()) {
            while (true) {
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public final IEmxDispatcher getDispatcher() {
        return this.dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            if (this.cpuAffinityMask >= 0L) {
                UtlThread.setCPUAffinityMask((long)this.cpuAffinityMask);
            }
            this.dispatcher.setOwner(1);
            DmnThread dmnThread = this;
            synchronized (dmnThread) {
                this.isStarted = true;
                this.notify();
            }
            this.tracer.log("Thread [" + this.dispatcher.getName() + "] waiting for go signal.", Tracer.Level.DEBUG);
            dmnThread = this;
            synchronized (dmnThread) {
                while (!this.go) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.tracer.log("Thread [" + this.dispatcher.getName() + "] started.", Tracer.Level.VERBOSE);
            while (!this.done) {
                this.dispatcher.run(-1);
            }
            this.dispatcher.close(true);
            this.tracer.log("Thread [" + this.dispatcher.getName() + "] stopped.", Tracer.Level.VERBOSE);
        }
        catch (Throwable e) {
            try {
                if (e instanceof OutOfMemoryError) {
                    System.out.println("*** The NVX Daemon has run out of memory!! Exiting the JVM... ***");
                } else {
                    this.tracer.log("Unhandled fault in thread [" + this.dispatcher.getName() + "] [" + e.toString() + "]", Tracer.Level.SEVERE);
                    e.printStackTrace();
                }
            }
            finally {
                System.exit(1);
            }
        }
    }

    private final class ShutdownEventHandler
    implements IEmxEventHandler {
        private ShutdownEventHandler() {
        }

        public boolean onEvent(IEmxDispatcher dispatcher, IEmxEvent event) {
            return false;
        }
    }
}

