/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class UtlLinkedLongMap<V> {
    private transient Entry<V>[] _entries;
    private transient int _capacity;
    private transient int _mask;
    private transient Entry<V> _poolFirst;
    private transient Entry<V> _mapFirst;
    private transient Entry<V> _mapLast;
    private transient int _size;
    private final FastIterator _fastIterator = new FastIterator();
    private transient Values _values;
    private transient EntrySet _entrySet;

    public UtlLinkedLongMap() {
        this.initialize(16);
    }

    public UtlLinkedLongMap(int capacity) {
        this.initialize(capacity);
    }

    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._capacity;
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public boolean containsKey(long key) {
        Entry entry = this._entries[UtlLinkedLongMap.keyHash(key) & this._mask];
        while (entry != null) {
            if (key == entry._key) {
                return true;
            }
            entry = entry._next;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        Entry entry = this._mapFirst;
        while (entry != null) {
            if (value.equals(entry._value)) {
                return true;
            }
            entry = entry._after;
        }
        return false;
    }

    public V get(long key) {
        Entry entry = this._entries[UtlLinkedLongMap.keyHash(key) & this._mask];
        while (entry != null) {
            if (key == entry._key) {
                return (V)entry._value;
            }
            entry = entry._next;
        }
        return null;
    }

    public Entry<V> getEntry(long key) {
        Entry entry = this._entries[UtlLinkedLongMap.keyHash(key) & this._mask];
        while (entry != null) {
            if (key == entry._key) {
                return entry;
            }
            entry = entry._next;
        }
        return null;
    }

    public V put(long key, V value) {
        Entry entry = this._entries[UtlLinkedLongMap.keyHash(key) & this._mask];
        while (entry != null) {
            if (key == entry._key) {
                Object prevValue = entry._value;
                entry._value = value;
                return (V)prevValue;
            }
            entry = entry._next;
        }
        this.addEntry(key, value);
        return null;
    }

    public FastIterator fastIterator() {
        return this._fastIterator;
    }

    public V remove(long key) {
        Entry entry = this._entries[UtlLinkedLongMap.keyHash(key) & this._mask];
        while (entry != null) {
            if (key == entry._key) {
                Object prevValue = entry._value;
                this.removeEntry(entry);
                return (V)prevValue;
            }
            entry = entry._next;
        }
        return null;
    }

    public void clear() {
        Entry entry = this._mapFirst;
        while (entry != null) {
            entry._key = -1L;
            entry._value = null;
            entry._before = null;
            entry._next = null;
            if (entry._previous == null) {
                this._entries[entry._index] = null;
            } else {
                entry._previous = null;
            }
            entry = entry._after;
        }
        if (this._mapLast != null) {
            ((Entry)this._mapLast)._after = (Entry)this._poolFirst;
            this._poolFirst = this._mapFirst;
            this._mapFirst = null;
            this._mapLast = null;
            this._size = 0;
            this.sizeChanged();
        }
    }

    public void setCapacity(int newCapacity) {
        int tableLength;
        Entry entry;
        int i;
        if (newCapacity > this._capacity) {
            for (i = this._capacity; i < newCapacity; ++i) {
                entry = new Entry();
                entry._after = (Entry)this._poolFirst;
                this._poolFirst = entry;
            }
        } else if (newCapacity < this._capacity) {
            for (i = newCapacity; i < this._capacity && this._poolFirst != null; ++i) {
                entry = this._poolFirst;
                this._poolFirst = entry._after;
                entry._after = null;
            }
        }
        for (tableLength = 16; tableLength < newCapacity; tableLength <<= 1) {
        }
        if (this._entries.length != tableLength) {
            this._entries = new Entry[tableLength];
            this._mask = tableLength - 1;
            entry = this._mapFirst;
            while (entry != null) {
                int index = UtlLinkedLongMap.keyHash(entry._key) & this._mask;
                entry._index = index;
                entry._previous = null;
                Entry<V> next = this._entries[index];
                entry._next = (Entry)next;
                if (next != null) {
                    ((Entry)next)._previous = entry;
                }
                this._entries[index] = entry;
                entry = entry._after;
            }
        }
        this._capacity = newCapacity;
    }

    public int hashCode() {
        int code = 0;
        Entry entry = this._mapFirst;
        while (entry != null) {
            code += entry.hashCode();
            entry = entry._after;
        }
        return code;
    }

    public String toString() {
        return this.entrySet().toString();
    }

    public Collection<V> values() {
        return this._values;
    }

    public Set<Entry<V>> entrySet() {
        return this._entrySet;
    }

    protected void sizeChanged() {
        if (this.size() > this.capacity()) {
            this.setCapacity(this.capacity() * 2);
        }
    }

    private static int keyHash(long key) {
        return (int)(key ^ key >>> 32);
    }

    private void addEntry(long key, V value) {
        Entry<V> entry = this._poolFirst;
        if (entry != null) {
            this._poolFirst = ((Entry)entry)._after;
            ((Entry)entry)._after = null;
        } else {
            entry = new Entry();
        }
        ((Entry)entry)._key = key;
        ((Entry)entry)._value = value;
        int index = UtlLinkedLongMap.keyHash(key) & this._mask;
        ((Entry)entry)._index = index;
        Entry<V> next = this._entries[index];
        ((Entry)entry)._next = (Entry)next;
        if (next != null) {
            ((Entry)next)._previous = (Entry)entry;
        }
        this._entries[index] = entry;
        if (this._mapLast != null) {
            ((Entry)entry)._before = (Entry)this._mapLast;
            ((Entry)this._mapLast)._after = (Entry)entry;
        } else {
            this._mapFirst = entry;
        }
        this._mapLast = entry;
        ++this._size;
        this.sizeChanged();
    }

    private void removeEntry(Entry<V> entry) {
        Entry previous = ((Entry)entry)._previous;
        Entry next = ((Entry)entry)._next;
        if (previous != null) {
            previous._next = next;
            ((Entry)entry)._previous = null;
        } else {
            this._entries[((Entry)entry)._index] = next;
        }
        if (next != null) {
            next._previous = previous;
            ((Entry)entry)._next = null;
        }
        Entry before = ((Entry)entry)._before;
        Entry after = ((Entry)entry)._after;
        if (before != null) {
            before._after = after;
            ((Entry)entry)._before = null;
        } else {
            this._mapFirst = after;
        }
        if (after != null) {
            after._before = before;
        } else {
            this._mapLast = before;
        }
        ((Entry)entry)._key = -1L;
        ((Entry)entry)._value = null;
        ((Entry)entry)._after = (Entry)this._poolFirst;
        this._poolFirst = entry;
        --this._size;
        this.sizeChanged();
    }

    private void initialize(int capacity) {
        int tableLength;
        for (tableLength = 16; tableLength < capacity; tableLength <<= 1) {
        }
        this._entries = new Entry[tableLength];
        this._mask = tableLength - 1;
        this._capacity = capacity;
        this._size = 0;
        this._values = new Values();
        this._entrySet = new EntrySet();
        this._poolFirst = null;
        this._mapFirst = null;
        this._mapLast = null;
        for (int i = 0; i < capacity; ++i) {
            Entry entry = new Entry();
            entry._after = (Entry)this._poolFirst;
            this._poolFirst = entry;
        }
    }

    public static final class Entry<V> {
        private long _key;
        private V _value;
        private int _index;
        private Entry<V> _previous;
        private Entry<V> _next;
        private Entry<V> _before;
        private Entry<V> _after;

        public long getKey() {
            return this._key;
        }

        public V getValue() {
            return this._value;
        }

        public V setValue(V value) {
            V old = this._value;
            this._value = value;
            return old;
        }

        public boolean equals(Object that) {
            if (that instanceof Entry) {
                Entry entry = (Entry)that;
                return this._key == entry._key && (this._value != null ? this._value.equals(entry.getValue()) : entry.getValue() == null);
            }
            return false;
        }

        public int hashCode() {
            return UtlLinkedLongMap.keyHash(this._key) ^ (this._value != null ? this._value.hashCode() : 0);
        }

        public String toString() {
            return this._key + "=" + this._value;
        }
    }

    public final class FastIterator
    implements ListIterator<Entry<V>> {
        Entry<V> after;
        Entry<V> before;
        int nextIndex;

        public FastIterator() {
            this.after = UtlLinkedLongMap.this._mapFirst;
            this.nextIndex = 0;
        }

        public FastIterator toFirst() {
            this.after = UtlLinkedLongMap.this._mapFirst;
            this.before = null;
            this.nextIndex = 0;
            return this;
        }

        public FastIterator toLast() {
            this.after = null;
            this.before = UtlLinkedLongMap.this._mapLast;
            this.nextIndex = UtlLinkedLongMap.this._size;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.after != null;
        }

        public Entry<V> nextEntry() {
            if (this.after != null) {
                ++this.nextIndex;
                this.before = this.after;
                this.after = this.after._after;
                return this.before;
            }
            throw new NoSuchElementException();
        }

        @Override
        public Entry<V> next() {
            return this.nextEntry();
        }

        @Override
        public boolean hasPrevious() {
            return this.before != null;
        }

        public Entry<V> previousEntry() {
            if (this.before != null) {
                --this.nextIndex;
                this.after = this.before;
                this.before = this.before._after;
                return this.after;
            }
            throw new NoSuchElementException();
        }

        @Override
        public Entry<V> previous() {
            return this.previousEntry();
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            if (this.before == null) {
                throw new IllegalStateException();
            }
            UtlLinkedLongMap.this.removeEntry(this.before);
        }

        @Override
        public void set(Entry<V> o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Entry<V> o) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntrySet
    extends AbstractSet<Entry<V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Entry<V>> iterator() {
            return new Iterator<Entry<V>>(){
                Entry<V> after;
                Entry<V> before;
                {
                    this.after = UtlLinkedLongMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    if (this.before == null) {
                        throw new IllegalStateException();
                    }
                    UtlLinkedLongMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                @Override
                public Entry<V> next() {
                    if (this.after != null) {
                        this.before = this.after;
                        this.after = this.after._after;
                        return this.before;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public int size() {
            return UtlLinkedLongMap.this._size;
        }

        @Override
        public boolean contains(Object obj) {
            if (obj instanceof Entry) {
                Entry entry = (Entry)obj;
                Entry mapEntry = UtlLinkedLongMap.this.getEntry(entry.getKey());
                return entry.equals(mapEntry);
            }
            return false;
        }

        @Override
        public boolean remove(Object obj) {
            Entry entry;
            Entry mapEntry;
            if (obj instanceof Entry && (mapEntry = UtlLinkedLongMap.this.getEntry((entry = (Entry)obj).getKey())) != null && entry.getValue().equals(mapEntry._value)) {
                UtlLinkedLongMap.this.removeEntry(mapEntry);
                return true;
            }
            return false;
        }
    }

    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new Iterator<V>(){
                Entry<V> after;
                Entry<V> before;
                {
                    this.after = UtlLinkedLongMap.this._mapFirst;
                }

                @Override
                public void remove() {
                    if (this.before == null) {
                        throw new IllegalStateException();
                    }
                    UtlLinkedLongMap.this.removeEntry(this.before);
                }

                @Override
                public boolean hasNext() {
                    return this.after != null;
                }

                @Override
                public V next() {
                    if (this.after != null) {
                        this.before = this.after;
                        this.after = this.after._after;
                        return this.before._value;
                    }
                    throw new NoSuchElementException();
                }
            };
        }

        @Override
        public int size() {
            return UtlLinkedLongMap.this._size;
        }

        @Override
        public boolean contains(Object o) {
            return UtlLinkedLongMap.this.containsValue(o);
        }

        @Override
        public void clear() {
            UtlLinkedLongMap.this.clear();
        }
    }
}

