/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import java.io.IOException;

public class UtlDescriptor {
    public final String type;
    public final String config;
    public static final String SEPARATOR_STR = "://";

    protected UtlDescriptor(String type, String config) {
        this.type = type;
        this.config = config;
    }

    protected UtlDescriptor(CharSequence descriptor) throws IllegalArgumentException {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor cannot be null");
        }
        int index = -1;
        int s = 0;
        for (int i = 0; i < descriptor.length(); ++i) {
            s = descriptor.charAt(i) == SEPARATOR_STR.charAt(s) ? ++s : 0;
            if (s != SEPARATOR_STR.length()) continue;
            index = i - SEPARATOR_STR.length() + 1;
            break;
        }
        if (index <= 0) {
            throw new IllegalArgumentException("Descriptor must of of format [type]://[config], but was '" + descriptor + "'");
        }
        this.type = descriptor.subSequence(0, index).toString().trim();
        this.config = descriptor.subSequence(index + SEPARATOR_STR.length(), descriptor.length()).toString().trim();
    }

    public final String toString() {
        return this.type + SEPARATOR_STR + this.config;
    }

    public final void appendTo(Appendable appendable) {
        try {
            appendable.append(this.type).append(SEPARATOR_STR).append(this.config);
        }
        catch (IOException e) {
            throw new RuntimeException("Error appending descriptor: " + e.getMessage(), e);
        }
    }

    public static UtlDescriptor parse(CharSequence descriptor) throws IllegalArgumentException {
        return new UtlDescriptor(descriptor);
    }
}

