/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.config;

import com.neeve.config.ConfigObject;
import com.neeve.config.ConfigProviderRegistry;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.env.Env;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlAddressDescriptor;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public final class ConfigRepositoryFactory
extends ConfigObject {
    private static final ConfigRepositoryFactory instance;
    private final Object localRepositoryLock = new Object();
    private final Object defaultRepositoryLock = new Object();
    private IConfigRepository localRepository;
    private IConfigRepository defaultRepository;
    private boolean defaultOpenInProgress = false;
    public static final String LOCAL_CONFIG_DESCRIPTOR;
    public static final String DEFAULT_CONFIG_DESCRIPTOR;
    private static final String MEMORY_CONFIG_DESCRIPTOR = "mem://.";

    private ConfigRepositoryFactory() {
    }

    public static final ConfigRepositoryFactory getInstance() {
        return instance;
    }

    private final List<BufferedInputStream> getEmbeddedRepositories() throws IOException {
        ArrayList<BufferedInputStream> repos = new ArrayList<BufferedInputStream>();
        boolean useEmbeddedRepos = Env.getValue("nv.config.useembeddedrepos", true);
        if (useEmbeddedRepos) {
            this.tracer.log("Looking for config repositories in the classpath", Tracer.Level.INFO);
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            for (Resource resource : resolver.getResources("classpath*:/META-INF/repo/*.repo")) {
                this.tracer.log("...found repo '" + resource.getFilename() + "'.", Tracer.Level.INFO);
                repos.add(new BufferedInputStream(resource.getURL().openStream()));
            }
            this.tracer.log("...found a total of " + repos.size() + " repo(s)", Tracer.Level.INFO);
        } else {
            this.tracer.log("Configured not to use embedded config repos", Tracer.Level.INFO);
        }
        return repos;
    }

    private final byte[] toByteArray(BufferedInputStream bin) throws IOException {
        int len;
        byte[] array = new byte[8192];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((len = bin.read(array, 0, array.length)) >= 0) {
            baos.write(array, 0, len);
        }
        return baos.toByteArray();
    }

    public final IConfigRepository createRepository(String descriptorStr) throws EConfigException {
        if (descriptorStr == null) {
            throw new IllegalArgumentException("descriptor string cannot be null");
        }
        UtlAddressDescriptor descriptor = UtlAddressDescriptor.parse(descriptorStr, null);
        return ConfigProviderRegistry.getInstance().getProvider(descriptor.type).createRepository(descriptor);
    }

    public final IConfigRepository openRepository(String descriptorStr) throws EConfigException {
        if (descriptorStr == null) {
            throw new IllegalArgumentException("descriptor string cannot be null");
        }
        UtlAddressDescriptor descriptor = UtlAddressDescriptor.parse(descriptorStr, null);
        return ConfigProviderRegistry.getInstance().getProvider(descriptor.type).openRepository(descriptor);
    }

    public final boolean repositoryExists(String descriptorStr) throws EConfigException {
        if (descriptorStr == null) {
            throw new IllegalArgumentException("descriptor string cannot be null");
        }
        UtlAddressDescriptor descriptor = UtlAddressDescriptor.parse(descriptorStr, null);
        return ConfigProviderRegistry.getInstance().getProvider(descriptor.type).repositoryExists(descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IConfigRepository getLocalRepository() {
        Object object = this.localRepositoryLock;
        synchronized (object) {
            block21: {
                if (this.localRepository == null) {
                    if (this.tracer.debug) {
                        this.tracer.log("Initializing local configuration repository...", Tracer.Level.DEBUG);
                    }
                    List<BufferedInputStream> bins = null;
                    try {
                        bins = this.getEmbeddedRepositories();
                    }
                    catch (IOException e) {
                        this.tracer.log("Failure encountered while getting embedded repositories [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
                        e.printStackTrace();
                        System.exit(0);
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("Embedded repositories exist = " + (bins.size() > 0) + ".", Tracer.Level.DEBUG);
                    }
                    try {
                        boolean durableRepoExists = this.repositoryExists(LOCAL_CONFIG_DESCRIPTOR);
                        if (this.tracer.debug) {
                            this.tracer.log("Durable repository exists = " + durableRepoExists + ".", Tracer.Level.DEBUG);
                        }
                        if (!durableRepoExists && bins.size() == 0) {
                            this.tracer.log("Durable configuration repository '" + LOCAL_CONFIG_DESCRIPTOR + "' does not exist and no embedded repositories. Cannot proceed!", Tracer.Level.SEVERE);
                            System.exit(0);
                        }
                        String repoDescriptor = durableRepoExists ? LOCAL_CONFIG_DESCRIPTOR : MEMORY_CONFIG_DESCRIPTOR;
                        try {
                            if (this.tracer.debug) {
                                this.tracer.log("Opening repository '" + repoDescriptor + "' as local configuration repository...", Tracer.Level.DEBUG);
                            }
                            this.localRepository = this.openRepository(repoDescriptor);
                        }
                        catch (Exception e) {
                            this.tracer.log("Failed to open local configuration repository '" + repoDescriptor + "' [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
                            e.printStackTrace();
                            System.exit(0);
                        }
                        if (bins.size() <= 0) break block21;
                        try {
                            this.tracer.log("Initializing local repository using the " + bins.size() + " embedded repositories found on classpath.", Tracer.Level.INFO);
                            for (BufferedInputStream bin : bins) {
                                try {
                                    this.localRepository.deserialize(new String(this.toByteArray(bin), "UTF-8"), false);
                                }
                                finally {
                                    bin.close();
                                }
                            }
                        }
                        catch (Exception e) {
                            this.tracer.log("Failed to initialize local configuration repository '" + repoDescriptor + "' using embedded repositories [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
                            e.printStackTrace();
                            System.exit(0);
                        }
                    }
                    catch (EConfigException e) {
                        this.tracer.log("Failure encountered while checking for existence of durable local repository '" + LOCAL_CONFIG_DESCRIPTOR + "' [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
                        e.printStackTrace();
                        System.exit(0);
                    }
                }
            }
        }
        return this.localRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IConfigRepository getDefaultRepository() {
        Object object = this.defaultRepositoryLock;
        synchronized (object) {
            block25: {
                if (this.defaultRepository == null) {
                    if (this.defaultOpenInProgress) {
                        return this.getLocalRepository();
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("Initializing default configuration repository...", Tracer.Level.DEBUG);
                    }
                    this.defaultOpenInProgress = true;
                    List<BufferedInputStream> bins = null;
                    try {
                        bins = this.getEmbeddedRepositories();
                    }
                    catch (IOException e) {
                        this.tracer.log("Failure encountered while getting embedded repositories [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
                        e.printStackTrace();
                        System.exit(0);
                    }
                    if (this.tracer.debug) {
                        this.tracer.log("Embedded repositories exist = " + (bins.size() > 0) + ".", Tracer.Level.DEBUG);
                    }
                    try {
                        try {
                            boolean durableRepoExists = this.repositoryExists(DEFAULT_CONFIG_DESCRIPTOR);
                            if (this.tracer.debug) {
                                this.tracer.log("Durable repository exists = " + durableRepoExists + ".", Tracer.Level.DEBUG);
                            }
                            if (!durableRepoExists && bins.size() == 0) {
                                this.tracer.log("Durable configuration repository '" + DEFAULT_CONFIG_DESCRIPTOR + "' does not exist and no embedded repositories. Cannot proceed!", Tracer.Level.SEVERE);
                                System.exit(0);
                            }
                            String repoDescriptor = durableRepoExists ? DEFAULT_CONFIG_DESCRIPTOR : MEMORY_CONFIG_DESCRIPTOR;
                            try {
                                if (this.tracer.debug) {
                                    this.tracer.log("Opening repository '" + repoDescriptor + "' as default configuration repository...", Tracer.Level.DEBUG);
                                }
                                this.defaultRepository = this.openRepository(repoDescriptor);
                            }
                            catch (Exception e) {
                                this.tracer.log("Failed to open default configuration repository '" + repoDescriptor + "' [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
                                e.printStackTrace();
                                System.exit(0);
                            }
                            if (bins.size() <= 0) break block25;
                            try {
                                this.tracer.log("Initializing default repository using the " + bins.size() + " embedded repositories found on classpath.", Tracer.Level.INFO);
                                for (BufferedInputStream bin : bins) {
                                    try {
                                        this.defaultRepository.deserialize(new String(this.toByteArray(bin), "UTF-8"), false);
                                    }
                                    finally {
                                        bin.close();
                                    }
                                }
                            }
                            catch (Exception e) {
                                this.tracer.log("Failed to initialize default configuration repository '" + repoDescriptor + "' using embedded repositories [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
                                e.printStackTrace();
                                System.exit(0);
                            }
                        }
                        catch (EConfigException e) {
                            this.tracer.log("Failure encountered while checking for existence of durable default repository '" + DEFAULT_CONFIG_DESCRIPTOR + "' [" + e.toString() + "]. Cannot proceed!", Tracer.Level.SEVERE);
                            e.printStackTrace();
                            System.exit(0);
                        }
                    }
                    finally {
                        this.defaultOpenInProgress = false;
                    }
                }
            }
        }
        return this.defaultRepository;
    }

    public final void close() {
        if (this.defaultRepository != null && this.defaultRepository != this.localRepository) {
            try {
                if (this.tracer.debug) {
                    this.tracer.log("Closing configuration repository '" + DEFAULT_CONFIG_DESCRIPTOR + "'...", Tracer.Level.DEBUG);
                }
                this.defaultRepository.close();
            }
            catch (EConfigException e) {
                this.tracer.log("Failed to close configuration repository '" + DEFAULT_CONFIG_DESCRIPTOR + "' [" + e.toString() + "]!", Tracer.Level.WARNING);
            }
        }
        if (this.localRepository != null) {
            try {
                if (this.tracer.debug) {
                    this.tracer.log("Closing configuration repository '" + LOCAL_CONFIG_DESCRIPTOR + "'...", Tracer.Level.DEBUG);
                }
                this.localRepository.close();
            }
            catch (EConfigException e) {
                this.tracer.log("Failed to close configuration repository '" + LOCAL_CONFIG_DESCRIPTOR + "' [" + e.toString() + "]!", Tracer.Level.WARNING);
            }
        }
    }

    static {
        LOCAL_CONFIG_DESCRIPTOR = Env.getValue("nv.local.config.descriptor", "pft://.");
        DEFAULT_CONFIG_DESCRIPTOR = Env.getValue("nv.config.descriptor", LOCAL_CONFIG_DESCRIPTOR);
        instance = new ConfigRepositoryFactory();
    }
}

