/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.impl.executor;

import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageLatencyManager;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageWaypointListener;
import com.neeve.sma.MessageWaypointListenerRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaPermanentException;
import com.neeve.sma.impl.MessageChannelBase;
import com.neeve.sma.impl.executor.ExecutorBusBinding;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlTime;

public class ExecutorBusChannel
extends MessageChannelBase {
    private final ExecutorBusBinding binding;

    protected ExecutorBusChannel(MessageChannelDescriptor descriptor, ExecutorBusBinding binding) throws SmaException {
        super(null, descriptor, binding);
        this.binding = binding;
    }

    final void ack(MessageView message, Exception status) {
        this.onMessageStability(message, status);
    }

    @Override
    public String getType() {
        return "Executor";
    }

    @Override
    protected boolean doSend(MessageView view, MessageBusBinding.FlushContext flushContext, int flags) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Received request to send message...", Tracer.Level.DEBUG);
        }
        MessageWaypointListenerRegistry.dispatch(MessageWaypointListener.Waypoint.s1, MessageWaypointListener.MessagingDirection.Outbound, view);
        if (MessageLatencyManager.captureMsgLatencyStats) {
            view.setPreSerializeTs(UtlTime.now());
        }
        if (MessageLatencyManager.captureMsgLatencyStats) {
            view.setPostSerializeTs(UtlTime.now());
        }
        MessageWaypointListenerRegistry.dispatch(MessageWaypointListener.Waypoint.s2, MessageWaypointListener.MessagingDirection.Outbound, view);
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Enqueuing executor bus task. Message is " + view.getClass().getSimpleName(), Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... Timestamps {", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... ...preSerialize=" + view.getPreSerializeTs(), Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... ...postSerialize=" + view.getPostSerializeTs(), Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "... }", Tracer.Level.DEBUG);
        }
        this.binding.processMessage(this, view);
        return this.binding.markFlushAsComplete(flushContext);
    }

    @Override
    protected void doJoin(String[] filters, int flags) throws SmaException {
        throw new SmaPermanentException("Joining an executor bus channel is not supported");
    }

    @Override
    protected void doLeave(int flags) throws SmaException {
        throw new SmaPermanentException("Leaving an executor bus channel is not supported");
    }

    @Override
    protected void doClose() throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Closing channel...", Tracer.Level.DEBUG);
        }
    }
}

