/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.impl;

import com.neeve.ci.XRuntime;
import com.neeve.event.Event;
import com.neeve.lang.XString;
import com.neeve.root.RootConfig;
import com.neeve.sma.MessageBusBinding;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageChannelKeyResolver;
import com.neeve.sma.MessageEncodingTypeRegistry;
import com.neeve.sma.MessageReflector;
import com.neeve.sma.MessageSerializer;
import com.neeve.sma.MessageTransportHeaders;
import com.neeve.sma.MessageView;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.sma.UnsupportedMessageEncodingTypeException;
import com.neeve.sma.event.MessageStabilityEvent;
import com.neeve.sma.impl.DefaultMessageChannelKeyResolver;
import com.neeve.sma.impl.MessageBusBindingBase;
import com.neeve.sma.impl.MessageChannelKeyNormalizer;
import com.neeve.sma.impl.MessagingProviderBase;
import com.neeve.trace.Tracer;
import java.util.Properties;

public abstract class MessageChannelBase
extends SmaObject
implements MessageChannel {
    private static final int globalMaxKeyLength = XRuntime.getValue((String)"nv.sma.maxresolvedkeylength", (int)XRuntime.getValue((String)"nv.sma.maxResolvedKeyLength", (int)0));
    private static final boolean validateMessageKey = XRuntime.getValue((String)"nv.sma.validatemessagekey", (boolean)false);
    protected final XString name;
    protected final short id;
    protected final MessageChannelDescriptor descriptor;
    protected final MessageBusBindingBase binding;
    protected final WireInfo wireInfo;
    protected final String tracePrefix;
    protected final int channelMaxKeyLength;
    protected volatile MessageChannel.State state;
    private final MessageEncodingTypeRegistry encodingTypeRegistry;
    private final DefaultMessageChannelKeyResolver keyResolver;
    private boolean joined;
    private Object attachment;

    protected MessageChannelBase(RootConfig.ObjectConfig config, MessageChannelDescriptor descriptor, MessageBusBindingBase binding) throws SmaException {
        super(config);
        this.descriptor = descriptor;
        this.name = XString.create((String)descriptor.getName(), (boolean)true, (boolean)true);
        this.id = descriptor.getChannelId();
        this.binding = binding;
        this.tracePrefix = "[MsgChannel<" + binding.getUserName() + "." + this.getName() + "@" + binding.getName() + "(" + this.getType() + ")>] ";
        MessageChannelKeyNormalizer keyNormalizer = null;
        if (binding.provider instanceof MessagingProviderBase) {
            keyNormalizer = ((MessagingProviderBase)binding.provider).createMessageChannelKeyNormalizer(null);
        }
        if (keyNormalizer == null) {
            keyNormalizer = new MessageChannelImplKeyNormalizer(this);
        }
        this.keyResolver = new DefaultMessageChannelKeyResolver(descriptor, keyNormalizer);
        this.wireInfo = new WireInfo();
        this.encodingTypeRegistry = MessageEncodingTypeRegistry.getInstance();
        int n = globalMaxKeyLength > 0 && keyNormalizer.getMaxKeyLength() > 0 ? Math.min(globalMaxKeyLength, keyNormalizer.getMaxKeyLength()) : (this.channelMaxKeyLength = globalMaxKeyLength > 0 ? globalMaxKeyLength : Math.max(0, keyNormalizer.getMaxKeyLength()));
        if (binding.topicStartsWithChannel() && validateMessageKey && this.channelMaxKeyLength > 0 && this.name.length() > this.channelMaxKeyLength) {
            throw new SmaException("Binding configured to prefix topic name with channel name, but channel name '" + this.name.getValue() + "' exceeds max supported length of " + this.channelMaxKeyLength);
        }
        this.state = MessageChannel.State.Open;
    }

    private final SmaException prepareStateValidationErrorException() {
        switch (this.state) {
            case Open: {
                return new SmaException("channel is open");
            }
            case Failed: {
                return new SmaException("channel's binding has failed");
            }
            case Closed: {
                return new SmaException("channel is closed");
            }
            case Closing: {
                return new SmaException("channel is closing");
            }
        }
        throw new InternalError("Unknown state!!");
    }

    @Deprecated
    protected String cleanFilterLevel(String filterLevel) {
        StringBuilder sb = new StringBuilder();
        for (int j = 0; j < filterLevel.length(); ++j) {
            char c = filterLevel.charAt(j);
            sb.append(Character.isLetterOrDigit(c) ? Character.valueOf(c) : "_");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean sendMessageCore(MessageView view, Properties keyResolutionTable, MessageChannel.RawKeyResolutionTable rawKeyResolutionTable, MessageBusBinding.FlushContext flushContext, int flags) throws SmaException {
        if (view == null) {
            throw new IllegalArgumentException("message view cannot be null");
        }
        if (this.state == MessageChannel.State.Open) {
            boolean flushed;
            XString key;
            int sender;
            boolean keyAlreadyValidated;
            boolean viewAlreadySyncd = (flags & 2) == 2;
            boolean senderAlreadyResolved = (flags & 4) == 4;
            boolean snoAlreadyResolved = (flags & 8) == 8;
            boolean keyAlreadyResolved = (flags & 0x10) == 16;
            boolean bl = keyAlreadyValidated = (flags & 0x20) == 32;
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Sending message...", Tracer.Level.DEBUG);
            }
            if (!viewAlreadySyncd) {
                view.sync();
            }
            if (!senderAlreadyResolved && (sender = view.getMessageSender()) == 0) {
                view.setMessageSender(this.binding.getId());
            }
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "...message sender =" + view.getMessageSender() + "...", Tracer.Level.DEBUG);
            }
            if (!keyAlreadyResolved && ((key = view.getMessageKeyAsRaw()) == null || key.isNull())) {
                try {
                    if (keyResolutionTable != null) {
                        view.resolveMessageKeyWith((MessageChannelKeyResolver)this.keyResolver, keyResolutionTable);
                    } else {
                        view.resolveMessageKeyWith((MessageChannelKeyResolver)this.keyResolver, rawKeyResolutionTable);
                    }
                }
                catch (SmaException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!keyAlreadyValidated) {
                this.validateResolvedMessageKey(view);
            }
            if (this.tracer.debug) {
                if (view.getMessageKeyAsRaw() != null) {
                    this.tracer.log(this.tracePrefix + "...message key =" + view.getMessageKeyAsRaw().toDiagnosticString() + (!keyAlreadyResolved ? "(not pre resolved)..." : "..."), Tracer.Level.DEBUG);
                } else {
                    this.tracer.log(this.tracePrefix + "...message key = null " + (!keyAlreadyResolved ? "(not pre resolved)..." : "..."), Tracer.Level.DEBUG);
                }
            }
            if (this.getQos() == MessageChannel.Qos.Guaranteed) {
                view.acquire();
            }
            this.binding.acquireSendLock();
            try {
                if (!snoAlreadyResolved) {
                    view.setMessageSequenceNumber(this.binding.getNextSno());
                }
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "...message sno =" + view.getMessageSequenceNumber() + "...", Tracer.Level.DEBUG);
                }
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + "Sending message [" + view.getMessage() + "].", Tracer.Level.DEBUG);
                }
                flushed = this.doSend(view, flushContext, flags);
            }
            finally {
                this.binding.releaseSendLock();
            }
            this.wireInfo.postSend();
            return flushed;
        }
        throw this.prepareStateValidationErrorException();
    }

    static final boolean isValidId(short id) {
        return id > 0;
    }

    static final boolean hasValidId(MessageChannel channel) {
        return MessageChannelBase.isValidId(channel.getId());
    }

    protected final MessageSerializer getMessageSerializer(int encodingType) throws UnsupportedMessageEncodingTypeException {
        MessageSerializer serializer = this.encodingTypeRegistry.getMessageSerializer(encodingType);
        if (serializer != null) {
            return serializer;
        }
        throw new UnsupportedMessageEncodingTypeException();
    }

    protected final MessageReflector getMessageReflector(int encodingType) {
        return this.encodingTypeRegistry.getMessageReflector(encodingType);
    }

    protected abstract boolean doSend(MessageView var1, MessageBusBinding.FlushContext var2, int var3) throws SmaException;

    protected abstract void doJoin(String[] var1, int var2) throws SmaException;

    protected abstract void doLeave(int var1) throws SmaException;

    protected abstract void doClose() throws SmaException;

    @Deprecated
    protected char getHierarchicalKeyDelimiter() {
        return '/';
    }

    @Deprecated
    protected int getMaxKeyLength() {
        return 0;
    }

    protected final void onFail(Exception e) {
        this.joined = false;
        this.state = MessageChannel.State.Failed;
    }

    @Deprecated
    protected final void onMessage(Object message, short vfid, short vtype, int encodingType, int sender, int flow, long sno, XString key, MessageBusBindingBase.Acknowledger<?> acknowledger, long originTs, long preWireTs, long postWireTs, long preDeserializeTs) {
        this.onMessage(message, null, vfid, vtype, encodingType, sender, flow, sno, key, acknowledger, originTs, preWireTs, postWireTs, preDeserializeTs);
    }

    protected final void onMessage(Object message, MessageTransportHeaders headers, short vfid, short vtype, int encodingType, int sender, int flow, long sno, XString key, MessageBusBindingBase.Acknowledger<?> acknowledger, long originTs, long preWireTs, long postWireTs, long preDeserializeTs) {
        if (message == null) {
            throw new RuntimeException("Inbound message is corrupt [no body data in message]");
        }
        MessageView view = this.binding.wrap(message, vfid, vtype, encodingType, sender, flow, sno, key, originTs, preWireTs, postWireTs, preDeserializeTs);
        if (this.binding.isEnableInboundTransportHeaders()) {
            view.setMessageTransportHeaders(headers);
        }
        this.binding.onMessage(this, view, acknowledger);
    }

    @Deprecated
    protected final void onMessage(Object message, short vfid, short vtype, int encodingType, int sender, int flow, long sno, MessageBusBindingBase.Acknowledger<?> acknowledger, long originTs, long preWireTs, long postWireTs, long preDeserializeTs) {
        this.onMessage(message, null, vfid, vtype, encodingType, sender, flow, sno, null, acknowledger, originTs, preWireTs, postWireTs, preDeserializeTs);
    }

    @Deprecated
    protected final void onStability(MessageView view) {
        this.onMessageStability(view, null);
    }

    protected final void onMessageStability(MessageView view) {
        this.onMessageStability(view, null);
    }

    protected final void onMessageStability(MessageView view, Exception status) {
        this.onEvent(MessageStabilityEvent.create(this.binding, this, view, status));
    }

    protected final void onEvent(Event event, boolean trapException) {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null");
        }
        this.binding.onEvent(event, trapException);
    }

    protected final void onEvent(Event event) {
        this.onEvent(event, true);
    }

    @Override
    public void validateResolvedMessageKey(MessageView view) throws SmaException {
        int keyLength;
        if (!validateMessageKey) {
            if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + "Skipping key validation...", Tracer.Level.DEBUG);
            }
            return;
        }
        XString key = view.getMessageKeyAsRaw();
        if (key == null || key.length() == 0) {
            if (!this.binding.topicStartsWithChannel()) {
                throw new SmaException(this.tracePrefix + "message has null key but binding configured to not prepend topic with channel");
            }
            return;
        }
        if (this.channelMaxKeyLength > 0 && (keyLength = key.length() + (this.binding.topicStartsWithChannel ? this.name.length() + 1 : 0)) > this.channelMaxKeyLength) {
            throw new SmaException(this.tracePrefix + "message key '" + (this.binding.topicStartsWithChannel ? this.name.getValue() + "/" : "") + key.getValue() + "' has exceeded the max supported key length (" + this.channelMaxKeyLength + ")");
        }
        if (key.charAt(0) == '\u0000') {
            throw new SmaException(this.tracePrefix + "message key cannot start with a null character '" + key.getValue() + "'");
        }
        int delim = 47;
        boolean inDelim = false;
        for (int i = 0; i < key.length(); ++i) {
            boolean isDelim;
            char c = key.charAt(i);
            boolean bl = isDelim = c == '/';
            if (inDelim && isDelim) {
                throw new SmaException(this.tracePrefix + "Empty key level detected in key '" + key.getValue() + "' at position " + i);
            }
            inDelim = isDelim;
        }
    }

    @Override
    public final void setAttachment(Object object) {
        this.attachment = object;
    }

    @Override
    public final Object getAttachment() {
        return this.attachment;
    }

    @Override
    public final String getName() {
        return this.name.getValue();
    }

    @Override
    public final XString getNameAsRaw() {
        return this.name;
    }

    @Override
    public final short getId() {
        return this.id;
    }

    @Override
    public final MessageChannelDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final MessageBusBinding getMessageBusBinding() {
        return this.binding;
    }

    @Override
    public final MessageChannel.State getState() {
        return this.state;
    }

    @Override
    public final MessageChannel.Qos getQos() {
        return this.descriptor.getChannelQos();
    }

    @Override
    public final void setKeyResolutionTable(Properties table) {
        this.keyResolver.setKeyResolutionTable(table);
    }

    @Override
    public final Properties getKeyResolutionTable() {
        return this.keyResolver.getKeyResolutionTable();
    }

    @Override
    public final void setRawKeyResolutionTable(MessageChannel.RawKeyResolutionTable table) {
        this.keyResolver.setRawKeyResolutionTable(table);
    }

    @Override
    public final MessageChannel.RawKeyResolutionTable getRawKeyResolutionTable() {
        return this.keyResolver.getRawKeyResolutionTable();
    }

    @Override
    public final String resolveMessageKey(MessageView view, Properties keyResolutionTable) throws SmaException {
        return this.keyResolver.resolveMessageKey(view, keyResolutionTable);
    }

    @Override
    public final XString resolveMessageKeyToRaw(XString target, MessageView view, MessageChannel.RawKeyResolutionTable keyResolutionTable) throws SmaException {
        return this.keyResolver.resolveMessageKey(target, view, keyResolutionTable);
    }

    @Override
    public final MessageChannelKeyResolver getMessageKeyResolver() {
        return this.keyResolver;
    }

    @Override
    public final boolean sendMessage(MessageView view, Properties keyResolutionTable, MessageBusBinding.FlushContext flushContext, int flags) throws SmaException {
        return this.sendMessageCore(view, keyResolutionTable, null, flushContext, flags);
    }

    @Override
    public final boolean sendMessage(MessageView view, MessageChannel.RawKeyResolutionTable keyResolutionTable, MessageBusBinding.FlushContext flushContext, int flags) throws SmaException {
        return this.sendMessageCore(view, null, keyResolutionTable, flushContext, flags);
    }

    @Override
    public final boolean sendMessage(MessageView view, MessageBusBinding.FlushContext flushContext, int flags) throws SmaException {
        return this.sendMessageCore(view, null, null, flushContext, flags);
    }

    @Override
    public final boolean isJoined() {
        return this.joined;
    }

    @Override
    public final void join(int flags) throws SmaException {
        if (this.state == MessageChannel.State.Open) {
            if (!this.joined) {
                this.doJoin(this.keyResolver.getKeyBasedFilters(), flags);
                this.joined = true;
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
    }

    @Override
    public final void leave(int flags) throws SmaException {
        if (this.state == MessageChannel.State.Open || this.state == MessageChannel.State.Closing) {
            if (this.joined) {
                this.doLeave(flags);
                this.joined = false;
            }
        } else {
            throw this.prepareStateValidationErrorException();
        }
    }

    @Override
    public final void close() throws SmaException {
        int flags = 0;
        if (this.descriptor.getPreserveJoinsOnClose() == MessageChannel.PreserveJoinPolicy.Preserve) {
            flags |= 0x40;
        }
        this.close(flags);
    }

    @Override
    public final void close(int flags) throws SmaException {
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " closing channel [state=" + (Object)((Object)this.state) + ", flags=" + flags + "]", Tracer.Level.DEBUG);
        }
        if (this.state == MessageChannel.State.Open || this.state == MessageChannel.State.Failed) {
            try {
                if (this.state != MessageChannel.State.Failed) {
                    this.state = MessageChannel.State.Closing;
                    if ((flags & 0x40) == 0) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + " leaving channel", Tracer.Level.DEBUG);
                        }
                        this.leave(0);
                    }
                }
                this.doClose();
                this.state = MessageChannel.State.Closed;
                this.binding.onChannelClose(this);
            }
            catch (Throwable thrown) {
                if (this.state == MessageChannel.State.Closing) {
                    if (this.binding.canFail()) {
                        this.onFail(new SmaException(this.tracePrefix + "Exception during channel close, failing channel: " + thrown.getMessage(), thrown));
                    } else {
                        this.state = MessageChannel.State.Closed;
                    }
                }
                if (thrown instanceof SmaException) {
                    throw (SmaException)thrown;
                }
                throw new SmaException(this.tracePrefix + "Exception during channel close: " + thrown.getMessage(), thrown);
            }
        }
    }

    protected final void finalize() {
        try {
            this.close();
        }
        catch (SmaException smaException) {
            // empty catch block
        }
    }

    public String toString() {
        return "MessageChannel [type=" + this.getType() + ", name=" + this.getName() + ", qos=" + (Object)((Object)this.getQos()) + ", id=" + this.getId() + ", state=" + (Object)((Object)this.getState()) + "]";
    }

    private static final class MessageChannelImplKeyNormalizer
    implements MessageChannelKeyNormalizer {
        private final MessageChannelBase channel;

        private MessageChannelImplKeyNormalizer(MessageChannelBase channel) {
            this.channel = channel;
        }

        @Override
        public final int getMaxKeyLength() {
            return this.channel.getMaxKeyLength();
        }

        @Override
        public final char getHierarchicalKeyDelimiter() {
            return this.channel.getHierarchicalKeyDelimiter();
        }

        @Override
        public final String cleanFilterLevel(String filterLevel) {
            return this.channel.cleanFilterLevel(filterLevel);
        }
    }

    protected final class WireInfo {
        private volatile boolean firstSendDone;
        private XString name;
        private short id;

        private WireInfo() {
            this.name = XString.create((String)MessageChannelBase.this.name.getValue(), (boolean)true, (boolean)true);
            this.id = MessageChannelBase.this.id;
            this.firstSendDone = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void postSend() {
            if (!this.firstSendDone) {
                WireInfo wireInfo = this;
                synchronized (wireInfo) {
                    if (!this.firstSendDone) {
                        if (this.id > 0) {
                            this.name = null;
                        }
                        this.firstSendDone = true;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final String getChannelName() {
            if (!this.firstSendDone) {
                WireInfo wireInfo = this;
                synchronized (wireInfo) {
                    if (this.name != null) {
                        return this.name.getValue();
                    }
                }
            } else if (this.name != null) {
                return this.name.getValue();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final XString getChannelNameAsRaw() {
            if (!this.firstSendDone) {
                WireInfo wireInfo = this;
                synchronized (wireInfo) {
                    return this.name;
                }
            }
            return this.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final short getChannelId() {
            if (!this.firstSendDone) {
                WireInfo wireInfo = this;
                synchronized (wireInfo) {
                    return this.id;
                }
            }
            return this.id;
        }
    }
}

