/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma.impl;

import com.neeve.ci.XRuntime;
import com.neeve.lang.XLinkedHashMap;
import com.neeve.lang.XString;
import com.neeve.sma.MapMessageView;
import com.neeve.sma.MessageBusDescriptor;
import com.neeve.sma.MessageChannel;
import com.neeve.sma.MessageChannelDescriptor;
import com.neeve.sma.MessageChannelKeyResolver;
import com.neeve.sma.MessageReflector;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessagingProvider;
import com.neeve.sma.MessagingProviderRegistry;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import com.neeve.sma.SmaPermanentException;
import com.neeve.sma.impl.DefaultMessageChannelKeyNormalizer;
import com.neeve.sma.impl.MessageChannelKeyFunctionRegistry;
import com.neeve.sma.impl.MessageChannelKeyNormalizer;
import com.neeve.sma.impl.MessagingProviderBase;
import com.neeve.trace.Tracer;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlProps;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class DefaultMessageChannelKeyResolver
extends SmaObject
implements MessageChannelKeyResolver {
    private static final int globalMaxKeyLength = XRuntime.getValue((String)"nv.sma.maxresolvedkeylength", (int)XRuntime.getValue((String)"nv.sma.maxResolvedKeyLength", (int)0));
    private static final boolean cleanKey = XRuntime.getValue((String)"nv.sma.cleanmessagekey", (boolean)XRuntime.getValue((String)"nv.sma.cleanMessageKey", (boolean)false));
    private static final boolean cleanFilter = XRuntime.getValue((String)"nv.sma.cleanchannelfilter", (boolean)false);
    private static final boolean treatEmptyKeyAsNull = XRuntime.getValue((String)"nv.sma.treatemptykeyfieldasnull", (boolean)false);
    private static final boolean allowEmptyKey = XRuntime.getValue((String)"nv.sma.allowemptykeyfield", (boolean)XRuntime.getValue((String)"nv.sma.allowEmptyKeyField", (boolean)false));
    private static final boolean validateMessageKey = XRuntime.getValue((String)"nv.sma.validatemessagekey", (boolean)false);
    private static final ThreadLocal<XString> cachedKeyBuilder = new ThreadLocal();
    private final XString channelName;
    private final String tracePrefix;
    private final ChannelKey parsedKey;
    private final Properties channelFilterTable;
    private final Properties contentFilterTable;
    private final String[] keyBasedFilters;
    private final boolean topicStartsWithChannel;
    private final int channelMaxKeyLength;
    private final MessageChannelKeyNormalizer keyNormalizer;
    private volatile Properties keyResolutionTable;
    private volatile MessageChannel.RawKeyResolutionTable rawKeyResolutionTable;

    DefaultMessageChannelKeyResolver(MessageChannelDescriptor descriptor, MessageChannelKeyNormalizer keyNormalizer) throws SmaException {
        super(null);
        this.channelName = XString.create((String)descriptor.getName(), (boolean)true, (boolean)true);
        MessageBusDescriptor busDescriptor = descriptor.getParent();
        this.tracePrefix = "[MsgChannelKeyResolver<" + descriptor.getName() + "@" + busDescriptor.getName() + "(" + busDescriptor.getProviderConfig().getProperty("Provider", "unknown") + ")>] ";
        if (keyNormalizer == null) {
            block23: {
                String providerName;
                Properties providerConfig = busDescriptor.getProviderConfig();
                String string = providerName = providerConfig == null ? null : providerConfig.getProperty("Provider");
                if (providerName != null) {
                    try {
                        MessagingProvider provider = MessagingProviderRegistry.getInstance().getProvider(providerName);
                        if (provider instanceof MessagingProviderBase) {
                            keyNormalizer = ((MessagingProviderBase)provider).createMessageChannelKeyNormalizer(null);
                        }
                        break block23;
                    }
                    catch (Exception e) {
                        if (this.tracer.debug) {
                            this.tracer.log(this.tracePrefix + " could not load key normalizer from configured messaging provider '" + providerName + "' [" + e.getMessage() + "]", Tracer.Level.WARNING);
                        }
                        break block23;
                    }
                }
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " no provider configured for bus '" + busDescriptor.getName() + " ... will use default key normalizer.", Tracer.Level.WARNING);
                }
            }
            if (keyNormalizer == null) {
                keyNormalizer = new DefaultMessageChannelKeyNormalizer();
                if (this.tracer.debug) {
                    this.tracer.log(this.tracePrefix + " using default key normalizer (" + keyNormalizer.getClass().getName() + ")", Tracer.Level.DEBUG);
                }
            } else if (this.tracer.debug) {
                this.tracer.log(this.tracePrefix + " using provider supplied key normalizer (" + keyNormalizer.getClass().getName() + ")", Tracer.Level.DEBUG);
            }
        } else if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + " using provided key normalizer (" + keyNormalizer.getClass().getName() + ")", Tracer.Level.DEBUG);
        }
        this.keyNormalizer = keyNormalizer;
        this.parsedKey = ChannelKey.parse(descriptor.getChannelKey());
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Parsed channel key '" + this.parsedKey.channelKey + "': ", Tracer.Level.DEBUG);
            if (!this.parsedKey.isNull()) {
                for (int i = 0; i < this.parsedKey.keyParts.length; ++i) {
                    this.tracer.log(this.tracePrefix + "..." + this.parsedKey.keyParts[i], Tracer.Level.DEBUG);
                }
            } else {
                this.tracer.log(this.tracePrefix + "...<null>", Tracer.Level.DEBUG);
            }
        }
        this.channelFilterTable = this.parseFilter(descriptor.getChannelFilter());
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Parsed channel filters:", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "..." + (this.channelFilterTable == null ? "<null>" : this.channelFilterTable), Tracer.Level.DEBUG);
        }
        this.contentFilterTable = this.computeContentFilters(this.channelFilterTable);
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Parsed content filters:", Tracer.Level.DEBUG);
            this.tracer.log(this.tracePrefix + "..." + (this.contentFilterTable == null ? "<null>" : this.contentFilterTable), Tracer.Level.DEBUG);
        }
        this.keyBasedFilters = this.resolveKeyBasedFilters();
        if (this.tracer.debug) {
            this.tracer.log(this.tracePrefix + "Resolved key based filters:", Tracer.Level.DEBUG);
            if (this.keyBasedFilters == null) {
                this.tracer.log(this.tracePrefix + "...<null>", Tracer.Level.DEBUG);
            } else {
                for (String keyBasedFilter : this.keyBasedFilters) {
                    this.tracer.log(this.tracePrefix + "..." + keyBasedFilter, Tracer.Level.DEBUG);
                }
            }
        }
        this.topicStartsWithChannel = UtlProps.getValue((Properties)busDescriptor.getProviderConfig(), (String)"topic_starts_with_channel", (boolean)true);
        this.channelMaxKeyLength = globalMaxKeyLength > 0 && keyNormalizer.getMaxKeyLength() > 0 ? Math.min(globalMaxKeyLength, keyNormalizer.getMaxKeyLength()) : (globalMaxKeyLength > 0 ? globalMaxKeyLength : Math.max(0, keyNormalizer.getMaxKeyLength()));
    }

    public static final DefaultMessageChannelKeyResolver create(MessageChannelDescriptor descriptor) throws SmaException {
        return new DefaultMessageChannelKeyResolver(descriptor, null);
    }

    public static final DefaultMessageChannelKeyResolver create(MessageChannelDescriptor descriptor, MessageChannelKeyNormalizer keyNormalizer) throws SmaException {
        return new DefaultMessageChannelKeyResolver(descriptor, keyNormalizer);
    }

    public final void setKeyResolutionTable(Properties table) {
        this.keyResolutionTable = table;
    }

    @Override
    public final Properties getKeyResolutionTable() {
        return this.keyResolutionTable;
    }

    public final void setRawKeyResolutionTable(MessageChannel.RawKeyResolutionTable table) {
        this.rawKeyResolutionTable = table;
    }

    @Override
    public final MessageChannel.RawKeyResolutionTable getRawKeyResolutionTable() {
        return this.rawKeyResolutionTable;
    }

    @Override
    public final String resolveMessageKey(MessageView view, Properties callerSuppliedKRT) throws SmaException {
        int keyLength;
        if (callerSuppliedKRT != null && this.rawKeyResolutionTable != null) {
            throw new IllegalArgumentException("A Properties based KRT cannot be used with a channel configured with a RawKeyResolutionTable.");
        }
        if (this.parsedKey.isNull()) {
            return null;
        }
        XString keyBuilder = cachedKeyBuilder.get();
        if (keyBuilder == null) {
            keyBuilder = XString.create((int)255, (boolean)true, (boolean)true);
            cachedKeyBuilder.set(keyBuilder);
        }
        keyBuilder.reset();
        this.parsedKey.resolve(keyBuilder, view, callerSuppliedKRT, this.keyResolutionTable);
        if (!validateMessageKey && this.channelMaxKeyLength > 0 && (keyLength = keyBuilder.length() + (this.topicStartsWithChannel ? this.channelName.length() + 1 : 0)) > this.channelMaxKeyLength) {
            throw new SmaException(this.tracePrefix + "message key '" + (this.topicStartsWithChannel ? this.channelName.getValue() + "/" : "") + keyBuilder.toString() + "' has exceeded the max supported key length (" + this.channelMaxKeyLength + ")");
        }
        return keyBuilder.toString();
    }

    @Override
    public XString resolveMessageKey(XString target, MessageView view, MessageChannel.RawKeyResolutionTable callerSuppliedKRT) throws SmaException {
        int keyLength;
        if (callerSuppliedKRT != null && this.keyResolutionTable != null) {
            throw new IllegalArgumentException("A RawKeyResolutionTable cannot be used with a channel configured with a Properties based KRT.");
        }
        if (this.parsedKey.isNull()) {
            return null;
        }
        this.parsedKey.resolve(target, view, callerSuppliedKRT, this.rawKeyResolutionTable);
        if (!validateMessageKey && this.channelMaxKeyLength > 0 && (keyLength = target.length() + (this.topicStartsWithChannel ? this.channelName.length() + 1 : 0)) > this.channelMaxKeyLength) {
            throw new SmaException(this.tracePrefix + "message key '" + (this.topicStartsWithChannel ? this.channelName.getValue() + "/" : "") + target.getValue() + "' has exceeded the max supported key length (" + this.channelMaxKeyLength + ")");
        }
        return target;
    }

    private final Properties parseFilter(String filter) {
        if (filter != null) {
            String[] list;
            Properties parsedFilter = new Properties();
            for (String item : list = filter.split(";")) {
                String[] pair = item.split("=");
                if (pair.length != 2) continue;
                parsedFilter.setProperty(pair[0], pair[1]);
            }
            return parsedFilter;
        }
        return null;
    }

    public final String[] getKeyBasedFilters() {
        return this.keyBasedFilters;
    }

    private final Properties computeContentFilters(Properties channelFilters) {
        if (channelFilters == null || channelFilters.size() == 0 || this.parsedKey.isNull()) {
            return null;
        }
        Set key_vars = this.parsedKey.variableKeyParts.keySet();
        if (key_vars == null || key_vars.isEmpty()) {
            return channelFilters;
        }
        if (key_vars.size() == channelFilters.size()) {
            return null;
        }
        Properties r = new Properties();
        for (Map.Entry<Object, Object> e : channelFilters.entrySet()) {
            String k = (String)e.getKey();
            String v = (String)e.getValue();
            r.put(k, v);
        }
        for (String k : key_vars) {
            r.remove(k);
        }
        return r;
    }

    private final void appendElementDepthWiseToKeyBasedFilters(ArrayList<StringBuilder> filterBuilders, String element) {
        if (filterBuilders.size() == 0) {
            filterBuilders.add(new StringBuilder(""));
        }
        for (StringBuilder filterBuilder : filterBuilders) {
            filterBuilder.append(element);
        }
    }

    final ArrayList<StringBuilder> cloneFilterBuilders(ArrayList<StringBuilder> filterBuilders) {
        ArrayList<StringBuilder> ret = new ArrayList<StringBuilder>();
        for (StringBuilder filterBuilder : filterBuilders) {
            ret.add(new StringBuilder(filterBuilder.toString()));
        }
        return ret;
    }

    private final ArrayList<StringBuilder> appendElementBreadthWiseToKeyBasedFilters(ArrayList<StringBuilder> filterBuilders, String elementsStr) {
        if (filterBuilders.size() == 0) {
            filterBuilders.add(new StringBuilder(""));
        }
        ArrayList<StringBuilder> ret = new ArrayList<StringBuilder>();
        String[] elements = elementsStr.split("\\|");
        for (int i = 0; i < elements.length; ++i) {
            String element;
            ArrayList<StringBuilder> cloned = this.cloneFilterBuilders(filterBuilders);
            String escapedElement = element = elements[i];
            if (cleanFilter) {
                escapedElement = this.keyNormalizer.cleanFilterLevel(escapedElement);
            }
            this.appendElementDepthWiseToKeyBasedFilters(cloned, escapedElement);
            ret.addAll(cloned);
        }
        return ret;
    }

    private final String[] resolveKeyBasedFilters() {
        if (this.parsedKey.isNull()) {
            return null;
        }
        ArrayList<StringBuilder> filterBuilders = new ArrayList<StringBuilder>();
        for (int i = 0; i < this.parsedKey.keyParts.length; ++i) {
            ChannelKeyPart keyPart = this.parsedKey.keyParts[i];
            if (this.parsedKey.keyParts[i].isVariable()) {
                if (this.channelFilterTable == null || this.channelFilterTable.size() == 0 || !this.channelFilterTable.containsKey(keyPart.getVariableName())) {
                    this.appendElementDepthWiseToKeyBasedFilters(filterBuilders, "*");
                    continue;
                }
                filterBuilders = this.appendElementBreadthWiseToKeyBasedFilters(filterBuilders, this.channelFilterTable.getProperty(keyPart.getVariableName()));
                continue;
            }
            this.appendElementDepthWiseToKeyBasedFilters(filterBuilders, keyPart.keyPart.getValue());
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (StringBuilder filterBuilder : filterBuilders) {
            ret.add(filterBuilder.toString());
        }
        return ret.toArray(new String[ret.size()]);
    }

    private static final char escapeKeyChar(char c) {
        return Character.isLetterOrDigit(c) ? c : (char)'_';
    }

    private static final class FunctionKeyPart
    extends ChannelKeyPart {
        private final String variableName;
        private final Method function;
        private final ChannelKeyPart[] args;

        public FunctionKeyPart(String keyPart, String variableName, Method function, ChannelKeyPart[] args) {
            super(keyPart);
            this.variableName = variableName;
            this.function = function;
            this.args = args;
            if (FunctionKeyPartParameters.shouldPool && FunctionKeyPartParameters.getParametersPool(args.length) == null) {
                throw new SmaPermanentException("Invalid channel key function '" + keyPart + "' number of arguments (" + args.length + ") exceeds the maximum allowable value of " + FunctionKeyPartParameters.PARAMETER_POOLS.length);
            }
        }

        public static final ChannelKeyPart parse(String channelKey, int offset) {
            int openParenthesisIndex;
            int eqIndex;
            if (!channelKey.startsWith("#[", offset)) {
                throw new SmaPermanentException("Invalid channel key function: " + channelKey + "' does not start with '#[' at index " + offset);
            }
            int endIndex = FunctionKeyPart.findMatchingClosingChar(channelKey, offset + 1, '[', ']');
            if (endIndex == -1) {
                throw new SmaPermanentException("Invalid channel key function: " + channelKey + "' has no closing ']' after index " + offset);
            }
            for (eqIndex = offset + 2; eqIndex < channelKey.length() && channelKey.charAt(eqIndex) != '='; ++eqIndex) {
            }
            if (eqIndex == channelKey.length()) {
                throw new SmaPermanentException("Invalid channel key function '" + channelKey + "' at index " + offset + " ... missing '=', expected 'keyVarName=function(arg1[,argN])'");
            }
            String variableName = channelKey.substring(offset + 2, eqIndex).trim();
            for (openParenthesisIndex = eqIndex + 1; openParenthesisIndex < channelKey.length() && channelKey.charAt(openParenthesisIndex) != '('; ++openParenthesisIndex) {
            }
            if (openParenthesisIndex == channelKey.length()) {
                throw new SmaPermanentException("Invalid channel key function '" + channelKey + "' at index " + offset + " ... missing '(', expected 'keyVarName=function(arg1[,argN])'");
            }
            String functionName = channelKey.substring(eqIndex + 1, openParenthesisIndex).trim();
            if (functionName.length() == 0) {
                throw new SmaPermanentException("Invalid channel key function '" + channelKey + "' at index " + offset + " ... function name length can not be 0, expected 'keyVarName=function(arg1[,argN])'");
            }
            int closingParenthesisIndex = FunctionKeyPart.findMatchingClosingChar(channelKey, openParenthesisIndex, '(', ')');
            if (closingParenthesisIndex == -1) {
                throw new SmaPermanentException("Invalid channel key function: " + channelKey + "' has no closing ')' after index " + openParenthesisIndex);
            }
            ArrayList<ChannelKeyPart> args = new ArrayList<ChannelKeyPart>();
            String[] argTokens = channelKey.substring(openParenthesisIndex + 1, closingParenthesisIndex).split(",");
            for (int i = 0; i < argTokens.length; ++i) {
                String arg = argTokens[i].trim();
                if (arg.length() == 0) {
                    throw new SmaPermanentException("Invalid channel key function: " + channelKey + "' arg " + (i + 1) + " near index " + openParenthesisIndex + " cannot be empty.");
                }
                ChannelKeyPart part = FunctionKeyPart.parseKeyPart(arg, 0);
                if (part.getLength() != arg.length()) {
                    throw new SmaPermanentException("Invalid channel key function argument: " + channelKey + "' arg " + (i + 1) + " near index " + openParenthesisIndex + " must be either a pure variable or static value.");
                }
                args.add(part);
            }
            Method function = MessageChannelKeyFunctionRegistry.lookup(functionName, args.size());
            if (function == null) {
                throw new SmaPermanentException("Invalid channel key function: " + channelKey + "' at index " + offset + " no function found matching '" + functionName + "'");
            }
            return new FunctionKeyPart(channelKey.substring(offset, endIndex + 1), variableName, function, args.toArray(new ChannelKeyPart[args.size()]));
        }

        @Override
        public final boolean isVariable() {
            return true;
        }

        @Override
        public final String getVariableName() {
            return this.variableName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resolve(XString keyBuilder, MessageView view, MessageReflector messageReflector, Properties callerSuppliedKRT, Properties keyResolutionTable) throws SmaException {
            if (!FunctionKeyPartParameters.shouldPool) {
                Object[] resolvedArgs = new Object[this.args.length + 1];
                resolvedArgs[0] = keyBuilder;
                for (int i = 1; i <= this.args.length; ++i) {
                    if (!this.args[i - 1].isVariable()) {
                        resolvedArgs[i] = this.args[i - 1].keyPart;
                        continue;
                    }
                    resolvedArgs[i] = XString.create((int)32, (boolean)true, (boolean)true);
                    this.args[i - 1].resolve((XString)resolvedArgs[i], view, messageReflector, callerSuppliedKRT, keyResolutionTable);
                }
                try {
                    this.function.invoke(null, resolvedArgs);
                }
                catch (Throwable t) {
                    throw new SmaException("Channel key function resolution failure for '" + this.variableName + "' [" + t.getMessage() + "]", t);
                }
            }
            FunctionKeyPartParameters params = FunctionKeyPartParameters.create(this.args.length);
            try {
                params.arguments[0] = keyBuilder;
                for (int i = 1; i <= this.args.length; ++i) {
                    if (this.args[i - 1].isVariable()) {
                        params.variables[i].reset();
                        this.args[i - 1].resolve(params.variables[i], view, messageReflector, callerSuppliedKRT, keyResolutionTable);
                        params.arguments[i] = params.variables[i];
                        continue;
                    }
                    params.arguments[i] = this.args[i - 1].keyPart;
                }
                try {
                    this.function.invoke(null, params.arguments);
                }
                catch (Throwable t) {
                    throw new SmaException("Channel key function resolution failure for '" + this.variableName + "' [" + t.getMessage() + "]", t);
                }
            }
            finally {
                params.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void resolve(XString keyBuilder, MessageView view, MessageReflector messageReflector, MessageChannel.RawKeyResolutionTable callerSuppliedKRT, MessageChannel.RawKeyResolutionTable keyResolutionTable) throws SmaException {
            if (!FunctionKeyPartParameters.shouldPool) {
                Object[] resolvedArgs = new Object[this.args.length + 1];
                resolvedArgs[0] = keyBuilder;
                for (int i = 1; i <= this.args.length; ++i) {
                    if (!this.args[i - 1].isVariable()) {
                        resolvedArgs[i] = this.args[i - 1].keyPart;
                        continue;
                    }
                    resolvedArgs[i] = XString.create((int)32, (boolean)true, (boolean)true);
                    this.args[i - 1].resolve((XString)resolvedArgs[i], view, messageReflector, callerSuppliedKRT, keyResolutionTable);
                }
                try {
                    this.function.invoke(null, resolvedArgs);
                }
                catch (Throwable t) {
                    throw new SmaException("Channel key function resolution failure for '" + this.variableName + "' [" + t.getMessage() + "]", t);
                }
            }
            FunctionKeyPartParameters params = FunctionKeyPartParameters.create(this.args.length);
            try {
                params.arguments[0] = keyBuilder;
                for (int i = 1; i <= this.args.length; ++i) {
                    if (this.args[i - 1].isVariable()) {
                        params.variables[i].reset();
                        this.args[i - 1].resolve(params.variables[i], view, messageReflector, callerSuppliedKRT, keyResolutionTable);
                        params.arguments[i] = params.variables[i];
                        continue;
                    }
                    params.arguments[i] = this.args[i - 1].keyPart;
                }
                try {
                    this.function.invoke(null, params.arguments);
                }
                catch (Throwable t) {
                    throw new SmaException("Channel key function resolution failure for '" + this.variableName + "' [" + t.getMessage() + "]", t);
                }
            }
            finally {
                params.dispose();
            }
        }

        public final String toString() {
            return "[F]" + this.variableName + "[function=" + this.function.toString() + ", args=" + Arrays.toString(this.args) + "]";
        }
    }

    private static final class FunctionKeyPartParameters
    implements UtlPool.Item<FunctionKeyPartParameters> {
        private static final boolean shouldPool = XRuntime.getValue((String)"nv.sma.keyfunctionpoolargs", (boolean)true);
        private static UtlPool<FunctionKeyPartParameters>[] PARAMETER_POOLS = (UtlPool[])Array.newInstance(UtlPool.class, XRuntime.getValue((String)"nv.sma.keyfunctionmaxargs", (int)16));
        private UtlPool<FunctionKeyPartParameters> pool;
        public final Object[] arguments;
        public final XString[] variables;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static final UtlPool<FunctionKeyPartParameters> getParametersPool(final int numArguments) {
            if (numArguments >= PARAMETER_POOLS.length) return null;
            UtlPool pool = PARAMETER_POOLS[numArguments];
            if (pool != null) return pool;
            UtlPool<FunctionKeyPartParameters>[] utlPoolArray = PARAMETER_POOLS;
            synchronized (PARAMETER_POOLS) {
                if (PARAMETER_POOLS[numArguments] != null) return PARAMETER_POOLS[numArguments];
                FunctionKeyPartParameters.PARAMETER_POOLS[numArguments] = pool = UtlPool.create((String)"sma-fx-params", (String)String.valueOf(numArguments), (UtlPool.Factory)new UtlPool.Factory<FunctionKeyPartParameters>(){

                    public FunctionKeyPartParameters createItem(Object object) {
                        return new FunctionKeyPartParameters(numArguments);
                    }

                    public FunctionKeyPartParameters[] createItemArray(int size) {
                        return new FunctionKeyPartParameters[size];
                    }
                }, (UtlPool.Params)UtlPool.Params.create().setThreaded(true).setPreallocate(false).setInitialCapacity(16));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return pool;
            }
        }

        static final FunctionKeyPartParameters create(int numArgs) {
            if (shouldPool) {
                return (FunctionKeyPartParameters)FunctionKeyPartParameters.getParametersPool(numArgs).get(null);
            }
            return new FunctionKeyPartParameters(numArgs);
        }

        private FunctionKeyPartParameters(int numArgs) {
            this.arguments = new Object[numArgs + 1];
            this.variables = new XString[numArgs + 1];
            for (int i = 1; i < this.variables.length; ++i) {
                this.variables[i] = XString.create((int)32, (boolean)true, (boolean)true);
            }
        }

        public final FunctionKeyPartParameters init() {
            return this;
        }

        public final FunctionKeyPartParameters setPool(UtlPool<FunctionKeyPartParameters> pool) {
            this.pool = pool;
            return this;
        }

        public final UtlPool<FunctionKeyPartParameters> getPool() {
            return this.pool;
        }

        public final void dispose() {
            if (this.pool != null) {
                this.pool.put((UtlPool.Item)this);
            }
        }
    }

    private static final class VariableKeyPart
    extends ChannelKeyPart {
        private final String variableName;
        private final XString variableDefault;
        private final String[] variableFieldPath;

        private VariableKeyPart(String keyPart, String variableName, XString variableDefault) {
            super(keyPart);
            this.variableName = variableName;
            this.variableDefault = variableDefault;
            this.variableFieldPath = variableName.split("\\.");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static final ChannelKeyPart parse(String channelKey, int offset) {
            XString variableDefault;
            String variableName;
            if (!channelKey.startsWith("${", offset)) {
                throw new SmaPermanentException("Invalid variable channel key part " + channelKey + "' does not start with '${' at index " + offset);
            }
            int endIndex = channelKey.indexOf("}", offset);
            if (endIndex == -1) {
                throw new SmaPermanentException("Invalid variable channel key part " + channelKey + "' has no closing '}' after index " + offset);
            }
            String variable = channelKey.substring(offset + 2, endIndex);
            if (variable.indexOf("::") > 0) {
                String[] valAndDefault = variable.split("::");
                if (valAndDefault.length != 2) throw new SmaPermanentException("Invalid variable channel key part '" + channelKey + "' at index " + offset + " contains too many '::' delimiters");
                variableName = valAndDefault[0].trim();
                variableDefault = XString.create((String)valAndDefault[1].trim(), (boolean)true, (boolean)true);
            } else {
                variableDefault = null;
                variableName = variable.trim();
            }
            if (variableName.length() != 0) return new VariableKeyPart(channelKey.substring(offset, endIndex + 1), variableName, variableDefault);
            throw new SmaPermanentException("Invalid variable channel key part '" + channelKey + "' at index " + offset + " variable name cannot be empty");
        }

        @Override
        public final boolean isVariable() {
            return true;
        }

        @Override
        public final String getVariableName() {
            return this.variableName;
        }

        @Override
        public void resolve(XString keyBuilder, MessageView view, MessageReflector messageReflector, Properties callerSuppliedKRT, Properties keyResolutionTable) throws SmaException {
            String fieldValue;
            String fieldValue2;
            if (messageReflector != null && (fieldValue2 = messageReflector.getFieldValueAsString((Object)view, this.variableFieldPath)) != null && this.append(keyBuilder, fieldValue2)) {
                return;
            }
            if (callerSuppliedKRT != null && (fieldValue2 = callerSuppliedKRT.getProperty(this.variableName)) != null && this.append(keyBuilder, fieldValue2)) {
                return;
            }
            Properties table = keyResolutionTable;
            if (table != null && (fieldValue = table.getProperty(this.variableName)) != null && this.append(keyBuilder, fieldValue)) {
                return;
            }
            if (this.variableDefault != null && this.append(keyBuilder, this.variableDefault.getValue())) {
                return;
            }
            if (messageReflector != null && messageReflector.fieldExists(view, this.variableName)) {
                if (!messageReflector.isFieldReflectable(view, this.variableName)) {
                    throw new SmaException("channel key field '" + this.variableName + "' is not a reflectable field in the message and was not found in any of the key resolution tables and has no default value");
                }
                throw new SmaException("channel key field '" + this.variableName + "' is null in the message and was not found in any of the key resolution tables and has no default value");
            }
            throw new SmaException("channel key field '" + this.variableName + "' was not found in the message or any of the key resolution tables and has no default value");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void resolve(XString keyBuilder, MessageView view, MessageReflector messageReflector, MessageChannel.RawKeyResolutionTable callerSuppliedKRT, MessageChannel.RawKeyResolutionTable keyResolutionTable) throws SmaException {
            XString fieldValue;
            block16: {
                if (messageReflector != null) {
                    try {
                        if (cleanKey || !allowEmptyKey || treatEmptyKeyAsNull) {
                            int oldKeyLength = keyBuilder.length();
                            if (!messageReflector.appendFieldValueTo((Object)view, this.variableFieldPath, keyBuilder)) break block16;
                            int newLength = keyBuilder.length();
                            if (newLength == oldKeyLength) {
                                if (!treatEmptyKeyAsNull) {
                                    if (!allowEmptyKey) {
                                        throw new SmaException("channel key field '" + this.variableName + "' is empty");
                                    }
                                    return;
                                }
                                break block16;
                            } else {
                                if (cleanKey) {
                                    for (int p = oldKeyLength; p < newLength; ++p) {
                                        char c = keyBuilder.charAt(p);
                                        if (Character.isLetterOrDigit(c)) continue;
                                        keyBuilder.setCharAt(p, '_');
                                    }
                                }
                                return;
                            }
                        }
                        if (messageReflector.appendFieldValueTo((Object)view, this.variableFieldPath, keyBuilder)) {
                            return;
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw new SmaException("Error resolving channel key field '" + this.variableName + "': " + e.getMessage(), e);
                    }
                }
            }
            if (callerSuppliedKRT != null && (fieldValue = callerSuppliedKRT.get(this.variableName)) != null && this.append(keyBuilder, fieldValue)) {
                return;
            }
            if (keyResolutionTable != null && (fieldValue = keyResolutionTable.get(this.variableName)) != null && this.append(keyBuilder, fieldValue)) {
                return;
            }
            if (this.variableDefault != null && this.append(keyBuilder, this.variableDefault)) {
                return;
            }
            if (messageReflector != null && messageReflector.fieldExists(view, this.variableName)) {
                if (!messageReflector.isFieldReflectable(view, this.variableName)) {
                    throw new SmaException("channel key field '" + this.variableName + "' is not a reflectable field in the message and was not found in any of the key resolution tables and had no default value");
                }
                throw new SmaException("channel key field '" + this.variableName + "' is null in the message and was not found in any of the key resolution tables and had no default value");
            }
            throw new SmaException("channel key field '" + this.variableName + "' was not found in the message or any of the key resolution tables and had no default value");
        }

        public final String toString() {
            return "[V]" + this.variableName + (this.variableDefault != null ? " [default=" + this.variableDefault + "]" : " [No Default]");
        }
    }

    static final class StaticKeyPart
    extends ChannelKeyPart {
        StaticKeyPart(String keyPart) {
            super(keyPart);
        }

        public static final ChannelKeyPart parse(String channelKey, int offset) {
            int i;
            for (i = offset; i < channelKey.length() && !channelKey.startsWith("${", i) && !channelKey.startsWith("#[", i); ++i) {
            }
            return new StaticKeyPart(channelKey.substring(offset, i));
        }

        public final String toString() {
            return "[S]" + this.keyPart;
        }

        @Override
        public final void resolve(XString keyBuilder, MessageView view, MessageReflector reflector, Properties callerSuppliedKRT, Properties keyResolutionTable) {
            keyBuilder.append((CharSequence)this.keyPart.getValue());
        }

        @Override
        public final void resolve(XString keyBuilder, MessageView view, MessageReflector messageReflector, MessageChannel.RawKeyResolutionTable callerSuppliedKRT, MessageChannel.RawKeyResolutionTable keyResolutionTable) throws SmaException {
            keyBuilder.append(this.keyPart);
        }
    }

    protected static abstract class ChannelKeyPart {
        protected final XString keyPart;

        ChannelKeyPart(String keyPart) {
            this.keyPart = XString.create((String)keyPart, (boolean)true, (boolean)true);
        }

        static final ChannelKeyPart parseKeyPart(String channelKey, int offset) {
            if (channelKey.startsWith("${", offset)) {
                return VariableKeyPart.parse(channelKey, offset);
            }
            if (channelKey.startsWith("#[", offset)) {
                return FunctionKeyPart.parse(channelKey, offset);
            }
            return StaticKeyPart.parse(channelKey, offset);
        }

        public boolean isVariable() {
            return false;
        }

        public String getVariableName() {
            return null;
        }

        public int getLength() {
            return this.keyPart.length();
        }

        public abstract void resolve(XString var1, MessageView var2, MessageReflector var3, Properties var4, Properties var5) throws SmaException;

        public abstract void resolve(XString var1, MessageView var2, MessageReflector var3, MessageChannel.RawKeyResolutionTable var4, MessageChannel.RawKeyResolutionTable var5) throws SmaException;

        protected static final int findMatchingClosingChar(String text, int offset, char open, char close) {
            int endIndex = offset + 1;
            int balanceCount = 1;
            boolean inEscape = false;
            while (endIndex < text.length()) {
                if (inEscape) {
                    inEscape = false;
                    ++endIndex;
                    continue;
                }
                if (text.charAt(endIndex) == '\\') {
                    inEscape = true;
                    ++endIndex;
                    continue;
                }
                if (text.charAt(endIndex) == close) {
                    if (--balanceCount == 0) {
                        return endIndex;
                    }
                } else if (text.charAt(endIndex) == open) {
                    ++balanceCount;
                }
                ++endIndex;
            }
            return -1;
        }

        protected final boolean append(XString target, String fieldValue) throws SmaException {
            if (this.isVariable()) {
                if (fieldValue.length() == 0) {
                    if (treatEmptyKeyAsNull) {
                        return false;
                    }
                    if (!allowEmptyKey) {
                        throw new SmaException("channel key field '" + this.getVariableName() + "' is empty");
                    }
                }
                if (cleanKey) {
                    int length = fieldValue.length();
                    for (int i = 0; i < length; ++i) {
                        char c = fieldValue.charAt(i);
                        target.append(DefaultMessageChannelKeyResolver.escapeKeyChar(c));
                    }
                } else {
                    target.append((CharSequence)fieldValue);
                }
                return true;
            }
            target.append((CharSequence)fieldValue);
            return true;
        }

        protected final boolean append(XString target, XString fieldValue) throws SmaException {
            if (fieldValue.length() == 0) {
                if (treatEmptyKeyAsNull) {
                    return false;
                }
                if (!allowEmptyKey) {
                    throw new SmaException("channel key field '" + this.getVariableName() + "' is empty");
                }
            }
            if (cleanKey) {
                int length = fieldValue.length();
                for (int i = 0; i < length; ++i) {
                    char c = fieldValue.charAt(i);
                    try {
                        target.append(DefaultMessageChannelKeyResolver.escapeKeyChar(c));
                        continue;
                    }
                    catch (Exception e) {
                        throw new SmaException("Error appending '" + c + "' from '" + fieldValue + "' + to channel key");
                    }
                }
            } else {
                target.append(fieldValue);
            }
            return true;
        }
    }

    static final class ChannelKey {
        private final String channelKey;
        private final ChannelKeyPart[] keyParts;
        private final XLinkedHashMap<String, ChannelKeyPart> variableKeyParts = new XLinkedHashMap();

        private ChannelKey(String channelKey, ChannelKeyPart[] keyParts) {
            this.channelKey = channelKey;
            this.keyParts = keyParts;
            if (keyParts != null) {
                for (int i = 0; i < keyParts.length; ++i) {
                    if (!keyParts[i].isVariable()) continue;
                    this.variableKeyParts.put((Object)keyParts[i].getVariableName(), (Object)keyParts[i]);
                }
            }
        }

        public static final ChannelKey parse(String channelKey) throws SmaException {
            ChannelKeyPart part;
            if (channelKey == null) {
                return new ChannelKey(null, null);
            }
            ArrayList<ChannelKeyPart> keyParts = new ArrayList<ChannelKeyPart>();
            for (int i = 0; i < channelKey.length(); i += part.getLength()) {
                part = ChannelKeyPart.parseKeyPart(channelKey, i);
                keyParts.add(part);
            }
            return new ChannelKey(channelKey, keyParts.toArray(new ChannelKeyPart[keyParts.size()]));
        }

        public final boolean isNull() {
            return this.keyParts == null || this.keyParts.length == 0;
        }

        public final void resolve(XString keyBuilder, MessageView view, Properties callerSuppliedKRT, Properties keyResolutionTable) throws SmaException {
            if (this.keyParts != null && this.keyParts.length > 0) {
                MessageReflector messageReflector = view instanceof MapMessageView ? ((MapMessageView)view).getMessageReflector() : null;
                for (int i = 0; i < this.keyParts.length; ++i) {
                    this.keyParts[i].resolve(keyBuilder, view, messageReflector, callerSuppliedKRT, keyResolutionTable);
                }
            }
        }

        public final void resolve(XString keyBuilder, MessageView view, MessageChannel.RawKeyResolutionTable callerSuppliedKRT, MessageChannel.RawKeyResolutionTable keyResolutionTable) throws SmaException {
            if (this.keyParts != null && this.keyParts.length > 0) {
                MessageReflector messageReflector = view instanceof MapMessageView ? ((MapMessageView)view).getMessageReflector() : null;
                for (int i = 0; i < this.keyParts.length; ++i) {
                    this.keyParts[i].resolve(keyBuilder, view, messageReflector, callerSuppliedKRT, keyResolutionTable);
                }
            }
        }

        public final String toString() {
            if (this.keyParts != null && this.keyParts.length > 0) {
                String rc = "ChannelKey [" + this.channelKey + "]";
                for (int i = 0; i < this.keyParts.length; ++i) {
                    rc = rc + "\n..." + this.keyParts[i];
                }
                return rc;
            }
            return "ChannelKey [<null>]";
        }
    }
}

