/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.pkt.PktPacket;
import com.neeve.sma.MessageView;
import com.neeve.sma.MessageViewFactory;
import com.neeve.sma.RawMessageViewImpl;
import com.neeve.sma.SmaObject;
import java.nio.ByteBuffer;
import java.util.Properties;

public final class RawMessageViewFactory
extends SmaObject
implements MessageViewFactory {
    private RawMessageViewFactory(Properties props) {
        super(null);
    }

    @Override
    public final short getVfid() {
        return 1;
    }

    @Override
    public final MessageView create(short type) {
        throw new IllegalArgumentException("unknown view type");
    }

    @Override
    public final MessageView wrap(short type, int encodingType, Object message) {
        if (encodingType != 1) {
            throw new IllegalArgumentException("raw messages only support custom encoding formats");
        }
        RawMessageViewImpl view = RawMessageViewImpl.create();
        if (message instanceof byte[]) {
            return view.deserializeFromByteArray((byte[])message);
        }
        if (message instanceof ByteBuffer) {
            return view.deserializeFromByteBuffer((ByteBuffer)message);
        }
        if (message instanceof PktPacket) {
            return view.deserializeFromPacket((PktPacket)message);
        }
        throw new IllegalArgumentException("unknown serialized form '" + message.getClass().getName() + "'");
    }

    public static final RawMessageViewFactory create(Properties props) {
        return new RawMessageViewFactory(props);
    }
}

