/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.sma;

import com.neeve.config.ConfigRepositoryFactory;
import com.neeve.config.EConfigException;
import com.neeve.config.IConfigRepository;
import com.neeve.config.IConfigSimpleEntity;
import com.neeve.config.IConfigSimpleEntityContainer;
import com.neeve.sma.SmaException;
import com.neeve.sma.SmaObject;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class MessagingProviderDescriptor
extends SmaObject {
    private final String name;
    private final String className;
    private final Properties props;

    private MessagingProviderDescriptor(String name, String className) {
        super(null);
        this.name = name;
        this.className = className;
        this.props = new Properties();
    }

    public final String getName() {
        return this.name;
    }

    public final String getClassName() {
        return this.className;
    }

    public final void setProperty(String name, String val) {
        if (val != null) {
            this.props.setProperty(name, val);
        } else {
            this.props.remove(name);
        }
    }

    public final void setProperties(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }

    public final Properties getProperties() {
        return this.props;
    }

    public final void save(IConfigRepository repo) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        try {
            IConfigSimpleEntity entity;
            IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/sma/providers");
            if (container == null) {
                container = repo.createSimpleEntityContainer("/sma/providers");
            }
            if ((entity = (IConfigSimpleEntity)container.getEntity(this.name)) == null) {
                entity = (IConfigSimpleEntity)container.createEntity(this.name);
            }
            entity.setProperties(null);
            entity.setProperties(this.props);
            entity.setProperty("Class", this.getClassName());
        }
        catch (EConfigException e) {
            throw new SmaException(e);
        }
    }

    public final void delete(IConfigRepository repo) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/sma/providers");
        if (container != null) {
            container.removeEntity(this.name);
        }
    }

    public final String toString() {
        return "(" + this.name + ", '" + this.className + "', " + this.props + ")";
    }

    public static boolean exists(IConfigRepository repo, String name) {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("provider name cannot be null");
        }
        return repo.getSimpleEntity("/sma/providers/" + name) != null;
    }

    public static boolean exists(String name) {
        return MessagingProviderDescriptor.exists(ConfigRepositoryFactory.getInstance().getDefaultRepository(), name);
    }

    public static MessagingProviderDescriptor create(String name, String className) {
        if (name == null) {
            throw new IllegalArgumentException("provider name cannot be null");
        }
        if (className == null) {
            throw new IllegalArgumentException("provider class name cannot be null");
        }
        return new MessagingProviderDescriptor(name, className);
    }

    public static MessagingProviderDescriptor load(IConfigRepository repo, String name) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        IConfigSimpleEntity entity = repo.getSimpleEntity("/sma/providers/" + name);
        if (entity != null) {
            String className = entity.getProperty("Class", null);
            if (className == null) {
                throw new SmaException("Invalid provider configuration [Missing 'Class' property]");
            }
            MessagingProviderDescriptor providerDescriptor = MessagingProviderDescriptor.create(name, className);
            providerDescriptor.setProperties(entity.getProperties());
            providerDescriptor.getProperties().remove("Class");
            return providerDescriptor;
        }
        throw new SmaException("Provider '" + name + "' not found in repository");
    }

    public static MessagingProviderDescriptor load(String name) throws SmaException {
        return MessagingProviderDescriptor.load(ConfigRepositoryFactory.getInstance().getDefaultRepository(), name);
    }

    public static Set<MessagingProviderDescriptor> loadAll(IConfigRepository repo) throws SmaException {
        if (repo == null) {
            throw new IllegalArgumentException("configuration respository cannot be null");
        }
        LinkedHashSet<MessagingProviderDescriptor> providers = new LinkedHashSet<MessagingProviderDescriptor>();
        IConfigSimpleEntityContainer container = repo.getSimpleEntityContainer("/sma/providers");
        if (container != null) {
            for (IConfigSimpleEntity entity : container) {
                try {
                    providers.add(MessagingProviderDescriptor.load(repo, entity.getName()));
                }
                catch (SmaException e) {
                    throw new SmaException("Failure in loading descriptor for provider '" + entity.getName() + "' [" + e.toString() + "]");
                }
            }
        }
        return providers;
    }

    public static Set<MessagingProviderDescriptor> loadAll() throws SmaException {
        return MessagingProviderDescriptor.loadAll(ConfigRepositoryFactory.getInstance().getDefaultRepository());
    }
}

