/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.perf.aep.mux;

import com.neeve.ci.XRuntime;
import com.neeve.event.Event;
import com.neeve.event.EventFactory;
import com.neeve.event.EventMultiplexerSingleThreaded;
import com.neeve.event.IEventHandler;
import com.neeve.event.IEventMultiplexer;
import com.neeve.tools.interactive.commands.AnnotatedCommand;
import com.neeve.util.UtlGovernor;
import com.neeve.util.UtlThread;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

@AnnotatedCommand.Command(keywords={"Driver"}, description="A sender to benchmark event multiplexer performance")
public final class Driver
extends AnnotatedCommand {
    @AnnotatedCommand.Option(shortForm=110, longForm="count", required=false, defaultValue="15000000", description="Number of events to send through the multiplexer")
    private int count;
    @AnnotatedCommand.Option(shortForm=114, longForm="rate", required=false, defaultValue="1000000", description="Rate at which to send events through the multiplexer")
    private int rate;
    @AnnotatedCommand.Option(shortForm=115, longForm="schedule", required=false, defaultValue="false", description="Indicates that schedule should be used instead of multiplex to send the event")
    private boolean schedule;
    @AnnotatedCommand.Option(shortForm=111, longForm="offerStrategy", required=false, description="Sets the offer strategy to be configured in the multiplexer")
    private String offerStrategy;
    @AnnotatedCommand.Option(shortForm=119, longForm="waitStrategy", required=false, description="Sets the wait strategy to be configured in the multiplexer")
    private String waitStrategy;
    @AnnotatedCommand.Option(shortForm=113, longForm="queueSize", required=false, description="Sets the queue size to be configured in the multiplexer")
    private String queueSize;
    @AnnotatedCommand.Option(shortForm=112, longForm="producerCPUAffinityMask", required=false, description="Sets the producer thread CPU affinity mask")
    private String producerCPUAffinityMask;
    @AnnotatedCommand.Option(shortForm=99, longForm="consumerCPUAffinityMask", required=false, description="Sets the consumer thread CPU affinity mask")
    private String consumerCPUAffinityMask;
    private int[] latencies;

    private final void writeLatencies(String filename, int count, int[] latencies) {
        try {
            FileOutputStream fos = new FileOutputStream(new File(filename));
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(fos, 8192));
            for (int k = 0; k < count; ++k) {
                dos.writeInt(k);
                dos.writeInt(latencies[k]);
            }
            dos.flush();
            dos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws Exception {
        EventFactory.getInstance().registerEventType(EventFactory.EventType.create((short)10000, (String)"TestEvent", (String)TestEvent.class.getName(), (boolean)true, null));
        Properties props = new Properties();
        if (this.queueSize != null) {
            props.setProperty("queueDepth", this.queueSize);
        }
        if (this.offerStrategy != null) {
            props.setProperty("queueOfferStrategy", this.offerStrategy);
        }
        if (this.waitStrategy != null) {
            props.setProperty("queueWaitStrategy", this.waitStrategy);
        }
        if (this.consumerCPUAffinityMask != null) {
            props.setProperty("queueDrainerCpuAffinityMask", this.consumerCPUAffinityMask);
        }
        IEventMultiplexer mux = EventMultiplexerSingleThreaded.create((String)"test", (boolean)false, (IEventHandler)new EventHandler(), (Properties)props);
        System.out.println("Configuration");
        System.out.println("  Count....,.,................" + this.count);
        System.out.println("  Rate.....,.,................" + this.rate);
        System.out.println("  Schedule...................." + this.schedule);
        System.out.println("  OfferStrategy..............." + this.offerStrategy + " (actual=" + mux.getStats().getClaimStrategy() + ")");
        System.out.println("  Wait Strategy..............." + this.waitStrategy + " (actual=" + mux.getStats().getWaitStrategy() + ")");
        System.out.println("  Queue Size.................." + this.queueSize + " (actual=" + mux.getStats().getCapacity() + ")");
        System.out.println("  Producer CPU Affinity Mask.." + this.producerCPUAffinityMask);
        System.out.println("  Consumer CPU Affinity Mask.." + this.consumerCPUAffinityMask);
        System.out.println("  nv.optimizefor.............." + (XRuntime.optimizeForThroughput() ? "Throughput" : (XRuntime.optimizeForLatency() ? "Latency" : "None")));
        System.out.println("  nv.conserveMemory..........." + XRuntime.optimizeMemoryUsage());
        System.out.println("  nv.conservecpu.............." + XRuntime.conserveCPU());
        System.out.println("  nv.enablecpuaffinitymask...." + UtlThread.cpuAffinityMasksEnabled());
        mux.open();
        if (this.producerCPUAffinityMask != null) {
            UtlThread.setCPUAffinityMask((long)UtlThread.parseAffinityMask((String)this.producerCPUAffinityMask));
        }
        this.latencies = new int[this.count];
        try {
            UtlGovernor governor = new UtlGovernor(this.rate);
            for (int i = 0; i < this.count; ++i) {
                Event event = TestEvent.create(i + 1);
                try {
                    if (this.schedule) {
                        mux.scheduleEvent(event);
                    } else {
                        mux.multiplexEvent(event, 0);
                    }
                }
                finally {
                    event.dispose();
                }
                governor.blockToNext();
            }
        }
        finally {
            mux.close();
        }
    }

    public static void main(String[] args) throws Exception {
        new Driver().run(args);
    }

    private static final class TestEvent
    extends Event {
        static final short ID = 10000;
        int num;
        long offerTs;

        TestEvent() {
            super((short)10000);
        }

        final TestEvent init(int num) {
            super.init(null, null);
            this.offerTs = System.nanoTime();
            this.num = num;
            return this;
        }

        static final Event create(int num) {
            return ((TestEvent)EventFactory.getInstance().createEvent((short)10000)).init(num);
        }

        public static final Event create(Properties props) {
            return new TestEvent();
        }

        protected final void reset() {
        }
    }

    private final class EventHandler
    implements IEventHandler {
        private EventHandler() {
        }

        public final void onEvent(Event event) {
            int latency;
            TestEvent testEvent = (TestEvent)event;
            ((Driver)Driver.this).latencies[testEvent.num - 1] = latency = (int)(System.nanoTime() - testEvent.offerTs);
            if (testEvent.num == Driver.this.count) {
                System.out.println("Writing o2p times...");
                Driver.this.writeLatencies("o2p.bin", Driver.this.count, Driver.this.latencies);
            }
        }
    }
}

