/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.test.unit;

import com.neeve.ods.IStoreCheckpointingController;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.rog.test.unit.RogReplicatedStoreTestBase;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class RogRecoveryAndReplicationTestBase
extends RogReplicatedStoreTestBase {
    protected static final int MEMBER_COUNT = 2;
    private static List<Object> openMemberParameters;
    protected List<Object> currentTestParameters;
    protected FailureType failureType;
    protected boolean compactionEnabled;

    @Parameterized.Parameters(name="{index}_persistent_{0}_failure_{1}_compaction_{2}_cdc_{3}")
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{false, FailureType.NO_FAILURES, false, false}, {true, FailureType.NO_FAILURES, false, false}, {true, FailureType.RESTART_ON_COMMIT, false, false}, {true, FailureType.COMPACT_NO_FAILURE, true, false}, {true, FailureType.COMPACT_AND_RESTART, true, false}, {true, FailureType.NO_FAILURES, false, true}, {true, FailureType.RESTART_ON_COMMIT, false, true}};
        return Arrays.asList(data);
    }

    public RogRecoveryAndReplicationTestBase(boolean persistent, FailureType failureType, boolean compactionEnabled, boolean cdcEnabled) {
        this.persistent = persistent;
        this.failureType = failureType;
        this.currentTestParameters = Arrays.asList(new Object[]{persistent, failureType});
        this.compactionEnabled = compactionEnabled;
        this.cdcEnabled = cdcEnabled;
    }

    @Before
    public synchronized void setup() throws Exception {
        if (openMembers.isEmpty() || openMemberParameters == null || !openMemberParameters.equals(this.currentTestParameters)) {
            RogRecoveryAndReplicationTestBase.closeOpenMembers();
        }
        super.setupBase();
        openMemberParameters = this.currentTestParameters;
    }

    @Override
    protected void configureStoreDescriptor(StoreDescriptor descriptor) {
        if (this.compactionEnabled && this.cdcEnabled) {
            descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
            descriptor.setCheckpointThreshold(1);
        } else if (this.compactionEnabled) {
            descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Conflation);
            descriptor.setCheckpointThreshold(5);
        } else if (this.cdcEnabled) {
            descriptor.setCheckpointingType(IStoreCheckpointingController.Type.CDC);
            descriptor.setCheckpointThreshold(1);
        }
    }

    @Override
    protected void configurePersisterDescriptor(StorePersisterDescriptor persisterDescriptor) {
        if (this.compactionEnabled) {
            persisterDescriptor.setProperty("compaction.compactionThreshold", "1");
            persisterDescriptor.setProperty("logScavengePolicy", "Delete");
        }
        persisterDescriptor.setProperty("initialLogLength", "0");
        persisterDescriptor.setProperty("cdcEnabled", String.valueOf(this.cdcEnabled));
    }

    @Override
    protected synchronized void induceCommitFailure() throws Exception {
        switch (this.failureType) {
            case NO_FAILURES: {
                break;
            }
            case RESTART_ON_COMMIT: {
                System.out.println("Restarting Members on Commit");
                RogRecoveryAndReplicationTestBase.closeOpenMembers();
                this.checkInitialized();
                break;
            }
            case COMPACT_NO_FAILURE: {
                System.out.println("Compacting Logs on Commit");
                this.primaryMember().getCompactor().compact();
                this.primaryMember().getCompactor().waitForCompactionToComplete();
                break;
            }
            case COMPACT_AND_RESTART: {
                System.out.println("Compacting Logs and Restarting Members on Commit");
                this.primaryMember().getCompactor().compact();
                this.primaryMember().getCompactor().waitForCompactionToComplete();
                RogRecoveryAndReplicationTestBase.closeOpenMembers();
                this.checkInitialized();
                break;
            }
        }
    }

    public static enum FailureType {
        NO_FAILURES,
        RESTART_ON_COMMIT,
        COMPACT_NO_FAILURE,
        COMPACT_AND_RESTART;

    }
}

