/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.test.unit;

import com.eaio.uuid.UUID;
import com.neeve.adm.test.unit.json.Child1;
import com.neeve.adm.test.unit.json.ChildEntity;
import com.neeve.adm.test.unit.json.CollectionTestParent;
import com.neeve.adm.test.unit.json.Enumeration;
import com.neeve.adm.test.unit.json.Factory;
import com.neeve.ods.IStoreCheckpointingController;
import com.neeve.ods.IStoreObjectFactory;
import com.neeve.ods.StoreDescriptor;
import com.neeve.ods.StorePersisterDescriptor;
import com.neeve.rog.ERogIllegalParentReferenceException;
import com.neeve.rog.impl.RogNode;
import com.neeve.rog.test.unit.RogReplicatedStoreTestBase;
import com.neeve.util.UtlReflection;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class RogMapReplicationTests
extends RogReplicatedStoreTestBase {
    private static final Set<String> fields = UtlReflection.getDecamelcasedProperties(Child1.class);
    private static final Byte[] byteTestValues = new Byte[]{(byte)1, (byte)2, (byte)3, (byte)4, (byte)5};
    private static final Character[] charTestValues = new Character[]{Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5')};
    private static final Short[] shortTestValues = new Short[]{(short)1, (short)2, (short)3, (short)4, (short)5};
    private static final Integer[] intTestValues = new Integer[]{1, 2, 3, 4, 5};
    private static final Long[] longTestValues = new Long[]{1L, 2L, 3L, 4L, 5L};
    private static final Float[] floatTestValues = new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f)};
    private static final Double[] doubleTestValues = new Double[]{1.0, 2.0, 3.0, 4.0, 5.0};
    private static final String[] stringTestValues = new String[]{"1", "2", "3", "4", "5"};
    protected static final int MEMBER_COUNT = 2;
    private static List<Object> openMemberParameters;
    protected List<Object> currentTestParameters;
    protected FailureType failureType;
    protected boolean compactionEnabled;
    protected MapType mapType;

    @Parameterized.Parameters(name="{index}_{0}_persistent_{1}_failure_{2}_compaction_{3}_cdc_{4}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (MapType mapType : MapType.values()) {
            data.add(new Object[]{mapType, false, FailureType.NO_FAILURES, false, false});
            data.add(new Object[]{mapType, true, FailureType.NO_FAILURES, false, false});
            data.add(new Object[]{mapType, true, FailureType.RESTART_ON_COMMIT, false, false});
            data.add(new Object[]{mapType, true, FailureType.COMPACT_NO_FAILURE, true, false});
            data.add(new Object[]{mapType, true, FailureType.COMPACT_AND_RESTART, true, false});
        }
        return data;
    }

    public RogMapReplicationTests(MapType mapType, boolean persistent, FailureType failureType, boolean compactionEnabled, boolean cdcEnabled) {
        this.mapType = mapType;
        this.persistent = persistent;
        this.failureType = failureType;
        this.compactionEnabled = compactionEnabled;
        this.cdcEnabled = cdcEnabled;
        this.currentTestParameters = Arrays.asList(new Object[]{persistent, failureType});
    }

    @Before
    public synchronized void setup() throws Exception {
        if (openMembers.isEmpty() || openMemberParameters == null || !openMemberParameters.equals(this.currentTestParameters)) {
            RogMapReplicationTests.closeOpenMembers();
        }
        super.setupBase();
        openMemberParameters = this.currentTestParameters;
    }

    @Override
    protected void configureStoreDescriptor(StoreDescriptor descriptor) {
        if (this.compactionEnabled && this.cdcEnabled) {
            descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Default);
            descriptor.setCheckpointThreshold(1);
        } else if (this.compactionEnabled) {
            descriptor.setCheckpointingType(IStoreCheckpointingController.Type.Conflation);
            descriptor.setCheckpointThreshold(5);
        } else if (this.cdcEnabled) {
            descriptor.setCheckpointingType(IStoreCheckpointingController.Type.CDC);
            descriptor.setCheckpointThreshold(1);
        }
    }

    @Override
    protected void configurePersisterDescriptor(StorePersisterDescriptor persisterDescriptor) {
        if (this.compactionEnabled) {
            persisterDescriptor.setProperty("compaction.compactionThreshold", "1");
            persisterDescriptor.setProperty("logScavengePolicy", "Delete");
        }
        persisterDescriptor.setProperty("initialLogLength", "0");
        persisterDescriptor.setProperty("cdcEnabled", String.valueOf(this.cdcEnabled));
    }

    @Override
    protected synchronized void induceCommitFailure() throws Exception {
        switch (this.failureType) {
            case NO_FAILURES: {
                break;
            }
            case RESTART_ON_COMMIT: {
                System.out.println("Restarting Members on Commit");
                RogMapReplicationTests.closeOpenMembers();
                this.checkInitialized();
                break;
            }
            case COMPACT_NO_FAILURE: {
                System.out.println("Compacting Logs and Restarting Members on Commit");
                this.primaryMember().getCompactor().compact();
                this.primaryMember().getCompactor().waitForCompactionToComplete();
                break;
            }
            case COMPACT_AND_RESTART: {
                System.out.println("Compacting Logs and Restarting Members on Commit");
                this.primaryMember().getCompactor().compact();
                this.primaryMember().getCompactor().waitForCompactionToComplete();
                RogMapReplicationTests.closeOpenMembers();
                this.checkInitialized();
                break;
            }
        }
    }

    @Override
    protected Collection<IStoreObjectFactory> getObjectFactories() {
        return Arrays.asList(new Factory());
    }

    @Test
    public void testMapClear() throws Exception {
        int i;
        CollectionTestParent parent = this.primaryMember().addRootObject(Factory.createCollectionTestParent(this.nextGraphId()));
        this.primaryMember().commit(true);
        Map<?, Child1> map = this.getMap(parent, this.mapType);
        for (i = 0; i < 5; ++i) {
            this.putMapObject(map, this.mapType, this.getTestKeyValue(i, this.mapType), Factory.createChild1());
        }
        this.primaryMember().commit(true);
        for (i = 0; i < 5; ++i) {
            this.setKeyField(map.get(this.getTestKeyValue(i, this.mapType)), this.mapType, this.getTestKeyValue(i, this.mapType));
        }
        this.primaryMember().commit(true);
        CollectionTestParent replicated = (CollectionTestParent)this.backupMember().getRootObject(parent.getGraphId());
        Map<?, Child1> replicatedMap = this.getMap(replicated, this.mapType);
        Assert.assertEquals((String)"Replicated map is incorrect size", (long)5L, (long)replicatedMap.size());
        map.clear();
        this.primaryMember().commitAndFail(true);
        replicated = (CollectionTestParent)this.backupMember().getRootObject(parent.getGraphId());
        replicatedMap = this.getMap(replicated, this.mapType);
        parent = (CollectionTestParent)this.primaryMember().getRootObject(((RogNode)((Object)map)).getGraphId());
        map = this.getMap(parent, this.mapType);
        replicated = (CollectionTestParent)this.backupMember().getRootObject(parent.getGraphId());
        replicatedMap = this.getMap(replicated, this.mapType);
        Assert.assertEquals((String)"Primary map is incorrect size", (long)0L, (long)map.size());
        Assert.assertEquals((String)"Replicated map is incorrect size", (long)0L, (long)replicatedMap.size());
    }

    @Test
    public void testMapReadd() throws Exception {
        CollectionTestParent parent = this.primaryMember().addRootObject(Factory.createCollectionTestParent(this.nextGraphId()));
        Child1 child1 = Factory.createChild1();
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType), child1);
        this.primaryMember().commitAndFail(true);
        parent = (CollectionTestParent)this.primaryMember().getRootObject(parent.getGraphId());
        child1 = this.getMap(parent, this.mapType).get(this.getTestKeyValue(0, this.mapType));
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType), child1);
        this.removeMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType));
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType), child1);
        this.removeMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType));
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(1, this.mapType), child1);
        Assert.assertEquals((String)("Child entry not found at expected key. map entries are " + this.getMap(parent, this.mapType).entrySet()), (Object)child1, (Object)this.getMap(parent, this.mapType).get(this.getTestKeyValue(1, this.mapType)));
        Assert.assertEquals((String)("Child entry found at unexpected key. map entries are " + this.getMap(parent, this.mapType).entrySet()), null, (Object)this.getMap(parent, this.mapType).get(this.getTestKeyValue(0, this.mapType)));
    }

    @Test
    @Ignore
    public void testMapReaddRollback() throws Exception {
        CollectionTestParent parent = this.primaryMember().addRootObject(Factory.createCollectionTestParent(this.nextGraphId()));
        Child1 child1 = Factory.createChild1();
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType), child1);
        this.primaryMember().commitAndFail(true);
        parent = (CollectionTestParent)this.primaryMember().getRootObject(parent.getGraphId());
        child1 = this.getMap(parent, this.mapType).get(this.getTestKeyValue(0, this.mapType));
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType), child1);
        this.removeMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType));
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType), child1);
        this.removeMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType));
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(1, this.mapType), child1);
        Assert.assertEquals((String)("Child entry not found at expected key. map entries are " + this.getMap(parent, this.mapType).entrySet()), (Object)child1, (Object)this.getMap(parent, this.mapType).get(this.getTestKeyValue(1, this.mapType)));
        Assert.assertEquals((String)("Child entry found at unexpected key. map entries are " + this.getMap(parent, this.mapType).entrySet()), null, (Object)this.getMap(parent, this.mapType).get(this.getTestKeyValue(0, this.mapType)));
        this.primaryMember().getStore().rollback();
        Assert.assertEquals((String)("Child entry not found at expected key. map entries are " + this.getMap(parent, this.mapType).entrySet()), (Object)child1, (Object)this.getMap(parent, this.mapType).get(this.getTestKeyValue(0, this.mapType)));
        Assert.assertEquals((String)("Child entry found at unexpected key. map entries are " + this.getMap(parent, this.mapType).entrySet()), null, (Object)this.getMap(parent, this.mapType).get(this.getTestKeyValue(1, this.mapType)));
    }

    @Test
    public void testMapAddUpdateRemove() throws Exception {
        CollectionTestParent parent = this.primaryMember().addRootObject(Factory.createCollectionTestParent(this.nextGraphId()));
        Child1 child1 = Factory.createChild1();
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType), child1);
        ChildEntity grandChild = ChildEntity.create();
        child1.getLongMapField().put(2L, grandChild);
        this.primaryMember().commit(true);
        child1.setDateField(new Date());
        this.primaryMember().commit(true);
        this.getMap(parent, this.mapType).get(this.getTestKeyValue(0, this.mapType)).setBooleanArrayField(new boolean[]{false});
        this.getMap(parent, this.mapType).remove(this.getTestKeyValue(0, this.mapType));
        this.primaryMember().commit(true);
        this.primaryMember().commitAndFail(true);
        Assert.assertEquals((String)"Child map value not removed", null, (Object)this.getMap(parent, this.mapType).get(this.getTestKeyValue(0, this.mapType)));
        CollectionTestParent replicated = (CollectionTestParent)this.backupMember().getRootObject(parent.getGraphId());
        Assert.assertEquals((String)"Child map value not removed on backup", null, (Object)this.getMap(replicated, this.mapType).get(this.getTestKeyValue(0, this.mapType)));
    }

    @Test
    public void testMapReaddUpdateRollback() throws Exception {
        CollectionTestParent parent = this.primaryMember().addRootObject(Factory.createCollectionTestParent(this.nextGraphId()));
        Child1 child1 = Factory.createChild1();
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType), child1);
        child1.setEnumField(Enumeration.Value1);
        this.primaryMember().commitAndFail(true);
        parent = (CollectionTestParent)this.primaryMember().getRootObject(parent.getGraphId());
        child1 = this.getMap(parent, this.mapType).get(this.getTestKeyValue(0, this.mapType));
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType), child1);
        child1.setEnumField(Enumeration.Value2);
        this.getMap(parent, this.mapType).remove(this.getTestKeyValue(0, this.mapType));
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType), child1);
        this.getMap(parent, this.mapType).remove(this.getTestKeyValue(0, this.mapType));
        child1.setEnumField(Enumeration.Value2);
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(1, this.mapType), child1);
        this.primaryMember().getStore().rollback();
        Assert.assertEquals((String)("Child map value not rolled back to original key. map entries are " + this.getMap(parent, this.mapType).entrySet()), (Object)child1, (Object)this.getMap(parent, this.mapType).get(this.getTestKeyValue(0, this.mapType)));
        Assert.assertEquals((String)"Child field value not rolled back to original value", (Object)((Object)Enumeration.Value1), (Object)((Object)child1.getEnumField()));
    }

    @Test
    public void testNestedContainerNodeDetach() throws Exception {
        CollectionTestParent parent = this.primaryMember().addRootObject(CollectionTestParent.create(this.nextGraphId()));
        Child1 child = Child1.create();
        for (int i = 0; i < 7; ++i) {
            child.getChildQueueField().add(ChildEntity.create());
        }
        HashSet<UUID> idsThatShouldBeRemoved = new HashSet<UUID>();
        for (ChildEntity ce : child.getChildQueueField()) {
            idsThatShouldBeRemoved.add(ce.getId());
        }
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType), child);
        this.primaryMember().commit(true);
        this.removeMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType));
        this.primaryMember().commit(true);
        for (UUID id : idsThatShouldBeRemoved) {
            Assert.assertNull((String)"Descendent node have been removed", (Object)this.primaryMember().getStore().get(id));
        }
    }

    @Test
    public void testMapMultipleAddIllegal() throws Exception {
        CollectionTestParent parent = this.primaryMember().addRootObject(CollectionTestParent.create(this.nextGraphId()));
        Child1 entity = Child1.create();
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType), entity);
        try {
            this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(1, this.mapType), entity);
            Assert.fail((String)"Should not have been able to add an entity to the same collection twice!");
        }
        catch (ERogIllegalParentReferenceException e) {
            System.out.println("Got EXPECTED: " + e.getMessage());
        }
        this.removeMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(0, this.mapType));
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(1, this.mapType), entity);
        this.primaryMember().commit(true);
        CollectionTestParent replicated = (CollectionTestParent)this.backupMember().getRootObject(parent.getGraphId());
        Assert.assertNotNull((String)"entity was not replicated to backup", (Object)this.getMap(replicated, this.mapType).get(this.getTestKeyValue(1, this.mapType)));
        this.putMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(1, this.mapType), entity);
        this.primaryMember().commit(true);
        replicated = (CollectionTestParent)this.backupMember().getRootObject(parent.getGraphId());
        Assert.assertNotNull((String)"entity was not replicated to backup", (Object)this.getMap(replicated, this.mapType).get(this.getTestKeyValue(1, this.mapType)));
        try {
            parent.setEntityField(entity);
            Assert.fail((String)"Should not have been able to add an entity to the same collection twice!");
        }
        catch (ERogIllegalParentReferenceException e) {
            System.out.println("Got EXPECTED: " + e.getMessage());
        }
        this.removeMapObject(this.getMap(parent, this.mapType), this.mapType, this.getTestKeyValue(1, this.mapType)).acquire();
        this.primaryMember().commit(true);
        parent.setEntityField(entity);
        this.primaryMember().commit(true);
        Assert.assertNotNull((String)"entity was not replicated to backup", (Object)replicated.getEntityField());
    }

    private Map<?, Child1> getMap(CollectionTestParent parent, MapType mapType) {
        switch (mapType) {
            case ByteMap: {
                return parent.getByteXMapField();
            }
            case CharMap: {
                return parent.getCharXMapField();
            }
            case DoubleMap: {
                return parent.getDoubleXMapField();
            }
            case FloatMap: {
                return parent.getFloatXMapField();
            }
            case IntMap: {
                return parent.getIntXMapField();
            }
            case LongMap: {
                return parent.getLongXMapField();
            }
            case ShortMap: {
                return parent.getShortXMapField();
            }
            case StringMap: {
                return parent.getStringXMapField();
            }
        }
        throw new IllegalArgumentException("unkown map field type");
    }

    private Child1 putMapObject(Map<?, Child1> map, MapType mapType, Object key, Child1 value) {
        switch (mapType) {
            case ByteMap: {
                return map.put((Byte)key, value);
            }
            case CharMap: {
                return map.put((Character)key, value);
            }
            case DoubleMap: {
                return map.put((Double)key, value);
            }
            case FloatMap: {
                return map.put((Float)key, value);
            }
            case IntMap: {
                return map.put((Integer)key, value);
            }
            case LongMap: {
                return map.put((Long)key, value);
            }
            case ShortMap: {
                return map.put((Short)key, value);
            }
            case StringMap: {
                return map.put((String)key, value);
            }
        }
        throw new IllegalArgumentException("unknown key field type");
    }

    private Child1 removeMapObject(Map<?, Child1> map, MapType mapType, Object key) {
        switch (mapType) {
            case ByteMap: {
                return map.remove(key);
            }
            case CharMap: {
                return map.remove(key);
            }
            case DoubleMap: {
                return map.remove(key);
            }
            case FloatMap: {
                return map.remove(key);
            }
            case IntMap: {
                return map.remove(key);
            }
            case LongMap: {
                return map.remove(key);
            }
            case ShortMap: {
                return map.remove(key);
            }
            case StringMap: {
                return map.remove(key);
            }
        }
        throw new IllegalArgumentException("unknown key field type");
    }

    private void setKeyField(Child1 entity, MapType mapType, Object value) throws Exception {
        try {
            switch (mapType) {
                case ByteMap: {
                    if (fields.contains("XRogByteKey")) {
                        UtlReflection.setNonNestedProperty((Object)entity, (String)"XRogByteKey", (Object)value);
                    } else {
                        entity.setByteField((Byte)value);
                    }
                    return;
                }
                case CharMap: {
                    if (fields.contains("XRogCharKey")) {
                        UtlReflection.setNonNestedProperty((Object)entity, (String)"XRogCharKey", (Object)value);
                    } else {
                        entity.setCharField(((Character)value).charValue());
                    }
                    return;
                }
                case DoubleMap: {
                    if (fields.contains("XRogDoubleKey")) {
                        UtlReflection.setNonNestedProperty((Object)entity, (String)"XRogDoubleKey", (Object)value);
                    } else {
                        entity.setDoubleField((Double)value);
                    }
                    return;
                }
                case FloatMap: {
                    if (fields.contains("XRogFloatKey")) {
                        UtlReflection.setNonNestedProperty((Object)entity, (String)"XRogFloatKey", (Object)value);
                    } else {
                        entity.setFloatField(((Float)value).floatValue());
                    }
                    return;
                }
                case IntMap: {
                    if (fields.contains("XRogIntKey")) {
                        UtlReflection.setNonNestedProperty((Object)entity, (String)"XRogIntKey", (Object)value);
                    } else {
                        entity.setIntField((Integer)value);
                    }
                    return;
                }
                case LongMap: {
                    if (fields.contains("XRogLongKey")) {
                        UtlReflection.setNonNestedProperty((Object)entity, (String)"XRogLongKey", (Object)value);
                    } else {
                        entity.setLongField((Long)value);
                    }
                    return;
                }
                case ShortMap: {
                    if (fields.contains("XRogShortKey")) {
                        UtlReflection.setNonNestedProperty((Object)entity, (String)"XRogShortKey", (Object)value);
                    } else {
                        entity.setShortField((Short)value);
                    }
                    return;
                }
                case StringMap: {
                    if (fields.contains("XRogStrKey")) {
                        UtlReflection.setNonNestedProperty((Object)entity, (String)"XRogStrKey", (Object)value);
                    } else {
                        entity.setStringField((String)value);
                    }
                    return;
                }
            }
        }
        catch (InvocationTargetException ite) {
            if (ite.getTargetException() instanceof Exception) {
                throw (Exception)ite.getTargetException();
            }
            throw ite;
        }
        throw new IllegalArgumentException("unkown key field type");
    }

    private Object getTestKeyValue(int index, MapType mapType) {
        switch (mapType) {
            case ByteMap: {
                return byteTestValues[index];
            }
            case CharMap: {
                return charTestValues[index];
            }
            case DoubleMap: {
                return doubleTestValues[index];
            }
            case FloatMap: {
                return floatTestValues[index];
            }
            case IntMap: {
                return intTestValues[index];
            }
            case LongMap: {
                return longTestValues[index];
            }
            case ShortMap: {
                return shortTestValues[index];
            }
            case StringMap: {
                return stringTestValues[index];
            }
        }
        throw new IllegalArgumentException("unkown key field type");
    }

    public static enum MapType {
        ByteMap(Byte.class),
        CharMap(Character.class),
        ShortMap(Short.class),
        IntMap(Integer.class),
        LongMap(Long.class),
        FloatMap(Float.class),
        DoubleMap(Double.class),
        StringMap(String.class);


        private MapType(Class<?> keyType) {
        }
    }

    public static enum FailureType {
        NO_FAILURES,
        RESTART_ON_COMMIT,
        COMPACT_NO_FAILURE,
        COMPACT_AND_RESTART;

    }
}

