/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit;

import com.eaio.uuid.UUID;
import com.neeve.io.IOElasticBuffer;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.IStoreReader;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.pkt.PktBuffer;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogMetadata;
import com.neeve.rog.log.test.unit.messages.proto.InMessage;
import com.neeve.test.UnitTest;
import java.util.Properties;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class RogLogStoreReaderTest
extends UnitTest {
    private int logCount;
    private int valCount;
    private long txnId;
    private long sno;
    private RogLog log;
    private Random random = new Random(System.currentTimeMillis());

    private final void createLog() throws Exception {
        Properties props = new Properties();
        props.setProperty("detachedPersist", "false");
        props.setProperty("initialLogLength", "0.01");
        this.log = RogLog.create("logStoreReaderTest-" + System.currentTimeMillis() + "-" + ++this.logCount, props);
        this.log.open();
    }

    private final RogLogMetadata deserializeMetadata(PktBuffer buffer) {
        RogLogMetadata metadata = new RogLogMetadata(this.log.getMetadata().getRoot(), new UUID().toString());
        try {
            metadata.open((IOElasticBuffer)buffer, null);
            return metadata;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private final void logSends(int count) {
        for (int i = 0; i < count; ++i) {
            InMessage message = InMessage.create();
            message.setTransactionId(this.txnId);
            message.setMessageSequenceNumber(++this.sno);
            message.setVal("test-" + System.currentTimeMillis() + "-" + ++this.valCount);
            this.log.writeCommitEntry(StoreCommitEntry.create().init(IStoreBinding.Operation.Send, new UUID(), message.getOfid(), message.getType(), message.getTransactionId(), message.getStableTransactionId(), message.getCheckpointVersion(), message, message.serializeToPacket(), message.getContentEncodingType(), false, i == count - 1), false, i == count - 1);
        }
        ++this.txnId;
    }

    @Before
    public void testInitialize() throws Exception {
        ++this.txnId;
        this.sno = 0L;
    }

    @After
    public void testCleanup() throws Exception {
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRead() throws Exception {
        StoreCommitEntry commitEntry;
        int numTransactions;
        int numEntries;
        RogLogMetadata metadata;
        int num;
        int i;
        this.createLog();
        int count = 0;
        for (int i2 = 0; i2 < 100; ++i2) {
            int num2 = 1 + this.random.nextInt(20);
            this.logSends(num2);
            count += num2;
        }
        this.log.flush(false);
        ReadCallbackHandler handler = new ReadCallbackHandler(false);
        Assert.assertTrue((boolean)this.log.read(handler));
        Assert.assertEquals((long)1L, (long)handler.metadataCount);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)0L, (long)handler.metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)-1L, (long)handler.metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)-1L, (long)handler.metadata.getCdcLogNumber());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)handler.metadata.getLiveLogNumber());
        Assert.assertNotNull((Object)handler.metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)handler.metadata.getVersion());
        Assert.assertEquals((long)count, (long)handler.numEntries);
        Assert.assertEquals((long)100L, (long)handler.numTransactions);
        this.log.getMetadata().setCdcLogNumber(0);
        long cdcCheckpointVersion = this.random.nextInt(100000);
        this.log.getMetadata().setCdcCheckpointVersion(cdcCheckpointVersion);
        long cdcCursor = (long)this.random.nextInt(Integer.MAX_VALUE) + 1000L;
        this.log.getMetadata().setCdcCursor(cdcCursor);
        for (i = 0; i < 100; ++i) {
            num = 1 + this.random.nextInt(20);
            this.logSends(num);
            count += num;
        }
        this.log.flush(false);
        handler = new ReadCallbackHandler(true);
        while (!this.log.read(handler)) {
        }
        Assert.assertEquals((long)1L, (long)handler.metadataCount);
        Assert.assertEquals((String)"Wrong checkpoint version", (long)cdcCheckpointVersion, (long)handler.metadata.getCdcCheckpointVersion());
        Assert.assertEquals((String)"Wrong cdc cursor", (long)cdcCursor, (long)handler.metadata.getCdcCursor());
        Assert.assertEquals((String)"Wrong cdc log number", (long)0L, (long)handler.metadata.getCdcLogNumber());
        Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)handler.metadata.getLiveLogNumber());
        Assert.assertNotNull((Object)handler.metadata.getLogUUID());
        Assert.assertEquals((String)"Wrong log version", (long)1L, (long)handler.metadata.getVersion());
        Assert.assertEquals((long)count, (long)handler.numEntries);
        Assert.assertEquals((long)200L, (long)handler.numTransactions);
        this.log.getMetadata().setCdcLogNumber(0);
        cdcCheckpointVersion = this.random.nextInt(100000);
        this.log.getMetadata().setCdcCheckpointVersion(cdcCheckpointVersion);
        cdcCursor = (long)this.random.nextInt(Integer.MAX_VALUE) + 1000L;
        this.log.getMetadata().setCdcCursor(cdcCursor);
        for (i = 0; i < 100; ++i) {
            num = 1 + this.random.nextInt(20);
            this.logSends(num);
            count += num;
        }
        this.log.flush(false);
        try (IStoreReader.IterativeReader reader = this.log.iterativeReader(0);){
            metadata = this.deserializeMetadata(reader.metadata());
            Assert.assertEquals((String)"Wrong checkpoint version", (long)cdcCheckpointVersion, (long)metadata.getCdcCheckpointVersion());
            Assert.assertEquals((String)"Wrong cdc cursor", (long)cdcCursor, (long)metadata.getCdcCursor());
            Assert.assertEquals((String)"Wrong cdc log number", (long)0L, (long)metadata.getCdcLogNumber());
            Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
            Assert.assertNotNull((Object)metadata.getLogUUID());
            Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
            Assert.assertEquals((long)0L, (long)reader.stats().numEntriesRead());
            Assert.assertEquals((long)0L, (long)reader.stats().numTransactionsRead());
            numEntries = 0;
            numTransactions = 0;
            while ((commitEntry = reader.next()) != null) {
                ++numEntries;
                if (!commitEntry.commitEnd) continue;
                ++numTransactions;
            }
            Assert.assertEquals((long)count, (long)numEntries);
            Assert.assertEquals((long)300L, (long)numTransactions);
            Assert.assertEquals((long)count, (long)reader.stats().numEntriesRead());
            Assert.assertEquals((long)300L, (long)reader.stats().numTransactionsRead());
        }
        cdcCheckpointVersion = this.random.nextInt(100000);
        this.log.getMetadata().setCdcCheckpointVersion(cdcCheckpointVersion);
        cdcCursor = (long)this.random.nextInt(Integer.MAX_VALUE) + 1000L;
        this.log.getMetadata().setCdcCursor(cdcCursor);
        reader = this.log.iterativeReader(0);
        try {
            metadata = this.deserializeMetadata(reader.metadata());
            Assert.assertEquals((String)"Wrong checkpoint version", (long)cdcCheckpointVersion, (long)metadata.getCdcCheckpointVersion());
            Assert.assertEquals((String)"Wrong cdc cursor", (long)cdcCursor, (long)metadata.getCdcCursor());
            Assert.assertEquals((String)"Wrong cdc log number", (long)0L, (long)metadata.getCdcLogNumber());
            Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata.getLiveLogNumber());
            Assert.assertNotNull((Object)metadata.getLogUUID());
            Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata.getVersion());
            Assert.assertEquals((long)0L, (long)reader.stats().numEntriesRead());
            Assert.assertEquals((long)0L, (long)reader.stats().numTransactionsRead());
            numEntries = 0;
            numTransactions = 0;
            while ((commitEntry = reader.next()) != null) {
                ++numEntries;
                if (!commitEntry.commitEnd) continue;
                ++numTransactions;
            }
            Assert.assertEquals((long)count, (long)numEntries);
            Assert.assertEquals((long)300L, (long)numTransactions);
            Assert.assertEquals((long)count, (long)reader.stats().numEntriesRead());
            Assert.assertEquals((long)300L, (long)reader.stats().numTransactionsRead());
        }
        finally {
            reader.close();
        }
        reader = this.log.iterativeReader(0);
        for (int i3 = 0; i3 < 10; ++i3) {
            Assert.assertNotNull((Object)reader.next());
        }
        reader = this.log.iterativeReader(0);
        try {
            RogLogMetadata metadata2 = this.deserializeMetadata(reader.metadata());
            Assert.assertEquals((String)"Wrong checkpoint version", (long)cdcCheckpointVersion, (long)metadata2.getCdcCheckpointVersion());
            Assert.assertEquals((String)"Wrong cdc cursor", (long)cdcCursor, (long)metadata2.getCdcCursor());
            Assert.assertEquals((String)"Wrong cdc log number", (long)0L, (long)metadata2.getCdcLogNumber());
            Assert.assertEquals((String)"Wrong live log number", (long)0L, (long)metadata2.getLiveLogNumber());
            Assert.assertNotNull((Object)metadata2.getLogUUID());
            Assert.assertEquals((String)"Wrong log version", (long)1L, (long)metadata2.getVersion());
            Assert.assertEquals((long)0L, (long)reader.stats().numEntriesRead());
            Assert.assertEquals((long)0L, (long)reader.stats().numTransactionsRead());
            numEntries = 0;
            numTransactions = 0;
            while ((commitEntry = reader.next()) != null) {
                ++numEntries;
                if (!commitEntry.commitEnd) continue;
                ++numTransactions;
            }
            Assert.assertEquals((long)count, (long)numEntries);
            Assert.assertEquals((long)300L, (long)numTransactions);
            Assert.assertEquals((long)count, (long)reader.stats().numEntriesRead());
            Assert.assertEquals((long)300L, (long)reader.stats().numTransactionsRead());
        }
        finally {
            reader.close();
        }
    }

    private final class ReadCallbackHandler
    implements IStoreReader.ReadCallback {
        private final Random random;
        RogLogMetadata metadata;
        int metadataCount;
        int numTransactions;
        int numEntries;

        public ReadCallbackHandler(boolean suspend) {
            this.random = suspend ? new Random(System.currentTimeMillis()) : null;
        }

        @Override
        public final void metadata(PktBuffer buffer) {
            ++this.metadataCount;
            this.metadata = RogLogStoreReaderTest.this.deserializeMetadata(buffer);
        }

        @Override
        public final boolean entry(StoreCommitEntry commitEntry) {
            ++this.numEntries;
            if (commitEntry.commitEnd) {
                ++this.numTransactions;
            }
            return this.random != null ? this.random.nextInt(100) < 99 : true;
        }

        @Override
        public final void done(long lastTransactionId) {
        }
    }
}

