/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.log.test.unit;

import com.eaio.uuid.UUID;
import com.neeve.ods.IStoreBinding;
import com.neeve.ods.StoreCommitEntry;
import com.neeve.pkt.log.EPktLogInvalidPositionException;
import com.neeve.rog.IRogNode;
import com.neeve.rog.IRogRawMessage;
import com.neeve.rog.impl.RogRawMessageFactory;
import com.neeve.rog.log.RogLog;
import com.neeve.rog.log.RogLogReader;
import com.neeve.rog.log.test.unit.messages.proto.Factory;
import com.neeve.rog.log.test.unit.messages.proto.InMessage;
import com.neeve.rog.log.test.unit.messages.proto.OutMessage;
import com.neeve.test.UnitTest;
import com.neeve.util.UtlObjectGraph;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public final class RogLogReaderTest
extends UnitTest {
    private int logCount;
    private int valCount;
    private long txnId;
    private long sno;
    private RogLog log;
    private RogLogReader reader;
    private Random random = new Random(System.currentTimeMillis());

    private final void createLog() throws Exception {
        Properties props = new Properties();
        props.setProperty("detachedPersist", "false");
        props.setProperty("initialLogLength", "0.01");
        this.log = RogLog.create("logReaderTest-" + System.currentTimeMillis() + "-" + ++this.logCount, props);
        this.log.open();
        this.reader = this.log.createReader();
        RogLogReader.registerFactory(new Factory());
    }

    private final void logRawSends(int count, boolean hasOutMsgsInTransaction, boolean commit, long txnId) {
        for (int i = 0; i < count; ++i) {
            IRogRawMessage message = RogRawMessageFactory.createRogRawMessage();
            message.setTransactionId(txnId);
            message.setOutMsgsInTransaction(hasOutMsgsInTransaction);
            message.setMessageSequenceNumber(++this.sno);
            message.setRawMessage(ByteBuffer.wrap(("test-" + ++this.valCount).getBytes()));
            message.setMessageChannel("channel-" + this.valCount);
            message.setMessageKey("key-" + this.valCount);
            this.log.writeCommitEntry(StoreCommitEntry.create().init(IStoreBinding.Operation.Send, new UUID(), message.getOfid(), message.getType(), message.getTransactionId(), message.getStableTransactionId(), message.getCheckpointVersion(), message, message.serializeToPacket(), message.getContentEncodingType(), false, commit), false, commit);
        }
    }

    private final void logSends(int count, boolean hasOutMsgsInTransaction, boolean commit, long txnId) {
        for (int i = 0; i < count; ++i) {
            InMessage message = InMessage.create();
            message.setTransactionId(txnId);
            message.setOutMsgsInTransaction(hasOutMsgsInTransaction);
            message.setMessageSequenceNumber(++this.sno);
            message.setVal("test-" + System.currentTimeMillis() + "-" + ++this.valCount);
            this.log.writeCommitEntry(StoreCommitEntry.create().init(IStoreBinding.Operation.Send, new UUID(), message.getOfid(), message.getType(), message.getTransactionId(), message.getStableTransactionId(), message.getCheckpointVersion(), message, message.serializeToPacket(), message.getContentEncodingType(), false, i == count - 1 && commit), false, i == count - 1 && commit);
        }
        this.log.flush(true);
    }

    private final void logSends(int count, boolean hasOutMsgsInTransaction, boolean commit) {
        this.logSends(count, hasOutMsgsInTransaction, commit, this.txnId);
    }

    private final void logMessages(int count, boolean hasInMsgsInTransaction, long txnId, boolean commit) {
        for (int i = 0; i < count; ++i) {
            OutMessage message = OutMessage.create();
            message.setTransactionId(txnId);
            message.setInMsgsInTransaction(hasInMsgsInTransaction);
            message.setMessageSequenceNumber(++this.sno);
            message.setAsOutboundMessage(true);
            message.setVal("test-" + System.currentTimeMillis() + "-" + ++this.valCount);
            message.sync();
            this.log.log(message, i == count - 1 && commit);
        }
        this.log.flush(true);
    }

    private final void logMessages(int count, boolean hasInMsgsInTransaction, boolean commit) {
        this.logMessages(count, hasInMsgsInTransaction, this.txnId, commit);
    }

    private final void logRawMessages(int count, boolean hasInMsgsInTransaction, boolean commit, long txnId) {
        for (int i = 0; i < count; ++i) {
            IRogRawMessage message = RogRawMessageFactory.createRogRawMessage();
            message.setTransactionId(txnId);
            message.setInMsgsInTransaction(hasInMsgsInTransaction);
            message.setMessageSequenceNumber(++this.sno);
            message.setAsOutboundMessage(true);
            message.setRawMessage(ByteBuffer.wrap(("test-" + ++this.valCount).getBytes()));
            message.setMessageChannel("channel-" + this.valCount);
            message.setMessageKey("key-" + this.valCount);
            message.sync();
            this.log.log(message, i == count - 1 && commit);
        }
        this.log.flush(true);
    }

    private final void validateSendEntry(RogLog.Entry entry, long txnId, long sno) {
        Assert.assertNotNull((String)"Entry shouldn't be null", (Object)entry);
        Assert.assertEquals((String)"Wrong entry type", (Object)((Object)RogLog.Entry.Type.Send), (Object)((Object)entry.getEntryType()));
        Assert.assertTrue((String)("Expected Entry to be instance of InMessage but was: " + entry.getObject().getClass()), (boolean)(entry.getObject() instanceof InMessage));
        Assert.assertEquals((String)"Wrong transaction id", (long)((IRogNode)entry.getObject()).getTransactionId(), (long)txnId);
        Assert.assertEquals((String)"Wrong sequence number", (long)((IRogNode)entry.getObject()).getMessageSequenceNumber(), (long)sno);
    }

    private final void validateSendEntry(RogLog.Entry entry, long sno) {
        this.validateSendEntry(entry, this.txnId, sno);
    }

    private final void validateMessageEntry(RogLog.Entry entry, long txnId, long sno) {
        Assert.assertNotNull((String)"Entry shouldn't be null", (Object)entry);
        Assert.assertEquals((String)"Wrong entry type", (Object)((Object)RogLog.Entry.Type.Send), (Object)((Object)entry.getEntryType()));
        Assert.assertTrue((String)("Expected Entry to be instance of InMessage but was: " + entry.getObject().getClass()), (boolean)(entry.getObject() instanceof OutMessage));
        Assert.assertEquals((String)"Wrong transaction id", (long)((IRogNode)entry.getObject()).getTransactionId(), (long)txnId);
        Assert.assertEquals((String)"Wrong sequence number", (long)((IRogNode)entry.getObject()).getMessageSequenceNumber(), (long)sno);
    }

    private final void validateMessageEntry(RogLog.Entry entry, long sno) {
        this.validateMessageEntry(entry, this.txnId, sno);
    }

    @BeforeClass
    public static void initialize() throws Exception {
    }

    @AfterClass
    public static void cleanup() {
    }

    @Before
    public void testInitialize() throws Exception {
        ++this.txnId;
        this.sno = 0L;
    }

    @After
    public void testCleanup() throws Exception {
        if (this.log != null) {
            this.log.close();
            this.log = null;
        }
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    @Test
    public void testSingleTransactionOneReplicateNoMessage() throws Exception {
        this.createLog();
        this.logSends(1, false, true);
        RogLog.Entry entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)1L, (long)entries.size());
        this.validateSendEntry(entries.get(0), 1L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionOneReplicateOneMessage() throws Exception {
        this.createLog();
        this.logSends(1, true, false);
        this.logMessages(1, true, true);
        RogLog.Entry entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        this.validateMessageEntry(entry, 2L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        this.validateMessageEntry(entry, 2L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)2L, (long)entries.size());
        this.validateSendEntry(entries.get(0), 1L);
        this.validateMessageEntry(entries.get(1), 2L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionOneMessageNoReplicate() throws Exception {
        this.createLog();
        this.logMessages(1, false, true);
        RogLog.Entry entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)1L, (long)entries.size());
        this.validateMessageEntry(entries.get(0), 1L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionOneMessageOneReplicate() throws Exception {
        this.createLog();
        this.logMessages(1, true, false);
        this.logSends(1, true, true);
        RogLog.Entry entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        this.validateSendEntry(entry, 2L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        this.validateSendEntry(entry, 2L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)2L, (long)entries.size());
        this.validateMessageEntry(entries.get(0), 1L);
        this.validateSendEntry(entries.get(1), 2L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionTwoReplicateNoMessage() throws Exception {
        this.createLog();
        this.logSends(2, false, true);
        RogLog.Entry entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)2L, (long)entries.size());
        this.validateSendEntry(entries.get(0), 1L);
        this.validateSendEntry(entries.get(1), 2L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionTwoReplicateOneMessage() throws Exception {
        this.createLog();
        this.logSends(2, true, false);
        this.logMessages(1, true, true);
        RogLog.Entry entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 3L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 3L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)3L, (long)entries.size());
        this.validateSendEntry(entries.get(0), 1L);
        this.validateSendEntry(entries.get(1), 2L);
        this.validateMessageEntry(entries.get(2), 3L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionTwoReplicateTwoMessage() throws Exception {
        this.createLog();
        this.logSends(2, true, false);
        this.logMessages(2, true, true);
        RogLog.Entry entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 4L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 4L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)4L, (long)entries.size());
        this.validateSendEntry(entries.get(0), 1L);
        this.validateSendEntry(entries.get(1), 2L);
        this.validateMessageEntry(entries.get(2), 3L);
        this.validateMessageEntry(entries.get(3), 4L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionTwoMessageNoReplicate() throws Exception {
        this.createLog();
        this.logMessages(2, false, true);
        RogLog.Entry entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)2L, (long)entries.size());
        this.validateMessageEntry(entries.get(0), 1L);
        this.validateMessageEntry(entries.get(1), 2L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionTwoMessageOneReplicate() throws Exception {
        this.createLog();
        this.logMessages(2, true, false);
        this.logSends(1, true, true);
        RogLog.Entry entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 3L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 3L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)3L, (long)entries.size());
        this.validateMessageEntry(entries.get(0), 1L);
        this.validateMessageEntry(entries.get(1), 2L);
        this.validateSendEntry(entries.get(2), 3L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionTwoMessageTwoReplicate() throws Exception {
        this.createLog();
        this.logMessages(2, true, false);
        this.logSends(2, true, true);
        RogLog.Entry entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 4L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 4L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)4L, (long)entries.size());
        this.validateMessageEntry(entries.get(0), 1L);
        this.validateMessageEntry(entries.get(1), 2L);
        this.validateSendEntry(entries.get(2), 3L);
        this.validateSendEntry(entries.get(3), 4L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionThreeReplicateNoMessage() throws Exception {
        this.createLog();
        this.logSends(3, false, true);
        RogLog.Entry entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 3L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 3L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)3L, (long)entries.size());
        this.validateSendEntry(entries.get(0), 1L);
        this.validateSendEntry(entries.get(1), 2L);
        this.validateSendEntry(entries.get(2), 3L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionThreeReplicateOneMessage() throws Exception {
        this.createLog();
        this.logSends(3, true, false);
        this.logMessages(1, true, true);
        RogLog.Entry entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 4L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 4L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)4L, (long)entries.size());
        this.validateSendEntry(entries.get(0), 1L);
        this.validateSendEntry(entries.get(1), 2L);
        this.validateSendEntry(entries.get(2), 3L);
        this.validateMessageEntry(entries.get(3), 4L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionThreeReplicateTwoMessage() throws Exception {
        this.createLog();
        this.logSends(3, true, false);
        this.logMessages(2, true, true);
        RogLog.Entry entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 5L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 5L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)5L, (long)entries.size());
        this.validateSendEntry(entries.get(0), 1L);
        this.validateSendEntry(entries.get(1), 2L);
        this.validateSendEntry(entries.get(2), 3L);
        this.validateMessageEntry(entries.get(3), 4L);
        this.validateMessageEntry(entries.get(4), 5L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionThreeReplicateThreeMessage() throws Exception {
        this.createLog();
        this.logSends(3, true, false);
        this.logMessages(3, true, true);
        RogLog.Entry entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 5L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 6L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateSendEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 5L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 6L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)6L, (long)entries.size());
        this.validateSendEntry(entries.get(0), 1L);
        this.validateSendEntry(entries.get(1), 2L);
        this.validateSendEntry(entries.get(2), 3L);
        this.validateMessageEntry(entries.get(3), 4L);
        this.validateMessageEntry(entries.get(4), 5L);
        this.validateMessageEntry(entries.get(5), 6L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionThreeMessageNoReplicate() throws Exception {
        this.createLog();
        this.logMessages(3, false, true);
        RogLog.Entry entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 3L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 3L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)3L, (long)entries.size());
        this.validateMessageEntry(entries.get(0), 1L);
        this.validateMessageEntry(entries.get(1), 2L);
        this.validateMessageEntry(entries.get(2), 3L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionThreeMessageOneReplicate() throws Exception {
        this.createLog();
        this.logMessages(3, true, false);
        this.logSends(1, true, true);
        RogLog.Entry entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 4L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 4L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)4L, (long)entries.size());
        this.validateMessageEntry(entries.get(0), 1L);
        this.validateMessageEntry(entries.get(1), 2L);
        this.validateMessageEntry(entries.get(2), 3L);
        this.validateSendEntry(entries.get(3), 4L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionThreeMessageTwoReplicate() throws Exception {
        this.createLog();
        this.logMessages(3, true, false);
        this.logSends(2, true, true);
        RogLog.Entry entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 5L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 5L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)5L, (long)entries.size());
        this.validateMessageEntry(entries.get(0), 1L);
        this.validateMessageEntry(entries.get(1), 2L);
        this.validateMessageEntry(entries.get(2), 3L);
        this.validateSendEntry(entries.get(3), 4L);
        this.validateSendEntry(entries.get(4), 5L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testSingleTransactionThreeMessageThreeReplicate() throws Exception {
        this.createLog();
        this.logMessages(3, true, false);
        this.logSends(3, true, true);
        RogLog.Entry entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 5L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 6L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateMessageEntry(entry, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 5L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, 6L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)6L, (long)entries.size());
        this.validateMessageEntry(entries.get(0), 1L);
        this.validateMessageEntry(entries.get(1), 2L);
        this.validateMessageEntry(entries.get(2), 3L);
        this.validateSendEntry(entries.get(3), 4L);
        this.validateSendEntry(entries.get(4), 5L);
        this.validateSendEntry(entries.get(5), 6L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testIncompleteTransactionAtLogBegin() throws Exception {
        this.createLog();
        this.logMessages(3, false, false);
        ++this.txnId;
        this.logSends(3, false, true);
        RogLog.Entry entry = this.reader.next();
        this.validateMessageEntry(entry, this.txnId - 1L, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 5L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 6L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateMessageEntry(entry, this.txnId - 1L, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 5L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 6L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)3L, (long)entries.size());
        this.validateSendEntry(entries.get(0), this.txnId, 4L);
        this.validateSendEntry(entries.get(1), this.txnId, 5L);
        this.validateSendEntry(entries.get(2), this.txnId, 6L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testIncompleteTransactionAtLogMiddle() throws Exception {
        this.createLog();
        this.logSends(3, false, true);
        ++this.txnId;
        this.logMessages(3, false, false);
        ++this.txnId;
        this.logSends(3, false, true);
        RogLog.Entry entry = this.reader.next();
        this.validateSendEntry(entry, this.txnId - 2L, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId - 2L, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId - 2L, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 5L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 6L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 7L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 8L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 9L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateSendEntry(entry, this.txnId - 2L, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId - 2L, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId - 2L, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 5L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 6L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 7L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 8L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 9L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)3L, (long)entries.size());
        this.validateSendEntry(entries.get(0), this.txnId - 2L, 1L);
        this.validateSendEntry(entries.get(1), this.txnId - 2L, 2L);
        this.validateSendEntry(entries.get(2), this.txnId - 2L, 3L);
        transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        entries = transaction.getEntries();
        Assert.assertEquals((long)3L, (long)entries.size());
        this.validateSendEntry(entries.get(0), this.txnId, 7L);
        this.validateSendEntry(entries.get(1), this.txnId, 8L);
        this.validateSendEntry(entries.get(2), this.txnId, 9L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testIncompleteTransactionAtLogEnd() throws Exception {
        this.createLog();
        this.logMessages(3, false, true);
        ++this.txnId;
        this.logSends(3, false, false);
        RogLog.Entry entry = this.reader.next();
        this.validateMessageEntry(entry, this.txnId - 1L, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 5L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 6L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        entry = this.reader.next();
        this.validateMessageEntry(entry, this.txnId - 1L, 1L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 2L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateMessageEntry(entry, this.txnId - 1L, 3L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 4L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 5L);
        entry = this.reader.next();
        Assert.assertNotNull((Object)entry);
        this.validateSendEntry(entry, this.txnId, 6L);
        Assert.assertNull((Object)this.reader.next());
        this.reader.rewind();
        RogLogReader.Transaction transaction = this.reader.nextTransaction();
        Assert.assertNotNull((Object)transaction);
        List<RogLog.Entry> entries = transaction.getEntries();
        Assert.assertEquals((long)3L, (long)entries.size());
        this.validateMessageEntry(entries.get(0), this.txnId - 1L, 1L);
        this.validateMessageEntry(entries.get(1), this.txnId - 1L, 2L);
        this.validateMessageEntry(entries.get(2), this.txnId - 1L, 3L);
        Assert.assertNull((Object)this.reader.nextTransaction());
    }

    @Test
    public void testConsecutiveTransactions() throws Exception {
        this.createLog();
        for (int i = 0; i < 100; ++i) {
            long startSno;
            int numSends;
            int numMsgs;
            do {
                startSno = this.sno;
                numMsgs = this.random.nextInt(10);
                numSends = this.random.nextInt(10);
                this.logMessages(numMsgs, numSends > 0, numSends == 0);
                this.logSends(numSends, numMsgs > 0, true);
            } while (numMsgs + numSends <= 0);
            System.out.println("..." + i + "(numMsgs=" + numMsgs + ", numSends=" + numSends + ")");
            RogLogReader.Transaction transaction = this.reader.nextTransaction();
            Assert.assertNotNull((Object)transaction);
            List<RogLog.Entry> entries = transaction.getEntries();
            Assert.assertEquals((long)(numMsgs + numSends), (long)entries.size());
            for (int j = 0; j < numMsgs; ++j) {
                this.validateMessageEntry(entries.get(j), startSno + (long)j + 1L);
            }
            for (int k = numMsgs; k < numMsgs + numSends; ++k) {
                this.validateSendEntry(entries.get(k), startSno + (long)k + 1L);
            }
            Assert.assertNull((Object)this.reader.nextTransaction());
            ++this.txnId;
        }
    }

    @Test
    public void testRandomAccess() throws Exception {
        this.createLog();
        for (int i = 0; i < 100; ++i) {
            int numMsgs = 5;
            int numSends = 5;
            this.logMessages(5, true, false);
            this.logSends(5, true, true);
            ++this.txnId;
        }
        HashMap<Long, RogLog.Entry> sequentialReads = new HashMap<Long, RogLog.Entry>();
        RogLogReader reader = this.log.createReader();
        reader.rewind();
        RogLog.Entry entry = null;
        while ((entry = reader.next()) != null) {
            Assert.assertNull((String)"Sequential read return two objects at same position", (Object)sequentialReads.put(entry.getFilePosition(), entry));
        }
        List<Class> comparisonApis = Arrays.asList(RogLog.Entry.class, IRogNode.class);
        for (Long position : sequentialReads.keySet()) {
            StringBuffer buf;
            RogLog.Entry randomEntry;
            entry = (RogLog.Entry)sequentialReads.get(position);
            if (UtlObjectGraph.deepApiEquals((Object)entry, (Object)(randomEntry = reader.getEntryAt(position)), (StringBuffer)(buf = new StringBuffer()), comparisonApis)) continue;
            Assert.fail((String)("Random Access Entry doesn't match sequential entry for " + entry.getFilePosition() + ": " + buf));
        }
    }

    @Test
    public void testRandomAccessReadInterleavedWithRead() throws Exception {
        this.createLog();
        int entryCount = 0;
        for (int i = 0; i < 10; ++i) {
            int numMsgs = 5;
            int numSends = 5;
            this.logMessages(5, true, false);
            this.logSends(5, true, true);
            entryCount += 10;
            ++this.txnId;
        }
        RogLogReader reader = this.log.createReader();
        reader.rewind();
        RogLog.Entry entry = null;
        HashMap<Long, RogLog.Entry> sequentialReads = new HashMap<Long, RogLog.Entry>();
        HashMap<Long, RogLog.Entry> randomReads = new HashMap<Long, RogLog.Entry>();
        for (int i = 0; i < entryCount / 2; ++i) {
            entry = reader.next();
            Assert.assertNull((String)"Sequential read return two objects at same position", (Object)sequentialReads.put(entry.getFilePosition(), entry));
        }
        HashSet interleavedReadSeqNos = new HashSet(sequentialReads.keySet());
        Iterator readPosIterator = interleavedReadSeqNos.iterator();
        while ((entry = reader.next()) != null) {
            Assert.assertNull((String)"Sequential read return two objects at same position", (Object)sequentialReads.put(entry.getFilePosition(), entry));
            long randomReadSeqNo = (Long)readPosIterator.next();
            randomReads.put(randomReadSeqNo, reader.getEntryAt(randomReadSeqNo));
        }
        List<Class> comparisonApis = Arrays.asList(RogLog.Entry.class, IRogNode.class);
        for (Long position : sequentialReads.keySet()) {
            StringBuffer buf;
            RogLog.Entry randomEntry;
            entry = (RogLog.Entry)sequentialReads.get(position);
            if (UtlObjectGraph.deepApiEquals((Object)entry, (Object)(randomEntry = randomReads.containsKey(position) ? (RogLog.Entry)randomReads.get(position) : reader.getEntryAt(position)), (StringBuffer)(buf = new StringBuffer()), comparisonApis)) continue;
            Assert.fail((String)("Random Access Entry doesn't match sequential entry for " + entry.getFilePosition() + ": " + buf));
        }
    }

    @Test
    public void testRandomAccessReadInterleavedWithWrite() throws Exception {
        this.createLog();
        int entryCount = 0;
        for (int i = 0; i < 5; ++i) {
            int numMsgs = 5;
            int numSends = 5;
            this.logMessages(5, true, false);
            this.logSends(5, true, true);
            entryCount += 10;
            ++this.txnId;
        }
        HashSet<Long> interleavedReadSeqNos = new HashSet<Long>();
        RogLog.Entry entry = null;
        RogLogReader reader = this.log.createReader();
        for (int i = 0; i < entryCount; ++i) {
            interleavedReadSeqNos.add(reader.next().getFilePosition());
        }
        HashMap<Long, RogLog.Entry> randomReads = new HashMap<Long, RogLog.Entry>();
        Iterator readPosIterator = interleavedReadSeqNos.iterator();
        for (int i = 0; i < 5; ++i) {
            long randomReadSeqNo;
            int r;
            int numMsgs = 5;
            int numSends = 5;
            this.logMessages(5, true, false);
            for (r = 0; r < 5; ++r) {
                randomReadSeqNo = (Long)readPosIterator.next();
                randomReads.put(randomReadSeqNo, reader.getEntryAt(randomReadSeqNo));
            }
            this.logSends(5, true, true);
            for (r = 0; r < 5; ++r) {
                randomReadSeqNo = (Long)readPosIterator.next();
                randomReads.put(randomReadSeqNo, reader.getEntryAt(randomReadSeqNo));
            }
            entryCount += 10;
            ++this.txnId;
        }
        reader.rewind();
        HashMap<Long, RogLog.Entry> sequentialReads = new HashMap<Long, RogLog.Entry>();
        while ((entry = reader.next()) != null) {
            Assert.assertNull((String)"Sequential read return two objects at same position", (Object)sequentialReads.put(entry.getFilePosition(), entry));
        }
        Assert.assertEquals((String)"Wrong number of entries read", (long)entryCount, (long)sequentialReads.size());
        List<Class> comparisonApis = Arrays.asList(RogLog.Entry.class, IRogNode.class);
        for (Long position : sequentialReads.keySet()) {
            StringBuffer buf;
            RogLog.Entry randomEntry;
            entry = (RogLog.Entry)sequentialReads.get(position);
            if (UtlObjectGraph.deepApiEquals((Object)entry, (Object)(randomEntry = randomReads.containsKey(position) ? (RogLog.Entry)randomReads.get(position) : reader.getEntryAt(position)), (StringBuffer)(buf = new StringBuffer()), comparisonApis)) continue;
            Assert.fail((String)("Random Access Entry doesn't match sequential entry for " + entry.getFilePosition() + ": " + buf));
        }
    }

    @Test
    public void testRandomAccessReadBounderies() throws Exception {
        this.createLog();
        int entryCount = 0;
        for (int i = 0; i < 5; ++i) {
            int numMsgs = 5;
            int numSends = 5;
            this.logMessages(5, true, false);
            this.logSends(5, true, true);
            entryCount += 10;
            ++this.txnId;
        }
        HashSet<Long> logPositions = new HashSet<Long>();
        RogLogReader reader = this.log.createReader();
        for (int i = 0; i < entryCount; ++i) {
            logPositions.add(reader.next().getFilePosition());
        }
        long invalidPosition = 1000L;
        int i = 0;
        while ((long)i < this.log.getSize() && logPositions.contains(invalidPosition)) {
            ++i;
        }
        try {
            reader.getEntryAt(invalidPosition);
            Assert.fail((String)("Didn't get expected " + EPktLogInvalidPositionException.class));
        }
        catch (EPktLogInvalidPositionException ePktLogInvalidPositionException) {
            // empty catch block
        }
        try {
            reader.getEntryAt(-1L);
            Assert.fail((String)("Didn't get expected " + EPktLogInvalidPositionException.class));
        }
        catch (EPktLogInvalidPositionException ePktLogInvalidPositionException) {
            // empty catch block
        }
        try {
            reader.getEntryAt(this.log.getSize());
            Assert.fail((String)("Didn't get expected " + EPktLogInvalidPositionException.class));
        }
        catch (EPktLogInvalidPositionException ePktLogInvalidPositionException) {
            // empty catch block
        }
        try {
            reader.getEntryAt(this.log.getSize() + 10L);
            Assert.fail((String)("Didn't get expected " + EPktLogInvalidPositionException.class));
        }
        catch (EPktLogInvalidPositionException ePktLogInvalidPositionException) {
            // empty catch block
        }
        try {
            reader.getEntryAt(0L);
            Assert.fail((String)("Didn't get expected " + EPktLogInvalidPositionException.class));
        }
        catch (EPktLogInvalidPositionException ePktLogInvalidPositionException) {
            // empty catch block
        }
        Assert.assertNull((Object)reader.getEntryAt(this.log.getSize() - 34L));
    }

    @Test
    public void testRawMessagePersist() throws Exception {
        this.createLog();
        int entryCount = 0;
        for (int i = 0; i < 5; ++i) {
            int numMsgs = 5;
            int numSends = 5;
            this.logRawMessages(5, true, false, this.txnId);
            this.logRawSends(5, true, true, this.txnId);
            entryCount += 10;
            ++this.txnId;
        }
        RogLog.Entry entry = null;
        RogLogReader reader = this.log.createReader();
        for (int i = 1; i <= entryCount; ++i) {
            entry = reader.next();
            IRogRawMessage message = (IRogRawMessage)entry.getObject();
            String expectedMessage = "test-" + i;
            String actual = new String(message.getRawMessage().array(), message.getRawMessage().arrayOffset(), message.getRawMessage().remaining());
            Assert.assertEquals((String)"Wrong raw bytes", (Object)expectedMessage, (Object)actual);
            Assert.assertEquals((String)"Wrong message channel", (Object)("channel-" + i), (Object)message.getMessageChannel());
            Assert.assertEquals((String)"Wrong message key", (Object)("key-" + i), (Object)message.getMessageKey());
        }
    }
}

