/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.rog.impl;

import com.eaio.uuid.UUID;
import com.neeve.ci.XRuntime;
import com.neeve.lang.XCharIterator;
import com.neeve.lang.XCharLinkedHashMap;
import com.neeve.lang.XCharMap;
import com.neeve.lang.XCharSet;
import com.neeve.lang.XIterator;
import com.neeve.pkt.PktFactory;
import com.neeve.pkt.PktPacket;
import com.neeve.rog.IRogCharMap;
import com.neeve.rog.IRogCollectionNodeElement;
import com.neeve.rog.IRogNode;
import com.neeve.rog.impl.RogCollectionNode;
import com.neeve.rog.impl.RogGraphVisitor;
import com.neeve.rog.impl.RogNode;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class RogXCharMap<V extends IRogCollectionNodeElement>
extends RogCollectionNode<V>
implements IRogCharMap<V> {
    private final int initialCapacity = XRuntime.getValue((String)("nv.rog.map." + this.getClass().getName() + ".initialCapacity"), (int)0);
    private final XCharLinkedHashMap<V> map = this.initialCapacity > 0 ? new XCharLinkedHashMap(this.initialCapacity) : new XCharLinkedHashMap();
    private Set<Map.Entry<Character, V>> boxedEntrySet;
    private Set<Character> boxedKeySet;

    protected RogXCharMap(short ofid, short vfid, short type, UUID id, boolean transactional) {
        super(ofid, vfid, type, id, transactional);
        this.map.setSupportsIteratorModifications(false);
    }

    protected abstract char getMapElementKey(V var1);

    protected abstract void setMapElementKey(V var1, char var2);

    @Override
    protected final void onChildAddRollback(RogNode element) {
        this.map.remove(this.getMapElementKey((IRogCollectionNodeElement)((Object)element)));
    }

    @Override
    protected final void onChildRemoveRollback(RogNode element) {
        this.add((IRogCollectionNodeElement)((Object)element));
    }

    private final V add(V element) {
        return (V)((IRogCollectionNodeElement)this.map.put(this.getMapElementKey(element), element));
    }

    @Override
    protected final void visitFields(RogGraphVisitor visitor) {
        int i = 0;
        XIterator iterator = this.map.reuseableEntryIterator();
        while (iterator.hasNext()) {
            XCharMap.Entry entry = (XCharMap.Entry)iterator.next();
            this.visitField(visitor, "Key " + i, Character.valueOf(entry.getKey()));
            this.visitField(visitor, "Value " + i, (RogNode)entry.getValue());
            ++i;
        }
    }

    @Override
    protected final PktPacket getStoreCommitPacket() {
        return PktFactory.getInstance().createPacket(257);
    }

    @Override
    public final void clear() {
        XCharIterator iterator = this.map.reuseableKeyIterator();
        while (iterator.hasNext()) {
            this.remove(iterator.next());
            this.map.reuseableKeyIterator();
        }
        this.map.clear();
    }

    @Override
    public final boolean containsKey(char key) {
        return this.map.containsKey(key);
    }

    public final boolean containsKey(Character key) {
        if (key == null) {
            return false;
        }
        return this.containsKey(key.charValue());
    }

    @Override
    public final boolean containsKey(Object key) {
        return this.containsKey((Character)key);
    }

    @Override
    public final boolean containsValue(Object val) {
        return this.map.containsValue(val);
    }

    @Override
    public final Set<Map.Entry<Character, V>> entrySet() {
        if (this.boxedEntrySet == null) {
            this.boxedEntrySet = new EntrySet();
        }
        return this.boxedEntrySet;
    }

    @Override
    public final Set<Character> keySet() {
        if (this.boxedKeySet == null) {
            this.boxedKeySet = new KeySet();
        }
        return this.boxedKeySet;
    }

    public final XCharSet keyCharSet() {
        return this.map.keySet();
    }

    @Override
    public final Collection<V> values() {
        return this.map.values();
    }

    @Override
    public final boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public final V get(char key) {
        return (V)((IRogCollectionNodeElement)this.map.get(key));
    }

    public final V get(Character key) {
        if (key == null) {
            return null;
        }
        return this.get(key.charValue());
    }

    @Override
    public final V get(Object key) {
        if (key instanceof Character) {
            return this.get((Character)key);
        }
        return null;
    }

    @Override
    public final int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public final boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public final XCharIterator reuseableKeyIterator() {
        return this.map.reuseableKeyIterator();
    }

    @Override
    public final XIterator<V> reuseableValueIterator() {
        return this.map.reuseableValueIterator();
    }

    @Override
    public XIterator<XCharMap.Entry<V>> reuseableEntryIterator() {
        return this.map.reuseableEntryIterator();
    }

    @Override
    public final V put(char key, V value) {
        V rc;
        if (value.getParent() == this && key == this.getMapElementKey(value)) {
            return value;
        }
        if (this.getMapElementKey(value) != key) {
            this.setMapElementKey(value, key);
        }
        if ((rc = this.add(value)) != null && rc != value) {
            try {
                this.removeChild(rc);
            }
            catch (RuntimeException thrown) {
                this.map.remove(key);
                this.map.put(key, rc);
                throw thrown;
            }
        }
        this.addChild(value);
        return rc;
    }

    @Override
    public final V put(Character key, V value) {
        if (key == null) {
            throw new NullPointerException("Null values not supported");
        }
        return this.put(key.charValue(), value);
    }

    public final void putAll(XCharMap<? extends V> from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void putAll(Map<? extends Character, ? extends V> from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final V remove(char key) {
        IRogCollectionNodeElement element = (IRogCollectionNodeElement)this.map.remove(key);
        if (element != null) {
            this.setMapElementKey(element, (char)(key + '\u0001'));
            this.removeChild(element);
        }
        return (V)element;
    }

    public final V remove(Character key) {
        if (key == null) {
            return null;
        }
        return this.remove(key.charValue());
    }

    @Override
    public final V remove(Object key) {
        if (key instanceof Character) {
            return this.remove((Character)key);
        }
        return null;
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final void addChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.put(this.getMapElementKey(mapElement), (V)mapElement);
    }

    @Override
    public final void removeChild(IRogNode element) {
        IRogCollectionNodeElement mapElement = (IRogCollectionNodeElement)element;
        this.remove(this.getMapElementKey(mapElement));
    }

    @Override
    public int dispose() {
        int count = super.dispose();
        if (count == 0) {
            this.map.clear();
        }
        return count;
    }

    @Override
    public String toString() {
        return super.toString() + ", elements=" + this.size();
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<Character, V>> {
        private EntrySet() {
        }

        @Override
        public final int size() {
            return RogXCharMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return RogXCharMap.this.isEmpty();
        }

        @Override
        public final Iterator<Map.Entry<Character, V>> iterator() {
            final Iterator it = RogXCharMap.this.map.entrySet().iterator();
            return new Iterator<Map.Entry<Character, V>>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Map.Entry<Character, V> next() {
                    final XCharMap.Entry e = (XCharMap.Entry)it.next();
                    return new Map.Entry<Character, V>(){

                        @Override
                        public Character getKey() {
                            return Character.valueOf(e.getKey());
                        }

                        @Override
                        public V getValue() {
                            return (IRogCollectionNodeElement)e.getValue();
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean add(Map.Entry<Character, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Character, V>> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class KeySet
    extends AbstractSet<Character> {
        KeySet() {
        }

        @Override
        public int size() {
            return RogXCharMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return RogXCharMap.this.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return RogXCharMap.this.containsKey(o);
        }

        @Override
        public Iterator<Character> iterator() {
            final XCharIterator it = RogXCharMap.this.map.keySet().iterator();
            return new Iterator<Character>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public Character next() {
                    return Character.valueOf(it.next());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove not supported");
                }
            };
        }

        @Override
        public boolean add(Character e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends Character> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

