/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.neeve.query.Query;
import com.neeve.query.QueryResult;
import com.neeve.query.QueryResultSet;
import com.neeve.query.impl.QueryEngineImpl;
import com.neeve.query.impl.mem.MemQuerySetRepository;
import com.neeve.query.impl.mock.MockQueryEngine;
import com.neeve.query.impl.mock.MockRecord;
import com.neeve.query.impl.mock.domain.DataTypePayload;
import com.neeve.query.index.IdxField;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Currency;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class QueryEngineDataTypeTest {
    private static QueryEngineImpl<Integer, MockRecord> engine;
    private static MemQuerySetRepository<Integer, MockRecord> repo;
    public static IdxField<MockRecord, Byte> byteData;
    public static IdxField<MockRecord, Short> shortData;
    public static IdxField<MockRecord, Integer> intData;
    public static IdxField<MockRecord, Long> longData;
    public static IdxField<MockRecord, Float> floatData;
    public static IdxField<MockRecord, Double> doubleData;
    public static IdxField<MockRecord, Boolean> booleanData;
    public static IdxField<MockRecord, String> stringData;
    public static IdxField<MockRecord, Date> dateData;
    public static IdxField<MockRecord, Character> charData;
    public static IdxField<MockRecord, Currency> currencyData;
    public static IdxField<MockRecord, BigInteger> bigIntData;
    public static IdxField<MockRecord, BigDecimal> bigDecimalData;
    public static IdxField<MockRecord, DataTypePayload.Color> colorData;

    @BeforeClass
    public static void init() throws Exception {
        engine = new QueryEngineImpl(MockRecord.class);
        repo = new MemQuerySetRepository<Integer, MockRecord>("mock", MockRecord.keyMapper);
        repo.open();
        engine.addRepository(repo, "mock");
        for (int i = 0; i < 500; ++i) {
            DataTypePayload dt = new DataTypePayload(i);
            int recordId = i + 1;
            MockRecord record = new MockRecord(recordId, dt);
            repo.add(record);
        }
    }

    @AfterClass
    public static void teardown() throws Exception {
        engine.close();
    }

    @Test
    public void testByte() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(byteData.is((byte)68));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"byte yields 68", (long)68L, (long)dt.getIntData());
        rs.close();
    }

    @Test
    public void testShort() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(shortData.is((short)68));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"short yields 68", (long)68L, (long)dt.getIntData());
        rs.close();
    }

    @Test
    public void testInt() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(intData.is(68));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"int yields 68", (long)68L, (long)dt.getIntData());
        rs.close();
    }

    @Test
    public void testLong() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(longData.equal(68L));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"long yields 68", (long)68L, (long)dt.getIntData());
        rs.close();
    }

    @Test
    public void testFloat() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(floatData.is(Float.valueOf(68.0f)));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"float yields 68", (long)68L, (long)dt.getIntData());
        rs.close();
    }

    @Test
    public void testDouble() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(doubleData.is(68.0));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"double yields 68", (long)68L, (long)dt.getIntData());
        rs.close();
    }

    @Test
    public void testBoolean() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(booleanData.is(true));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"boolean yields 0", (long)0L, (long)dt.getIntData());
        rs.close();
    }

    @Test
    public void testString() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(stringData.is("68"));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"string yields 68", (long)68L, (long)dt.getIntData());
        rs.close();
    }

    @Test
    public void testDate() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(dateData.is(new Date(68000L)));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"date yields 68", (long)68L, (long)dt.getIntData());
        rs.close();
    }

    @Test
    public void testChar() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(charData.is(Character.valueOf('D')));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"date yields 68", (long)68L, (long)dt.getIntData());
        rs.close();
    }

    @Test
    public void testCurrency() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(currencyData.is(Currency.getInstance(Locale.US)));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"currency yields 0", (long)0L, (long)dt.getIntData());
        rs.close();
    }

    @Test
    public void testBigInteger() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(bigIntData.is(BigInteger.valueOf(68L)));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"big integer yields 68", (long)68L, (long)dt.getIntData());
        rs.close();
    }

    @Test
    public void testBigDecimal() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(bigDecimalData.is(BigDecimal.valueOf(68.0)));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"big decimal yields 68", (long)68L, (long)dt.getIntData());
        rs.close();
    }

    @Test
    public void testEnum() {
        Query<MockRecord> query = engine.createQuery();
        query.from("mock").where(colorData.is(DataTypePayload.Color.GREEN));
        QueryResultSet<MockRecord> rs = engine.execute(query);
        QueryResult<MockRecord> queryResult = rs.getQueryResult();
        Iterator iter = queryResult.iterator();
        Assert.assertTrue((String)"not empty", (boolean)iter.hasNext());
        MockRecord record = (MockRecord)((QueryResultSet.Row)iter.next()).getRecord();
        DataTypePayload dt = (DataTypePayload)record.getObject();
        Assert.assertEquals((String)"color:green yields 2", (long)2L, (long)dt.getIntData());
        rs.close();
    }

    static {
        byteData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.byteData", Byte.class, DataTypePayload.class);
        shortData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.shortData", Short.class, DataTypePayload.class);
        intData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.intData", Integer.class, DataTypePayload.class);
        longData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.longData", Long.class, DataTypePayload.class);
        floatData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.floatData", Float.class, DataTypePayload.class);
        doubleData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.doubleData", Double.class, DataTypePayload.class);
        booleanData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.booleanData", Boolean.class, DataTypePayload.class);
        stringData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.stringData", String.class, DataTypePayload.class);
        dateData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.dateData", Date.class, DataTypePayload.class);
        charData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.charData", Character.class, DataTypePayload.class);
        currencyData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.currencyData", Currency.class, DataTypePayload.class);
        bigIntData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.bigIntegerData", BigInteger.class, DataTypePayload.class);
        bigDecimalData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.bigDecimalData", BigDecimal.class, DataTypePayload.class);
        colorData = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.colorData", DataTypePayload.Color.class, DataTypePayload.class);
    }
}

