/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.neeve.query.QueryParseException;
import com.neeve.query.impl.QueryParser;
import org.junit.BeforeClass;
import org.junit.Test;

public class ParserValidationTest {
    private static QueryParser parser;

    @BeforeClass
    public static void init() {
        parser = new QueryParser();
    }

    @Test
    public void testSelectClassFields() {
        parser.parseQuery("select Customer, Customer.id, fake_pseudo_column from some_table");
    }

    @Test(expected=QueryParseException.class)
    public void testSelectNumber() {
        parser.parseQuery("select 1 from x");
    }

    @Test(expected=QueryParseException.class)
    public void testSelectVarchar() {
        parser.parseQuery("select 'asdf' from x");
    }

    @Test(expected=QueryParseException.class)
    public void testSelectDate() {
        parser.parseQuery("select date '2010-10-10' from x");
    }

    @Test(expected=QueryParseException.class)
    public void testSelectFunction() {
        parser.parseQuery("select f(a) from x");
    }

    @Test(expected=QueryParseException.class)
    public void testSelectSubquery() {
        parser.parseQuery("select (select a from b) from x");
    }

    @Test
    public void testFromRepos() {
        parser.parseQuery("select a from b");
        parser.parseQuery("select a from b,c");
    }

    @Test(expected=QueryParseException.class)
    public void testFromSchemaQualifiedRepo() {
        parser.parseQuery("select a from s.b");
    }

    @Test(expected=QueryParseException.class)
    public void testFromMissing() {
        parser.parseQuery("select a");
    }

    @Test(expected=QueryParseException.class)
    public void testFromMissing2() {
        parser.parseQuery("select a where x=y");
    }

    @Test(expected=QueryParseException.class)
    public void testFromSubquery() {
        parser.parseQuery("select a from (select x as a from y)");
    }

    @Test(expected=QueryParseException.class)
    public void testFromJoins() {
        parser.parseQuery("select x.a from x inner join y on x.a = y.a");
    }

    @Test
    public void testWhere() {
        parser.parseQuery("select x from y where (a='abc' and b<=7.0) or (c in (1,2,3) and d between DATE '2010-10-10' and DATE '2020-04-04')");
    }

    @Test
    public void testNotIn() {
        parser.parseQuery("select x from y where x not in (1,2,3)");
    }

    @Test
    public void testNotBetween() {
        parser.parseQuery("select x from y where x not between 'a' and 'b'");
    }

    @Test(expected=QueryParseException.class)
    public void testExists() {
        parser.parseQuery("select x from y where exists (select a from b)");
    }

    @Test(expected=QueryParseException.class)
    public void testNotExists() {
        parser.parseQuery("select x from y where not exists (select a from b)");
    }

    @Test(expected=QueryParseException.class)
    public void testScalarSubqueryCondition() {
        parser.parseQuery("select x from y where x = (select a from b)");
    }

    @Test(expected=QueryParseException.class)
    public void testInSubqueryCondition() {
        parser.parseQuery("select x from y where x in (select a from b)");
    }

    @Test
    public void testOrderBy() {
        parser.parseQuery("select x from y order by x");
    }

    @Test
    public void testGroupBy() {
        parser.parseQuery("select x from y group by x");
    }

    @Test
    public void testHaving() {
        parser.parseQuery("select x from y having x = 0");
    }
}

