/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.test.unit;

import com.neeve.query.QueryException;
import com.neeve.query.impl.mem.MemQuerySetRepository;
import com.neeve.query.impl.mock.MockQueryEngine;
import com.neeve.query.impl.mock.MockRecord;
import com.neeve.query.impl.mock.domain.Customer;
import com.neeve.query.index.IdxField;
import com.neeve.query.index.IdxUniqueIndex;
import com.neeve.test.UnitTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IndexedRepositoryTest
extends UnitTest {
    private static MemQuerySetRepository<Integer, MockRecord> repo;
    private static IdxField<MockRecord, Long> customerId;
    private static IdxField<MockRecord, String> customerName;

    @Before
    public void setup() {
        repo = new MemQuerySetRepository<Integer, MockRecord>("mock", MockRecord.keyMapper);
        customerId = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.id", Long.class, new Class[0]);
        customerName = MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.name", String.class, new Class[0]);
    }

    @After
    public void teardown() throws Exception {
        repo.close();
    }

    @Test
    public void testIndexOpenThenAdd() throws Exception {
        repo.open();
        repo.createIndex(customerId, true);
        for (int i = 0; i < 100; ++i) {
            repo.add(new MockRecord(i, new Customer(i, "John" + i)));
        }
        IdxUniqueIndex customerIndex = repo.getUniqueIndex(customerId);
        Assert.assertNotNull((String)("IdxIndex wasn't found for " + customerId), customerIndex);
        Integer recordKey = (Integer)customerIndex.getId(10L);
        Assert.assertNotNull((String)"Record wasn't found in index for customer id: 10", (Object)recordKey);
        MockRecord record = repo.retrieve(recordKey);
        Assert.assertNotNull((String)"Record wasn't found in repo for customer id: 10", (Object)record);
        Assert.assertEquals((String)"Wrong name", (Object)"John10", (Object)((Customer)record.getObject()).getName());
    }

    @Test
    public void testIndexAddThenOpen() throws Exception {
        for (int i = 0; i < 100; ++i) {
            repo.add(new MockRecord(i, new Customer(i, "John" + i)));
        }
        repo.open();
        repo.createIndex(customerId, true);
        IdxUniqueIndex customerIndex = repo.getUniqueIndex(customerId);
        Assert.assertNotNull((String)("IdxIndex wasn't found for " + customerId), customerIndex);
        Integer recordKey = (Integer)customerIndex.getId(10L);
        Assert.assertNotNull((String)"Record wasn't found in index for customer id: 10", (Object)recordKey);
        MockRecord record = repo.retrieve(recordKey);
        Assert.assertNotNull((String)"Record wasn't found in repo for customer id: 10", (Object)record);
        Assert.assertEquals((String)"Wrong name", (Object)"John10", (Object)((Customer)record.getObject()).getName());
    }

    @Test
    public void testIndexOpenThenAddThenCreateIndex() throws Exception {
        repo.open();
        for (int i = 0; i < 100; ++i) {
            repo.add(new MockRecord(i, new Customer(i, "John" + i)));
        }
        repo.createIndex(customerId, true);
        IdxUniqueIndex customerIndex = repo.getUniqueIndex(customerId);
        Assert.assertNotNull((String)("IdxIndex wasn't found for " + customerId), customerIndex);
        Integer recordKey = (Integer)customerIndex.getId(10L);
        Assert.assertNotNull((String)"Record wasn't found in index for customer id: 10", (Object)recordKey);
        MockRecord record = repo.retrieve(recordKey);
        Assert.assertNotNull((String)"Record wasn't found in repo for customer id: 10", (Object)record);
        Assert.assertEquals((String)"Wrong name", (Object)"John10", (Object)((Customer)record.getObject()).getName());
    }

    @Test(expected=QueryException.class)
    public void testIndexCreateFailsOnClosedIndex() throws Exception {
        repo.createIndex(customerId, true);
    }

    @Test
    public void testDropIndex() throws Exception {
        for (int i = 0; i < 100; ++i) {
            repo.add(new MockRecord(i, new Customer(i, "John" + i)));
        }
        repo.open();
        repo.createIndex(customerId, true);
        IdxUniqueIndex customerIndex = repo.getUniqueIndex(customerId);
        Assert.assertNotNull((String)("IdxIndex wasn't found for " + customerId), customerIndex);
        Integer recordKey = (Integer)customerIndex.getId(10L);
        Assert.assertNotNull((String)"Record wasn't found in index for customer id: 10", (Object)recordKey);
        MockRecord record = repo.retrieve(recordKey);
        Assert.assertNotNull((String)"Record wasn't found in repo for customer id: 10", (Object)record);
        repo.dropIndex(MockQueryEngine.FIELD_RESOLVER.getField(MockRecord.class, "object.id", Long.class, new Class[0]));
        Assert.assertNull((String)("IdxIndex wasn't dropped for " + customerId), repo.getUniqueIndex(customerId));
    }

    @Test
    public void testDropIndexAndRead() throws Exception {
        for (int i = 0; i < 100; ++i) {
            repo.add(new MockRecord(i, new Customer(i, "John" + i)));
        }
        repo.open();
        repo.createIndex(customerId, true);
        IdxUniqueIndex customerIndex = repo.getUniqueIndex(customerId);
        Assert.assertNotNull((String)("IdxIndex wasn't found for " + customerId), customerIndex);
        Integer recordKey = (Integer)customerIndex.getId(10L);
        Assert.assertNotNull((String)"Record wasn't found in index for customer id: 10", (Object)recordKey);
        MockRecord record = repo.retrieve(recordKey);
        Assert.assertNotNull((String)"Record wasn't found in repo for customer id: 10", (Object)record);
        repo.dropIndex(customerId);
        Assert.assertNull((String)("IdxIndex wasn't dropped for " + customerId), repo.getUniqueIndex(customerId));
        repo.createIndex(customerId, true);
        customerIndex = repo.getUniqueIndex(customerId);
        Assert.assertNotNull((String)("IdxIndex wasn't found for " + customerId), customerIndex);
        recordKey = (Integer)customerIndex.getId(10L);
        Assert.assertNotNull((String)"Record wasn't found in index for customer id: 10", (Object)recordKey);
        record = repo.retrieve(recordKey);
        Assert.assertNotNull((String)"Record wasn't found in repo for customer id: 10", (Object)record);
    }
}

