/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.mem;

import com.neeve.query.QueryException;
import com.neeve.query.impl.QueryConfig;
import com.neeve.query.impl.QueryRepositoryBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public class MemQuerySetRepository<K, V>
extends QueryRepositoryBase<K, V>
implements Set<V> {
    TreeMap<Long, V> insertPosToValue = new TreeMap();
    HashMap<K, V> valuesByKey = new HashMap();
    HashMap<K, Long> keyToInsertPos = new HashMap();
    AtomicLong insertCounter = new AtomicLong(0L);
    private final RecordMapper<K, V> mapper;
    private boolean indexOpen = false;

    public MemQuerySetRepository(String name, RecordMapper<K, V> keyMapper) {
        super(null, name, QueryConfig.getConfig());
        this.mapper = keyMapper;
    }

    @Override
    public K getRecordId(V value) {
        return this.mapper.getKey(value);
    }

    @Override
    public V retrieve(K key) throws QueryException {
        return this.valuesByKey.get(key);
    }

    @Override
    public Iterable<V> retrieve(long startSeqNo, long endSeqNo) throws QueryException {
        return this.insertPosToValue.subMap(startSeqNo, true, endSeqNo, true).values();
    }

    @Override
    public int size() {
        return this.valuesByKey.size();
    }

    @Override
    public boolean isEmpty() {
        return this.valuesByKey.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.valuesByKey.values().contains(o);
    }

    @Override
    public Iterator<V> iterator() {
        return this.valuesByKey.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.valuesByKey.values().toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.valuesByKey.values().toArray(a);
    }

    @Override
    public synchronized boolean add(V e) {
        long insertPos = this.insertCounter.incrementAndGet();
        K key = this.getRecordId(e);
        if (this.valuesByKey.containsKey(key)) {
            return false;
        }
        this.valuesByKey.put(key, e);
        this.insertPosToValue.put(insertPos, e);
        this.keyToInsertPos.put(key, insertPos);
        try {
            if (this.indexOpen) {
                this.index(e);
                this.commit(insertPos);
            }
        }
        catch (InterruptedException e1) {
            throw new QueryException("Interrupted while indexing");
        }
        return true;
    }

    @Override
    public synchronized boolean remove(Object o) {
        try {
            K key = this.getRecordId((V)o);
            V old = this.valuesByKey.remove(key);
            if (old == null) {
                return false;
            }
            try {
                if (this.indexOpen) {
                    this.removeIndexing(old);
                    this.commit(this.insertCounter.get());
                }
            }
            catch (InterruptedException e1) {
                throw new RuntimeException("Interrupted while indexing");
            }
            long oldPos = this.keyToInsertPos.get(key);
            this.insertPosToValue.remove(oldPos);
        }
        catch (ClassCastException cce) {
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.valuesByKey.values().containsAll(c);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends V> c) {
        boolean changed = false;
        for (V v : c) {
            changed |= this.add(v);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    public synchronized void clear() {
        for (V v : this) {
            this.remove(v);
        }
    }

    @Override
    public synchronized void open() throws Exception {
        super.open();
        if (!this.insertPosToValue.isEmpty()) {
            for (Map.Entry<Long, V> entry : this.insertPosToValue.entrySet()) {
                this.index(entry.getValue());
            }
            this.commit(this.insertPosToValue.lastKey());
            this.insertCounter.set(this.insertPosToValue.lastKey());
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
    }

    @Override
    public synchronized void flushIndexing() throws QueryException {
    }

    @Override
    public synchronized void stopIndexing() throws QueryException {
        this.indexOpen = false;
    }

    @Override
    public synchronized void startIndexing(long fromPos) throws QueryException {
        this.indexOpen = true;
        int i = 0;
        for (Map.Entry<Long, V> entry : this.insertPosToValue.entrySet()) {
            try {
                this.index(entry.getValue());
                if (++i % 1000 != 0) continue;
                this.commit(entry.getKey());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new QueryException("Interrupted during reindex");
            }
        }
        if (!this.insertPosToValue.isEmpty()) {
            try {
                this.commit(this.insertPosToValue.lastKey());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new QueryException("Interrupted during reindex");
            }
        }
    }

    @Override
    public int getSize() {
        return this.size();
    }

    @Override
    public long getCommitSequence(V record) {
        return this.mapper.getCommitSequenceNumber(record);
    }

    @Override
    public final boolean isLiveIndexingUpToDate() {
        return true;
    }

    @Override
    protected boolean isOrderedRepository() {
        return false;
    }

    public static interface RecordMapper<K, V> {
        public K getKey(V var1);

        public long getCommitSequenceNumber(V var1);
    }
}

