/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.index.test.unit;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.neeve.query.impl.index.IdxNonUniqueTreeIndex;
import com.neeve.query.impl.util.collect.UtlRangeBase;
import com.neeve.test.UnitTest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.junit.Assert;
import org.junit.Test;

public class NonUniqueIndexTest
extends UnitTest {
    @Test
    public void basicTest() {
        TreeSet set = new TreeSet();
        TreeSet<Object> keySet = new TreeSet<Object>();
        IdxNonUniqueTreeIndex<Integer, String> index = new IdxNonUniqueTreeIndex<Integer, String>("test", keySet, set);
        index.put(1, "a");
        index.put(1, "b");
        index.put(2, "c");
        HashSet values = Sets.newHashSet(index.get(1));
        Assert.assertEquals((String)"two values for key:1", (Object)Sets.newHashSet((Object[])new String[]{"a", "b"}), (Object)values);
        values = Sets.newHashSet(index.get(2));
        Assert.assertEquals((String)"one value for key:2", (Object)Sets.newHashSet((Object[])new String[]{"c"}), (Object)values);
        values = Sets.newHashSet();
        Assert.assertEquals((String)"no values for key:3", (Object)Sets.newHashSet(), (Object)values);
    }

    private <T> List<T> getValues(Iterable<T> rangeResult) {
        ArrayList values = Lists.newArrayList();
        for (T value : rangeResult) {
            values.add(value);
        }
        return values;
    }

    @Test
    public void testRange() {
        TreeSet set = new TreeSet();
        TreeSet<Object> keySet = new TreeSet<Object>();
        IdxNonUniqueTreeIndex<Integer, String> index = new IdxNonUniqueTreeIndex<Integer, String>("test", keySet, set);
        index.put(1, "a");
        index.put(1, "b");
        index.put(2, "c");
        index.put(2, "d");
        index.put(3, "e");
        index.put(3, "f");
        index.put(4, "g");
        index.put(4, "h");
        UtlRangeBase<Integer> range = new UtlRangeBase<Integer>(2, 3);
        Iterable result = index.getIds(range);
        List values = this.getValues(result);
        Assert.assertEquals((String)"c-f", (Object)Lists.newArrayList((Object[])new String[]{"c", "d", "e", "f"}), values);
        range.setIncludeStart(false);
        result = index.getIds(range);
        values = this.getValues(result);
        Assert.assertEquals((String)"e-f", (Object)Lists.newArrayList((Object[])new String[]{"e", "f"}), values);
        range.setIncludeEnd(false);
        result = index.getIds(range);
        values = this.getValues(result);
        Assert.assertEquals((String)"empty", (Object)Lists.newArrayList(), values);
        range = new UtlRangeBase<Integer>(null, 2);
        result = index.getIds(range);
        values = this.getValues(result);
        Assert.assertEquals((String)"a-d", (Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d"}), values);
        range.setIncludeEnd(false);
        result = index.getIds(range);
        values = this.getValues(result);
        Assert.assertEquals((String)"a-b", (Object)Lists.newArrayList((Object[])new String[]{"a", "b"}), values);
        range = new UtlRangeBase<Object>(3, null);
        result = index.getIds(range);
        values = this.getValues(result);
        Assert.assertEquals((String)"e-h", (Object)Lists.newArrayList((Object[])new String[]{"e", "f", "g", "h"}), values);
        range.setIncludeStart(false);
        result = index.getIds(range);
        values = this.getValues(result);
        Assert.assertEquals((String)"g-h", (Object)Lists.newArrayList((Object[])new String[]{"g", "h"}), values);
    }

    @Test
    public void testCardinality() {
        TreeSet set = new TreeSet();
        TreeSet<Object> keySet = new TreeSet<Object>();
        IdxNonUniqueTreeIndex<Integer, String> index = new IdxNonUniqueTreeIndex<Integer, String>("test", keySet, set);
        int keySize = 10000;
        int size = 10000;
        for (int i = 0; i < size; ++i) {
            index.put(i % keySize, "data:" + i);
        }
        Assert.assertEquals((String)"wrong value card", (long)size, (long)index.getStats().getCardinality());
        Assert.assertEquals((String)"wrong key cardinality", (long)keySize, (long)index.getStats().getKeyCardinality());
    }
}

