/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.query.impl.index.test.unit;

import java.io.Serializable;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class MapdbTest {
    private int testSize = 10000;

    private DB createDb() {
        DB db = DBMaker.newTempFileDB().asyncWriteEnable().asyncWriteFlushDelay(5).mmapFileEnable().transactionDisable().deleteFilesAfterClose().closeOnJvmShutdown().make();
        return db;
    }

    private <K, V> Map<K, V> createMap(DB db, String name) {
        return db.createHashMap(name).makeOrGet();
    }

    @Test
    public void testMapInsert() {
        DB db = this.createDb();
        Map<String, Counter> map = this.createMap(db, "insertMap");
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.testSize; ++i) {
            map.put(String.valueOf(i), new Counter(i));
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("Insert: " + this.testSize + " in " + millis + "ms, " + (long)this.testSize / millis + "/ms");
        db.close();
    }

    @Test
    public void testMapUpdate() {
        DB db = this.createDb();
        Map<String, Counter> map = this.createMap(db, "insertMap");
        String key = "counter";
        map.put(key, new Counter());
        long start = System.currentTimeMillis();
        for (int i = 0; i < this.testSize; ++i) {
            Counter counter = (Counter)map.get(key);
            counter.count();
            map.put(key, counter);
        }
        long millis = System.currentTimeMillis() - start;
        System.out.println("Update: " + this.testSize + " in " + millis + "ms, " + (long)this.testSize / millis + "/ms");
        Assert.assertEquals((String)"counted inaccurately", (long)this.testSize, (long)((Counter)map.get(key)).getValue());
        db.close();
    }

    private static class Counter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        int count = 0;

        public Counter() {
        }

        public Counter(int startingValue) {
            this.count = startingValue;
        }

        public void count() {
            ++this.count;
        }

        public int getValue() {
            return this.count;
        }
    }
}

