/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util.test.unit;

import com.neeve.test.UnitTest;
import com.neeve.util.UtlUnit;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class UtlUnitTest
extends UnitTest {
    @Test
    public void testDaysUnitConversion() {
        Assert.assertEquals((double)1.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.DAYS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)1.5, (double)UtlUnit.convertDuration(1.5, TimeUnit.DAYS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)24.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.DAYS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)36.0, (double)UtlUnit.convertDuration(1.5, TimeUnit.DAYS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)1440.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.DAYS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)2160.0, (double)UtlUnit.convertDuration(1.5, TimeUnit.DAYS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)86400.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.DAYS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)129600.0, (double)UtlUnit.convertDuration(1.5, TimeUnit.DAYS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)8.64E7, (double)UtlUnit.convertDuration(1.0, TimeUnit.DAYS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)1.296E8, (double)UtlUnit.convertDuration(1.5, TimeUnit.DAYS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)8.64E10, (double)UtlUnit.convertDuration(1.0, TimeUnit.DAYS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)1.296E11, (double)UtlUnit.convertDuration(1.5, TimeUnit.DAYS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)8.64E13, (double)UtlUnit.convertDuration(1.0, TimeUnit.DAYS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)1.296E14, (double)UtlUnit.convertDuration(1.5, TimeUnit.DAYS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)0.5, (double)UtlUnit.convertDuration(0.5, TimeUnit.DAYS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)0.75, (double)UtlUnit.convertDuration(0.75, TimeUnit.DAYS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)12.0, (double)UtlUnit.convertDuration(0.5, TimeUnit.DAYS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)18.0, (double)UtlUnit.convertDuration(0.75, TimeUnit.DAYS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)720.0, (double)UtlUnit.convertDuration(0.5, TimeUnit.DAYS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)1080.0, (double)UtlUnit.convertDuration(0.75, TimeUnit.DAYS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)43200.0, (double)UtlUnit.convertDuration(0.5, TimeUnit.DAYS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)64800.0, (double)UtlUnit.convertDuration(0.75, TimeUnit.DAYS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)4.32E7, (double)UtlUnit.convertDuration(0.5, TimeUnit.DAYS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)6.48E7, (double)UtlUnit.convertDuration(0.75, TimeUnit.DAYS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)4.32E10, (double)UtlUnit.convertDuration(0.5, TimeUnit.DAYS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)6.48E10, (double)UtlUnit.convertDuration(0.75, TimeUnit.DAYS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)4.32E13, (double)UtlUnit.convertDuration(0.5, TimeUnit.DAYS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)6.48E13, (double)UtlUnit.convertDuration(0.75, TimeUnit.DAYS, TimeUnit.NANOSECONDS), (double)0.0);
    }

    @Test
    public void testHoursUnitConversion() {
        Assert.assertEquals((double)0.041666666666666664, (double)UtlUnit.convertDuration(1.0, TimeUnit.HOURS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)0.0625, (double)UtlUnit.convertDuration(1.5, TimeUnit.HOURS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)1.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.HOURS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)1.5, (double)UtlUnit.convertDuration(1.5, TimeUnit.HOURS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)60.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.HOURS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)90.0, (double)UtlUnit.convertDuration(1.5, TimeUnit.HOURS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)3600.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.HOURS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)5400.0, (double)UtlUnit.convertDuration(1.5, TimeUnit.HOURS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)3600000.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.HOURS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)5400000.0, (double)UtlUnit.convertDuration(1.5, TimeUnit.HOURS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)3.6E9, (double)UtlUnit.convertDuration(1.0, TimeUnit.HOURS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)5.4E9, (double)UtlUnit.convertDuration(1.5, TimeUnit.HOURS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)3.6E12, (double)UtlUnit.convertDuration(1.0, TimeUnit.HOURS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)5.4E12, (double)UtlUnit.convertDuration(1.5, TimeUnit.HOURS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)0.020833333333333332, (double)UtlUnit.convertDuration(0.5, TimeUnit.HOURS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)0.03125, (double)UtlUnit.convertDuration(0.75, TimeUnit.HOURS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)0.5, (double)UtlUnit.convertDuration(0.5, TimeUnit.HOURS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)0.75, (double)UtlUnit.convertDuration(0.75, TimeUnit.HOURS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)30.0, (double)UtlUnit.convertDuration(0.5, TimeUnit.HOURS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)45.0, (double)UtlUnit.convertDuration(0.75, TimeUnit.HOURS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)1800.0, (double)UtlUnit.convertDuration(0.5, TimeUnit.HOURS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)2700.0, (double)UtlUnit.convertDuration(0.75, TimeUnit.HOURS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)1800000.0, (double)UtlUnit.convertDuration(0.5, TimeUnit.HOURS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)2700000.0, (double)UtlUnit.convertDuration(0.75, TimeUnit.HOURS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)1.8E9, (double)UtlUnit.convertDuration(0.5, TimeUnit.HOURS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)2.7E9, (double)UtlUnit.convertDuration(0.75, TimeUnit.HOURS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)1.8E12, (double)UtlUnit.convertDuration(0.5, TimeUnit.HOURS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)2.7E12, (double)UtlUnit.convertDuration(0.75, TimeUnit.HOURS, TimeUnit.NANOSECONDS), (double)0.0);
    }

    @Test
    public void testMinuesUnitConversion() {
        Assert.assertEquals((double)6.944444444444444E-4, (double)UtlUnit.convertDuration(1.0, TimeUnit.MINUTES, TimeUnit.DAYS), (double)1.0E-6);
        Assert.assertEquals((double)0.0010416666666666667, (double)UtlUnit.convertDuration(1.5, TimeUnit.MINUTES, TimeUnit.DAYS), (double)1.0E-6);
        Assert.assertEquals((double)0.016666666666666666, (double)UtlUnit.convertDuration(1.0, TimeUnit.MINUTES, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)0.025, (double)UtlUnit.convertDuration(1.5, TimeUnit.MINUTES, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)1.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.MINUTES, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)1.5, (double)UtlUnit.convertDuration(1.5, TimeUnit.MINUTES, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)60.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.MINUTES, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)90.0, (double)UtlUnit.convertDuration(1.5, TimeUnit.MINUTES, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)60000.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.MINUTES, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)90000.0, (double)UtlUnit.convertDuration(1.5, TimeUnit.MINUTES, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)6.0E7, (double)UtlUnit.convertDuration(1.0, TimeUnit.MINUTES, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)9.0E7, (double)UtlUnit.convertDuration(1.5, TimeUnit.MINUTES, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)6.0E10, (double)UtlUnit.convertDuration(1.0, TimeUnit.MINUTES, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)9.0E10, (double)UtlUnit.convertDuration(1.5, TimeUnit.MINUTES, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)3.472222222222222E-4, (double)UtlUnit.convertDuration(0.5, TimeUnit.MINUTES, TimeUnit.DAYS), (double)0.001);
        Assert.assertEquals((double)5.208333333333333E-4, (double)UtlUnit.convertDuration(0.75, TimeUnit.MINUTES, TimeUnit.DAYS), (double)0.001);
        Assert.assertEquals((double)0.008333333333333333, (double)UtlUnit.convertDuration(0.5, TimeUnit.MINUTES, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)0.0125, (double)UtlUnit.convertDuration(0.75, TimeUnit.MINUTES, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)0.5, (double)UtlUnit.convertDuration(0.5, TimeUnit.MINUTES, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)0.75, (double)UtlUnit.convertDuration(0.75, TimeUnit.MINUTES, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)30.0, (double)UtlUnit.convertDuration(0.5, TimeUnit.MINUTES, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)45.0, (double)UtlUnit.convertDuration(0.75, TimeUnit.MINUTES, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)30000.0, (double)UtlUnit.convertDuration(0.5, TimeUnit.MINUTES, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)45000.0, (double)UtlUnit.convertDuration(0.75, TimeUnit.MINUTES, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)3.0E7, (double)UtlUnit.convertDuration(0.5, TimeUnit.MINUTES, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)4.5E7, (double)UtlUnit.convertDuration(0.75, TimeUnit.MINUTES, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)3.0E10, (double)UtlUnit.convertDuration(0.5, TimeUnit.MINUTES, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)4.5E10, (double)UtlUnit.convertDuration(0.75, TimeUnit.MINUTES, TimeUnit.NANOSECONDS), (double)0.0);
    }

    @Test
    public void testSecondsUnitConversion() {
        Assert.assertEquals((double)1.1574074074074073E-5, (double)UtlUnit.convertDuration(1.0, TimeUnit.SECONDS, TimeUnit.DAYS), (double)1.0E-6);
        Assert.assertEquals((double)1.736111111111111E-5, (double)UtlUnit.convertDuration(1.5, TimeUnit.SECONDS, TimeUnit.DAYS), (double)1.0E-6);
        Assert.assertEquals((double)2.777777777777778E-4, (double)UtlUnit.convertDuration(1.0, TimeUnit.SECONDS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)4.166666666666667E-4, (double)UtlUnit.convertDuration(1.5, TimeUnit.SECONDS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)0.016666666666666666, (double)UtlUnit.convertDuration(1.0, TimeUnit.SECONDS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)0.025, (double)UtlUnit.convertDuration(1.5, TimeUnit.SECONDS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)1.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.SECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)1.5, (double)UtlUnit.convertDuration(1.5, TimeUnit.SECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)1000.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.SECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)1500.0, (double)UtlUnit.convertDuration(1.5, TimeUnit.SECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)1000000.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.SECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)1500000.0, (double)UtlUnit.convertDuration(1.5, TimeUnit.SECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)1.0E9, (double)UtlUnit.convertDuration(1.0, TimeUnit.SECONDS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)1.5E9, (double)UtlUnit.convertDuration(1.5, TimeUnit.SECONDS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)5.787037037037037E-6, (double)UtlUnit.convertDuration(0.5, TimeUnit.SECONDS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)8.680555555555556E-6, (double)UtlUnit.convertDuration(0.75, TimeUnit.SECONDS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)1.388888888888889E-4, (double)UtlUnit.convertDuration(0.5, TimeUnit.SECONDS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)2.0833333333333335E-4, (double)UtlUnit.convertDuration(0.75, TimeUnit.SECONDS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)0.008333333333333333, (double)UtlUnit.convertDuration(0.5, TimeUnit.SECONDS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)0.0125, (double)UtlUnit.convertDuration(0.75, TimeUnit.SECONDS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)0.5, (double)UtlUnit.convertDuration(0.5, TimeUnit.SECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)0.75, (double)UtlUnit.convertDuration(0.75, TimeUnit.SECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)500.0, (double)UtlUnit.convertDuration(0.5, TimeUnit.SECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)750.0, (double)UtlUnit.convertDuration(0.75, TimeUnit.SECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)500000.0, (double)UtlUnit.convertDuration(0.5, TimeUnit.SECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)750000.0, (double)UtlUnit.convertDuration(0.75, TimeUnit.SECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)5.0E8, (double)UtlUnit.convertDuration(0.5, TimeUnit.SECONDS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)7.5E8, (double)UtlUnit.convertDuration(0.75, TimeUnit.SECONDS, TimeUnit.NANOSECONDS), (double)0.0);
    }

    @Test
    public void testMillisecondsUnitConversion() {
        Assert.assertEquals((double)1.1574074074074074E-8, (double)UtlUnit.convertDuration(1.0, TimeUnit.MILLISECONDS, TimeUnit.DAYS), (double)1.0E-6);
        Assert.assertEquals((double)1.736111111111111E-8, (double)UtlUnit.convertDuration(1.5, TimeUnit.MILLISECONDS, TimeUnit.DAYS), (double)1.0E-6);
        Assert.assertEquals((double)2.7777777777777776E-7, (double)UtlUnit.convertDuration(1.0, TimeUnit.MILLISECONDS, TimeUnit.HOURS), (double)1.0E-6);
        Assert.assertEquals((double)4.166666666666667E-7, (double)UtlUnit.convertDuration(1.5, TimeUnit.MILLISECONDS, TimeUnit.HOURS), (double)1.0E-6);
        Assert.assertEquals((double)1.6666666666666667E-5, (double)UtlUnit.convertDuration(1.0, TimeUnit.MILLISECONDS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)2.5E-5, (double)UtlUnit.convertDuration(1.5, TimeUnit.MILLISECONDS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)0.001, (double)UtlUnit.convertDuration(1.0, TimeUnit.MILLISECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)0.0015, (double)UtlUnit.convertDuration(1.5, TimeUnit.MILLISECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)1.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)1.5, (double)UtlUnit.convertDuration(1.5, TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)1000.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)1500.0, (double)UtlUnit.convertDuration(1.5, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)1000000.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.MILLISECONDS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)1500000.0, (double)UtlUnit.convertDuration(1.5, TimeUnit.MILLISECONDS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)5.787037037037037E-9, (double)UtlUnit.convertDuration(0.5, TimeUnit.MILLISECONDS, TimeUnit.DAYS), (double)1.0E-6);
        Assert.assertEquals((double)8.680555555555555E-9, (double)UtlUnit.convertDuration(0.75, TimeUnit.MILLISECONDS, TimeUnit.DAYS), (double)1.0E-6);
        Assert.assertEquals((double)1.3888888888888888E-7, (double)UtlUnit.convertDuration(0.5, TimeUnit.MILLISECONDS, TimeUnit.HOURS), (double)1.0E-6);
        Assert.assertEquals((double)2.0833333333333336E-7, (double)UtlUnit.convertDuration(0.75, TimeUnit.MILLISECONDS, TimeUnit.HOURS), (double)1.0E-6);
        Assert.assertEquals((double)8.333333333333334E-6, (double)UtlUnit.convertDuration(0.5, TimeUnit.MILLISECONDS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)1.25E-5, (double)UtlUnit.convertDuration(0.75, TimeUnit.MILLISECONDS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)5.0E-4, (double)UtlUnit.convertDuration(0.5, TimeUnit.MILLISECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)7.5E-4, (double)UtlUnit.convertDuration(0.75, TimeUnit.MILLISECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)0.5, (double)UtlUnit.convertDuration(0.5, TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)0.75, (double)UtlUnit.convertDuration(0.75, TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)500.0, (double)UtlUnit.convertDuration(0.5, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)750.0, (double)UtlUnit.convertDuration(0.75, TimeUnit.MILLISECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)500000.0, (double)UtlUnit.convertDuration(0.5, TimeUnit.MILLISECONDS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)750000.0, (double)UtlUnit.convertDuration(0.75, TimeUnit.MILLISECONDS, TimeUnit.NANOSECONDS), (double)0.0);
    }

    @Test
    public void testMicrosecondsUnitConversion() {
        Assert.assertEquals((double)1.1574074074074074E-11, (double)UtlUnit.convertDuration(1.0, TimeUnit.MICROSECONDS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)1.736111111111111E-11, (double)UtlUnit.convertDuration(1.5, TimeUnit.MICROSECONDS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)2.7777777777777777E-10, (double)UtlUnit.convertDuration(1.0, TimeUnit.MICROSECONDS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)4.1666666666666673E-10, (double)UtlUnit.convertDuration(1.5, TimeUnit.MICROSECONDS, TimeUnit.HOURS), (double)1.0E-10);
        Assert.assertEquals((double)1.6666666666666667E-8, (double)UtlUnit.convertDuration(1.0, TimeUnit.MICROSECONDS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)2.5000000000000002E-8, (double)UtlUnit.convertDuration(1.5, TimeUnit.MICROSECONDS, TimeUnit.MINUTES), (double)1.0E-10);
        Assert.assertEquals((double)1.0E-6, (double)UtlUnit.convertDuration(1.0, TimeUnit.MICROSECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)1.5E-6, (double)UtlUnit.convertDuration(1.5, TimeUnit.MICROSECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)0.001, (double)UtlUnit.convertDuration(1.0, TimeUnit.MICROSECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)0.0015, (double)UtlUnit.convertDuration(1.5, TimeUnit.MICROSECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)1.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.MICROSECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)1.5, (double)UtlUnit.convertDuration(1.5, TimeUnit.MICROSECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)1000.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)1500.0, (double)UtlUnit.convertDuration(1.5, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)5.787037037037037E-12, (double)UtlUnit.convertDuration(0.5, TimeUnit.MICROSECONDS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)8.680555555555555E-12, (double)UtlUnit.convertDuration(0.75, TimeUnit.MICROSECONDS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)1.3888888888888888E-10, (double)UtlUnit.convertDuration(0.5, TimeUnit.MICROSECONDS, TimeUnit.HOURS), (double)0.0);
        Assert.assertEquals((double)2.0833333333333336E-10, (double)UtlUnit.convertDuration(0.75, TimeUnit.MICROSECONDS, TimeUnit.HOURS), (double)1.0E-10);
        Assert.assertEquals((double)8.333333333333334E-9, (double)UtlUnit.convertDuration(0.5, TimeUnit.MICROSECONDS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)1.2500000000000001E-8, (double)UtlUnit.convertDuration(0.75, TimeUnit.MICROSECONDS, TimeUnit.MINUTES), (double)1.0E-10);
        Assert.assertEquals((double)5.0E-7, (double)UtlUnit.convertDuration(0.5, TimeUnit.MICROSECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)7.5E-7, (double)UtlUnit.convertDuration(0.75, TimeUnit.MICROSECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)5.0E-4, (double)UtlUnit.convertDuration(0.5, TimeUnit.MICROSECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)7.5E-4, (double)UtlUnit.convertDuration(0.75, TimeUnit.MICROSECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)0.5, (double)UtlUnit.convertDuration(0.5, TimeUnit.MICROSECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)0.75, (double)UtlUnit.convertDuration(0.75, TimeUnit.MICROSECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)500.0, (double)UtlUnit.convertDuration(0.5, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)750.0, (double)UtlUnit.convertDuration(0.75, TimeUnit.MICROSECONDS, TimeUnit.NANOSECONDS), (double)0.0);
    }

    @Test
    public void testNanosecondUnitConversion() {
        Assert.assertEquals((double)1.1574074074074074E-14, (double)UtlUnit.convertDuration(1.0, TimeUnit.NANOSECONDS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)1.736111111111111E-14, (double)UtlUnit.convertDuration(1.5, TimeUnit.NANOSECONDS, TimeUnit.DAYS), (double)1.0E-10);
        Assert.assertEquals((double)2.7777777777777774E-13, (double)UtlUnit.convertDuration(1.0, TimeUnit.NANOSECONDS, TimeUnit.HOURS), (double)1.0E-10);
        Assert.assertEquals((double)4.1666666666666674E-13, (double)UtlUnit.convertDuration(1.5, TimeUnit.NANOSECONDS, TimeUnit.HOURS), (double)1.0E-10);
        Assert.assertEquals((double)1.6666666666666667E-11, (double)UtlUnit.convertDuration(1.0, TimeUnit.NANOSECONDS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)2.5E-11, (double)UtlUnit.convertDuration(1.5, TimeUnit.NANOSECONDS, TimeUnit.MINUTES), (double)1.0E-10);
        Assert.assertEquals((double)9.999999999999999E-10, (double)UtlUnit.convertDuration(1.0, TimeUnit.NANOSECONDS, TimeUnit.SECONDS), (double)1.0E-10);
        Assert.assertEquals((double)1.5E-9, (double)UtlUnit.convertDuration(1.5, TimeUnit.NANOSECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)1.0E-6, (double)UtlUnit.convertDuration(1.0, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)1.5E-6, (double)UtlUnit.convertDuration(1.5, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)0.001, (double)UtlUnit.convertDuration(1.0, TimeUnit.NANOSECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)0.0015, (double)UtlUnit.convertDuration(1.5, TimeUnit.NANOSECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)1.0, (double)UtlUnit.convertDuration(1.0, TimeUnit.NANOSECONDS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)1.5, (double)UtlUnit.convertDuration(1.5, TimeUnit.NANOSECONDS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)5.787037037037037E-15, (double)UtlUnit.convertDuration(0.5, TimeUnit.NANOSECONDS, TimeUnit.DAYS), (double)0.0);
        Assert.assertEquals((double)8.680555555555555E-15, (double)UtlUnit.convertDuration(0.75, TimeUnit.NANOSECONDS, TimeUnit.DAYS), (double)1.0E-10);
        Assert.assertEquals((double)1.3888888888888887E-13, (double)UtlUnit.convertDuration(0.5, TimeUnit.NANOSECONDS, TimeUnit.HOURS), (double)1.0E-10);
        Assert.assertEquals((double)2.0833333333333337E-13, (double)UtlUnit.convertDuration(0.75, TimeUnit.NANOSECONDS, TimeUnit.HOURS), (double)1.0E-10);
        Assert.assertEquals((double)8.333333333333334E-12, (double)UtlUnit.convertDuration(0.5, TimeUnit.NANOSECONDS, TimeUnit.MINUTES), (double)0.0);
        Assert.assertEquals((double)1.25E-11, (double)UtlUnit.convertDuration(0.75, TimeUnit.NANOSECONDS, TimeUnit.MINUTES), (double)1.0E-10);
        Assert.assertEquals((double)4.999999999999999E-10, (double)UtlUnit.convertDuration(0.5, TimeUnit.NANOSECONDS, TimeUnit.SECONDS), (double)1.0E-10);
        Assert.assertEquals((double)7.5E-10, (double)UtlUnit.convertDuration(0.75, TimeUnit.NANOSECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)5.0E-7, (double)UtlUnit.convertDuration(0.5, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)7.5E-7, (double)UtlUnit.convertDuration(0.75, TimeUnit.NANOSECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)5.0E-4, (double)UtlUnit.convertDuration(0.5, TimeUnit.NANOSECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)7.5E-4, (double)UtlUnit.convertDuration(0.75, TimeUnit.NANOSECONDS, TimeUnit.MICROSECONDS), (double)0.0);
        Assert.assertEquals((double)0.5, (double)UtlUnit.convertDuration(0.5, TimeUnit.NANOSECONDS, TimeUnit.NANOSECONDS), (double)0.0);
        Assert.assertEquals((double)0.75, (double)UtlUnit.convertDuration(0.75, TimeUnit.NANOSECONDS, TimeUnit.NANOSECONDS), (double)0.0);
    }

    @Test
    public void testDurationParsing() {
        try {
            UtlUnit.parseDuration(null, TimeUnit.SECONDS, TimeUnit.SECONDS);
            Assert.fail((String)"Should not be able to parse null duration");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Got expected exception: " + e.getMessage());
        }
        try {
            UtlUnit.parseDuration(null, TimeUnit.SECONDS, null);
            Assert.fail((String)"Should not be able to parse duration with null target unit");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Got expected exception: " + e.getMessage());
        }
        try {
            UtlUnit.parseDuration("", TimeUnit.SECONDS, TimeUnit.SECONDS);
            Assert.fail((String)"Should not be able to parse an empty duration");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Got expected exception: " + e.getMessage());
        }
        try {
            UtlUnit.parseDuration("1 qs", TimeUnit.SECONDS, TimeUnit.SECONDS);
            Assert.fail((String)"Should not be able to parse a duration without an invalid timeunit");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Got expected exception: " + e.getMessage());
        }
        try {
            UtlUnit.parseDuration("1", null, TimeUnit.SECONDS);
            Assert.fail((String)"Should not be able to parse a duration with no duration unit and no default duration specified");
        }
        catch (IllegalArgumentException e) {
            System.out.println("Got expected exception: " + e.getMessage());
        }
        Assert.assertEquals((double)1.0, (double)UtlUnit.parseDuration("1", TimeUnit.SECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)0.001, (double)UtlUnit.parseDuration("1", TimeUnit.MILLISECONDS, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)1000.0, (double)UtlUnit.parseDuration("1s", TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)1000.0, (double)UtlUnit.parseDuration("1s", null, TimeUnit.MILLISECONDS), (double)0.0);
        Assert.assertEquals((double)60.0, (double)UtlUnit.parseDuration("1m", null, TimeUnit.SECONDS), (double)0.0);
        Assert.assertEquals((double)60.0, (double)UtlUnit.parseDuration("1 minute", null, TimeUnit.SECONDS), (double)0.0);
    }

    @Test
    public void testBytesStringConversion() {
        try {
            UtlUnit.toNumBytes("");
            Assert.fail((String)"Should not be able to parse empty byte string");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.assertEquals((long)-1L, (long)UtlUnit.toNumBytes("-1"));
        Assert.assertEquals((long)1L, (long)UtlUnit.toNumBytes("1"));
        Assert.assertEquals((long)-2L, (long)UtlUnit.toNumBytes("-2b"));
        Assert.assertEquals((long)1L, (long)UtlUnit.toNumBytes("1b"));
        Assert.assertEquals((long)1L, (long)UtlUnit.toNumBytes("1B"));
        Assert.assertEquals((long)1L, (long)UtlUnit.toNumBytes("1 b"));
        Assert.assertEquals((long)1L, (long)UtlUnit.toNumBytes("1 B"));
        Assert.assertEquals((long)1L, (long)UtlUnit.toNumBytes("1 Byte"));
        Assert.assertEquals((long)1L, (long)UtlUnit.toNumBytes("1 bYte"));
        Assert.assertEquals((long)-1024L, (long)((int)UtlUnit.parseBytes("-1", UtlUnit.ByteUnit.Kilobytes, UtlUnit.ByteUnit.Bytes)));
        Assert.assertEquals((long)1024L, (long)((int)UtlUnit.parseBytes("1", UtlUnit.ByteUnit.Kilobytes, UtlUnit.ByteUnit.Bytes)));
        Assert.assertEquals((long)-1L, (long)((int)UtlUnit.parseBytes("-1b", UtlUnit.ByteUnit.Kilobytes, UtlUnit.ByteUnit.Bytes)));
        Assert.assertEquals((long)1L, (long)((int)UtlUnit.parseBytes("1b", UtlUnit.ByteUnit.Kilobytes, UtlUnit.ByteUnit.Bytes)));
        Assert.assertEquals((long)1000000L, (long)UtlUnit.toNumBytes("1,000,000B"));
        Assert.assertEquals((long)1536L, (long)UtlUnit.toNumBytes("1.5kb"));
        Assert.assertEquals((long)0x180000L, (long)UtlUnit.toNumBytes("1.5mb"));
        Assert.assertEquals((long)0x60000000L, (long)UtlUnit.toNumBytes("1.5Gb"));
        Assert.assertEquals((long)0x18000000000L, (long)UtlUnit.toNumBytes("1.5 TB"));
        Assert.assertEquals((long)0x6000000000000L, (long)UtlUnit.toNumBytes("1.5 PB"));
        Assert.assertEquals((long)0L, (long)UtlUnit.toNumBytes(".5 bytes"));
        Assert.assertEquals((long)512L, (long)UtlUnit.toNumBytes(".5 kilobytes"));
        Assert.assertEquals((long)524288L, (long)UtlUnit.toNumBytes(".5 megabytes"));
        Assert.assertEquals((long)0x20000000L, (long)UtlUnit.toNumBytes(".5 gigabytes"));
        Assert.assertEquals((long)0x8000000000L, (long)UtlUnit.toNumBytes(".5 terabytes"));
        Assert.assertEquals((long)0x2000000000000L, (long)UtlUnit.toNumBytes(".5 petabytes"));
    }
}

