/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util.test.unit;

import com.neeve.util.UtlGovernor;
import java.text.NumberFormat;
import org.junit.Assert;
import org.junit.Test;

public class UtlGovernorTest {
    @Test
    public void testSleeping10PerSecond() {
        UtlGovernor governor = new UtlGovernor(10);
        governor.setWaitStrategy(UtlGovernor.WaitStrategy.Sleep);
        this.testGovernor(governor, 10);
    }

    @Test
    public void testBusySpin10PerSecond() {
        UtlGovernor governor = new UtlGovernor(10);
        governor.setWaitStrategy(UtlGovernor.WaitStrategy.BusySpin);
        this.testGovernor(governor, 10);
    }

    @Test
    public void testYielding10PerSecond() {
        UtlGovernor governor = new UtlGovernor(10);
        governor.setWaitStrategy(UtlGovernor.WaitStrategy.Yield);
        this.testGovernor(governor, 10);
    }

    @Test
    public void testSleeping10000PerSecond() {
        UtlGovernor governor = new UtlGovernor(10000);
        governor.setWaitStrategy(UtlGovernor.WaitStrategy.Sleep);
        this.testGovernor(governor, 10000);
    }

    @Test
    public void testBusySpin10000PerSecond() {
        UtlGovernor governor = new UtlGovernor(10000);
        governor.setWaitStrategy(UtlGovernor.WaitStrategy.BusySpin);
        this.testGovernor(governor, 10000);
    }

    @Test
    public void testYielding10000PerSecond() {
        UtlGovernor governor = new UtlGovernor(10000);
        governor.setWaitStrategy(UtlGovernor.WaitStrategy.Yield);
        this.testGovernor(governor, 10000);
    }

    @Test
    public void testSleeping100000PerSecond() {
        UtlGovernor governor = new UtlGovernor(100000);
        governor.setWaitStrategy(UtlGovernor.WaitStrategy.Sleep);
        this.testGovernor(governor, 100000);
    }

    @Test
    public void testBusySpin100000PerSecond() {
        UtlGovernor governor = new UtlGovernor(100000);
        governor.setWaitStrategy(UtlGovernor.WaitStrategy.BusySpin);
        this.testGovernor(governor, 100000);
    }

    @Test
    public void testYielding100000PerSecond() {
        UtlGovernor governor = new UtlGovernor(100000);
        governor.setWaitStrategy(UtlGovernor.WaitStrategy.Yield);
        this.testGovernor(governor, 100000);
    }

    private void testGovernor(UtlGovernor governor, int rate) {
        long start = System.nanoTime();
        while (System.nanoTime() - start < 1000000000L) {
            governor.blockToNext();
        }
        governor.blockToNext();
        start = System.nanoTime();
        int opCount = 0;
        while (System.nanoTime() - start < 2000000000L) {
            governor.blockToNext();
            ++opCount;
        }
        long end = System.nanoTime();
        double actualRate = (double)opCount / ((double)(end - start) / 1.0E9);
        double diffFromExpected = actualRate - (double)rate;
        NumberFormat format = NumberFormat.getNumberInstance();
        format.setMaximumFractionDigits(2);
        System.out.println("[" + (Object)((Object)governor.getWaitStrategy()) + "] Expected Rate: " + format.format(rate) + " actual: " + format.format(actualRate));
        Assert.assertTrue((String)("Wrong rate achieved " + rate + " (expected " + format.format(rate) + "/sec, but was " + format.format(actualRate) + "/sec)"), (Math.abs(diffFromExpected) < 2.0 ? 1 : 0) != 0);
    }
}

