/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.util;

import com.mdimension.jchronic.Chronic;
import com.mdimension.jchronic.Options;
import com.mdimension.jchronic.tags.Pointer;
import com.mdimension.jchronic.utils.Span;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlText;
import com.neeve.util.UtlTime;
import java.io.File;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Currency;
import java.util.Date;
import java.util.TimeZone;
import java.util.UUID;

public class UtlDataTypes {
    public static final boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        if (targetType == String.class) {
            return true;
        }
        if (String.class.isAssignableFrom(sourceType)) {
            if (Number.class.isAssignableFrom(targetType) || targetType == Byte.TYPE || targetType == Character.TYPE || targetType == Short.TYPE || targetType == Integer.TYPE || targetType == Long.TYPE || targetType == Float.TYPE || targetType == Double.TYPE) {
                return true;
            }
            if (Date.class.isAssignableFrom(targetType)) {
                return true;
            }
            if (Boolean.class.isAssignableFrom(targetType) || targetType == Boolean.TYPE) {
                return true;
            }
            if (Currency.class.isAssignableFrom(targetType)) {
                return true;
            }
            if (BigInteger.class.isAssignableFrom(targetType)) {
                return true;
            }
            if (BigDecimal.class.isAssignableFrom(targetType)) {
                return true;
            }
            if (com.eaio.uuid.UUID.class.isAssignableFrom(targetType)) {
                return true;
            }
            if (UUID.class.isAssignableFrom(targetType)) {
                return true;
            }
            if (File.class.isAssignableFrom(targetType)) {
                return true;
            }
            if (targetType.isEnum()) {
                return true;
            }
        }
        return false;
    }

    public static <T> T convert(Class<T> targetType, Object value) {
        block41: {
            if (value == null || targetType.isAssignableFrom(value.getClass())) {
                return (T)value;
            }
            if (targetType == value.getClass()) {
                return (T)value;
            }
            try {
                if (targetType == String.class) {
                    return (T)value.toString();
                }
                if (value instanceof Number) {
                    return UtlDataTypes.convertNumber(targetType, (Number)value);
                }
                if (targetType == Integer.TYPE || targetType == Integer.class) {
                    return (T)new Integer(value.toString());
                }
                if (targetType == Boolean.TYPE || targetType == Boolean.class) {
                    if (value.toString().equalsIgnoreCase("true")) {
                        return (T)new Boolean(true);
                    }
                    if (value.toString().equalsIgnoreCase("false")) {
                        return (T)new Boolean(false);
                    }
                    break block41;
                }
                if (targetType == Double.TYPE || targetType == Double.class) {
                    return (T)new Double(value.toString());
                }
                if (targetType == Float.TYPE || targetType == Float.class) {
                    return (T)new Float(value.toString());
                }
                if (targetType == Long.TYPE || targetType == Long.class) {
                    try {
                        return (T)new Long(value.toString());
                    }
                    catch (Exception e) {
                        try {
                            Date d = UtlDataTypes.parseAsDate(value);
                            Long millis = d.getTime();
                            return (T)millis;
                        }
                        catch (Exception e2) {
                            throw new IllegalArgumentException("Couldn't parse as long or date");
                        }
                    }
                }
                if (targetType == Byte.TYPE || targetType == Byte.class) {
                    return (T)new Byte(value.toString());
                }
                if (targetType == Short.TYPE || targetType == Short.class) {
                    return (T)new Short(value.toString());
                }
                if (targetType == Currency.class) {
                    return (T)Currency.getInstance(value.toString());
                }
                if (targetType == BigInteger.class) {
                    return (T)new BigInteger(value.toString());
                }
                if (targetType == BigDecimal.class) {
                    return (T)new BigDecimal(value.toString());
                }
                if (targetType == Character.class || targetType == Character.TYPE) {
                    if (value instanceof String) {
                        String string = (String)value;
                        if (UtlText.isNullOrEmpty(string)) {
                            return null;
                        }
                        if (string.length() == 1) {
                            Character ch = Character.valueOf(string.charAt(0));
                            return (T)ch;
                        }
                    }
                    if (value instanceof Character) {
                        return (T)value;
                    }
                    break block41;
                }
                if (targetType == Date.class) {
                    return (T)UtlDataTypes.parseAsDate(value);
                }
                if (targetType == com.eaio.uuid.UUID.class) {
                    return (T)new com.eaio.uuid.UUID((CharSequence)value.toString());
                }
                if (targetType == UUID.class) {
                    return (T)UUID.fromString(value.toString());
                }
                if (targetType == File.class) {
                    return (T)new File(UtlFile.expandPath(String.valueOf(value)));
                }
                if (targetType.isEnum()) {
                    Object[] enumValues = null;
                    try {
                        Method method = targetType.getMethod("values", new Class[0]);
                        method.setAccessible(true);
                        enumValues = (Object[])method.invoke(null, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Unable to convert " + value + " to " + targetType.getSimpleName() + ", can't access enum options", e);
                    }
                    Object val = null;
                    try {
                        val = targetType.getMethod("valueOf", String.class).invoke(null, value);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (val == null) {
                        for (Object enumValue : enumValues) {
                            if (!String.valueOf(enumValue).equalsIgnoreCase(String.valueOf(value))) continue;
                            val = enumValue;
                            break;
                        }
                    }
                    return (T)val;
                }
                if (targetType == Class.class) {
                    return (T)Class.forName((String)value);
                }
            }
            catch (IllegalArgumentException iae) {
                if (iae.getMessage().startsWith("Cannot convert")) {
                    throw iae;
                }
                throw new IllegalArgumentException(UtlDataTypes.createErrorMessage(targetType, value, iae.getMessage()), iae);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(UtlDataTypes.createErrorMessage(targetType, value, e.getMessage()), e);
            }
        }
        throw new IllegalArgumentException(UtlDataTypes.createErrorMessage(targetType, value, null));
    }

    private static boolean hasDecimalValue(Number n) {
        return n.doubleValue() - (double)n.longValue() != 0.0;
    }

    public static <T> T convertNumber(Class<T> targetType, Number num) {
        if (num == null || targetType.isAssignableFrom(num.getClass())) {
            return (T)num;
        }
        Object obj = null;
        if (targetType == Byte.class || targetType == Byte.TYPE) {
            if (!UtlDataTypes.hasDecimalValue(num)) {
                obj = num.byteValue();
            }
        } else if (targetType == Short.class || targetType == Short.TYPE) {
            if (!UtlDataTypes.hasDecimalValue(num)) {
                obj = num.shortValue();
            }
        } else if (targetType == Integer.class || targetType == Integer.TYPE) {
            if (!UtlDataTypes.hasDecimalValue(num)) {
                obj = num.intValue();
            }
        } else if (targetType == Long.class || targetType == Long.TYPE) {
            if (!UtlDataTypes.hasDecimalValue(num)) {
                obj = num.longValue();
            }
        } else if (targetType == Float.class || targetType == Float.TYPE) {
            obj = Float.valueOf(num.floatValue());
        } else if (targetType.equals(Double.class) || targetType.equals(Double.TYPE)) {
            obj = num.doubleValue();
        } else if (targetType == BigInteger.class) {
            if (!UtlDataTypes.hasDecimalValue(num)) {
                long longVal = num.longValue();
                obj = BigInteger.valueOf(longVal);
            }
        } else if (targetType == BigDecimal.class) {
            double doubleVal = num.doubleValue();
            obj = BigDecimal.valueOf(doubleVal);
        } else if (targetType == Character.class || targetType == Character.TYPE) {
            if (!UtlDataTypes.hasDecimalValue(num)) {
                int n = num.intValue();
                obj = Character.valueOf((char)n);
            }
        } else if (targetType == String.class) {
            obj = num.toString();
        } else if (targetType == Date.class) {
            long millis = num.longValue();
            obj = new Date(millis);
        } else if (targetType == Boolean.class || targetType == Boolean.TYPE) {
            obj = num.intValue() != 0;
        } else if (targetType.isEnum()) {
            try {
                Method method = targetType.getMethod("values", new Class[0]);
                method.setAccessible(true);
                Object[] enumArray = (Object[])method.invoke(null, new Object[0]);
                obj = enumArray[num.intValue()];
            }
            catch (Exception e) {
                obj = null;
            }
        }
        if (obj == null) {
            throw new IllegalArgumentException(UtlDataTypes.createErrorMessage(targetType, num, null));
        }
        return (T)obj;
    }

    public static final Date parseAsDate(Object value) throws IllegalArgumentException {
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value.getClass() == Long.TYPE || value.getClass() == Long.class) {
            return new Date((Long)value);
        }
        try {
            String[] tokens = value.toString().trim().split(" ");
            if (tokens.length <= 3 && tokens.length >= 2) {
                Timestamp ts = Timestamp.valueOf(tokens[0] + " " + tokens[1]);
                Calendar c = Calendar.getInstance();
                c.set(1900 + ts.getYear(), ts.getMonth(), ts.getDate(), ts.getHours(), ts.getMinutes(), ts.getSeconds());
                long millis = ts.getNanos() / 1000000;
                c.set(14, (int)millis);
                if (tokens.length > 2) {
                    c.setTimeZone(TimeZone.getTimeZone(tokens[2]));
                }
                return c.getTime();
            }
        }
        catch (IllegalArgumentException e) {
            try {
                return UtlTime.parse(value.toString());
            }
            catch (ParseException ts) {
                // empty catch block
            }
        }
        Options dateParseOptions = new Options();
        dateParseOptions.setContext(Pointer.PointerType.PAST);
        dateParseOptions.setGuess(false);
        dateParseOptions.setAmbiguousTimeRange(1);
        dateParseOptions.setDebug(false);
        Span time = Chronic.parse((String)value.toString(), (Options)dateParseOptions);
        if (time == null) {
            throw new IllegalArgumentException("Can't parse as a date");
        }
        return new Date(time.getBegin() * 1000L);
    }

    private static <T> String createErrorMessage(Class<T> targetType, Object value, String message) {
        return "Cannot convert " + value.getClass().getSimpleName() + " [" + value + "] to " + targetType.getSimpleName() + (message != null && message.length() > 0 ? " (" + message + ")" : "");
    }

    public static String[] getEnumNames(Class<?> enumClass) {
        try {
            if (!enumClass.isEnum()) {
                throw new IllegalArgumentException(enumClass.getName() + " is not an enum.");
            }
            Method valuesMethod = enumClass.getMethod("values", new Class[0]);
            Method nameMethod = enumClass.getMethod("name", new Class[0]);
            valuesMethod.setAccessible(true);
            nameMethod.setAccessible(true);
            Object[] enumArray = (Object[])valuesMethod.invoke(null, new Object[0]);
            String[] rc = new String[enumArray.length];
            for (int i = 0; i < enumArray.length; ++i) {
                rc[i] = (String)nameMethod.invoke(enumArray[i], new Object[0]);
            }
            return rc;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to lookup enum values for " + enumClass.getName() + ": " + e.getMessage());
        }
    }
}

