/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.tools.interactive.commands;

import com.neeve.tools.interactive.commands.IndentingWriter;
import com.neeve.util.UtlFile;
import com.neeve.util.UtlText;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import jline.console.completer.Completer;
import jline.console.completer.EnumCompleter;
import jline.console.completer.FileNameCompleter;
import jline.console.completer.StringsCompleter;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.WordUtils;
import org.fusesource.jansi.Ansi;

public abstract class AnnotatedCommand
extends com.neeve.tools.interactive.commands.Command
implements Completer {
    @Option(shortForm=104, longForm="help", defaultValue="false", required=false, description="Displays this help message")
    public boolean showHelp;
    private static final String NULL = "$NONE$";
    private final CmdLineParser parser = new CmdLineParser();
    private final ArrayList<OptionHandler> optionHandlers = new ArrayList();
    private final HashMap<String, OptionHandler> optionsByShortForm = new HashMap();
    private final HashMap<String, OptionHandler> optionsByLongForm = new HashMap();
    private final ArrayList<ArgumentHandler> argHandlers = new ArrayList();
    private RemainingArgsHandler remaingArgsHandler;
    private final String[] keywords;
    private final String description;
    private StringBuilder usage = null;
    Command command = null;

    protected AnnotatedCommand() {
        this.parseOptionsAndArguments(this.getClass());
        Collections.sort(this.argHandlers);
        try {
            this.command = this.getClass().getAnnotation(Command.class);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(this.getClass().getCanonicalName() + " must be annotated with " + Command.class.getCanonicalName());
        }
        this.keywords = this.command.keywords();
        if (this.keywords == null || this.keywords.length == 0) {
            throw new IllegalArgumentException("keywords cannot be empty");
        }
        this.description = WordUtils.wrap((String)this.command.description(), (int)80, (String)"\n  ", (boolean)false);
    }

    private void parseOptionsAndArguments(Class<?> type) {
        if (type.getSuperclass() != Object.class) {
            this.parseOptionsAndArguments(type.getSuperclass());
        }
        for (Field field : type.getDeclaredFields()) {
            if (field.isAnnotationPresent(Option.class)) {
                field.setAccessible(true);
                Option option = field.getAnnotation(Option.class);
                this.optionHandlers.add(new OptionHandler(field, option));
            }
            if (type != this.getClass()) continue;
            if (field.isAnnotationPresent(Argument.class)) {
                field.setAccessible(true);
                this.argHandlers.add(new ArgumentHandler(field, field.getAnnotation(Argument.class)));
            }
            if (!field.isAnnotationPresent(RemainingArgs.class)) continue;
            field.setAccessible(true);
            this.remaingArgsHandler = new RemainingArgsHandler(field, field.getAnnotation(RemainingArgs.class));
        }
    }

    @Override
    public final void run(String[] args) {
        if (this.command.disabled()) {
            this.console().error("This command is disabled");
            return;
        }
        try {
            int parsedArgs;
            if (this.command.parseOptions()) {
                this.parser.parse(args);
                for (OptionHandler handler : this.optionHandlers) {
                    handler.parseOption();
                }
                args = this.parser.getRemainingArgs();
            } else if (args.length > 0 && (args[0].equals("-h") || args[0].equals("--help"))) {
                this.showHelp = true;
                String[] remaining = new String[args.length - 1];
                if (remaining.length > 0) {
                    System.arraycopy(args, 1, remaining, 0, remaining.length);
                }
                args = remaining;
            }
            if (this.showHelp) {
                this.help(this.console().out());
                this.showHelp = false;
                return;
            }
            if (args.length > this.argHandlers.size() && this.remaingArgsHandler == null) {
                throw new Exception("too many arguments: " + Arrays.asList(args));
            }
            for (parsedArgs = 0; parsedArgs < this.argHandlers.size(); ++parsedArgs) {
                String arg = null;
                if (parsedArgs < args.length) {
                    arg = args[parsedArgs];
                }
                this.argHandlers.get(parsedArgs).parse(arg);
            }
            if (this.remaingArgsHandler != null) {
                if (parsedArgs < args.length) {
                    String[] remainingArgs = new String[args.length - parsedArgs];
                    System.arraycopy(args, parsedArgs, remainingArgs, 0, args.length - parsedArgs);
                    this.remaingArgsHandler.parse(remainingArgs);
                } else {
                    this.remaingArgsHandler.parse(null);
                }
            }
        }
        catch (Exception e) {
            this.console().error("Error parsing command: " + e.getMessage(), e);
            this.help(this.console().err());
            return;
        }
        try {
            this.execute();
        }
        catch (InterruptedException ie) {
            this.error("'" + this.keywords[0] + "' was interrupted");
        }
        catch (Throwable e) {
            this.error("Error executing '" + this.keywords[0] + "': " + e.getMessage(), e);
        }
    }

    public abstract void execute() throws Exception;

    @Override
    public final void help() {
        if (this.command.disabled() || this.command.hidden()) {
            return;
        }
        this.help(this.console().out());
    }

    @Override
    public final boolean hidden() {
        return this.command.hidden();
    }

    public final boolean preserveArgumentQuotes() {
        return this.command.preserveArgumentQuotes();
    }

    @Override
    public final String[] keywords() {
        return this.keywords;
    }

    public void helpHtml(IndentingWriter out) throws IOException {
        out.print("<div class=\"commandDescription\">").print(this.description).println("</div>");
        this.usageHtml(out);
    }

    public void usageHtml(IndentingWriter out) throws IOException {
        if (this.usage == null) {
            StringBuilder optionUsage;
            StringBuilder builder = new StringBuilder();
            builder.append("Usage:\n");
            builder.append("  ").append(this.keywords[0]).append(" ");
            for (OptionHandler optionHandler : this.optionHandlers) {
                if (!optionHandler.option.required()) {
                    builder.append("[");
                }
                builder.append("-").append(optionHandler.option.shortForm());
                if (!optionHandler.option.required()) {
                    builder.append("] ");
                    continue;
                }
                builder.append(" ");
            }
            for (ArgumentHandler argumentHandler : this.argHandlers) {
                if (!argumentHandler.arg.required()) {
                    builder.append("[");
                }
                builder.append("<").append(argumentHandler.arg.name()).append(">");
                if (!argumentHandler.arg.required()) {
                    builder.append("] ");
                    continue;
                }
                builder.append(" ");
            }
            builder.append("\n\n");
            String optionIndent = "       ";
            String string = "           ";
            if (!this.optionHandlers.isEmpty()) {
                for (OptionHandler optionHandler : this.optionHandlers) {
                    optionUsage = new StringBuilder();
                    optionHandler.appendUsage(optionUsage);
                    builder.append(optionIndent).append(WordUtils.wrap((String)optionUsage.toString(), (int)68, (String)("\n" + string), (boolean)false)).append("\n");
                }
            }
            if (!this.argHandlers.isEmpty()) {
                for (ArgumentHandler argumentHandler : this.argHandlers) {
                    optionUsage = new StringBuilder();
                    argumentHandler.appendUsage(optionUsage);
                    builder.append(optionIndent).append(WordUtils.wrap((String)optionUsage.toString(), (int)68, (String)("\n" + string), (boolean)false)).append("\n");
                }
            }
            if (this.remaingArgsHandler != null) {
                StringBuilder optionUsage2 = new StringBuilder();
                this.remaingArgsHandler.appendUsage(optionUsage2);
                builder.append(optionIndent).append(WordUtils.wrap((String)optionUsage2.toString(), (int)68, (String)("\n" + string), (boolean)false)).append("\n");
            }
            this.usage = builder;
        }
        out.println("<div class=\"preformatted panel\" style=\"border-width: 1px;\">").indent();
        out.println("<div class=\"preformattedContent panelContent\">").indent();
        out.println("<pre>").indent();
        out.println(StringEscapeUtils.escapeHtml((String)this.usage.toString()), true);
        out.deindent().println("</pre>");
        out.deindent().println("</div>");
        out.deindent().println("</div>");
    }

    public final void help(PrintStream out) {
        if (Ansi.isEnabled()) {
            if (out == this.console().out()) {
                out.print(Ansi.ansi().fg(Ansi.Color.GREEN));
            } else if (out == this.console().err()) {
                out.print(Ansi.ansi().fg(Ansi.Color.RED));
            }
            out.flush();
        }
        if (this.keywords.length > 1) {
            boolean first = true;
            for (String keyword : this.keywords) {
                if (!first) {
                    out.print(" | ");
                } else {
                    first = false;
                }
                out.print(keyword);
            }
            out.println();
        } else {
            out.println(this.keywords[0]);
        }
        out.println("  " + this.description);
        out.flush();
        this.usage(out);
        if (Ansi.isEnabled() && (out == this.console().out() || out == this.console().err())) {
            out.flush();
            out.print(Ansi.ansi().reset());
            out.flush();
        }
    }

    public void usage(PrintStream out) {
        if (this.usage == null) {
            StringBuilder optionUsage;
            StringBuilder builder = new StringBuilder();
            builder.append("Usage:\n");
            builder.append("  ").append(this.keywords[0]).append(" ");
            for (OptionHandler optionHandler : this.optionHandlers) {
                if (!optionHandler.option.required()) {
                    builder.append("[");
                }
                builder.append("-").append(optionHandler.option.shortForm());
                if (!optionHandler.option.required()) {
                    builder.append("] ");
                    continue;
                }
                builder.append(" ");
            }
            for (ArgumentHandler argumentHandler : this.argHandlers) {
                if (!argumentHandler.arg.required()) {
                    builder.append("[");
                }
                builder.append("<").append(argumentHandler.arg.name()).append(">");
                if (!argumentHandler.arg.required()) {
                    builder.append("] ");
                    continue;
                }
                builder.append(" ");
            }
            builder.append("\n\n");
            String optionIndent = "       ";
            String string = "           ";
            if (!this.optionHandlers.isEmpty()) {
                for (OptionHandler optionHandler : this.optionHandlers) {
                    optionUsage = new StringBuilder();
                    optionHandler.appendUsage(optionUsage);
                    builder.append(optionIndent).append(WordUtils.wrap((String)optionUsage.toString(), (int)68, (String)("\n" + string), (boolean)false)).append("\n");
                }
            }
            if (!this.argHandlers.isEmpty()) {
                for (ArgumentHandler argumentHandler : this.argHandlers) {
                    optionUsage = new StringBuilder();
                    argumentHandler.appendUsage(optionUsage);
                    builder.append(optionIndent).append(WordUtils.wrap((String)optionUsage.toString(), (int)68, (String)("\n" + string), (boolean)false)).append("\n");
                }
            }
            if (this.remaingArgsHandler != null) {
                StringBuilder optionUsage2 = new StringBuilder();
                this.remaingArgsHandler.appendUsage(optionUsage2);
                builder.append(optionIndent).append(WordUtils.wrap((String)optionUsage2.toString(), (int)68, (String)("\n" + string), (boolean)false)).append("\n");
            }
            this.usage = builder;
        }
        out.println(this.usage);
    }

    private void setField(String name, Field field, String value) throws IllegalArgumentException, IllegalAccessException {
        if (value == null) {
            if (!field.getType().isPrimitive()) {
                field.set(this, null);
            }
            return;
        }
        if (field.getType().isAssignableFrom(String.class)) {
            field.set(this, value);
        } else if (field.getType().isAssignableFrom(Boolean.class) || field.getType() == Boolean.TYPE) {
            field.set(this, Boolean.parseBoolean(value));
        } else if (field.getType().isAssignableFrom(Integer.class) || field.getType() == Integer.TYPE) {
            field.set(this, Integer.parseInt(value));
        } else if (field.getType().isAssignableFrom(Double.class) || field.getType() == Double.TYPE) {
            field.set(this, Double.parseDouble(value));
        } else if (field.getType().isAssignableFrom(Long.class) || field.getType() == Long.TYPE) {
            field.set(this, Long.parseLong(value));
        } else if (field.getType().isAssignableFrom(Float.class) || field.getType() == Float.TYPE) {
            field.set(this, Float.valueOf(Float.parseFloat(value)));
        } else if (field.getType().isAssignableFrom(String.class)) {
            field.set(this, value);
        } else if (field.getType().isAssignableFrom(File.class)) {
            field.set(this, new File(UtlFile.expandPath(value)));
        } else {
            if (field.getType().isEnum()) {
                try {
                    Object val = field.getType().getMethod("valueOf", String.class).invoke(null, value);
                    if (val != null) {
                        field.set(this, val);
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new IllegalArgumentException("Unable to convert " + value + " to " + field.getType().getSimpleName() + " for '" + name + "'");
            }
            throw new IllegalArgumentException("Unable to convert " + value + " to " + field.getType().getSimpleName() + " for '" + name + "'");
        }
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        StringTokenizer tokenizer = new StringTokenizer(buffer, " ", true);
        String[] args = buffer.trim().split(" ");
        int pos = 0;
        int lastArgPos = 0;
        boolean inOptions = true;
        String token = tokenizer.nextToken();
        pos += token.length();
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
            boolean delim = token.trim().length() > 0;
            String lastArg = args[lastArgPos];
            int argIndex = 1;
            if (pos + token.length() >= cursor) {
                if (token.startsWith("--")) {
                    String match = "";
                    if (token.length() > 2) {
                        match = token.substring(2);
                    }
                    ArrayList<String> possibleOptions = new ArrayList<String>();
                    for (OptionHandler handler : this.optionHandlers) {
                        if (!handler.option.longForm().startsWith(match)) continue;
                        possibleOptions.add(handler.option.longForm());
                    }
                    int rc = new StringsCompleter(possibleOptions).complete(token, cursor, candidates);
                    if (rc != -1) {
                        return pos + rc;
                    }
                    return rc;
                }
                if (token.equals("-")) {
                    ArrayList<String> possibleOptions = new ArrayList<String>();
                    for (OptionHandler handler : this.optionHandlers) {
                        possibleOptions.add("" + handler.option.shortForm());
                    }
                    int rc = new StringsCompleter(possibleOptions).complete(token, cursor, candidates);
                    if (rc != -1) {
                        return pos + rc;
                    }
                    return rc;
                }
                if (inOptions) {
                    OptionHandler optionHandler = null;
                    if (lastArg.startsWith("--") && lastArg.length() >= 3) {
                        optionHandler = this.optionsByLongForm.get(lastArg.substring(2));
                    } else if (lastArg.startsWith("-") && lastArg.length() == 2) {
                        optionHandler = this.optionsByShortForm.get(lastArg.substring(1));
                    }
                    if (optionHandler != null) {
                        if (optionHandler.option.validOptions().length > 0) {
                            int rc = new StringsCompleter(Arrays.asList(optionHandler.option.validOptions())).complete(token, cursor, candidates);
                            if (rc != -1) {
                                return pos + rc;
                            }
                            return rc;
                        }
                        if (optionHandler.field.getType().isEnum()) {
                            int rc = new EnumCompleter(optionHandler.field.getType()).complete(token, cursor, candidates);
                            if (rc != -1) {
                                return pos + rc;
                            }
                            return rc;
                        }
                        if (optionHandler.field.getType().equals(File.class)) {
                            int rc = new FileNameCompleter().complete(buffer, cursor, candidates);
                            if (rc != -1) {
                                return pos + rc;
                            }
                            return rc;
                        }
                        if (optionHandler.option.required() && optionHandler.option.defaultValue().equals(NULL)) {
                            return -1;
                        }
                    } else {
                        for (ArgumentHandler argHandler : this.argHandlers) {
                            if (argHandler.position != argIndex) continue;
                            if (argHandler.arg.validOptions().length > 0) {
                                int rc = new StringsCompleter(Arrays.asList(argHandler.arg.validOptions())).complete(token, cursor, candidates);
                                if (rc != -1) {
                                    return pos + rc;
                                }
                                return rc;
                            }
                            if (argHandler.argField.getType().isEnum()) {
                                int rc = new EnumCompleter(argHandler.argField.getType()).complete(token, cursor, candidates);
                                if (rc != -1) {
                                    return pos + rc;
                                }
                                return rc;
                            }
                            if (!argHandler.argField.getType().equals(File.class)) continue;
                            int rc = new FileNameCompleter().complete(token, cursor, candidates);
                            if (rc != -1) {
                                return rc += pos;
                            }
                            return rc;
                        }
                    }
                } else {
                    for (ArgumentHandler argHandler : this.argHandlers) {
                        if (argHandler.position != argIndex) continue;
                        if (argHandler.arg.validOptions().length > 0) {
                            int rc = new StringsCompleter(Arrays.asList(argHandler.arg.validOptions())).complete(token, cursor, candidates);
                            if (rc != -1) {
                                return pos + rc;
                            }
                            return rc;
                        }
                        if (argHandler.argField.getType().isEnum()) {
                            int rc = new EnumCompleter(argHandler.argField.getType()).complete(token, cursor, candidates);
                            if (rc != -1) {
                                return pos + rc;
                            }
                            return rc;
                        }
                        if (!argHandler.argField.getType().equals(File.class)) continue;
                        int rc = new FileNameCompleter().complete(token, cursor, candidates);
                        if (rc != -1) {
                            return rc += pos;
                        }
                        return rc;
                    }
                }
            } else {
                boolean isOption = false;
                boolean isOptionValue = false;
                if (token.startsWith("--") || token.startsWith("-")) {
                    isOption = true;
                }
                if (lastArgPos >= 1) {
                    OptionHandler optionHandler = null;
                    if (lastArg.startsWith("--") && lastArg.length() >= 3) {
                        optionHandler = this.optionsByLongForm.get(lastArg.substring(2));
                    } else if (lastArg.startsWith("-") && lastArg.length() == 2) {
                        optionHandler = this.optionsByShortForm.get(lastArg.substring(1));
                    }
                    if (optionHandler != null && optionHandler.option.required() && optionHandler.option.defaultValue().equals(NULL)) {
                        isOptionValue = true;
                    }
                }
                if (!isOption && !isOptionValue) {
                    ++argIndex;
                    inOptions = false;
                }
            }
            if (!delim) {
                ++lastArgPos;
            }
            pos += token.length();
        }
        return -1;
    }

    private class RemainingArgsHandler {
        private final RemainingArgs arg;
        private final Field argField;

        RemainingArgsHandler(Field argField, RemainingArgs arg) {
            this.arg = arg;
            this.argField = argField;
            if (!argField.getType().equals(String.class) && !argField.getType().equals(new String[0].getClass())) {
                throw new IllegalArgumentException("Invalid field type for remaining args: " + argField.getName() + "=" + argField.getType().getSimpleName() + ", expected String or String []");
            }
        }

        public void parse(String[] value) throws IllegalArgumentException, IllegalAccessException {
            if (value == null || value.length == 0) {
                if (this.arg.required() && AnnotatedCommand.NULL.equals(this.arg.defaultValue())) {
                    throw new IllegalArgumentException("Missing argument, expected " + this.arg.name());
                }
                value = !AnnotatedCommand.NULL.equals(this.arg.defaultValue()) ? (this.argField.getType().equals(String.class) ? new String[]{this.arg.defaultValue()} : UtlText.parseAsArgs(this.arg.defaultValue(), false)) : new String[]{};
            }
            if (this.argField.getType().equals(String.class)) {
                String str = null;
                if (value.length > 0) {
                    str = this.arg.requoteForSingleString() ? UtlText.quoteAndEscape(value[0]) : value[0];
                    for (int i = 1; i < value.length; ++i) {
                        str = str + " " + (this.arg.requoteForSingleString() ? UtlText.quoteAndEscape(value[i]) : value[i]);
                    }
                }
                this.argField.set(AnnotatedCommand.this, str);
            } else {
                this.argField.set(AnnotatedCommand.this, value);
            }
        }

        public void appendUsage(StringBuilder out) {
            if (!this.arg.required()) {
                out.append("[");
            }
            out.append(this.arg.name() + ": ");
            out.append(this.arg.description());
            if (!AnnotatedCommand.NULL.equals(this.arg.defaultValue())) {
                out.append(" default='" + this.arg.defaultValue() + "'");
            }
            if (!this.arg.required()) {
                out.append("]");
            }
        }
    }

    private class ArgumentHandler
    implements Comparable<ArgumentHandler> {
        private final int position;
        private final Argument arg;
        private final Field argField;
        private final HashSet<String> validOptions = new HashSet();

        ArgumentHandler(Field argField, Argument arg) {
            this.arg = arg;
            this.argField = argField;
            this.position = arg.position();
            if (arg.validOptions().length > 0) {
                this.validOptions.addAll(Arrays.asList(arg.validOptions()));
            }
        }

        public void parse(String value) throws IllegalArgumentException, IllegalAccessException {
            if (value == null) {
                if (!AnnotatedCommand.NULL.equals(this.arg.defaultValue())) {
                    value = this.arg.defaultValue();
                }
                if (this.arg.required() && value == null) {
                    throw new IllegalArgumentException("Too few arguments. Expected value for '" + this.arg.name() + "'.");
                }
            }
            if (this.arg.required() && !this.validOptions.isEmpty() && !this.validOptions.contains(value)) {
                throw new IllegalArgumentException(value + " is not a valid option for " + this.arg.name() + ". Expected one of " + this.validOptions);
            }
            AnnotatedCommand.this.setField(this.arg.name(), this.argField, value);
        }

        public void appendUsage(StringBuilder out) {
            if (!this.arg.required()) {
                out.append("[");
            }
            out.append(this.arg.name() + ": ");
            if (!this.validOptions.isEmpty()) {
                out.append("<");
                boolean first = true;
                for (String option : this.validOptions) {
                    if (!first) {
                        out.append("|");
                    }
                    first = false;
                    out.append(option);
                }
                out.append("> ");
            }
            out.append(this.arg.description());
            if (!AnnotatedCommand.NULL.equals(this.arg.defaultValue())) {
                out.append(" default='" + this.arg.defaultValue() + "'");
            }
            if (!this.arg.required()) {
                out.append("]");
            }
        }

        @Override
        public int compareTo(ArgumentHandler o) {
            if (o.position == this.position) {
                return 0;
            }
            return this.position - o.position;
        }
    }

    class OptionHandler {
        private final CmdLineParser.Option optionParser;
        private final Option option;
        private final Field field;
        private final HashSet<String> validOptions = new HashSet();

        OptionHandler(Field field, Option option) throws IllegalArgumentException {
            this.field = field;
            this.option = option;
            this.optionParser = this.createOption();
            if (option.validOptions().length > 0) {
                this.validOptions.addAll(Arrays.asList(option.validOptions()));
            }
            AnnotatedCommand.this.optionsByLongForm.put(option.longForm(), this);
            AnnotatedCommand.this.optionsByShortForm.put("" + option.shortForm(), this);
        }

        public void parseOption() throws IllegalArgumentException, IllegalAccessException {
            if (this.field.getType().isAssignableFrom(Boolean.class) || this.field.getType() == Boolean.TYPE) {
                Boolean val = null;
                val = !AnnotatedCommand.NULL.equals(this.option.defaultValue()) ? (Boolean)AnnotatedCommand.this.parser.getOptionValue(this.optionParser, (Object)Boolean.parseBoolean(this.option.defaultValue())) : (Boolean)AnnotatedCommand.this.parser.getOptionValue(this.optionParser);
                if (val == null && this.option.required()) {
                    throw new IllegalArgumentException("Option " + this.option.longForm() + " is a required value");
                }
                if (!this.validOptions.isEmpty() && !this.validOptions.contains(val.toString())) {
                    throw new IllegalArgumentException(val + " is not a valid option for " + this.option.longForm() + ". Expected one of " + this.validOptions);
                }
                if (val != null) {
                    this.field.setBoolean(AnnotatedCommand.this, val);
                }
            } else if (this.field.getType().isAssignableFrom(Integer.class) || this.field.getType() == Integer.TYPE) {
                Integer val = null;
                val = !AnnotatedCommand.NULL.equals(this.option.defaultValue()) ? (Integer)AnnotatedCommand.this.parser.getOptionValue(this.optionParser, (Object)Integer.parseInt(this.option.defaultValue())) : (Integer)AnnotatedCommand.this.parser.getOptionValue(this.optionParser);
                if (val == null && this.option.required()) {
                    throw new IllegalArgumentException("Option " + this.option.longForm() + " is a required value");
                }
                if (!this.validOptions.isEmpty() && !this.validOptions.contains(val.toString())) {
                    throw new IllegalArgumentException(val + " is not a valid option for " + this.option.longForm() + ". Expected one of " + this.validOptions);
                }
                if (val != null) {
                    this.field.setInt(AnnotatedCommand.this, val);
                }
            } else if (this.field.getType().isAssignableFrom(Double.class) || this.field.getType() == Double.TYPE) {
                Double val = null;
                val = !AnnotatedCommand.NULL.equals(this.option.defaultValue()) ? (Double)AnnotatedCommand.this.parser.getOptionValue(this.optionParser, (Object)Double.parseDouble(this.option.defaultValue())) : (Double)AnnotatedCommand.this.parser.getOptionValue(this.optionParser);
                if (val == null && this.option.required()) {
                    throw new IllegalArgumentException("Option " + this.option.longForm() + " is a required value");
                }
                if (!this.validOptions.isEmpty() && !this.validOptions.contains(val.toString())) {
                    throw new IllegalArgumentException(val + " is not a valid option for " + this.option.longForm() + ". Expected one of " + this.validOptions);
                }
                if (val != null) {
                    this.field.setDouble(AnnotatedCommand.this, val);
                }
            } else if (this.field.getType().isAssignableFrom(Float.class) || this.field.getType() == Float.TYPE) {
                Float val = null;
                val = !AnnotatedCommand.NULL.equals(this.option.defaultValue()) ? (Float)AnnotatedCommand.this.parser.getOptionValue(this.optionParser, (Object)Float.valueOf(Float.parseFloat(this.option.defaultValue()))) : (Float)AnnotatedCommand.this.parser.getOptionValue(this.optionParser);
                if (val == null && this.option.required()) {
                    throw new IllegalArgumentException("Option " + this.option.longForm() + " is a required value");
                }
                if (!this.validOptions.isEmpty() && !this.validOptions.contains(val.toString())) {
                    throw new IllegalArgumentException(val + " is not a valid option for " + this.option.longForm() + ". Expected one of " + this.validOptions);
                }
                if (val != null) {
                    this.field.setFloat(AnnotatedCommand.this, val.floatValue());
                }
            } else if (this.field.getType().isAssignableFrom(Long.class) || this.field.getType() == Long.TYPE) {
                Long val = null;
                val = !AnnotatedCommand.NULL.equals(this.option.defaultValue()) ? (Long)AnnotatedCommand.this.parser.getOptionValue(this.optionParser, (Object)Long.parseLong(this.option.defaultValue())) : (Long)AnnotatedCommand.this.parser.getOptionValue(this.optionParser);
                if (val == null && this.option.required()) {
                    throw new IllegalArgumentException("Option " + this.option.longForm() + " is a required value");
                }
                if (!this.validOptions.isEmpty() && !this.validOptions.contains(val.toString())) {
                    throw new IllegalArgumentException(val + " is not a valid option for " + this.option.longForm() + ". Expected one of " + this.validOptions);
                }
                if (val != null) {
                    this.field.setLong(AnnotatedCommand.this, val);
                }
            } else if (this.field.getType().isAssignableFrom(String.class)) {
                String val = null;
                val = !AnnotatedCommand.NULL.equals(this.option.defaultValue()) ? (String)AnnotatedCommand.this.parser.getOptionValue(this.optionParser, (Object)this.option.defaultValue()) : (String)AnnotatedCommand.this.parser.getOptionValue(this.optionParser);
                if (val == null && this.option.required()) {
                    throw new IllegalArgumentException("Option " + this.option.longForm() + " is a required value");
                }
                if (!this.validOptions.isEmpty() && !this.validOptions.contains(val.toString())) {
                    throw new IllegalArgumentException(val + " is not a valid option for " + this.option.longForm() + ". Expected one of " + this.validOptions);
                }
                this.field.set(AnnotatedCommand.this, val);
            } else {
                String val = null;
                val = !AnnotatedCommand.NULL.equals(this.option.defaultValue()) ? (String)AnnotatedCommand.this.parser.getOptionValue(this.optionParser, (Object)this.option.defaultValue()) : (String)AnnotatedCommand.this.parser.getOptionValue(this.optionParser);
                if (val == null && this.option.required()) {
                    throw new IllegalArgumentException("Option " + this.option.longForm() + " is a required value");
                }
                if (!this.validOptions.isEmpty() && !this.validOptions.contains(val.toString())) {
                    throw new IllegalArgumentException(val + " is not a valid option for " + this.option.longForm() + ". Expected one of " + this.validOptions);
                }
                AnnotatedCommand.this.setField(this.option.longForm(), this.field, val);
            }
        }

        private CmdLineParser.Option createOption() throws IllegalArgumentException {
            if (this.field.getType().isAssignableFrom(Boolean.class) || this.field.getType() == Boolean.TYPE) {
                return AnnotatedCommand.this.parser.addBooleanOption(this.option.shortForm(), this.option.longForm());
            }
            if (this.field.getType().isAssignableFrom(Integer.class) || this.field.getType() == Integer.TYPE) {
                return AnnotatedCommand.this.parser.addIntegerOption(this.option.shortForm(), this.option.longForm());
            }
            if (this.field.getType().isAssignableFrom(Double.class) || this.field.getType() == Double.TYPE) {
                return AnnotatedCommand.this.parser.addDoubleOption(this.option.shortForm(), this.option.longForm());
            }
            if (this.field.getType().isAssignableFrom(Float.class) || this.field.getType() == Float.TYPE) {
                return AnnotatedCommand.this.parser.addStringOption(this.option.shortForm(), this.option.longForm());
            }
            if (this.field.getType().isAssignableFrom(Long.class) || this.field.getType() == Long.TYPE) {
                return AnnotatedCommand.this.parser.addLongOption(this.option.shortForm(), this.option.longForm());
            }
            if (this.field.getType().isAssignableFrom(String.class)) {
                return AnnotatedCommand.this.parser.addStringOption(this.option.shortForm(), this.option.longForm());
            }
            if (this.field.getType().isAssignableFrom(File.class)) {
                return AnnotatedCommand.this.parser.addStringOption(this.option.shortForm(), this.option.longForm());
            }
            if (this.field.getType().isEnum()) {
                return AnnotatedCommand.this.parser.addStringOption(this.option.shortForm(), this.option.longForm());
            }
            throw new IllegalArgumentException("Unsupported option field type " + this.field.getType().getSimpleName());
        }

        public void appendUsage(StringBuilder out) {
            if (!this.option.required()) {
                out.append("[");
            }
            out.append("<-" + this.option.shortForm() + "|--" + this.option.longForm() + "> ");
            if (!this.validOptions.isEmpty()) {
                out.append("<");
                boolean first = true;
                for (String option : this.validOptions) {
                    if (!first) {
                        out.append("|");
                    }
                    first = false;
                    out.append(option);
                }
                out.append("> ");
            }
            out.append(this.option.description());
            if (!AnnotatedCommand.NULL.equals(this.option.defaultValue())) {
                out.append(" (default='" + this.option.defaultValue() + "')");
            }
            if (!this.option.required()) {
                out.append("]");
            }
        }

        public void appendHtmlUsage(StringBuilder out) {
            if (!this.option.required()) {
                out.append("[");
            }
            out.append("<-" + this.option.shortForm() + "|--" + this.option.longForm() + "> ");
            if (!this.validOptions.isEmpty()) {
                out.append("<");
                boolean first = true;
                for (String option : this.validOptions) {
                    if (!first) {
                        out.append("|");
                    }
                    first = false;
                    out.append(option);
                }
                out.append("> ");
            }
            out.append(this.option.description());
            if (!AnnotatedCommand.NULL.equals(this.option.defaultValue())) {
                out.append(" (default='" + this.option.defaultValue() + "')");
            }
            if (!this.option.required()) {
                out.append("]");
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface RemainingArgs {
        public String name();

        public String description();

        public String defaultValue() default "$NONE$";

        public boolean required() default true;

        public boolean requoteForSingleString() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Argument {
        public String name();

        public String description();

        public int position();

        public String defaultValue() default "$NONE$";

        public boolean required() default true;

        public String[] validOptions() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Option {
        public char shortForm();

        public String longForm();

        public String description();

        public String defaultValue() default "$NONE$";

        public boolean required() default false;

        public String[] validOptions() default {};
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Command {
        public String description();

        public String[] keywords();

        public boolean hidden() default false;

        public boolean disabled() default false;

        public boolean parseOptions() default true;

        public boolean preserveArgumentQuotes() default false;
    }
}

