/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.raw.impl;

import com.eaio.util.lang.Hex;
import com.eaio.uuid.UUIDGen;
import com.neeve.lang.XString;
import com.neeve.raw.RawUUID;
import java.io.IOException;
import java.util.UUID;

public class RawUUIDImpl
implements RawUUID {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private long time;
    private long clockSeqAndNode;
    private boolean initialized = false;
    private boolean mutable = true;
    private UUID value;
    private final CharSequenceView charSequenceView = new CharSequenceView();

    private RawUUIDImpl() {
    }

    private RawUUIDImpl(long time, long clockSeqAndNode) {
        this.initialize(time, clockSeqAndNode);
    }

    public static final RawUUIDImpl create(boolean mutable) {
        RawUUIDImpl rc = new RawUUIDImpl();
        rc.mutable = mutable;
        return rc;
    }

    public static final RawUUIDImpl create(UUID uuid) {
        RawUUIDImpl rc = new RawUUIDImpl();
        rc.initialize(uuid);
        rc.mutable = false;
        return rc;
    }

    public void initialize(long time, long clockSeqAndNode) {
        this.checkMutable();
        this.time = time;
        this.clockSeqAndNode = clockSeqAndNode;
        this.value = null;
        this.initialized = true;
    }

    @Override
    public int compareTo(RawUUID t) {
        if (this == t) {
            return 0;
        }
        if (this.time > t.getTime()) {
            return 1;
        }
        if (this.time < t.getTime()) {
            return -1;
        }
        if (this.clockSeqAndNode > t.getClockSeqAndNode()) {
            return 1;
        }
        if (this.clockSeqAndNode < t.getClockSeqAndNode()) {
            return -1;
        }
        return 0;
    }

    public final String toString() {
        return this.toAppendable(null).toString();
    }

    public StringBuffer toStringBuffer(StringBuffer in) {
        StringBuffer out = in;
        if (out == null) {
            out = new StringBuffer(36);
        } else {
            out.ensureCapacity(out.length() + 36);
        }
        return (StringBuffer)this.toAppendable(out);
    }

    public Appendable toAppendable(Appendable a) {
        Appendable out = a;
        if (out == null) {
            out = new StringBuilder(36);
        }
        try {
            Hex.append((Appendable)out, (int)((int)(this.time >> 32))).append('-');
            Hex.append((Appendable)out, (short)((short)(this.time >> 16))).append('-');
            Hex.append((Appendable)out, (short)((short)this.time)).append('-');
            Hex.append((Appendable)out, (short)((short)(this.clockSeqAndNode >> 48))).append('-');
            Hex.append((Appendable)out, (long)this.clockSeqAndNode, (int)12);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }

    public int hashCode() {
        return (int)(this.time >> 32 ^ this.time ^ this.clockSeqAndNode >> 32 ^ this.clockSeqAndNode);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    @Override
    public final long getTime() {
        return this.time;
    }

    @Override
    public final long getClockSeqAndNode() {
        return this.clockSeqAndNode;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RawUUID)) {
            return false;
        }
        return this.compareTo((RawUUID)obj) == 0;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean initialize(UUID uuid) {
        if (uuid == null) {
            this.initialize(-1L, -1L);
        } else {
            this.initialize(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
        }
        this.value = uuid;
        return true;
    }

    @Override
    public final void setValue(RawUUID value) {
        if (value == null) {
            this.initialize(-1L, -1L);
            this.value = null;
        } else {
            this.initialize(value.getTime(), value.getClockSeqAndNode());
            this.value = ((RawUUIDImpl)value).value;
        }
    }

    @Override
    public final void setValue(UUID value) {
        this.initialize(value);
    }

    @Override
    public UUID getValue() {
        if (!this.initialized) {
            return null;
        }
        if (this.time == -1L && this.clockSeqAndNode == -1L) {
            return null;
        }
        if (this.value == null) {
            this.value = new UUID(this.time, this.clockSeqAndNode);
        }
        return this.value;
    }

    @Override
    public boolean isImmutable() {
        return !this.mutable && this.initialized;
    }

    @Override
    public boolean initializeFrom(RawUUID value) {
        if (this.initialized) {
            throw new IllegalStateException("Already inialized");
        }
        if (value != null) {
            return value.copyInto(this) == this;
        }
        this.initialize(-1L, -1L);
        return true;
    }

    @Override
    public RawUUID copyInto(RawUUID target) {
        return this.copyInto((RawUUIDImpl)target);
    }

    @Override
    public final RawUUIDImpl copyInto(RawUUIDImpl target) {
        this.checkInitialized();
        if (target.isImmutable()) {
            target = RawUUIDImpl.create(false);
        }
        target.initialize(this.time, this.clockSeqAndNode);
        target.value = this.value;
        return target;
    }

    private final void checkMutable() {
        if (this.isImmutable()) {
            throw new IllegalStateException("Not Mutable");
        }
    }

    private final void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Not Initialized");
        }
    }

    @Override
    public final long getMostSignificantBits() {
        this.checkInitialized();
        return this.time;
    }

    @Override
    public final long getLeastSignificantBits() {
        this.checkInitialized();
        return this.clockSeqAndNode;
    }

    @Override
    public final void clear() {
        this.reset();
    }

    public final void reset() {
        this.checkMutable();
        this.initialized = false;
        this.clockSeqAndNode = -1L;
        this.time = -1L;
        this.value = null;
    }

    @Override
    public void initializeRandom() {
        this.checkMutable();
        this.initialize(UUIDGen.newTime(), UUIDGen.getClockSeqAndNode());
    }

    @Override
    public void initializeFrom(XString string) {
        if (string.length() < 36) {
            throw new IllegalArgumentException("String must be at least 36 characters.");
        }
        long time = RawUUIDImpl.parseLong(string, 0, 18);
        long clockAndSequenceNode = RawUUIDImpl.parseLong(string, 19, 36);
        this.initialize(time, clockAndSequenceNode);
    }

    @Override
    public void initializeFrom(CharSequence string) {
        if (string.length() < 36) {
            throw new IllegalArgumentException("String must be at least 36 characters.");
        }
        long time = RawUUIDImpl.parseLong(string, 0, 18);
        long clockAndSequenceNode = RawUUIDImpl.parseLong(string, 19, 36);
        this.initialize(time, clockAndSequenceNode);
    }

    private static final long parseLong(XString s, int startPos, int endPos) {
        long out = 0L;
        int shifts = 0;
        for (int i = startPos; i < endPos && shifts < 16; ++i) {
            char c = s.charAt(i);
            if (c > '/' && c < ':') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c - 48);
                continue;
            }
            if (c > '@' && c < 'G') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c - 55);
                continue;
            }
            if (c <= '`' || c >= 'g') continue;
            shifts = (byte)(shifts + 1);
            out <<= 4;
            out |= (long)(c - 87);
        }
        return out;
    }

    private static final long parseLong(CharSequence s, int startPos, int endPos) {
        long out = 0L;
        int shifts = 0;
        for (int i = startPos; i < endPos && shifts < 16; ++i) {
            char c = s.charAt(i);
            if (c > '/' && c < ':') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c - 48);
                continue;
            }
            if (c > '@' && c < 'G') {
                shifts = (byte)(shifts + 1);
                out <<= 4;
                out |= (long)(c - 55);
                continue;
            }
            if (c <= '`' || c >= 'g') continue;
            shifts = (byte)(shifts + 1);
            out <<= 4;
            out |= (long)(c - 87);
        }
        return out;
    }

    @Override
    public CharSequence asCharSequence() {
        if (!this.initialized) {
            return null;
        }
        return this.charSequenceView;
    }

    private class CharSequenceView
    implements CharSequence {
        private CharSequenceView() {
        }

        @Override
        public int length() {
            if (!RawUUIDImpl.this.initialized) {
                return 0;
            }
            return 36;
        }

        @Override
        public char charAt(int i) {
            if (i < 0 || i >= this.length()) {
                throw new IndexOutOfBoundsException(i + ": index should be between 0 and " + this.length());
            }
            if (i == 8 || i == 13 || i == 18 || i == 23) {
                return '-';
            }
            if (i < 8) {
                return DIGITS[(byte)(0xFL & RawUUIDImpl.this.time >> 60 - i * 4)];
            }
            if (i < 13) {
                return DIGITS[(byte)(0xFL & RawUUIDImpl.this.time >> 60 - (i - 1) * 4)];
            }
            if (i < 18) {
                return DIGITS[(byte)(0xFL & RawUUIDImpl.this.time >> 60 - (i - 2) * 4)];
            }
            if (i < 23) {
                return DIGITS[(byte)(0xFL & RawUUIDImpl.this.clockSeqAndNode >> 60 - (i - 19) * 4)];
            }
            return DIGITS[(byte)(0xFL & RawUUIDImpl.this.clockSeqAndNode >> 60 - (i - 20) * 4)];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new String(RawUUIDImpl.this.getValue().toString().substring(start, end));
        }
    }
}

