/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang.test.unit;

import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.neeve.lang.XShortCollection;
import com.neeve.lang.XShortIterator;
import com.neeve.lang.XShortLinkedHashMap;
import com.neeve.lang.XShortLinkedList;
import com.neeve.lang.XShortList;
import com.neeve.lang.XShortListIterator;
import com.neeve.lang.XShortMap;
import com.neeve.lang.XShortSet;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class ShortCollectionAdapters {
    ShortCollectionAdapters() {
    }

    static <V> Map<Short, V> toLinkedShortMap(XShortMap<V> map) {
        return new XPrimitiveToShortMapAdapter<V>(map);
    }

    static <V> List<Short> toShortList(XShortList list) {
        return new XPrimitiveToShortListAdapter(list);
    }

    private static short adaptShort(Object value) {
        if (value == null) {
            throw new NullPointerException("Null values not supported");
        }
        return (Short)value;
    }

    private static Object adaptShortMapEntry(Object entry) {
        if (entry == null) {
            return null;
        }
        if (entry instanceof Map.Entry) {
            try {
                return ShortCollectionAdapters.adaptShortMapEntry((Map.Entry)entry);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return entry;
    }

    private static <V> XShortMap.Entry<V> adaptShortMapEntry(Map.Entry<Short, V> entry) {
        if (entry == null) {
            return null;
        }
        return new XShortToPrimitiveMapEntryAdapter<V>(entry);
    }

    private static Collection<?> adaptToPrimitiveShortMapEntryCollectionIfPossible(Collection<?> c) {
        if (c == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object o : c) {
            list.add(ShortCollectionAdapters.adaptShortMapEntry(o));
        }
        return list;
    }

    private static <V> Collection<? extends XShortMap.Entry<V>> adaptToPrimitiveShortMapEntryCollection(Collection<? extends Map.Entry<Short, V>> c) {
        if (c == null) {
            return null;
        }
        ArrayList<XShortMap.Entry<V>> list = new ArrayList<XShortMap.Entry<V>>(c.size());
        for (Map.Entry<Short, V> e : c) {
            list.add(ShortCollectionAdapters.adaptShortMapEntry(e));
        }
        return list;
    }

    public static class Shorts
    extends SampleElements<Short> {
        public Shorts() {
            super((Object)1, (Object)2, (Object)3, (Object)4, (Object)5);
        }
    }

    public static abstract class TestShortListGenerator
    implements TestListGenerator<Short> {
        public SampleElements<Short> samples() {
            return new Shorts();
        }

        public List<Short> create(Object ... elements) {
            Short[] array = new Short[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Short)e;
            }
            return this.create(array);
        }

        protected abstract List<Short> create(Short[] var1);

        public Short[] createArray(int length) {
            return new Short[length];
        }

        public List<Short> order(List<Short> insertionOrder) {
            return insertionOrder;
        }
    }

    public static abstract class TestShortMapGenerator
    implements TestMapGenerator<Short, String> {
        public SampleElements<Map.Entry<Short, String>> samples() {
            return new SampleElements((Object)Helpers.mapEntry((Object)1, (Object)"January"), (Object)Helpers.mapEntry((Object)2, (Object)"February"), (Object)Helpers.mapEntry((Object)3, (Object)"March"), (Object)Helpers.mapEntry((Object)4, (Object)"April"), (Object)Helpers.mapEntry((Object)5, (Object)"May"));
        }

        public Map<Short, String> create(Object ... entries) {
            Map.Entry[] array = new Map.Entry[entries.length];
            int i = 0;
            for (Object o : entries) {
                Map.Entry e = (Map.Entry)o;
                array[i++] = e;
            }
            return this.create(array);
        }

        protected abstract Map<Short, String> create(Map.Entry<Short, String>[] var1);

        public final Map.Entry<Short, String>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public final Short[] createKeyArray(int length) {
            return new Short[length];
        }

        public final String[] createValueArray(int length) {
            return new String[length];
        }

        public Iterable<Map.Entry<Short, String>> order(List<Map.Entry<Short, String>> insertionOrder) {
            return insertionOrder;
        }
    }

    private static class XPrimtiveToShortEntrySetAdapter<V>
    extends AbstractSet<Map.Entry<Short, V>>
    implements Set<Map.Entry<Short, V>> {
        private final Set<XShortMap.Entry<V>> adaptee;

        public XPrimtiveToShortEntrySetAdapter(Set<XShortMap.Entry<V>> entrySet) {
            this.adaptee = entrySet;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(ShortCollectionAdapters.adaptShortMapEntry(o));
        }

        @Override
        public Iterator<Map.Entry<Short, V>> iterator() {
            final Iterator<XShortMap.Entry<V>> toAdapt = this.adaptee.iterator();
            return new Iterator<Map.Entry<Short, V>>(){

                @Override
                public boolean hasNext() {
                    return toAdapt.hasNext();
                }

                @Override
                public Map.Entry<Short, V> next() {
                    XShortMap.Entry next = (XShortMap.Entry)toAdapt.next();
                    if (next == null) {
                        return null;
                    }
                    return new AbstractMap.SimpleEntry(next.getKey(), next.getValue());
                }

                @Override
                public void remove() {
                    toAdapt.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] toAdapt = this.adaptee.toArray();
            Object[] adapted = new Object[toAdapt.length];
            for (int i = 0; i < toAdapt.length; ++i) {
                if (toAdapt[i] == null) continue;
                XShortMap.Entry xEntry = (XShortMap.Entry)toAdapt[i];
                adapted[i] = new AbstractMap.SimpleEntry(xEntry.getKey(), xEntry.getValue());
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            XShortMap.Entry[] toAdapt = this.adaptee.toArray(new XShortMap.Entry[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < toAdapt.length; ++i) {
                a[i] = toAdapt[i] != null ? new AbstractMap.SimpleEntry(toAdapt[i].getKey(), toAdapt[i].getValue()) : null;
            }
            return a;
        }

        @Override
        public boolean add(Map.Entry<Short, V> e) {
            return this.adaptee.add(ShortCollectionAdapters.adaptShortMapEntry(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(ShortCollectionAdapters.adaptShortMapEntry(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.adaptee.containsAll(ShortCollectionAdapters.adaptToPrimitiveShortMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Short, V>> c) {
            return this.adaptee.addAll(ShortCollectionAdapters.adaptToPrimitiveShortMapEntryCollection(c));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.adaptee.retainAll(ShortCollectionAdapters.adaptToPrimitiveShortMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.adaptee.removeAll(ShortCollectionAdapters.adaptToPrimitiveShortMapEntryCollectionIfPossible(c));
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class XShortToPrimitiveMapEntryAdapter<V>
    extends XShortLinkedHashMap.Entry<V> {
        XShortToPrimitiveMapEntryAdapter(Map.Entry<Short, V> entry) {
            this.setKey(entry.getKey());
            this.setValue(entry.getValue());
        }
    }

    private static class XPrimitiveToShortListIteratorAdapater
    extends XShortIteratorAdapater
    implements ListIterator<Short> {
        final XShortListIterator adaptee;

        XPrimitiveToShortListIteratorAdapater(XShortListIterator iterator) {
            super(iterator);
            this.adaptee = iterator;
        }

        @Override
        public boolean hasPrevious() {
            return this.adaptee.hasPrevious();
        }

        @Override
        public Short previous() {
            return this.adaptee.previous();
        }

        @Override
        public int nextIndex() {
            return this.adaptee.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.adaptee.previousIndex();
        }

        @Override
        public void set(Short e) {
            this.adaptee.set(ShortCollectionAdapters.adaptShort(e));
        }

        @Override
        public void add(Short e) {
            this.adaptee.add(ShortCollectionAdapters.adaptShort(e));
        }
    }

    private static class XShortIteratorAdapater
    implements Iterator<Short> {
        final XShortIterator iterator;

        XShortIteratorAdapater(XShortIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Short next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class XPrimitiveToShortCollectionAdapter<S extends XShortCollection>
    extends AbstractCollection<Short>
    implements Collection<Short> {
        final S adaptee;

        XPrimitiveToShortCollectionAdapter(S collection) {
            this.adaptee = collection;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(ShortCollectionAdapters.adaptShort(o));
        }

        @Override
        public Iterator<Short> iterator() {
            return new XShortIteratorAdapater(this.adaptee.iterator());
        }

        @Override
        public Object[] toArray() {
            short[] val = this.adaptee.toArray();
            Object[] adapted = new Object[val.length];
            for (int i = 0; i < val.length; ++i) {
                adapted[i] = val[i];
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            short[] toAdapt = this.adaptee.toArray(new short[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < this.adaptee.size(); ++i) {
                a[i] = toAdapt[i];
            }
            if (a.length > this.adaptee.size()) {
                a[this.adaptee.size()] = null;
            }
            return a;
        }

        @Override
        public boolean add(Short e) {
            return this.adaptee.add(ShortCollectionAdapters.adaptShort(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(ShortCollectionAdapters.adaptShort(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            XShortLinkedList adapter = new XShortLinkedList();
            for (Object o : c) {
                adapter.add(ShortCollectionAdapters.adaptShort(o));
            }
            return this.adaptee.containsAll(adapter);
        }

        @Override
        public boolean addAll(Collection<? extends Short> c) {
            XShortLinkedList adapter = new XShortLinkedList();
            for (Short s : c) {
                adapter.add(ShortCollectionAdapters.adaptShort(s));
            }
            return this.adaptee.addAll(adapter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            XShortLinkedList adapter = new XShortLinkedList();
            for (Object o : c) {
                try {
                    adapter.add(ShortCollectionAdapters.adaptShort(o));
                }
                catch (NullPointerException nullPointerException) {}
            }
            return this.adaptee.retainAll(adapter);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            XShortLinkedList adapter = new XShortLinkedList();
            for (Object o : c) {
                adapter.add(ShortCollectionAdapters.adaptShort(o));
            }
            return this.adaptee.removeAll(adapter);
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }
    }

    private static class XPrimitiveToShortListAdapter
    extends XPrimitiveToShortCollectionAdapter<XShortList>
    implements List<Short> {
        XPrimitiveToShortListAdapter(XShortList set) {
            super(set);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Short> c) {
            XShortLinkedList adapter = new XShortLinkedList();
            for (Short s : c) {
                adapter.add(ShortCollectionAdapters.adaptShort(s));
            }
            return ((XShortList)this.adaptee).addAll(index, adapter);
        }

        @Override
        public Short get(int index) {
            return ((XShortList)this.adaptee).get(index);
        }

        @Override
        public Short set(int index, Short element) {
            return ((XShortList)this.adaptee).set(index, ShortCollectionAdapters.adaptShort(element));
        }

        @Override
        public void add(int index, Short element) {
            ((XShortList)this.adaptee).add(index, ShortCollectionAdapters.adaptShort(element));
        }

        @Override
        public Short remove(int index) {
            return ((XShortList)this.adaptee).remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return ((XShortList)this.adaptee).indexOf(ShortCollectionAdapters.adaptShort(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((XShortList)this.adaptee).lastIndexOf(ShortCollectionAdapters.adaptShort(o));
        }

        @Override
        public ListIterator<Short> listIterator() {
            return new XPrimitiveToShortListIteratorAdapater(((XShortList)this.adaptee).listIterator());
        }

        @Override
        public ListIterator<Short> listIterator(int index) {
            return new XPrimitiveToShortListIteratorAdapater(((XShortList)this.adaptee).listIterator(index));
        }

        @Override
        public List<Short> subList(int fromIndex, int toIndex) {
            return new XPrimitiveToShortListAdapter(((XShortList)this.adaptee).subList(fromIndex, toIndex));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            ListIterator<Short> e1 = this.listIterator();
            ListIterator e2 = ((List)o).listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                Short o1 = e1.next();
                Object o2 = e2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (Short obj : this) {
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            return hashCode;
        }
    }

    private static class XPrimitiveToShortSetAdapter
    extends XPrimitiveToShortCollectionAdapter<XShortSet>
    implements Set<Short> {
        XPrimitiveToShortSetAdapter(XShortSet set) {
            super(set);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Short obj : this) {
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            if (this.size() > c.size()) {
                Iterator<?> i = c.iterator();
                while (i.hasNext()) {
                    modified |= this.remove(i.next());
                }
            } else {
                Iterator<Short> i = this.iterator();
                while (i.hasNext()) {
                    if (!c.contains(i.next())) continue;
                    i.remove();
                    modified = true;
                }
            }
            return modified;
        }
    }

    private static class XPrimitiveToShortMapAdapter<V>
    extends AbstractMap<Short, V>
    implements Map<Short, V> {
        private final XShortMap<V> map;

        public XPrimitiveToShortMapAdapter(XShortMap<V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(ShortCollectionAdapters.adaptShort(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.map.get(ShortCollectionAdapters.adaptShort(key));
        }

        @Override
        public V put(Short key, V value) {
            return this.map.put(ShortCollectionAdapters.adaptShort(key), value);
        }

        @Override
        public V remove(Object key) {
            return this.map.remove(ShortCollectionAdapters.adaptShort(key));
        }

        @Override
        public void putAll(Map<? extends Short, ? extends V> m) {
            XShortLinkedHashMap<V> adapter = new XShortLinkedHashMap<V>(m != null ? m.size() : 16);
            for (Map.Entry<Short, V> entry : m.entrySet()) {
                adapter.put(ShortCollectionAdapters.adaptShort(entry.getKey()), entry.getValue());
            }
            this.map.putAll(adapter);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<Short> keySet() {
            return new XPrimitiveToShortSetAdapter(this.map.keySet());
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<Short, V>> entrySet() {
            return new XPrimtiveToShortEntrySetAdapter<V>(this.map.entrySet());
        }
    }
}

