/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang.test.unit;

import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.neeve.lang.XLongCollection;
import com.neeve.lang.XLongIterator;
import com.neeve.lang.XLongLinkedHashMap;
import com.neeve.lang.XLongLinkedList;
import com.neeve.lang.XLongList;
import com.neeve.lang.XLongListIterator;
import com.neeve.lang.XLongMap;
import com.neeve.lang.XLongSet;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

class LongCollectionAdapters {
    LongCollectionAdapters() {
    }

    static <V> Map<Long, V> toLinkedLongMap(XLongMap<V> map) {
        return new XPrimitiveToLongMapAdapter<V>(map);
    }

    static <V> List<Long> toLongList(XLongList list) {
        return new XPrimitiveToLongListAdapter(list);
    }

    private static long adaptLong(Object value) {
        if (value == null) {
            throw new NullPointerException("Null values not supported");
        }
        return (Long)value;
    }

    private static Object adaptLongMapEntry(Object entry) {
        if (entry == null) {
            return null;
        }
        if (entry instanceof Map.Entry) {
            try {
                return LongCollectionAdapters.adaptLongMapEntry((Map.Entry)entry);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return entry;
    }

    private static <V> XLongMap.Entry<V> adaptLongMapEntry(Map.Entry<Long, V> entry) {
        if (entry == null) {
            return null;
        }
        return new XLongToPrimitiveMapEntryAdapter<V>(entry);
    }

    private static Collection<?> adaptToPrimitiveLongMapEntryCollectionIfPossible(Collection<?> c) {
        if (c == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>(c.size());
        for (Object o : c) {
            list.add(LongCollectionAdapters.adaptLongMapEntry(o));
        }
        return list;
    }

    private static <V> Collection<? extends XLongMap.Entry<V>> adaptToPrimitiveLongMapEntryCollection(Collection<? extends Map.Entry<Long, V>> c) {
        if (c == null) {
            return null;
        }
        ArrayList<XLongMap.Entry<V>> list = new ArrayList<XLongMap.Entry<V>>(c.size());
        for (Map.Entry<Long, V> e : c) {
            list.add(LongCollectionAdapters.adaptLongMapEntry(e));
        }
        return list;
    }

    public static class Longs
    extends SampleElements<Long> {
        public Longs() {
            super((Object)1L, (Object)2L, (Object)3L, (Object)4L, (Object)5L);
        }
    }

    public static abstract class TestLongListGenerator
    implements TestListGenerator<Long> {
        public SampleElements<Long> samples() {
            return new Longs();
        }

        public List<Long> create(Object ... elements) {
            Long[] array = new Long[elements.length];
            int i = 0;
            for (Object e : elements) {
                array[i++] = (Long)e;
            }
            return this.create(array);
        }

        protected abstract List<Long> create(Long[] var1);

        public Long[] createArray(int length) {
            return new Long[length];
        }

        public List<Long> order(List<Long> insertionOrder) {
            return insertionOrder;
        }
    }

    public static abstract class TestLongMapGenerator
    implements TestMapGenerator<Long, String> {
        public SampleElements<Map.Entry<Long, String>> samples() {
            return new SampleElements((Object)Helpers.mapEntry((Object)1L, (Object)"January"), (Object)Helpers.mapEntry((Object)2L, (Object)"February"), (Object)Helpers.mapEntry((Object)3L, (Object)"March"), (Object)Helpers.mapEntry((Object)4L, (Object)"April"), (Object)Helpers.mapEntry((Object)5L, (Object)"May"));
        }

        public Map<Long, String> create(Object ... entries) {
            Map.Entry[] array = new Map.Entry[entries.length];
            int i = 0;
            for (Object o : entries) {
                Map.Entry e = (Map.Entry)o;
                array[i++] = e;
            }
            return this.create(array);
        }

        protected abstract Map<Long, String> create(Map.Entry<Long, String>[] var1);

        public final Map.Entry<Long, String>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public final Long[] createKeyArray(int length) {
            return new Long[length];
        }

        public final String[] createValueArray(int length) {
            return new String[length];
        }

        public Iterable<Map.Entry<Long, String>> order(List<Map.Entry<Long, String>> insertionOrder) {
            return insertionOrder;
        }
    }

    private static class XPrimtiveToLongEntrySetAdapter<V>
    extends AbstractSet<Map.Entry<Long, V>>
    implements Set<Map.Entry<Long, V>> {
        private final Set<XLongMap.Entry<V>> adaptee;

        public XPrimtiveToLongEntrySetAdapter(Set<XLongMap.Entry<V>> entrySet) {
            this.adaptee = entrySet;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(LongCollectionAdapters.adaptLongMapEntry(o));
        }

        @Override
        public Iterator<Map.Entry<Long, V>> iterator() {
            final Iterator<XLongMap.Entry<V>> toAdapt = this.adaptee.iterator();
            return new Iterator<Map.Entry<Long, V>>(){

                @Override
                public boolean hasNext() {
                    return toAdapt.hasNext();
                }

                @Override
                public Map.Entry<Long, V> next() {
                    XLongMap.Entry next = (XLongMap.Entry)toAdapt.next();
                    if (next == null) {
                        return null;
                    }
                    return new AbstractMap.SimpleEntry(next.getKey(), next.getValue());
                }

                @Override
                public void remove() {
                    toAdapt.remove();
                }
            };
        }

        @Override
        public Object[] toArray() {
            Object[] toAdapt = this.adaptee.toArray();
            Object[] adapted = new Object[toAdapt.length];
            for (int i = 0; i < toAdapt.length; ++i) {
                if (toAdapt[i] == null) continue;
                XLongMap.Entry xEntry = (XLongMap.Entry)toAdapt[i];
                adapted[i] = new AbstractMap.SimpleEntry(xEntry.getKey(), xEntry.getValue());
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            XLongMap.Entry[] toAdapt = this.adaptee.toArray(new XLongMap.Entry[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < toAdapt.length; ++i) {
                a[i] = toAdapt[i] != null ? new AbstractMap.SimpleEntry(toAdapt[i].getKey(), toAdapt[i].getValue()) : null;
            }
            return a;
        }

        @Override
        public boolean add(Map.Entry<Long, V> e) {
            return this.adaptee.add(LongCollectionAdapters.adaptLongMapEntry(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(LongCollectionAdapters.adaptLongMapEntry(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.adaptee.containsAll(LongCollectionAdapters.adaptToPrimitiveLongMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Long, V>> c) {
            return this.adaptee.addAll(LongCollectionAdapters.adaptToPrimitiveLongMapEntryCollection(c));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.adaptee.retainAll(LongCollectionAdapters.adaptToPrimitiveLongMapEntryCollectionIfPossible(c));
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.adaptee.removeAll(LongCollectionAdapters.adaptToPrimitiveLongMapEntryCollectionIfPossible(c));
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private static class XLongToPrimitiveMapEntryAdapter<V>
    extends XLongLinkedHashMap.Entry<V> {
        XLongToPrimitiveMapEntryAdapter(Map.Entry<Long, V> entry) {
            this.setKey(entry.getKey());
            this.setValue(entry.getValue());
        }
    }

    private static class XPrimitiveToLongListIteratorAdapater
    extends XLongIteratorAdapater
    implements ListIterator<Long> {
        final XLongListIterator adaptee;

        XPrimitiveToLongListIteratorAdapater(XLongListIterator iterator) {
            super(iterator);
            this.adaptee = iterator;
        }

        @Override
        public boolean hasPrevious() {
            return this.adaptee.hasPrevious();
        }

        @Override
        public Long previous() {
            return this.adaptee.previous();
        }

        @Override
        public int nextIndex() {
            return this.adaptee.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.adaptee.previousIndex();
        }

        @Override
        public void set(Long e) {
            this.adaptee.set(LongCollectionAdapters.adaptLong(e));
        }

        @Override
        public void add(Long e) {
            this.adaptee.add(LongCollectionAdapters.adaptLong(e));
        }
    }

    private static class XLongIteratorAdapater
    implements Iterator<Long> {
        final XLongIterator iterator;

        XLongIteratorAdapater(XLongIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Long next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class XPrimitiveToLongCollectionAdapter<S extends XLongCollection>
    extends AbstractCollection<Long>
    implements Collection<Long> {
        final S adaptee;

        XPrimitiveToLongCollectionAdapter(S collection) {
            this.adaptee = collection;
        }

        @Override
        public int size() {
            return this.adaptee.size();
        }

        @Override
        public boolean isEmpty() {
            return this.adaptee.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.adaptee.contains(LongCollectionAdapters.adaptLong(o));
        }

        @Override
        public Iterator<Long> iterator() {
            return new XLongIteratorAdapater(this.adaptee.iterator());
        }

        @Override
        public Object[] toArray() {
            long[] val = this.adaptee.toArray();
            Object[] adapted = new Object[val.length];
            for (int i = 0; i < val.length; ++i) {
                adapted[i] = val[i];
            }
            return adapted;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            long[] toAdapt = this.adaptee.toArray(new long[a.length]);
            if (toAdapt.length > a.length) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), toAdapt.length);
            }
            for (int i = 0; i < this.adaptee.size(); ++i) {
                a[i] = toAdapt[i];
            }
            if (a.length > this.adaptee.size()) {
                a[this.adaptee.size()] = null;
            }
            return a;
        }

        @Override
        public boolean add(Long e) {
            return this.adaptee.add(LongCollectionAdapters.adaptLong(e));
        }

        @Override
        public boolean remove(Object o) {
            return this.adaptee.remove(LongCollectionAdapters.adaptLong(o));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            XLongLinkedList adapter = new XLongLinkedList();
            for (Object o : c) {
                adapter.add(LongCollectionAdapters.adaptLong(o));
            }
            return this.adaptee.containsAll(adapter);
        }

        @Override
        public boolean addAll(Collection<? extends Long> c) {
            XLongLinkedList adapter = new XLongLinkedList();
            for (Long l : c) {
                adapter.add(LongCollectionAdapters.adaptLong(l));
            }
            return this.adaptee.addAll(adapter);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            XLongLinkedList adapter = new XLongLinkedList();
            for (Object o : c) {
                try {
                    adapter.add(LongCollectionAdapters.adaptLong(o));
                }
                catch (NullPointerException nullPointerException) {}
            }
            return this.adaptee.retainAll(adapter);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            XLongLinkedList adapter = new XLongLinkedList();
            for (Object o : c) {
                adapter.add(LongCollectionAdapters.adaptLong(o));
            }
            return this.adaptee.removeAll(adapter);
        }

        @Override
        public void clear() {
            this.adaptee.clear();
        }
    }

    private static class XPrimitiveToLongListAdapter
    extends XPrimitiveToLongCollectionAdapter<XLongList>
    implements List<Long> {
        XPrimitiveToLongListAdapter(XLongList set) {
            super(set);
        }

        @Override
        public boolean addAll(int index, Collection<? extends Long> c) {
            XLongLinkedList adapter = new XLongLinkedList();
            for (Long l : c) {
                adapter.add(LongCollectionAdapters.adaptLong(l));
            }
            return ((XLongList)this.adaptee).addAll(index, adapter);
        }

        @Override
        public Long get(int index) {
            return ((XLongList)this.adaptee).get(index);
        }

        @Override
        public Long set(int index, Long element) {
            return ((XLongList)this.adaptee).set(index, LongCollectionAdapters.adaptLong(element));
        }

        @Override
        public void add(int index, Long element) {
            ((XLongList)this.adaptee).add(index, LongCollectionAdapters.adaptLong(element));
        }

        @Override
        public Long remove(int index) {
            return ((XLongList)this.adaptee).remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return ((XLongList)this.adaptee).indexOf(LongCollectionAdapters.adaptLong(o));
        }

        @Override
        public int lastIndexOf(Object o) {
            return ((XLongList)this.adaptee).lastIndexOf(LongCollectionAdapters.adaptLong(o));
        }

        @Override
        public ListIterator<Long> listIterator() {
            return new XPrimitiveToLongListIteratorAdapater(((XLongList)this.adaptee).listIterator());
        }

        @Override
        public ListIterator<Long> listIterator(int index) {
            return new XPrimitiveToLongListIteratorAdapater(((XLongList)this.adaptee).listIterator(index));
        }

        @Override
        public List<Long> subList(int fromIndex, int toIndex) {
            return new XPrimitiveToLongListAdapter(((XLongList)this.adaptee).subList(fromIndex, toIndex));
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof List)) {
                return false;
            }
            ListIterator<Long> e1 = this.listIterator();
            ListIterator e2 = ((List)o).listIterator();
            while (e1.hasNext() && e2.hasNext()) {
                Long o1 = e1.next();
                Object o2 = e2.next();
                if (o1 != null ? o1.equals(o2) : o2 == null) continue;
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        }

        @Override
        public int hashCode() {
            int hashCode = 1;
            for (Long obj : this) {
                hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
            }
            return hashCode;
        }
    }

    private static class XPrimitiveToLongSetAdapter
    extends XPrimitiveToLongCollectionAdapter<XLongSet>
    implements Set<Long> {
        XPrimitiveToLongSetAdapter(XLongSet set) {
            super(set);
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Set)) {
                return false;
            }
            Collection c = (Collection)o;
            if (c.size() != this.size()) {
                return false;
            }
            try {
                return this.containsAll(c);
            }
            catch (ClassCastException unused) {
                return false;
            }
            catch (NullPointerException unused) {
                return false;
            }
        }

        @Override
        public int hashCode() {
            int h = 0;
            for (Long obj : this) {
                if (obj == null) continue;
                h += obj.hashCode();
            }
            return h;
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            boolean modified = false;
            if (this.size() > c.size()) {
                Iterator<?> i = c.iterator();
                while (i.hasNext()) {
                    modified |= this.remove(i.next());
                }
            } else {
                Iterator<Long> i = this.iterator();
                while (i.hasNext()) {
                    if (!c.contains(i.next())) continue;
                    i.remove();
                    modified = true;
                }
            }
            return modified;
        }
    }

    private static class XPrimitiveToLongMapAdapter<V>
    extends AbstractMap<Long, V>
    implements Map<Long, V> {
        private final XLongMap<V> map;

        public XPrimitiveToLongMapAdapter(XLongMap<V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(LongCollectionAdapters.adaptLong(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.map.get(LongCollectionAdapters.adaptLong(key));
        }

        @Override
        public V put(Long key, V value) {
            return this.map.put(LongCollectionAdapters.adaptLong(key), value);
        }

        @Override
        public V remove(Object key) {
            return this.map.remove(LongCollectionAdapters.adaptLong(key));
        }

        @Override
        public void putAll(Map<? extends Long, ? extends V> m) {
            XLongLinkedHashMap<V> adapter = new XLongLinkedHashMap<V>(m != null ? m.size() : 16);
            for (Map.Entry<Long, V> entry : m.entrySet()) {
                adapter.put(LongCollectionAdapters.adaptLong(entry.getKey()), entry.getValue());
            }
            this.map.putAll(adapter);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<Long> keySet() {
            return new XPrimitiveToLongSetAdapter(this.map.keySet());
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<Long, V>> entrySet() {
            return new XPrimtiveToLongEntrySetAdapter<V>(this.map.entrySet());
        }
    }
}

