/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.io.IOBuffer;
import com.neeve.io.IOElasticBuffer;
import com.neeve.util.UtlEnv;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;

public class XString
implements Appendable,
CharSequence {
    private static final boolean DISABLE_NATIVE_BUFFERS = UtlEnv.getValue("nv.xstring.disablenative", UtlEnv.getValue("nv.raw.string.disablenative", Boolean.FALSE));
    private static final char[] digits;
    private static final char[] DigitTens;
    private static final char[] DigitOnes;
    private static final String MIN_LONG_STRING = "-9223372036854775808";
    private static final long MULTMIN_RADIX_TEN = -922337203685477580L;
    private static final long N_MULTMAX_RADIX_TEN = -922337203685477580L;
    private static final CharsetEncoder asciiEncoder;
    private final IOElasticBuffer buffer;
    private final boolean isNative;
    private int offset;
    private int length;
    protected String str;
    protected boolean initialized = false;
    protected boolean mutable;
    protected boolean needsSync = true;

    protected XString(boolean isNative, boolean mutable, int initialLength) {
        this.isNative = !DISABLE_NATIVE_BUFFERS && isNative;
        this.mutable = mutable;
        this.buffer = IOElasticBuffer.create(null, Math.max(1, initialLength), isNative);
        if (initialLength > 0) {
            this.buffer.setLength(initialLength).setLength(0);
        }
    }

    public static XString create() {
        return new XString(false, true, 0);
    }

    public static XString create(String value) {
        return XString.create(value, false, false);
    }

    public static XString create(String value, boolean bufferbacked) {
        return XString.create(value, bufferbacked, false);
    }

    public static XString create(String value, boolean bufferbacked, boolean isNative) {
        XString rc = new XString(isNative, false, !bufferbacked || value == null ? 0 : value.length());
        if (bufferbacked) {
            rc.initialize(value);
        } else {
            rc.str = value;
            rc.initialized = true;
            rc.needsSync = true;
        }
        return rc;
    }

    public static XString create(int bufferSize) {
        XString rc = new XString(false, false, bufferSize);
        rc.initialized = false;
        return rc;
    }

    public static XString create(int bufferSize, boolean mutable) {
        XString rc = new XString(false, mutable, bufferSize);
        rc.initialized = false;
        return rc;
    }

    public static XString create(int bufferSize, boolean mutable, boolean isNative) {
        XString rc = new XString(isNative, mutable, bufferSize);
        rc.initialized = false;
        return rc;
    }

    private static final int stringSize(long val) {
        long p = 10L;
        for (int i = 1; i < 19; ++i) {
            if (val < p) {
                return i;
            }
            p = 10L * p;
        }
        return 19;
    }

    private static final boolean equalsCharSequence(CharSequence c1, CharSequence c2) {
        if (c1.length() != c2.length()) {
            return false;
        }
        for (int p = 0; p < c1.length(); ++p) {
            if (c1.charAt(p) == c2.charAt(p)) continue;
            return false;
        }
        return true;
    }

    public final boolean startsWith(CharSequence prefix) {
        return this.startsWith(prefix, 0);
    }

    public final boolean startsWith(CharSequence prefix, int offset) {
        if (this.isNull()) {
            return false;
        }
        if (prefix == null || prefix instanceof XString && !((XString)prefix).isInitialized()) {
            return false;
        }
        if (offset < 0 || offset > this.length() || this.length() - offset + 1 < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (this.charAt(i + offset) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public final int indexOf(CharSequence str) {
        return this.indexOf(str, 0);
    }

    public final int indexOf(CharSequence str, int offset) {
        if (this.isNull()) {
            return -1;
        }
        if (str == null || str instanceof XString && !((XString)str).isInitialized()) {
            return -1;
        }
        if (offset < 0 || offset >= this.length()) {
            return -1;
        }
        if (this.length() - offset == 0 && str.length() == 0) {
            return 0;
        }
        for (int i = offset; i < this.length(); ++i) {
            if (this.startsWith(str, i)) {
                return i;
            }
            if (this.length() - i >= str.length()) continue;
            return -1;
        }
        return -1;
    }

    public final int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public final int indexOf(char c, int offset) {
        if (this.isNull()) {
            return -1;
        }
        if (offset < 0 || offset >= this.length()) {
            return -1;
        }
        for (int i = offset; i < this.length(); ++i) {
            if (this.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public final int compareTo(CharSequence other) {
        if (other instanceof XString) {
            XString x = (XString)other;
            if (x.isNull() && this.isNull()) {
                return 0;
            }
            if (this.isNull()) {
                return -1;
            }
            if (x.isNull()) {
                return 1;
            }
        }
        if (this.isNull()) {
            if (other == null) {
                return 0;
            }
            return -1;
        }
        int len1 = this.length();
        int len2 = other.length();
        int lim = Math.min(len1, len2);
        for (int i = 0; i < lim; ++i) {
            char c2;
            char c1 = this.charAt(i);
            if (c1 == (c2 = other.charAt(i))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static final boolean isNativeXStringEnabled() {
        return !DISABLE_NATIVE_BUFFERS;
    }

    private final void syncToBackingBuffer() {
        if (this.needsSync) {
            if (this.str == null) {
                this.buffer.setLength(0);
                this.length = -1;
            } else {
                this.length = this.buffer.putString(this.offset, this.str);
            }
            this.needsSync = false;
        }
    }

    private final void checkMutable() {
        if (!this.mutable && this.initialized) {
            throw new IllegalStateException("not mutable");
        }
    }

    public final boolean isMutable() {
        return this.mutable;
    }

    public final String getValue() {
        if (!this.initialized) {
            return null;
        }
        if (this.str != null) {
            return this.str;
        }
        if (this.buffer != null) {
            if (this.length == -1) {
                return null;
            }
            this.str = this.buffer.getString(this.offset, this.length);
        }
        return this.str;
    }

    @Override
    public final CharSequence subSequence(int start, int end) {
        if (start < 0) {
            throw new StringIndexOutOfBoundsException(start);
        }
        if (start > end) {
            throw new StringIndexOutOfBoundsException(end - start);
        }
        if (end > this.length()) {
            throw new StringIndexOutOfBoundsException(end);
        }
        return new SubCharSequence(start, end - start);
    }

    public final boolean initialize(String value) {
        if (this.initialized) {
            throw new IllegalStateException("Already inialized");
        }
        this.initialized = true;
        this.str = value;
        if (this.str != null) {
            IOBuffer buf = this.buffer.getIOBuffer();
            this.buffer.setLength(0);
            this.length = this.buffer.putString(this.offset, this.str);
            this.needsSync = false;
            return buf == this.buffer.getIOBuffer();
        }
        this.length = -1;
        this.buffer.setLength(0);
        this.needsSync = false;
        return false;
    }

    public final boolean initializeFrom(XString value) {
        if (this.initialized) {
            throw new IllegalStateException("Already inialized");
        }
        IOBuffer buf = this.buffer.getIOBuffer();
        value.copyInto(this);
        return buf == this.buffer.getIOBuffer();
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final boolean isImmutable() {
        return !this.mutable && this.initialized;
    }

    public final void setValue(String val) {
        this.checkMutable();
        this.initialized = true;
        if (this.str == val && !this.initialized) {
            return;
        }
        this.buffer.setLength(0);
        this.needsSync = true;
        this.length = val != null ? val.length() : -1;
        this.str = val;
    }

    public final void setValue(XString value) {
        this.checkMutable();
        if (value != null) {
            value.copyInto(this);
        } else {
            this.clear();
        }
    }

    @Deprecated
    public final void copyFrom(XString val) {
        this.checkMutable();
        if (val != null) {
            val.copyInto(this);
        } else {
            this.clear();
        }
    }

    @Deprecated
    public final void copyFromNative(long address, int length) {
        this.setValueFromMemory(address, length);
    }

    @Deprecated
    public final void copyFromMemory(long address, int length) {
        this.setValueFromMemory(address, length);
    }

    public final void setValueFromMemory(long address, int length) {
        this.checkMutable();
        this.clear();
        this.buffer.putFromNative(this.offset, address, 0, length);
        this.length = length;
        this.needsSync = false;
        this.initialized = true;
    }

    @Deprecated
    public final void copyFrom(char[] val) {
        this.checkMutable();
        this.clear();
        this.append(val);
    }

    public void setValue(long value) {
        this.checkMutable();
        this.clear();
        this.append(value);
    }

    public void setValue(char[] value) {
        this.checkMutable();
        this.clear();
        this.append(value, 0, value != null ? value.length : 0);
    }

    public void setValue(char[] value, int valueOffset, int valueLength) {
        this.checkMutable();
        this.clear();
        this.append(value, valueOffset, valueLength);
    }

    public final void setValue(byte[] value) {
        this.checkMutable();
        this.clear();
        this.append(value, 0, value != null ? value.length : 0);
    }

    public final void setValue(byte[] value, int valueOffset, int valueLength) {
        this.checkMutable();
        this.clear();
        this.append(value, valueOffset, valueLength);
    }

    public void setValue(CharSequence value) {
        this.checkMutable();
        this.clear();
        this.length = this.buffer.putCharSequenceUTF(this.offset, value);
        this.needsSync = false;
        this.initialized = true;
    }

    public final long getValueAsLong() throws NumberFormatException {
        return this.getValueAsLong(10);
    }

    public final long getValueAsLongDecimal() {
        long num = 0L;
        long sign = -1L;
        int len = this.length();
        char ch = this.charAt(0);
        if (ch == '-') {
            sign = 1L;
        } else {
            num = 48 - ch;
        }
        int i = 1;
        while (i < len) {
            num = num * 10L + 48L - (long)this.charAt(i++);
        }
        return sign * num;
    }

    public final long getValueAsLong(int radix) throws NumberFormatException {
        if (!this.isInitialized() || this.length() <= 0) {
            throw new NumberFormatException("null");
        }
        if (radix < 2) {
            throw new NumberFormatException("radix " + radix + " less than Character.MIN_RADIX");
        }
        if (radix > 36) {
            throw new NumberFormatException("radix " + radix + " greater than Character.MAX_RADIX");
        }
        long result = 0L;
        boolean negative = false;
        int i = 0;
        int max = this.length();
        if (max > 0) {
            int digit;
            long limit;
            if (this.charAt(0) == '-') {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            long multmin = radix == 10 ? (negative ? -922337203685477580L : -922337203685477580L) : limit / (long)radix;
            if (i < max) {
                if ((digit = Character.digit(this.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException(this.getValue());
                }
                result = -digit;
            }
            while (i < max) {
                if ((digit = Character.digit(this.charAt(i++), radix)) < 0) {
                    throw new NumberFormatException(this.getValue());
                }
                if (result < multmin) {
                    throw new NumberFormatException(this.getValue());
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    throw new NumberFormatException(this.getValue());
                }
                result -= (long)digit;
            }
        } else {
            throw new NumberFormatException(this.getValue());
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            throw new NumberFormatException(this.getValue());
        }
        return -result;
    }

    public void setCharAt(int position, char value) {
        this.checkMutable();
        if (position < 0 || position >= this.length()) {
            throw new IndexOutOfBoundsException("Invalid position: " + position + " valid range is [0, " + this.length + "]");
        }
        if (!this.isInitialized() || this.length() <= 0) {
            throw new NumberFormatException("null");
        }
        if (!asciiEncoder.canEncode(value)) {
            throw new IllegalArgumentException("'" + value + "' is not an ascii character. XString currently only supports setting ascii encodable characters");
        }
        this.syncToBackingBuffer();
        this.str = null;
        this.buffer.put(this.offset + position, (byte)value);
    }

    public final void setValue(IOElasticBuffer source, int offset, int length) {
        this.checkMutable();
        this.buffer.setLength(0);
        this.buffer.putFrom(this.offset, source, offset, length);
        this.initialized = true;
        this.length = length;
        this.str = null;
        this.needsSync = false;
    }

    public final void setValue(IOBuffer source, int offset, int length, boolean wrap) {
        this.checkMutable();
        if (wrap) {
            this.buffer.wrapIOBuffer(source, offset, length);
        } else {
            this.buffer.setLength(0);
            this.buffer.putFrom(this.offset, source, offset, length);
        }
        this.initialized = true;
        this.length = length;
        this.str = null;
        this.needsSync = false;
    }

    public final void setValue(ByteBuffer source, int position, int length) {
        this.checkMutable();
        if (source.limit() < position + length) {
            throw new IllegalStateException("source buffer limit must be >= (position + length)");
        }
        this.buffer.setLength(0);
        this.buffer.putFrom(this.offset, source, position, length);
        this.initialized = true;
        this.length = length;
        this.str = null;
        this.needsSync = false;
    }

    public final void setValue(ByteBuffer source) {
        this.checkMutable();
        this.buffer.setLength(0);
        this.buffer.putFrom(this.offset, source, source.remaining());
        this.initialized = true;
        this.length = source.remaining();
        this.str = null;
        this.needsSync = false;
    }

    public final XString copyInto(XString target) {
        this.syncToBackingBuffer();
        if (target.isImmutable()) {
            target = XString.create(this.getSerializedLength(), false, target.isNative);
        }
        if (!this.initialized) {
            target.setValue((String)null);
            return target;
        }
        if (this.length >= 0) {
            target.buffer.putFrom(0, this.buffer, this.offset, this.length);
        } else {
            target.buffer.setLength(0);
        }
        target.length = this.length;
        target.initialized = true;
        target.needsSync = false;
        target.str = this.str;
        return target;
    }

    public final <T extends IOElasticBuffer> T copyInto(T target, int offset) {
        if (!this.initialized) {
            return null;
        }
        this.syncToBackingBuffer();
        if (this.length == -1) {
            return null;
        }
        if (this.buffer != target) {
            target.putFrom(offset, this.buffer, this.offset, this.length);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int copyInto(IOBuffer target, int offset) {
        if (!this.initialized) {
            return 0;
        }
        if (this.buffer.getIOBuffer() == target) {
            return 0;
        }
        this.syncToBackingBuffer();
        if (this.length == -1) {
            return 0;
        }
        if (this.buffer.getIOBuffer() != target) {
            ByteBuffer targetBuffer = target.getBufferUnsafe();
            int pos = targetBuffer.position();
            targetBuffer.position(offset);
            try {
                this.buffer.getTo(offset, targetBuffer, this.length);
                target.adjustHighwater(offset + this.length);
            }
            finally {
                targetBuffer.position(pos);
            }
            return this.length;
        }
        return 0;
    }

    public final int copyInto(ByteBuffer target, int position) {
        if (!this.initialized) {
            return 0;
        }
        this.syncToBackingBuffer();
        if (this.length == -1) {
            return 0;
        }
        if (this.buffer.getIOBuffer().getBufferUnsafe() != target) {
            this.buffer.getTo(this.offset, target, position, this.length);
            return this.length;
        }
        return 0;
    }

    public final void reset() {
        this.checkMutable();
        this.initialized = false;
        this.buffer.setLength(0);
        this.length = -1;
        this.str = null;
        this.needsSync = false;
    }

    public final void clear() throws IllegalStateException {
        this.reset();
    }

    @Override
    public final boolean isEmpty() {
        return this.needsSync ? this.str == null || this.str.isEmpty() : this.length < 0;
    }

    public final boolean isNull() {
        return this.needsSync ? this.str == null : this.length < 0;
    }

    public final int getSerializedLength() {
        this.syncToBackingBuffer();
        return this.length < 0 ? 0 : this.length;
    }

    public final int serializedLength() {
        return this.getSerializedLength();
    }

    public final IOElasticBuffer getBackingBuffer() {
        this.syncToBackingBuffer();
        return this.buffer;
    }

    public final int getBackingBufferOffset() {
        this.syncToBackingBuffer();
        return this.offset;
    }

    public final XString append(XString source) {
        this.checkMutable();
        if (source == this) {
            throw new IllegalStateException("Can't append XString to itself");
        }
        if (source == null || !source.isInitialized()) {
            return this;
        }
        if (source.getSerializedLength() <= 0) {
            return this;
        }
        int serializedLength = this.getSerializedLength();
        if (!this.initialized || this.length == -1) {
            this.length = 0;
            this.initialized = true;
        } else {
            this.syncToBackingBuffer();
        }
        source.copyInto(this.buffer, this.offset + serializedLength);
        this.str = null;
        this.initialized = true;
        this.needsSync = false;
        this.length = serializedLength + source.length();
        return this;
    }

    public final XString append(ByteBuffer value) {
        this.checkMutable();
        if (value == null || value.remaining() == 0) {
            return this;
        }
        int serializedLength = this.getSerializedLength();
        if (!this.initialized || this.length == -1) {
            this.length = 0;
            this.initialized = true;
        } else {
            this.syncToBackingBuffer();
        }
        this.buffer.putFrom(this.offset + serializedLength, value, value.remaining());
        this.str = null;
        this.initialized = true;
        this.needsSync = false;
        this.length = serializedLength + value.remaining();
        return this;
    }

    public final XString append(byte[] value) {
        return this.append(value, 0, value != null ? value.length : 0);
    }

    public final XString append(byte[] value, int valueOffset, int valueLength) {
        this.checkMutable();
        if (value == null) {
            return this;
        }
        if (valueOffset < 0 || valueOffset >= value.length) {
            throw new IllegalArgumentException("offset " + valueOffset + " is out of bounds for array of length " + value.length);
        }
        if (valueLength < 0 || valueLength + valueOffset > value.length) {
            throw new IllegalArgumentException("offset " + valueOffset + " and length " + valueLength + " are out of bounds for array of length " + value.length);
        }
        int serializedLength = this.getSerializedLength();
        if (!this.initialized || this.length == -1) {
            this.length = 0;
            this.initialized = true;
        } else {
            this.syncToBackingBuffer();
        }
        this.buffer.putFrom(this.offset + serializedLength, value, valueOffset, valueLength);
        this.str = null;
        this.initialized = true;
        this.needsSync = false;
        this.length = serializedLength + valueLength;
        return this;
    }

    public final XString append(boolean value) {
        this.append(value ? "true" : "false");
        return this;
    }

    public final XString append(long value) {
        int q2;
        int r;
        if (value == Long.MIN_VALUE) {
            this.append(MIN_LONG_STRING);
            return this;
        }
        this.checkMutable();
        if (!this.initialized || this.length == -1) {
            this.length = 0;
            this.initialized = true;
        } else {
            this.syncToBackingBuffer();
        }
        int strSize = value < 0L ? XString.stringSize(-value) + 1 : XString.stringSize(value);
        int charPos = this.buffer.getLength() + this.offset + strSize;
        this.length += strSize;
        this.str = null;
        this.initialized = true;
        this.needsSync = false;
        int sign = 0;
        if (value < 0L) {
            sign = 45;
            value = -value;
        }
        while (value > Integer.MAX_VALUE) {
            long q = value / 100L;
            r = (int)(value - ((q << 6) + (q << 5) + (q << 2)));
            value = q;
            this.buffer.put(--charPos, (byte)DigitOnes[r]);
            this.buffer.put(--charPos, (byte)DigitTens[r]);
        }
        int i2 = (int)value;
        while (i2 >= 65536) {
            q2 = i2 / 100;
            r = i2 - ((q2 << 6) + (q2 << 5) + (q2 << 2));
            i2 = q2;
            this.buffer.put(--charPos, (byte)DigitOnes[r]);
            this.buffer.put(--charPos, (byte)DigitTens[r]);
        }
        do {
            q2 = i2 * 52429 >>> 19;
            r = i2 - ((q2 << 3) + (q2 << 1));
            this.buffer.put(--charPos, (byte)digits[r]);
        } while ((i2 = q2) != 0);
        if (sign != 0) {
            this.buffer.put(--charPos, (byte)sign);
        }
        return this;
    }

    @Override
    public final XString append(char value) throws IllegalArgumentException {
        this.checkMutable();
        if (!this.initialized || this.length == -1) {
            this.length = 0;
            this.initialized = true;
        } else {
            this.syncToBackingBuffer();
        }
        int serializedLength = this.getSerializedLength();
        if (!asciiEncoder.canEncode(value)) {
            throw new IllegalArgumentException("'" + value + "' is not an ascii character. XString currently only supports appending ascii encodable characters");
        }
        this.buffer.put(this.offset + serializedLength, (byte)value);
        this.str = null;
        this.initialized = true;
        this.length = serializedLength + 1;
        this.needsSync = false;
        return this;
    }

    @Override
    public final XString append(CharSequence value) throws IllegalArgumentException {
        this.append(value, 0, value.length());
        return this;
    }

    @Override
    public final Appendable append(CharSequence value, int start, int end) throws IllegalArgumentException {
        this.checkMutable();
        if (value == null) {
            return this;
        }
        int initialLength = this.length;
        int initialBufferLength = this.getSerializedLength();
        if (!this.initialized || this.length == -1) {
            this.length = 0;
            this.initialized = true;
        } else {
            this.syncToBackingBuffer();
        }
        int appendPos = this.offset + this.length;
        for (int i = start; i < end; ++i) {
            char c = value.charAt(i);
            if (!asciiEncoder.canEncode(c)) {
                this.length = initialLength;
                this.buffer.setLength(initialBufferLength);
                throw new IllegalArgumentException("'" + c + "' is not an ascii character. XString currently only supports appending ascii encodable characters");
            }
            this.buffer.put(appendPos++, (byte)c);
        }
        this.length += value.length();
        this.str = null;
        this.initialized = true;
        this.needsSync = false;
        return this;
    }

    public final XString append(char[] value) throws IllegalArgumentException {
        return this.append(value, 0, value != null ? value.length : 0);
    }

    public final XString append(char[] value, int valueOffset, int valueLength) throws IllegalArgumentException {
        this.checkMutable();
        if (value == null) {
            return this;
        }
        if (valueOffset < 0 || valueOffset >= value.length) {
            throw new IllegalArgumentException("offset " + valueOffset + " is out of bounds for array of length " + value.length);
        }
        if (valueLength < 0 || valueLength + valueOffset > value.length) {
            throw new IllegalArgumentException("offset " + valueOffset + " and length " + valueLength + " are out of bounds for array of length " + value.length);
        }
        int initialLength = this.length;
        int initialBufferLength = this.getSerializedLength();
        if (!this.initialized || this.length == -1) {
            this.length = 0;
            this.initialized = true;
        } else {
            this.syncToBackingBuffer();
        }
        int appendPos = this.offset + this.length;
        for (int i = valueOffset; i < valueOffset + valueLength; ++i) {
            char c = value[i];
            if (!asciiEncoder.canEncode(c)) {
                this.length = initialLength;
                this.buffer.setLength(initialBufferLength);
                throw new IllegalArgumentException("'" + c + "' is not an ascii character. XString currently only supports appending ascii encodable characters");
            }
            this.buffer.put(appendPos++, (byte)c);
        }
        this.length += valueLength;
        this.str = null;
        this.initialized = true;
        this.needsSync = false;
        return this;
    }

    @Override
    public final int length() {
        return this.getSerializedLength();
    }

    @Override
    public final char charAt(int index) throws IndexOutOfBoundsException {
        if (this.length == -1 || index < 0 || index > this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (this.needsSync) {
            this.syncToBackingBuffer();
        }
        return (char)this.buffer.get(index);
    }

    public void padForNullTerminator() {
        int serializedLength = this.getSerializedLength();
        if (serializedLength + 1 >= this.buffer.getIOBuffer().getCapacity()) {
            this.buffer.setLength(serializedLength + 1);
            this.buffer.setLength(serializedLength);
        }
    }

    @Override
    public String toString() {
        return this.getValue();
    }

    public final String toDiagnosticString() {
        String val = null;
        if (!this.needsSync && this.length > -1) {
            val = this.buffer.getString(this.offset, this.length);
        }
        return this.getClass().getSimpleName() + ":[init=" + this.initialized + ", mutable=" + this.mutable + ", offset=" + this.offset + ", len=" + this.length + ", slen=" + this.getSerializedLength() + ", str='" + this.str + "', val='" + val + "', buf=" + this.buffer.toString() + "']";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof XString) {
            XString other = (XString)object;
            int sLength = this.getSerializedLength();
            if (other.getSerializedLength() != sLength) {
                return false;
            }
            int p = this.offset;
            int t = other.offset;
            while (p < sLength) {
                if (this.buffer.get(p) != other.buffer.get(t)) {
                    return false;
                }
                ++p;
                ++t;
            }
            return true;
        }
        if (object instanceof SubCharSequence) {
            return XString.equalsCharSequence(this, (SubCharSequence)object);
        }
        return false;
    }

    public int hashCode() {
        if (!this.initialized) {
            return 0;
        }
        int sLength = this.getSerializedLength();
        if (sLength == 0) {
            return 0;
        }
        int h = 1;
        for (int p = this.offset; p < sLength; ++p) {
            h = 31 * h + this.buffer.get(p);
        }
        return h;
    }

    static {
        if (UtlEnv.getValue("nv.native.configtrace", false)) {
            System.out.println("NATIVE XSTRING BUFFERS ARE " + (!DISABLE_NATIVE_BUFFERS ? "ENABLED" : "DISABLED"));
        }
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        DigitTens = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1', '1', '1', '1', '2', '2', '2', '2', '2', '2', '2', '2', '2', '2', '3', '3', '3', '3', '3', '3', '3', '3', '3', '3', '4', '4', '4', '4', '4', '4', '4', '4', '4', '4', '5', '5', '5', '5', '5', '5', '5', '5', '5', '5', '6', '6', '6', '6', '6', '6', '6', '6', '6', '6', '7', '7', '7', '7', '7', '7', '7', '7', '7', '7', '8', '8', '8', '8', '8', '8', '8', '8', '8', '8', '9', '9', '9', '9', '9', '9', '9', '9', '9', '9'};
        DigitOnes = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        asciiEncoder = Charset.forName("US-ASCII").newEncoder();
    }

    public static final class XStringFactory
    implements Factory<XString> {
        private final int stringLength;
        private final boolean isNative;

        private XStringFactory(String name, int stringLength, boolean isNative, boolean pooled, int preallocationCount, boolean threaded) {
            this.stringLength = stringLength;
            this.isNative = isNative;
            if (pooled) {
                throw new UnsupportedOperationException("XString does not support pooling, use XPooledString instead");
            }
            if (preallocationCount > 0) {
                throw new UnsupportedOperationException("XStringFactory does not currently support pool preallocation use XPooledString instead.");
            }
        }

        public static Factory<? extends XString> newFactory(String name, int stringLength, boolean isNative) {
            return new XStringFactory(name, stringLength, isNative, false, 0, false);
        }

        @Deprecated
        public static Factory<? extends XString> newFactory(String name, int stringLength, boolean pooled, int preallocationCount, boolean threaded, boolean isNative) {
            if (pooled) {
                return new XStringFactory(name, stringLength, isNative, pooled, preallocationCount, threaded);
            }
            return new XStringFactory(name, stringLength, isNative, pooled, preallocationCount, threaded);
        }

        public final boolean getIsNative() {
            return this.isNative;
        }

        public final int getStringLength() {
            return this.stringLength;
        }

        @Override
        public final XString create() {
            return this.create(true);
        }

        public final XString[] createArray(int size) {
            XString[] rc = new XString[size];
            for (int i = 0; i < size; ++i) {
                rc[i] = this.create(true);
            }
            return rc;
        }

        @Override
        public final XString create(String value) {
            return this.create(value, false);
        }

        @Override
        public final XString create(boolean mutable) {
            return new XString(this.isNative, mutable, this.stringLength);
        }

        @Override
        public final XString create(String initialValue, boolean mutable) {
            XString rc = this.create(mutable);
            rc.initialize(initialValue);
            return rc;
        }

        @Override
        public final XString create(XString initialValue, boolean mutable) {
            XString rc = this.create(mutable);
            rc.initializeFrom(initialValue);
            return rc;
        }
    }

    public static interface Factory<T extends XString> {
        public static final String PROP_INITIAL_LENGTH = "initialLength";
        public static final String PROP_NATIVE = "isNative";
        public static final String PROP_POOLED = "pool.enabled";
        public static final String PROP_POOL_THREADED = "pool.threaded";
        public static final String PROP_POOL_PREALLOCATE_COUNT = "pool.preallocateCount";

        public T create();

        public T[] createArray(int var1);

        public T create(boolean var1);

        public T create(String var1);

        public T create(String var1, boolean var2);

        public T create(XString var1, boolean var2);
    }

    private final class SubCharSequence
    implements CharSequence {
        final int start;
        final int length;

        SubCharSequence(int start, int length) {
            this.start = start;
            this.length = length;
        }

        @Override
        public final int length() {
            return this.length;
        }

        @Override
        public final char charAt(int index) {
            if (index < 0 || index >= this.length) {
                throw new StringIndexOutOfBoundsException("" + index);
            }
            return XString.this.charAt(this.start + index);
        }

        @Override
        public final CharSequence subSequence(int start, int end) {
            if (start < 0) {
                throw new StringIndexOutOfBoundsException(start);
            }
            if (start > end) {
                throw new StringIndexOutOfBoundsException(end - start);
            }
            if (end > this.length) {
                throw new StringIndexOutOfBoundsException(end);
            }
            return XString.this.subSequence(this.start + start, this.start + end);
        }

        public final boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof XString || object instanceof SubCharSequence) {
                return XString.equalsCharSequence(this, (CharSequence)object);
            }
            return true;
        }

        public final int hashCode() {
            if (!XString.this.initialized) {
                return 0;
            }
            if (this.length() == 0) {
                return 0;
            }
            int h = 1;
            for (int p = XString.this.offset; p < this.length(); ++p) {
                h = 31 * h + this.charAt(p);
            }
            return h;
        }

        @Override
        public String toString() {
            char[] chars = new char[this.length()];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = this.charAt(i);
            }
            return new String(chars);
        }
    }
}

