/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XCollection;
import com.neeve.lang.XLongCollection;
import com.neeve.lang.XLongIterator;
import com.neeve.lang.XLongIteratorImpl;
import com.neeve.lang.XLongList;
import com.neeve.lang.XLongListIterator;
import com.neeve.lang.XLongSet;
import java.util.List;

public abstract class XLongCollectionBase
implements XLongCollection {
    private XLongIteratorImpl reusableIterator;

    protected XLongCollectionBase() {
    }

    @Override
    public abstract int size();

    @Override
    public abstract XCollection.Record head();

    @Override
    public abstract XCollection.Record tail();

    @Override
    public abstract long valueOf(XCollection.Record var1);

    @Override
    public abstract void delete(XCollection.Record var1);

    @Override
    public XLongCollection unmodifiable() {
        return new Unmodifiable();
    }

    @Override
    public XLongCollection shared() {
        return new Shared();
    }

    @Override
    public XLongIterator iterator() {
        return XLongIteratorImpl.valueOf(this);
    }

    @Override
    public XLongIterator reusableIterator() {
        if (this.reusableIterator == null) {
            this.reusableIterator = XLongIteratorImpl.valueOf(this);
        } else {
            this.reusableIterator.toFirst();
        }
        return this.reusableIterator;
    }

    @Override
    public boolean supportsIteratorModifications() {
        return true;
    }

    @Override
    public boolean add(long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(long value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            this.delete(r);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        XCollection.Record head = this.head();
        for (XCollection.Record r = this.tail().getPrevious(); r != head; r = r.getPrevious()) {
            this.delete(r);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(long value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(XLongCollection c) {
        boolean modified = false;
        XLongIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.add(itr.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean containsAll(XLongCollection c) {
        XLongIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(XLongCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public boolean retainAll(XLongCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (!c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public long[] toArray() {
        return this.toArray(new long[this.size()]);
    }

    @Override
    public long[] toArray(long[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new long[size];
        }
        if (array.length > size) {
            array[size] = -1L;
        }
        int i = 0;
        long[] arrayView = array;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            arrayView[i++] = this.valueOf(r);
        }
        return array;
    }

    public String toString() {
        XLongIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            long e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this instanceof XLongList) {
            return obj instanceof XLongList ? this.equalsOrder((XLongList)obj) : false;
        }
        if (obj instanceof XLongList) {
            return false;
        }
        if (!(obj instanceof XLongCollection)) {
            return false;
        }
        XLongCollection that = (XLongCollection)obj;
        return this == that || this.size() == that.size() && this.containsAll(that);
    }

    private boolean equalsOrder(XLongList that) {
        if (that == this) {
            return true;
        }
        if (this.size() != that.size()) {
            return false;
        }
        XLongIterator thatIterator = that.iterator();
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            long o2;
            long o1 = this.valueOf(r);
            if (o1 == (o2 = thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this instanceof List) {
            return this.hashCodeList();
        }
        int hash = 0;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            hash += this.hashCodeFor(this.valueOf(r));
        }
        return hash;
    }

    private int hashCodeList() {
        int h = 1;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            h = 31 * h + this.hashCodeFor(this.valueOf(r));
        }
        return h;
    }

    private int hashCodeFor(long value) {
        return (int)(value ^ value >>> 32);
    }

    private class Shared
    implements XLongCollection {
        private Shared() {
        }

        @Override
        public synchronized int size() {
            return XLongCollectionBase.this.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return XLongCollectionBase.this.isEmpty();
        }

        @Override
        public synchronized boolean contains(long o) {
            return XLongCollectionBase.this.contains(o);
        }

        @Override
        public synchronized long[] toArray() {
            return XLongCollectionBase.this.toArray();
        }

        @Override
        public synchronized long[] toArray(long[] a) {
            return XLongCollectionBase.this.toArray(a);
        }

        @Override
        public synchronized XLongIterator iterator() {
            return new CollectionArrayIterator(XLongCollectionBase.this.toArray());
        }

        @Override
        public XLongIterator reusableIterator() {
            throw new UnsupportedOperationException("Reusable iterator not supported for this shared collection");
        }

        @Override
        public synchronized boolean supportsIteratorModifications() {
            return XLongCollectionBase.this.supportsIteratorModifications();
        }

        @Override
        public synchronized boolean add(long e) {
            return XLongCollectionBase.this.add(e);
        }

        @Override
        public synchronized boolean remove(long o) {
            return XLongCollectionBase.this.remove(o);
        }

        @Override
        public synchronized boolean containsAll(XLongCollection c) {
            return XLongCollectionBase.this.containsAll(c);
        }

        @Override
        public synchronized boolean addAll(XLongCollection c) {
            return XLongCollectionBase.this.addAll(c);
        }

        @Override
        public synchronized boolean removeAll(XLongCollection c) {
            return XLongCollectionBase.this.removeAll(c);
        }

        @Override
        public synchronized boolean retainAll(XLongCollection c) {
            return XLongCollectionBase.this.retainAll(c);
        }

        @Override
        public synchronized void clear() {
            XLongCollectionBase.this.clear();
        }

        public synchronized String toString() {
            return XLongCollectionBase.this.toString();
        }

        @Override
        public synchronized XCollection.Record head() {
            return XLongCollectionBase.this.head();
        }

        @Override
        public synchronized XCollection.Record tail() {
            return XLongCollectionBase.this.tail();
        }

        @Override
        public long valueOf(XCollection.Record record) {
            return XLongCollectionBase.this.valueOf(record);
        }

        @Override
        public synchronized void delete(XCollection.Record record) {
            XLongCollectionBase.this.delete(record);
        }

        @Override
        public XLongCollection unmodifiable() {
            return XLongCollectionBase.this.unmodifiable();
        }

        @Override
        public XLongCollection shared() {
            return this;
        }

        private class CollectionArrayIterator
        implements XLongIterator {
            private long[] _elements;
            private int _index;
            private long _next;
            private boolean removed;

            public CollectionArrayIterator(long[] elements) {
                this._elements = elements;
                this.removed = true;
            }

            @Override
            public boolean hasNext() {
                return this._index < this._elements.length;
            }

            @Override
            public long next() {
                this.removed = false;
                this._next = this._elements[this._index++];
                return this._next;
            }

            @Override
            public void remove() {
                if (this.removed) {
                    throw new IllegalStateException("No element to remove");
                }
                Shared.this.remove(this._next);
                this.removed = true;
            }

            @Override
            public CollectionArrayIterator toFirst() {
                this._index = 0;
                this._next = 0L;
                this._elements = Shared.this.toArray();
                this.removed = true;
                return this;
            }
        }
    }

    class Unmodifiable
    extends XLongCollectionBase
    implements XLongSet,
    XLongList {
        Unmodifiable() {
        }

        @Override
        public int size() {
            return XLongCollectionBase.this.size();
        }

        @Override
        public XCollection.Record head() {
            return XLongCollectionBase.this.head();
        }

        @Override
        public XCollection.Record tail() {
            return XLongCollectionBase.this.tail();
        }

        @Override
        public long valueOf(XCollection.Record record) {
            return XLongCollectionBase.this.valueOf(record);
        }

        @Override
        public boolean contains(long value) {
            return XLongCollectionBase.this.contains(value);
        }

        @Override
        public boolean containsAll(XLongCollection c) {
            return XLongCollectionBase.this.containsAll(c);
        }

        @Override
        public boolean add(long obj) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void delete(XCollection.Record node) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean addAll(int index, XLongCollection c) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public long get(int index) {
            return ((XLongList)((Object)XLongCollectionBase.this)).get(index);
        }

        @Override
        public long set(int index, long element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void add(int index, long element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean remove(long index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public long remove(int index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public int indexOf(long o) {
            return ((XLongList)((Object)XLongCollectionBase.this)).indexOf(o);
        }

        @Override
        public int lastIndexOf(long o) {
            return ((XLongList)((Object)XLongCollectionBase.this)).lastIndexOf(o);
        }

        @Override
        public XLongListIterator listIterator() {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XLongListIterator listIterator(int index) {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XLongList subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Sub-List not supported for unmodifiable collection");
        }
    }
}

