/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XByteCollectionBase;
import com.neeve.lang.XByteIterator;
import com.neeve.lang.XByteIteratorImpl;
import com.neeve.lang.XByteMap;
import com.neeve.lang.XByteSet;
import com.neeve.lang.XCollection;
import com.neeve.lang.XCollectionIterator;
import com.neeve.lang.XIterator;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class XByteLinkedHashMap<V>
implements XByteMap<V> {
    private static final int B0 = 4;
    private static final int C0 = 16;
    private static final int B1 = 10;
    private static final int C1 = 1024;
    private static final int B2 = 6;
    private static final int C2 = 64;
    private transient Entry<V> _head;
    private transient Entry<V> _tail;
    private transient Entry<V>[] _entries;
    private transient int _entryCount;
    private transient int _nullCount;
    private transient XByteLinkedHashMap<V>[] _subMaps;
    private transient boolean _useSubMaps;
    private transient int _keyShift;
    private transient Values _values;
    private transient KeySet _keySet;
    private transient EntrySet _entrySet;
    private transient XByteMap<V> _unmodifiable;
    private transient boolean _isShared;
    private transient boolean _supportsIteratorModifications = true;
    private static final Entry<?>[] NULL_ENTRIES = new Entry[1024];
    static volatile int ONE_VOLATILE = 1;

    public XByteLinkedHashMap() {
        this(4);
    }

    public XByteLinkedHashMap(int capacity) {
        this.setup(capacity);
    }

    public void setSupportsIteratorModifications(boolean allowed) {
        this._supportsIteratorModifications = allowed;
    }

    private void setup(int capacity) {
        int tableLength;
        for (tableLength = 16; tableLength < capacity; tableLength <<= 1) {
        }
        this._entries = new Entry[tableLength << 1];
        this._head = this.newEntry();
        this._tail = this.newEntry();
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        Entry<V> previous = this._tail;
        int i = 0;
        while (i++ < capacity) {
            Entry<V> newEntry = this.newEntry();
            ((Entry)newEntry)._previous = (Entry)previous;
            ((Entry)previous)._next = (Entry)newEntry;
            previous = newEntry;
        }
    }

    public XByteLinkedHashMap(XByteMap<? extends V> map) {
        this(map.size());
        this.putAll(map);
    }

    private XByteLinkedHashMap(Entry<V>[] entries) {
        this._entries = entries;
    }

    public static <V> XByteLinkedHashMap<V> newInstance() {
        return new XByteLinkedHashMap<V>();
    }

    public final Entry<V> head() {
        return this._head;
    }

    public final Entry<V> tail() {
        return this._tail;
    }

    @Override
    public final int size() {
        if (!this._useSubMaps) {
            return this._entryCount;
        }
        int sum = 0;
        int i = 0;
        while (i < this._subMaps.length) {
            sum += this._subMaps[i++].size();
        }
        return sum;
    }

    @Override
    public final boolean isEmpty() {
        return ((Entry)this._head)._next == this._tail;
    }

    @Override
    public final boolean containsKey(byte key) {
        return this.getEntry(key) != null;
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public final V get(byte key) {
        Entry<V> entry = this.getEntry(key);
        return (V)(entry != null ? ((Entry)entry)._value : null);
    }

    public final Entry<V> getEntry(byte key) {
        return this.getEntry(key, XByteLinkedHashMap.keyHash(key));
    }

    private final Entry<V> getEntry(byte key, int keyHash) {
        XByteLinkedHashMap<V> map = this.getSubMap(keyHash);
        Entry<V>[] entries = map._entries;
        int mask = entries.length - 1;
        int nullEntriesSkipped = 0;
        int i = keyHash >> map._keyShift;
        while (true) {
            Entry<V> entry;
            if ((entry = entries[i & mask]) == null) {
                if (map._nullCount < ++nullEntriesSkipped) {
                    return null;
                }
            } else if (key == ((Entry)entry)._key || keyHash == ((Entry)entry)._keyHash && key == ((Entry)entry)._key) {
                return entry;
            }
            ++i;
        }
    }

    private final XByteLinkedHashMap<V> getSubMap(int keyHash) {
        return this._useSubMaps ? super.getSubMap(keyHash >> 6) : this;
    }

    @Override
    public final V put(byte key, V value) {
        return (V)this.put(key, value, XByteLinkedHashMap.keyHash(key), this._isShared, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object put(byte key, V value, int keyHash, boolean concurrent, boolean noReplace, boolean returnEntry) {
        Entry entry;
        XByteLinkedHashMap<V> map = this.getSubMap(keyHash);
        Entry<V>[] entries = map._entries;
        int mask = entries.length - 1;
        int slot = -1;
        int i2 = keyHash >> map._keyShift;
        while (true) {
            Entry<V> entry2;
            if ((entry2 = entries[i2 & mask]) == null) break;
            if (entry2 == Entry.NULL) {
                slot = slot < 0 ? i2 & mask : slot;
            } else if (key == ((Entry)entry2)._key || keyHash == ((Entry)entry2)._keyHash && key == ((Entry)entry2)._key) {
                if (noReplace) {
                    return returnEntry ? entry2 : ((Entry)entry2)._value;
                }
                Object prevValue = ((Entry)entry2)._value;
                ((Entry)entry2)._value = value;
                return returnEntry ? entry2 : prevValue;
            }
            ++i2;
        }
        slot = slot < 0 ? i2 & mask : slot;
        if (concurrent) {
            XByteLinkedHashMap i2 = this;
            synchronized (i2) {
                return this.put(key, value, keyHash, false, noReplace, returnEntry);
            }
        }
        if (!this._isShared) {
            entry = this._tail;
            entry._key = key;
            entry._value = value;
            entry._keyHash = keyHash;
            if (entry._next == null) {
                this.createNewEntries();
            }
            entries[slot] = entry;
            map._entryCount += ONE_VOLATILE;
            this._tail = ((Entry)this._tail)._next;
        } else {
            if (((Entry)this._tail)._next == null) {
                this.createNewEntries();
            }
            entry = ((Entry)this._tail)._next;
            ((Entry)this._tail)._next = entry._next;
            entry._key = key;
            entry._value = value;
            entry._keyHash = keyHash;
            entry._next = (Entry)this._tail;
            entry._previous = ((Entry)this._tail)._previous;
            entries[slot] = entry;
            map._entryCount += ONE_VOLATILE;
            entry._next._previous = entry;
            entry._previous._next = entry;
        }
        if (map._entryCount + map._nullCount > entries.length >> 1) {
            super.resizeTable(this._isShared);
        }
        return returnEntry ? entry : null;
    }

    private void createNewEntries() {
        Entry<V> previous = this._tail;
        for (int i = 0; i < 8; ++i) {
            Entry<V> newEntry = this.newEntry();
            ((Entry)newEntry)._previous = (Entry)previous;
            ((Entry)previous)._next = (Entry)newEntry;
            previous = newEntry;
        }
    }

    private void resizeTable(boolean isShared) {
        int nullCount = this._nullCount;
        this._nullCount = 0;
        if (nullCount > this._entryCount) {
            if (isShared) {
                Entry[] tmp = new Entry[this._entries.length];
                this.copyEntries(this._entries, tmp, this._entries.length);
                this._entries = tmp;
            } else {
                Object[] tmp = new Entry[this._entries.length];
                System.arraycopy(this._entries, 0, tmp, 0, this._entries.length);
                XByteLinkedHashMap.reset(this._entries);
                this.copyEntries((Entry<V>[])tmp, this._entries, this._entries.length);
                XByteLinkedHashMap.reset(tmp);
            }
            return;
        }
        int tableLength = this._entries.length << 1;
        if (tableLength <= 1024) {
            Entry[] tmp = new Entry[tableLength];
            this.copyEntries(this._entries, tmp, this._entries.length);
            this._entries = tmp;
            return;
        }
        if (this._subMaps == null) {
            this._subMaps = this.newSubMaps(tableLength >> 5);
        }
        int i = 0;
        while (i < this._entries.length) {
            Entry<V> entry;
            if ((entry = this._entries[i++]) == null || entry == Entry.NULL) continue;
            XByteLinkedHashMap<V> subMap = this._subMaps[((Entry)entry)._keyHash >> this._keyShift & 0x3F];
            super.mapEntry(entry);
            if (subMap._entryCount + subMap._nullCount << 1 < subMap._entries.length) continue;
            System.err.println("Unevenly distributed hash code - Degraded Performance");
            Entry[] tmp = new Entry[tableLength];
            this.copyEntries(this._entries, tmp, this._entries.length);
            this._entries = tmp;
            this._subMaps = null;
            return;
        }
        if (isShared) {
            XByteLinkedHashMap.reset(this._entries);
            this._nullCount = 0;
            this._entryCount = 0;
        }
        this._useSubMaps = ONE_VOLATILE == 1;
    }

    private XByteLinkedHashMap<V>[] newSubMaps(int capacity) {
        XByteLinkedHashMap[] subMaps = new XByteLinkedHashMap[64];
        for (int i = 0; i < 64; ++i) {
            XByteLinkedHashMap<V> subMap = new XByteLinkedHashMap<V>(new Entry[capacity]);
            subMap._keyShift = 6 + this._keyShift;
            subMaps[i] = subMap;
        }
        return subMaps;
    }

    private void mapEntry(Entry<V> entry) {
        int mask = this._entries.length - 1;
        int i = ((Entry)entry)._keyHash >> this._keyShift;
        while (true) {
            Entry<V> e;
            if ((e = this._entries[i & mask]) == null) break;
            ++i;
        }
        this._entries[i & mask] = entry;
        ++this._entryCount;
    }

    private void copyEntries(Entry<V>[] from, Entry<V>[] to, int count) {
        int mask = to.length - 1;
        int i = 0;
        block0: while (i < count) {
            Entry<V> entry;
            if ((entry = from[i++]) == null || entry == Entry.NULL) continue;
            int j = ((Entry)entry)._keyHash >> this._keyShift;
            while (true) {
                Entry<V> tmp;
                if ((tmp = to[j & mask]) == null) {
                    to[j & mask] = entry;
                    continue block0;
                }
                ++j;
            }
        }
    }

    public final Entry<V> putEntry(byte key, V value) {
        return (Entry)this.put(key, value, XByteLinkedHashMap.keyHash(key), this._isShared, false, true);
    }

    @Override
    public final void putAll(XByteMap<? extends V> map) {
        for (XByteMap.Entry<V> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    public final V putIfAbsent(byte key, V value) {
        return (V)this.put(key, value, XByteLinkedHashMap.keyHash(key), this._isShared, true, false);
    }

    @Override
    public final V remove(byte key) {
        return this.remove(key, XByteLinkedHashMap.keyHash(key), this._isShared);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final V remove(byte key, int keyHash, boolean concurrent) {
        XByteLinkedHashMap<V> map = this.getSubMap(keyHash);
        Entry<V>[] entries = map._entries;
        int mask = entries.length - 1;
        int i = keyHash >> map._keyShift;
        Entry<V> entry;
        while ((entry = entries[i & mask]) != null) {
            if (key == ((Entry)entry)._key || keyHash == ((Entry)entry)._keyHash && key == ((Entry)entry)._key) {
                if (concurrent) {
                    XByteLinkedHashMap xByteLinkedHashMap = this;
                    synchronized (xByteLinkedHashMap) {
                        return this.remove(key, keyHash, false);
                    }
                }
                ((Entry)entry)._previous._next = ((Entry)entry)._next;
                ((Entry)entry)._next._previous = ((Entry)entry)._previous;
                entries[i & mask] = Entry.NULL;
                ++map._nullCount;
                --map._entryCount;
                Object prevValue = ((Entry)entry)._value;
                if (!this._isShared) {
                    ((Entry)entry)._key = (byte)-1;
                    ((Entry)entry)._value = null;
                    entry.init();
                    Entry next = ((Entry)this._tail)._next;
                    ((Entry)entry)._previous = (Entry)this._tail;
                    ((Entry)entry)._next = next;
                    ((Entry)this._tail)._next = (Entry)entry;
                    if (next != null) {
                        next._previous = (Entry)entry;
                    }
                }
                return (V)prevValue;
            }
            ++i;
        }
        return null;
    }

    public XByteLinkedHashMap<V> shared() {
        this._isShared = true;
        return this;
    }

    public boolean isShared() {
        return this._isShared;
    }

    @Override
    public final void clear() {
        if (this._isShared) {
            this.clearShared();
            return;
        }
        Entry e = this._head;
        Entry<V> end = this._tail;
        while ((e = e._next) != end) {
            e._key = (byte)-1;
            e._value = null;
            e.init();
        }
        this._tail = ((Entry)this._head)._next;
        this.clearTables();
    }

    private void clearTables() {
        if (this._useSubMaps) {
            int i = 0;
            while (i < 64) {
                super.clearTables();
            }
            this._useSubMaps = false;
        }
        XByteLinkedHashMap.reset(this._entries);
        this._nullCount = 0;
        this._entryCount = 0;
    }

    private synchronized void clearShared() {
        ((Entry)this._head)._next = (Entry)this._tail;
        ((Entry)this._tail)._previous = (Entry)this._head;
        if (this._useSubMaps) {
            this._useSubMaps = false;
            this._subMaps = this.newSubMaps(16);
        }
        this._entryCount = 0;
        this._nullCount = 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Map) {
            Map that = (Map)obj;
            return this.entrySet().equals(that.entrySet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 0;
        Entry e = this._head;
        Entry<V> end = this._tail;
        while ((e = e._next) != end) {
            code += e.hashCode();
        }
        return code;
    }

    public String toString() {
        Iterator<XByteMap.Entry<V>> i = this.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            XByteMap.Entry<V> e = i.next();
            byte key = e.getKey();
            V value = e.getValue();
            sb.append(key);
            sb.append('=');
            sb.append((Object)(value == this ? "(this Map)" : value));
            if (!i.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(", ");
        }
    }

    protected Entry<V> newEntry() {
        return new Entry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStatistics(PrintStream out) {
        byte sum = this.getSumDistance();
        int size = this.size();
        int avgDistancePercent = size != 0 ? 100 * sum / size : 0;
        PrintStream printStream = out;
        synchronized (printStream) {
            out.print("SIZE: " + size);
            out.print(", ENTRIES: " + this.getCapacity());
            out.print(", SLOTS: " + this.getTableLength());
            out.print(", USE SUB-MAPS: " + this._useSubMaps);
            out.print(", SUB-MAPS DEPTH: " + this.getSubMapDepth());
            out.print(", NULL COUNT: " + this._nullCount);
            out.print(", IS SHARED: " + this._isShared);
            out.print(", AVG DISTANCE: " + avgDistancePercent + "%");
            out.print(", MAX DISTANCE: " + this.getMaximumDistance());
            out.println();
        }
    }

    private int getTableLength() {
        if (this._useSubMaps) {
            int sum = 0;
            for (int i = 0; i < 64; ++i) {
                sum += super.getTableLength();
            }
            return sum;
        }
        return this._entries.length;
    }

    private int getCapacity() {
        int capacity = 0;
        Entry e = this._head;
        while ((e = e._next) != null) {
            ++capacity;
        }
        return capacity - 1;
    }

    private int getMaximumDistance() {
        int max = 0;
        if (this._useSubMaps) {
            for (int i = 0; i < 64; ++i) {
                int subMapMax = super.getMaximumDistance();
                max = Math.max(max, subMapMax);
            }
            return max;
        }
        for (int i = 0; i < this._entries.length; ++i) {
            Entry<V> entry = this._entries[i];
            if (entry == null || entry == Entry.NULL) continue;
            int slot = ((Entry)entry)._keyHash >> this._keyShift & this._entries.length - 1;
            int distanceToSlot = i - slot;
            if (distanceToSlot < 0) {
                distanceToSlot += this._entries.length;
            }
            if (distanceToSlot <= max) continue;
            max = distanceToSlot;
        }
        return max;
    }

    private byte getSumDistance() {
        byte sum = 0;
        if (this._useSubMaps) {
            for (int i = 0; i < 64; ++i) {
                sum = (byte)(sum + super.getSumDistance());
            }
            return sum;
        }
        for (int i = 0; i < this._entries.length; ++i) {
            Entry<V> entry = this._entries[i];
            if (entry == null || entry == Entry.NULL) continue;
            int slot = ((Entry)entry)._keyHash >> this._keyShift & this._entries.length - 1;
            int distanceToSlot = i - slot;
            if (distanceToSlot < 0) {
                distanceToSlot += this._entries.length;
            }
            sum = (byte)(sum + distanceToSlot);
        }
        return sum;
    }

    private int getSubMapDepth() {
        if (this._useSubMaps) {
            int depth = 0;
            for (int i = 0; i < 64; ++i) {
                int subMapDepth = super.getSubMapDepth();
                depth = Math.max(depth, subMapDepth);
            }
            return depth + 1;
        }
        return 0;
    }

    @Override
    public final Collection<V> values() {
        if (this._values == null) {
            this._values = new Values();
        }
        return this._values;
    }

    @Override
    public final Set<XByteMap.Entry<V>> entrySet() {
        if (this._entrySet == null) {
            this._entrySet = new EntrySet();
        }
        return this._entrySet;
    }

    @Override
    public final XByteSet keySet() {
        if (this._keySet == null) {
            this._keySet = new KeySet();
        }
        return this._keySet;
    }

    private static <K> int keyHash(byte value) {
        return value ^ value >>> 32;
    }

    @Override
    public XByteIterator reuseableKeyIterator() {
        this.keySet();
        return this._keySet.reusableIterator();
    }

    @Override
    public XIterator<V> reuseableValueIterator() {
        this.values();
        return this._values.reusableIterator();
    }

    @Override
    public XIterator<XByteMap.Entry<V>> reuseableEntryIterator() {
        this.entrySet();
        return (XCollectionIterator)this._entrySet.reusableIterator();
    }

    public final XByteMap<V> unmodifiable() {
        if (this._unmodifiable == null) {
            this._unmodifiable = new Unmodifiable();
        }
        return this._unmodifiable;
    }

    private static void reset(Object[] entries) {
        int count;
        for (int i = 0; i < entries.length; i += count) {
            count = Math.min(entries.length - i, 1024);
            System.arraycopy(NULL_ENTRIES, 0, entries, i, count);
        }
    }

    private final class Unmodifiable
    implements XByteMap<V> {
        private Unmodifiable() {
        }

        @Override
        public final boolean equals(Object obj) {
            return XByteLinkedHashMap.this.equals(obj);
        }

        @Override
        public final int hashCode() {
            return XByteLinkedHashMap.this.hashCode();
        }

        @Override
        public final int size() {
            return XByteLinkedHashMap.this.size();
        }

        @Override
        public final boolean isEmpty() {
            return XByteLinkedHashMap.this.isEmpty();
        }

        @Override
        public final boolean containsKey(byte key) {
            return XByteLinkedHashMap.this.containsKey(key);
        }

        @Override
        public final boolean containsValue(Object value) {
            return XByteLinkedHashMap.this.containsValue(value);
        }

        @Override
        public final V get(byte key) {
            return XByteLinkedHashMap.this.get(key);
        }

        @Override
        public final V put(byte key, V value) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        @Override
        public final V remove(byte key) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        @Override
        public final void putAll(XByteMap<? extends V> map) {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        @Override
        public final void clear() {
            throw new UnsupportedOperationException("Unmodifiable map");
        }

        @Override
        public final XByteSet keySet() {
            return (XByteSet)((KeySet)XByteLinkedHashMap.this.keySet()).unmodifiable();
        }

        @Override
        public final XCollection<V> values() {
            return (XCollection)((Values)XByteLinkedHashMap.this.values()).unmodifiable();
        }

        @Override
        public final Set<XByteMap.Entry<V>> entrySet() {
            throw new UnsupportedOperationException("Direct view over unmodifiable map entries is not supported  (to prevent access to Entry.setValue(Object) method). To iterate over unmodifiable map entries, applications may use the keySet() and values() fast collection views in conjonction.");
        }

        @Override
        public XByteIterator reuseableKeyIterator() {
            return this.keySet().reusableIterator();
        }

        @Override
        public XIterator<V> reuseableValueIterator() {
            return ((XCollection)this.values()).reusableIterator();
        }

        @Override
        public XIterator<XByteMap.Entry<V>> reuseableEntryIterator() {
            throw new UnsupportedOperationException("Reusable iterator over unmodifiable map entries is not supported  (to prevent access to Entry.setValue(Object) method). To iterate over unmodifiable map entries, applications may use the reusableKeyIterator() and reusableValueIterator() in conjonction.");
        }
    }

    public static class Entry<V>
    implements XByteMap.Entry<V>,
    XCollection.Record {
        public static final Entry<?> NULL = new Entry();
        private Entry<V> _next;
        private Entry<V> _previous;
        private byte _key;
        private V _value;
        private int _keyHash;

        protected Entry() {
            this.init();
        }

        protected void init() {
        }

        @Override
        public final Entry<V> getNext() {
            return this._next;
        }

        @Override
        public final Entry<V> getPrevious() {
            return this._previous;
        }

        @Override
        public final byte getKey() {
            return this._key;
        }

        @Override
        public final V getValue() {
            return this._value;
        }

        @Override
        public final V setValue(V value) {
            V old = this._value;
            this._value = value;
            return old;
        }

        @Override
        public boolean equals(Object that) {
            if (that instanceof XByteMap.Entry) {
                XByteMap.Entry entry = (XByteMap.Entry)that;
                return this._key == entry.getKey() && this._value.equals(entry.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this._key ^ this._key >>> 32 ^ (this._value != null ? this._value.hashCode() : 0);
        }

        public String toString() {
            return this._key + "=" + this._value.toString();
        }

        protected void setKey(byte key) {
            this._key = key;
        }
    }

    private final class KeySet
    extends XByteCollectionBase
    implements XByteSet {
        private KeySet() {
        }

        @Override
        public int size() {
            return XByteLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            XByteLinkedHashMap.this.clear();
        }

        @Override
        public boolean contains(byte obj) {
            return XByteLinkedHashMap.this.containsKey(obj);
        }

        @Override
        public boolean remove(byte obj) {
            return XByteLinkedHashMap.this.remove(obj) != null;
        }

        @Override
        public XCollection.Record head() {
            return XByteLinkedHashMap.this._head;
        }

        @Override
        public XCollection.Record tail() {
            return XByteLinkedHashMap.this._tail;
        }

        @Override
        public byte valueOf(XCollection.Record record) {
            return ((Entry)record)._key;
        }

        @Override
        public void delete(XCollection.Record record) {
            XByteLinkedHashMap.this.remove(((Entry)record).getKey());
        }

        @Override
        public XByteIterator iterator() {
            return XByteIteratorImpl.valueOf(this);
        }

        @Override
        public boolean supportsIteratorModifications() {
            return XByteLinkedHashMap.this._supportsIteratorModifications;
        }
    }

    private final class EntrySet
    extends XCollection<Entry<V>>
    implements Set<Entry<V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return XByteLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            XByteLinkedHashMap.this.clear();
        }

        @Override
        public boolean contains(Object obj) {
            if (obj instanceof XByteMap.Entry) {
                XByteMap.Entry thatEntry = (XByteMap.Entry)obj;
                Entry thisEntry = XByteLinkedHashMap.this.getEntry(thatEntry.getKey());
                if (thisEntry == null) {
                    return false;
                }
                return EntrySet.equals(thisEntry.getValue(), thatEntry.getValue());
            }
            return false;
        }

        @Override
        public XCollection.Record head() {
            return XByteLinkedHashMap.this._head;
        }

        @Override
        public XCollection.Record tail() {
            return XByteLinkedHashMap.this._tail;
        }

        @Override
        public Entry<V> valueOf(XCollection.Record record) {
            return (Entry)record;
        }

        @Override
        public void delete(XCollection.Record record) {
            XByteLinkedHashMap.this.remove(((Entry)record).getKey());
        }

        @Override
        public XIterator<Entry<V>> iterator() {
            return XCollectionIterator.valueOf(this);
        }

        @Override
        public boolean supportsIteratorModifications() {
            return XByteLinkedHashMap.this._supportsIteratorModifications;
        }
    }

    private final class Values
    extends XCollection<V> {
        private Values() {
        }

        @Override
        public int size() {
            return XByteLinkedHashMap.this.size();
        }

        @Override
        public void clear() {
            XByteLinkedHashMap.this.clear();
        }

        @Override
        public XCollection.Record head() {
            return XByteLinkedHashMap.this._head;
        }

        @Override
        public XCollection.Record tail() {
            return XByteLinkedHashMap.this._tail;
        }

        @Override
        public V valueOf(XCollection.Record record) {
            return ((Entry)record)._value;
        }

        @Override
        public void delete(XCollection.Record record) {
            XByteLinkedHashMap.this.remove(((Entry)record).getKey());
        }

        @Override
        public XIterator<V> iterator() {
            return XCollectionIterator.valueOf(this);
        }

        @Override
        public boolean supportsIteratorModifications() {
            return XByteLinkedHashMap.this._supportsIteratorModifications;
        }
    }
}

