/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XByteCollection;
import com.neeve.lang.XByteIterator;
import com.neeve.lang.XByteIteratorImpl;
import com.neeve.lang.XByteList;
import com.neeve.lang.XByteListIterator;
import com.neeve.lang.XByteSet;
import com.neeve.lang.XCollection;
import java.util.List;

public abstract class XByteCollectionBase
implements XByteCollection {
    private XByteIteratorImpl reusableIterator;

    protected XByteCollectionBase() {
    }

    @Override
    public abstract int size();

    @Override
    public abstract XCollection.Record head();

    @Override
    public abstract XCollection.Record tail();

    @Override
    public abstract byte valueOf(XCollection.Record var1);

    @Override
    public abstract void delete(XCollection.Record var1);

    @Override
    public XByteCollection unmodifiable() {
        return new Unmodifiable();
    }

    @Override
    public XByteCollection shared() {
        return new Shared();
    }

    @Override
    public XByteIterator iterator() {
        return XByteIteratorImpl.valueOf(this);
    }

    @Override
    public XByteIterator reusableIterator() {
        if (this.reusableIterator == null) {
            this.reusableIterator = XByteIteratorImpl.valueOf(this);
        } else {
            this.reusableIterator.toFirst();
        }
        return this.reusableIterator;
    }

    @Override
    public boolean supportsIteratorModifications() {
        return true;
    }

    @Override
    public boolean add(byte value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(byte value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            this.delete(r);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        XCollection.Record head = this.head();
        for (XCollection.Record r = this.tail().getPrevious(); r != head; r = r.getPrevious()) {
            this.delete(r);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(byte value) {
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            if (value != this.valueOf(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(XByteCollection c) {
        boolean modified = false;
        XByteIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (!this.add(itr.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean containsAll(XByteCollection c) {
        XByteIterator itr = c.iterator();
        while (itr.hasNext()) {
            if (this.contains(itr.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(XByteCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public boolean retainAll(XByteCollection c) {
        boolean modified = false;
        XCollection.Record head = this.head();
        XCollection.Record r = this.tail().getPrevious();
        while (r != head) {
            XCollection.Record previous = r.getPrevious();
            if (!c.contains(this.valueOf(r))) {
                this.delete(r);
                modified = true;
            }
            r = previous;
        }
        return modified;
    }

    @Override
    public byte[] toArray() {
        return this.toArray(new byte[this.size()]);
    }

    @Override
    public byte[] toArray(byte[] array) {
        int size = this.size();
        if (array.length < size) {
            array = new byte[size];
        }
        if (array.length > size) {
            array[size] = -1;
        }
        int i = 0;
        byte[] arrayView = array;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            arrayView[i++] = this.valueOf(r);
        }
        return array;
    }

    public String toString() {
        XByteIterator it = this.iterator();
        if (!it.hasNext()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        while (true) {
            byte e = it.next();
            sb.append(e);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (this instanceof XByteList) {
            return obj instanceof XByteList ? this.equalsOrder((XByteList)obj) : false;
        }
        if (obj instanceof XByteList) {
            return false;
        }
        if (!(obj instanceof XByteCollection)) {
            return false;
        }
        XByteCollection that = (XByteCollection)obj;
        return this == that || this.size() == that.size() && this.containsAll(that);
    }

    private boolean equalsOrder(XByteList that) {
        if (that == this) {
            return true;
        }
        if (this.size() != that.size()) {
            return false;
        }
        XByteIterator thatIterator = that.iterator();
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            byte o2;
            byte o1 = this.valueOf(r);
            if (o1 == (o2 = thatIterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this instanceof List) {
            return this.hashCodeList();
        }
        int hash = 0;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            hash += this.hashCodeFor(this.valueOf(r));
        }
        return hash;
    }

    private int hashCodeList() {
        int h = 1;
        XCollection.Record r = this.head();
        XCollection.Record end = this.tail();
        while ((r = r.getNext()) != end) {
            h = 31 * h + this.hashCodeFor(this.valueOf(r));
        }
        return h;
    }

    private int hashCodeFor(byte value) {
        return value;
    }

    private class Shared
    implements XByteCollection {
        private Shared() {
        }

        @Override
        public synchronized int size() {
            return XByteCollectionBase.this.size();
        }

        @Override
        public synchronized boolean isEmpty() {
            return XByteCollectionBase.this.isEmpty();
        }

        @Override
        public synchronized boolean contains(byte o) {
            return XByteCollectionBase.this.contains(o);
        }

        @Override
        public synchronized byte[] toArray() {
            return XByteCollectionBase.this.toArray();
        }

        @Override
        public synchronized byte[] toArray(byte[] a) {
            return XByteCollectionBase.this.toArray(a);
        }

        @Override
        public synchronized XByteIterator iterator() {
            return new CollectionArrayIterator(XByteCollectionBase.this.toArray());
        }

        @Override
        public XByteIterator reusableIterator() {
            throw new UnsupportedOperationException("Reusable iterator not supported for this shared collection");
        }

        @Override
        public synchronized boolean supportsIteratorModifications() {
            return XByteCollectionBase.this.supportsIteratorModifications();
        }

        @Override
        public synchronized boolean add(byte e) {
            return XByteCollectionBase.this.add(e);
        }

        @Override
        public synchronized boolean remove(byte o) {
            return XByteCollectionBase.this.remove(o);
        }

        @Override
        public synchronized boolean containsAll(XByteCollection c) {
            return XByteCollectionBase.this.containsAll(c);
        }

        @Override
        public synchronized boolean addAll(XByteCollection c) {
            return XByteCollectionBase.this.addAll(c);
        }

        @Override
        public synchronized boolean removeAll(XByteCollection c) {
            return XByteCollectionBase.this.removeAll(c);
        }

        @Override
        public synchronized boolean retainAll(XByteCollection c) {
            return XByteCollectionBase.this.retainAll(c);
        }

        @Override
        public synchronized void clear() {
            XByteCollectionBase.this.clear();
        }

        public synchronized String toString() {
            return XByteCollectionBase.this.toString();
        }

        @Override
        public synchronized XCollection.Record head() {
            return XByteCollectionBase.this.head();
        }

        @Override
        public synchronized XCollection.Record tail() {
            return XByteCollectionBase.this.tail();
        }

        @Override
        public byte valueOf(XCollection.Record record) {
            return XByteCollectionBase.this.valueOf(record);
        }

        @Override
        public synchronized void delete(XCollection.Record record) {
            XByteCollectionBase.this.delete(record);
        }

        @Override
        public XByteCollection unmodifiable() {
            return XByteCollectionBase.this.unmodifiable();
        }

        @Override
        public XByteCollection shared() {
            return this;
        }

        private class CollectionArrayIterator
        implements XByteIterator {
            private byte[] _elements;
            private int _index;
            private byte _next;
            private boolean removed;

            public CollectionArrayIterator(byte[] elements) {
                this._elements = elements;
                this.removed = true;
            }

            @Override
            public boolean hasNext() {
                return this._index < this._elements.length;
            }

            @Override
            public byte next() {
                this.removed = false;
                this._next = this._elements[this._index++];
                return this._next;
            }

            @Override
            public void remove() {
                if (this.removed) {
                    throw new IllegalStateException("No element to remove");
                }
                Shared.this.remove(this._next);
                this.removed = true;
            }

            @Override
            public CollectionArrayIterator toFirst() {
                this._index = 0;
                this._next = 0;
                this._elements = Shared.this.toArray();
                this.removed = true;
                return this;
            }
        }
    }

    class Unmodifiable
    extends XByteCollectionBase
    implements XByteSet,
    XByteList {
        Unmodifiable() {
        }

        @Override
        public int size() {
            return XByteCollectionBase.this.size();
        }

        @Override
        public XCollection.Record head() {
            return XByteCollectionBase.this.head();
        }

        @Override
        public XCollection.Record tail() {
            return XByteCollectionBase.this.tail();
        }

        @Override
        public byte valueOf(XCollection.Record record) {
            return XByteCollectionBase.this.valueOf(record);
        }

        @Override
        public boolean contains(byte value) {
            return XByteCollectionBase.this.contains(value);
        }

        @Override
        public boolean containsAll(XByteCollection c) {
            return XByteCollectionBase.this.containsAll(c);
        }

        @Override
        public boolean add(byte obj) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void delete(XCollection.Record node) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean addAll(int index, XByteCollection c) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public byte get(int index) {
            return ((XByteList)((Object)XByteCollectionBase.this)).get(index);
        }

        @Override
        public byte set(int index, byte element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public void add(int index, byte element) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public boolean remove(byte index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public byte remove(int index) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        @Override
        public int indexOf(byte o) {
            return ((XByteList)((Object)XByteCollectionBase.this)).indexOf(o);
        }

        @Override
        public int lastIndexOf(byte o) {
            return ((XByteList)((Object)XByteCollectionBase.this)).lastIndexOf(o);
        }

        @Override
        public XByteListIterator listIterator() {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XByteListIterator listIterator(int index) {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        @Override
        public XByteList subList(int fromIndex, int toIndex) {
            throw new UnsupportedOperationException("Sub-List not supported for unmodifiable collection");
        }
    }
}

