/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.lang;

import com.neeve.lang.XIterator;
import java.util.NoSuchElementException;

public class XArrayIterator<T>
implements XIterator<T> {
    private final T[] array;
    private final int offset;
    private final int length;
    private int current = 0;

    public XArrayIterator(T[] array) {
        this.array = array;
        this.offset = 0;
        this.length = array == null ? 0 : array.length;
    }

    public XArrayIterator(T[] array, int offset, int length) {
        this.array = array;
        this.offset = offset;
        this.length = length;
        if (length < 0 || array == null && length > 0 || length > array.length) {
            throw new IllegalArgumentException("length cannot be less than 0");
        }
        if (offset < 0 || array == null && offset > 0 || offset >= array.length) {
            throw new IndexOutOfBoundsException("length cannot be less than 0");
        }
    }

    protected final T next(boolean advance) {
        if (this.hasNext()) {
            T val = this.array[this.offset + this.current];
            if (advance) {
                ++this.current;
            }
            return val;
        }
        throw new NoSuchElementException();
    }

    public final T[] array() {
        return this.array;
    }

    public final int offset() {
        return this.offset;
    }

    public final int length() {
        return this.length;
    }

    @Override
    public final boolean hasNext() {
        return this.current < this.length;
    }

    @Override
    public final T next() {
        return this.next(true);
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }

    @Override
    public final XArrayIterator<T> toFirst() {
        this.current = 0;
        return this;
    }
}

