/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.io;

import cern.colt.map.OpenIntIntHashMap;
import com.neeve.io.IOElasticBuffer;
import com.neeve.util.UtlBuffer;
import com.neeve.util.UtlEnv;
import com.neeve.util.UtlLinkedLongMap;
import com.neeve.util.UtlPool;
import com.neeve.util.UtlReferenceTracker;
import java.io.UTFDataFormatException;
import java.lang.reflect.Constructor;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicInteger;

public class IOBuffer
implements UtlPool.Item<IOBuffer>,
UtlReferenceTracker.HasReferenceTracker {
    public static final boolean DISABLE_NATIVE_BUFFERS;
    private static final boolean USE_PKTIOBUFFER;
    private static final boolean USE_MASTERDIRECTBUFFER;
    private static final boolean USE_SINGLEMASTERDIRECTBUFFER;
    private static final IOBufferProvider provider;
    private static final long gb = 0x40000000L;
    private static final long mb = 0x100000L;
    private static final long kb = 1024L;
    private static final int SMALLEST_SLAB_SIZE = 32;
    private static final Factory[] directPoolFactories;
    private static final UtlPool<IOBuffer>[] directPools;
    private static final Factory[] heapPoolFactories;
    private static final UtlPool<IOBuffer>[] heapPools;
    private static final OpenIntIntHashMap slabTable;
    private static final int SLAB_SHIFT_FACTOR;
    private static final int NATIVE_PAGE_SIZE;
    private static final UtlLinkedLongMap<ByteBuffer> masterDirectBufferTable;
    private final boolean isNative;
    private final ByteBuffer buffer;
    private final int capacity;
    private final AtomicInteger ownershipCount;
    private final UtlReferenceTracker refTracker;
    private int length;
    private int highwater;
    private UtlPool<IOBuffer> pool;
    private boolean nowipe;
    private boolean taken;

    public static final boolean isNativeXIOBufferEnabled() {
        return !DISABLE_NATIVE_BUFFERS;
    }

    public static final boolean isSingleMasterDirectBufferEnabled() {
        return USE_SINGLEMASTERDIRECTBUFFER;
    }

    private IOBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
        this.isNative = buffer.isDirect();
        this.length = this.capacity = buffer.capacity();
        this.ownershipCount = new AtomicInteger(0);
        this.refTracker = UtlReferenceTracker.enabled(this.getClass()) ? new UtlReferenceTracker(this) : null;
    }

    protected IOBuffer(int capacity, boolean isNative) {
        this.isNative = isNative;
        this.buffer = isNative ? this.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        this.capacity = capacity;
        this.ownershipCount = new AtomicInteger(0);
        this.refTracker = UtlReferenceTracker.enabled(this.getClass()) ? new UtlReferenceTracker(this) : null;
    }

    private static final String memToStr(long val) {
        if (val >= 0x40000000L) {
            return String.format("%.1f", Float.valueOf((float)val / 1.0737418E9f)) + "G";
        }
        if (val >= 0x100000L) {
            return String.format("%d", val / 0x100000L) + "M";
        }
        if (val >= 1024L) {
            return String.format("%d", val / 1024L) + "K";
        }
        return String.format("%d", val);
    }

    private final IOBuffer undispose(int length, int highwater) {
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        this.length = length;
        this.buffer.limit(this.length);
        this.highwater = highwater;
        int val = this.ownershipCount.getAndSet(1);
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onInit(1);
        }
        if (val != 0 && this.pool != null) {
            throw new IllegalStateException("attempt to undispose an IO buffer that's not disposed (val=" + val + ", pool=" + this.pool + ")");
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ByteBuffer allocateDirect(int size) {
        if (USE_MASTERDIRECTBUFFER && size < NATIVE_PAGE_SIZE) {
            UtlLinkedLongMap<ByteBuffer> utlLinkedLongMap = masterDirectBufferTable;
            synchronized (utlLinkedLongMap) {
                int masterDirectBufferTableIndex = USE_SINGLEMASTERDIRECTBUFFER ? 0 : size;
                ByteBuffer masterDirectBuffer = (ByteBuffer)masterDirectBufferTable.get((long)masterDirectBufferTableIndex);
                if (masterDirectBuffer.remaining() < size) {
                    masterDirectBuffer = ByteBuffer.allocateDirect(NATIVE_PAGE_SIZE);
                    masterDirectBufferTable.put((long)masterDirectBufferTableIndex, (Object)masterDirectBuffer);
                }
                masterDirectBuffer.limit(masterDirectBuffer.position() + size);
                ByteBuffer sliced = masterDirectBuffer.slice();
                masterDirectBuffer.position(masterDirectBuffer.limit()).limit(masterDirectBuffer.capacity());
                return sliced;
            }
        }
        return ByteBuffer.allocateDirect(size);
    }

    public static IOBuffer create(int length, int highwater, boolean isNative) {
        if (highwater > length) {
            throw new IllegalArgumentException("highwater cannot be more than the buffer length");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        int slab = IOBuffer.slab(length);
        IOBuffer buffer = !DISABLE_NATIVE_BUFFERS && isNative ? (slab < 0 ? provider.create(length, isNative) : directPools[slab].get(null)) : (slab < 0 ? provider.create(length, isNative) : heapPools[slab].get(null));
        return buffer.undispose(length, highwater);
    }

    public static IOBuffer create(int length, boolean isNative) {
        return IOBuffer.create(length, length, isNative);
    }

    public static IOBuffer createNative(int length, int highwater) {
        if (highwater > length) {
            throw new IllegalArgumentException("highwater cannot be more than the buffer length");
        }
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0");
        }
        int slab = IOBuffer.slab(length);
        IOBuffer buffer = slab < 0 ? new IOBuffer(length, true) : directPools[slab].get(null);
        return buffer.undispose(length, highwater);
    }

    public static IOBuffer createNative(int length) {
        return IOBuffer.createNative(length, length);
    }

    public IOBuffer ensureCapacity(int newLength) {
        if (newLength > this.length && newLength > this.capacity) {
            IOBuffer newBuffer = IOBuffer.create(newLength, this.isNative);
            newBuffer.buffer.order(this.buffer.order());
            UtlBuffer.copy(this.buffer, 0, newBuffer.getBufferUnsafe(), 0, this.length);
            this.dispose();
            return newBuffer;
        }
        this.length = newLength;
        this.adjustHighwater(this.length);
        return this;
    }

    public static IOBuffer wrap(ByteBuffer buffer) {
        return new IOBuffer(buffer).acquire();
    }

    public static final int slab(int x) {
        x = Math.max(32, x);
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return slabTable.containsKey(++x) ? slabTable.get(x) - SLAB_SHIFT_FACTOR : -1;
    }

    public static final int smallestSlabSize() {
        return 32;
    }

    public static final int numSlabs() {
        return slabTable.size();
    }

    public final IOBuffer copy() {
        IOBuffer copy = IOBuffer.create(this.getLength(), this.isNative);
        this.takeBuffer();
        try {
            UtlBuffer.copy(this.buffer, 0, copy.buffer, 0, this.length);
        }
        finally {
            this.releaseBuffer();
        }
        copy.adjustHighwater(Math.min(this.highwater, copy.buffer.capacity()));
        return copy;
    }

    public final IOBuffer setByteOrder(ByteOrder order) {
        if (this.taken) {
            throw new IllegalStateException("operation not permitted while buffer is taken");
        }
        this.buffer.order(order);
        return this;
    }

    public final int getLength() {
        return this.length;
    }

    public final IOBuffer adjustHighwater(int val) {
        if (this.taken) {
            throw new IllegalStateException("operation not permitted while buffer is taken");
        }
        if (val < 0) {
            throw new IllegalArgumentException("highwater (" + val + ") cannot be negative");
        }
        if (val > this.capacity) {
            throw new IllegalArgumentException("highwater (" + val + ") exceeds capacity (" + this.capacity + ")");
        }
        this.highwater = Math.max(this.highwater, val);
        this.length = Math.max(this.length, this.highwater);
        this.buffer.limit(this.length);
        return this;
    }

    public final int getHighwater() {
        return this.highwater;
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final ByteBuffer takeBuffer() {
        if (this.taken) {
            throw new IllegalStateException("buffer already taken");
        }
        this.taken = true;
        return this.buffer;
    }

    public final IOBuffer releaseBuffer() {
        if (!this.taken) {
            throw new IllegalStateException("buffer not taken");
        }
        this.taken = false;
        this.buffer.position(0).limit(this.length);
        return this;
    }

    public final ByteBuffer getBufferUnsafe() {
        if (this.taken) {
            throw new IllegalStateException("operation not permitted while buffer is taken");
        }
        return this.buffer;
    }

    @Deprecated
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final boolean isNative() {
        return this.isNative;
    }

    public final IOBuffer setNoWipe() {
        this.nowipe = true;
        return this;
    }

    public final IOBuffer acquire() {
        int val = this.ownershipCount.incrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onAcquire(val);
        }
        if (val <= 1 && this.pool != null) {
            throw new IllegalStateException("attempt to acquire an already disposed IO buffer");
        }
        return this;
    }

    public final int getOwnerCount() {
        return this.ownershipCount.get();
    }

    public final void dispose() {
        if (this.taken) {
            throw new IllegalStateException("operation not permitted while buffer is taken");
        }
        int val = this.ownershipCount.decrementAndGet();
        if (UtlReferenceTracker.TYPE_TRACKING_ENABLED && this.refTracker != null) {
            this.refTracker.onDispose(val);
        }
        if (val < 0 && this.pool != null) {
            throw new IllegalStateException("attempt to dispose an already disposed IO buffer");
        }
        if (val == 0 && this.pool != null) {
            this.pool.put(this);
        }
    }

    @Override
    public final IOBuffer init() {
        this.buffer.clear();
        if (!this.nowipe) {
            UtlBuffer.wipe(this.buffer, this.highwater);
            this.nowipe = false;
        }
        this.highwater = 0;
        return this;
    }

    @Override
    public final IOBuffer setPool(UtlPool<IOBuffer> pool) {
        this.pool = pool;
        return this;
    }

    @Override
    public final UtlPool<IOBuffer> getPool() {
        return this.pool;
    }

    @Override
    public final UtlReferenceTracker referenceTracker() {
        return this.refTracker;
    }

    public final byte get(int index) {
        return this.buffer.get(index);
    }

    public final int getUnsignedByte(int index) {
        return this.buffer.get(index) & 0xFF;
    }

    public final char getChar(int index) {
        return this.buffer.getChar(index);
    }

    public final short getShort(int index) {
        return this.buffer.getShort(index);
    }

    public final int getUnsignedShort(int index) {
        return this.buffer.getShort(index) & 0xFFFF;
    }

    public final int getInt(int index) {
        return this.buffer.getInt(index);
    }

    public final long getUnsignedInt(int index) {
        return this.buffer.getLong(index) & 0xFFFFFFFFL;
    }

    public final float getFloat(int index) {
        return this.buffer.getFloat(index);
    }

    public final long getLong(int index) {
        return this.buffer.getLong(index);
    }

    public final double getDouble(int index) {
        return this.buffer.getDouble(index);
    }

    public final IOBuffer put(int index, byte value) {
        int offsetBeyondLastSerializedByte = index + 1;
        if (offsetBeyondLastSerializedByte > this.length) {
            throw new BufferOverflowException();
        }
        this.buffer.put(index, value);
        return this;
    }

    public final IOBuffer putChar(int index, char value) {
        int offsetBeyondLastSerializedByte = index + 2;
        if (offsetBeyondLastSerializedByte > this.length) {
            throw new BufferOverflowException();
        }
        this.buffer.putChar(index, value);
        return this;
    }

    public final int putCharUTF8(int index, char c) {
        int utflen = IOBuffer.calculateUTFLength(c);
        if (utflen == 0) {
            throw new IllegalArgumentException(c + " is a surrogate character");
        }
        int offsetBeyondLastSerializedByte = index + utflen * 1;
        if (offsetBeyondLastSerializedByte > this.length) {
            throw new BufferOverflowException();
        }
        if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
            if (c >= '\u0001' && c <= '\u007f') {
                this.buffer.put(index, (byte)c);
                return 1;
            }
            if (c <= '\u07ff') {
                this.buffer.put(index, (byte)(0xC0 | c >> 6 & 0x1F));
                this.buffer.put(index + 1, (byte)(0x80 | c & 0x3F));
                return 2;
            }
            this.buffer.put(index, (byte)(0xE0 | c >> 12 & 0xF));
            this.buffer.put(index + 1, (byte)(0x80 | c >> 6 & 0x3F));
            this.buffer.put(index + 2, (byte)(0x80 | c & 0x3F));
            return 3;
        }
        if (c >= '\u0001' && c <= '\u007f') {
            this.buffer.put(index, (byte)c);
            return 1;
        }
        if (c <= '\u07ff') {
            this.buffer.put(index + 1, (byte)(0xC0 | c >> 6 & 0x1F));
            this.buffer.put(index, (byte)(0x80 | c & 0x3F));
            return 2;
        }
        this.buffer.put(index + 2, (byte)(0xE0 | c >> 12 & 0xF));
        this.buffer.put(index + 1, (byte)(0x80 | c >> 6 & 0x3F));
        this.buffer.put(index + 0, (byte)(0x80 | c & 0x3F));
        return 3;
    }

    public final IOBuffer putShort(int index, short value) {
        int offsetBeyondLastSerializedByte = index + 2;
        if (offsetBeyondLastSerializedByte > this.length) {
            throw new BufferOverflowException();
        }
        this.buffer.putShort(index, value);
        return this;
    }

    public final IOBuffer putInt(int index, int value) {
        int offsetBeyondLastSerializedByte = index + 4;
        if (offsetBeyondLastSerializedByte > this.length) {
            throw new BufferOverflowException();
        }
        this.buffer.putInt(index, value);
        return this;
    }

    public final IOBuffer putFloat(int index, float value) {
        int offsetBeyondLastSerializedByte = index + 4;
        if (offsetBeyondLastSerializedByte > this.length) {
            throw new BufferOverflowException();
        }
        this.buffer.putFloat(index, value);
        return this;
    }

    public final IOBuffer putLong(int index, long value) {
        int offsetBeyondLastSerializedByte = index + 8;
        if (offsetBeyondLastSerializedByte > this.length) {
            throw new BufferOverflowException();
        }
        this.buffer.putLong(index, value);
        return this;
    }

    public final IOBuffer putDouble(int index, double value) {
        int offsetBeyondLastSerializedByte = index + 8;
        if (offsetBeyondLastSerializedByte > this.length) {
            throw new BufferOverflowException();
        }
        this.buffer.putDouble(index, value);
        return this;
    }

    public final int putString(int index, String value) {
        return this.putCharSequenceUTF(index, value);
    }

    public static final int calculateUTFLength(char c) {
        if (c >= '\u0001' && c <= '\u007f') {
            return 1;
        }
        if (c <= '\u07ff') {
            return 2;
        }
        if (!Character.isSurrogate(c)) {
            return 3;
        }
        return 0;
    }

    public static final int calculateUTFLength(CharSequence str) {
        if (str == null) {
            return 0;
        }
        int strlen = str.length();
        int utflen = 0;
        for (int i = 0; i < strlen; ++i) {
            int cutflen = IOBuffer.calculateUTFLength(str.charAt(i));
            if (cutflen == 0) {
                if (i == strlen - 1) {
                    throw new IllegalArgumentException("supplied string has an incomplete surrogate character pair");
                }
                utflen += 4;
                ++i;
                continue;
            }
            utflen += cutflen;
        }
        return utflen;
    }

    public final int putCharSequenceUTF(int index, CharSequence str) {
        char c;
        if (str == null) {
            return 0;
        }
        int utflen = IOBuffer.calculateUTFLength(str);
        if (utflen > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(new UTFDataFormatException("encoded string too long: " + utflen + " bytes"));
        }
        int offsetBeyondLastSerializedByte = index + utflen * 1;
        if (offsetBeyondLastSerializedByte > this.length) {
            throw new BufferOverflowException();
        }
        int pos = index;
        long strlen = str.length();
        int i = 0;
        while ((long)i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f') {
            this.buffer.put(pos++, (byte)c);
            ++i;
        }
        while ((long)i < strlen) {
            int uc;
            c = str.charAt(i);
            if (this.buffer.order() == ByteOrder.BIG_ENDIAN) {
                if (c >= '\u0001' && c <= '\u007f') {
                    this.buffer.put(pos++, (byte)c);
                } else if (c <= '\u07ff') {
                    this.buffer.put(pos++, (byte)(0xC0 | c >> 6 & 0x1F));
                    this.buffer.put(pos++, (byte)(0x80 | c & 0x3F));
                } else if (Character.isSurrogate(c)) {
                    if ((long)i == strlen - 1L) {
                        throw new IllegalArgumentException("supplied char sequence has an incomplete surrogate character pair");
                    }
                    uc = Character.toCodePoint(c, str.charAt(++i));
                    this.buffer.put(pos++, (byte)(0xF0 | uc >> 18 & 7));
                    this.buffer.put(pos++, (byte)(0x80 | uc >> 12 & 0x3F));
                    this.buffer.put(pos++, (byte)(0x80 | uc >> 6 & 0x3F));
                    this.buffer.put(pos++, (byte)(0x80 | uc & 0x3F));
                } else {
                    this.buffer.put(pos++, (byte)(0xE0 | c >> 12 & 0xF));
                    this.buffer.put(pos++, (byte)(0x80 | c >> 6 & 0x3F));
                    this.buffer.put(pos++, (byte)(0x80 | c & 0x3F));
                }
            } else if (c >= '\u0001' && c <= '\u007f') {
                this.buffer.put(pos++, (byte)c);
            } else if (c <= '\u07ff') {
                this.buffer.put(pos++, (byte)(0x80 | c & 0x3F));
                this.buffer.put(pos++, (byte)(0xC0 | c >> 6 & 0x1F));
            } else if (Character.isSurrogate(c)) {
                if ((long)i == strlen - 1L) {
                    throw new IllegalArgumentException("supplied char sequence has an incomplete surrogate character pair");
                }
                uc = Character.toCodePoint(c, str.charAt(++i));
                this.buffer.put(pos++, (byte)(0x80 | uc & 0x3F));
                this.buffer.put(pos++, (byte)(0x80 | uc >> 6 & 0x3F));
                this.buffer.put(pos++, (byte)(0x80 | uc >> 12 & 0x3F));
                this.buffer.put(pos++, (byte)(0xF0 | uc >> 18 & 7));
            } else {
                this.buffer.put(pos++, (byte)(0x80 | c & 0x3F));
                this.buffer.put(pos++, (byte)(0x80 | c >> 6 & 0x3F));
                this.buffer.put(pos++, (byte)(0xE0 | c >> 12 & 0xF));
            }
            ++i;
        }
        return utflen;
    }

    public final IOBuffer putFrom(int index, IOElasticBuffer source, int bufferOffset, int length) {
        int offsetBeyondLastSerializedByte = index + length;
        if (offsetBeyondLastSerializedByte > this.length) {
            throw new BufferOverflowException();
        }
        UtlBuffer.copy(source.getIOBufferForRead().buffer, source.getOffset(), this.buffer, index, length);
        return this;
    }

    public final IOBuffer putFrom(int index, IOBuffer source, int bufferOffset, int length) {
        int offsetBeyondLastSerializedByte = index + length;
        if (offsetBeyondLastSerializedByte > this.length) {
            throw new BufferOverflowException();
        }
        UtlBuffer.copy(source.buffer, bufferOffset, this.buffer, index, length);
        return this;
    }

    public final IOBuffer putFrom(int index, byte[] source, int offset, int length) {
        int offsetBeyondLastSerializedByte = index + length;
        if (offsetBeyondLastSerializedByte > this.length) {
            throw new BufferOverflowException();
        }
        UtlBuffer.copy(source, offset, this.buffer, index, length);
        return this;
    }

    public final String toString() {
        return "[native=" + this.isNative + ", ownerCount=" + this.ownershipCount.get() + ", buf=" + UtlBuffer.toString(this.buffer) + ", highwater=" + this.highwater + "]";
    }

    static {
        int i;
        DISABLE_NATIVE_BUFFERS = UtlEnv.getValue("nv.xiobuf.disablenative", UtlEnv.getValue("nv.pkt.iobuf.disablenative", false));
        USE_PKTIOBUFFER = UtlEnv.getValue("nv.xiobuf.usepacketiobuffer", true);
        USE_MASTERDIRECTBUFFER = UtlEnv.getValue("nv.xiobuf.usemasterdirectbuffer", true);
        USE_SINGLEMASTERDIRECTBUFFER = UtlEnv.getValue("nv.xiobuf.usesinglemasterdirectbuffer", false);
        if (!USE_PKTIOBUFFER) {
            provider = new Provider();
        } else {
            try {
                Class<?> providerClass = Class.forName("com.neeve.pkt.PktIOBuffer$Provider");
                Constructor<?> providerConstructor = providerClass.getDeclaredConstructor(new Class[0]);
                providerConstructor.setAccessible(true);
                provider = (IOBufferProvider)providerConstructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                InternalError ie = new InternalError("Error loading PktIOBuffer provider class");
                ie.initCause(e);
                throw ie;
            }
        }
        directPoolFactories = new Factory[]{new Factory(32, true), new Factory(64, true), new Factory(128, true), new Factory(256, true), new Factory(512, true), new Factory(1024, true), new Factory(2048, true), new Factory(4096, true), new Factory(8192, true), new Factory(16384, true), new Factory(32768, true), new Factory(65536, true), new Factory(131072, true), new Factory(262144, true), new Factory(524288, true), new Factory(0x100000, true), new Factory(0x200000, true), new Factory(0x400000, true), new Factory(0x800000, true)};
        heapPoolFactories = new Factory[]{new Factory(32, false), new Factory(64, false), new Factory(128, false), new Factory(256, false), new Factory(512, false), new Factory(1024, false), new Factory(2048, false), new Factory(4096, false), new Factory(8192, false), new Factory(16384, false), new Factory(32768, false), new Factory(65536, false), new Factory(131072, false), new Factory(262144, false), new Factory(524288, false), new Factory(0x100000, false), new Factory(0x200000, false), new Factory(0x400000, false), new Factory(0x800000, false)};
        heapPools = UtlPool.createPoolArray(heapPoolFactories.length);
        for (i = 0; i < heapPoolFactories.length; ++i) {
            IOBuffer.heapPools[i] = UtlPool.create("iobuf", "heap-" + IOBuffer.memToStr(IOBuffer.heapPoolFactories[i].slabSize), heapPoolFactories[i], UtlPool.Params.create().setThreaded(true).setDetachedWash(true));
        }
        slabTable = new OpenIntIntHashMap();
        for (i = 0; i < heapPoolFactories.length; ++i) {
            slabTable.put(IOBuffer.heapPoolFactories[i].slabSize, (int)(Math.log(IOBuffer.heapPoolFactories[i].slabSize) / Math.log(2.0)));
        }
        SLAB_SHIFT_FACTOR = IOBuffer.slab(32);
        NATIVE_PAGE_SIZE = UtlEnv.getValue("nv.iobuf.native.pagesize", 8192);
        directPools = UtlPool.createPoolArray(directPoolFactories.length);
        for (i = 0; i < directPoolFactories.length; ++i) {
            IOBuffer.directPools[i] = UtlPool.create("iobuf", "native-" + IOBuffer.memToStr(IOBuffer.directPoolFactories[i].slabSize), directPoolFactories[i], UtlPool.Params.create().setThreaded(true).setDetachedWash(true));
        }
        if (USE_MASTERDIRECTBUFFER) {
            masterDirectBufferTable = new UtlLinkedLongMap();
            if (USE_SINGLEMASTERDIRECTBUFFER) {
                masterDirectBufferTable.put(0L, (Object)ByteBuffer.allocateDirect(NATIVE_PAGE_SIZE));
            } else {
                for (i = 0; i < directPoolFactories.length; ++i) {
                    if (IOBuffer.directPoolFactories[i].slabSize >= NATIVE_PAGE_SIZE) continue;
                    masterDirectBufferTable.put((long)IOBuffer.directPoolFactories[i].slabSize, (Object)ByteBuffer.allocateDirect(NATIVE_PAGE_SIZE));
                }
            }
            if (UtlEnv.getValue("nv.native.configtrace", false)) {
                System.out.println("NATIVE IO BUFFERS ARE " + (!DISABLE_NATIVE_BUFFERS ? "ENABLED" : "DISABLED"));
            }
        } else {
            masterDirectBufferTable = null;
        }
    }

    private static final class Factory
    implements UtlPool.Factory<IOBuffer> {
        final int slabSize;
        final boolean isNative;

        Factory(int slabSize, boolean isNative) {
            this.slabSize = slabSize;
            this.isNative = isNative;
        }

        @Override
        public final IOBuffer createItem(Object object) {
            return provider.create(this.slabSize, this.isNative);
        }

        public final IOBuffer[] createItemArray(int size) {
            return provider.createArray(size);
        }
    }

    private static final class Provider
    implements IOBufferProvider {
        private Provider() {
        }

        @Override
        public final IOBuffer create(int capacity, boolean isNative) {
            return new IOBuffer(capacity, isNative);
        }

        @Override
        public final IOBuffer[] createArray(int size) {
            return new IOBuffer[size];
        }
    }

    protected static interface IOBufferProvider {
        public IOBuffer create(int var1, boolean var2);

        public IOBuffer[] createArray(int var1);
    }
}

