/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.ci;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.neeve.license.License;
import com.neeve.license.LicenseException;
import com.neeve.license.LicenseVerifier;
import com.neeve.util.UtlEnv;
import com.neeve.util.UtlNet;
import com.neeve.util.UtlPlatform;
import com.neeve.util.UtlProc;
import com.neeve.util.UtlProps;
import com.neeve.util.UtlUnit;
import java.io.File;
import java.io.FileInputStream;
import java.net.UnknownHostException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.Properties;

public class XRuntime {
    private static final String DEFAULT_APPLICATION_CONF = "conf/application.conf";
    private static String appName;
    private static String appGroup;
    private static Optimization optimization;
    private static boolean optimizeMemoryUsage;
    private static boolean disableWaitStrategyOptimizations;
    private static boolean conserveCPU;
    private static final License license;
    public static final String defaultAppName = "anonymous";
    public static final String defaultAppGroup = "default";

    public static License getLicense() {
        return license;
    }

    public static Date getLicenseExpiration() throws Exception {
        if (license == null || license.isPerpetual()) {
            return null;
        }
        return license.getExpiration();
    }

    private static final void updateEnv(Properties val, Properties env) {
        for (String key : val.stringPropertyNames()) {
            try {
                String value = val.getProperty(key);
                if (value == null) continue;
                env.setProperty(key, value);
            }
            catch (RuntimeException thrown) {
                System.err.println("Error updating XRuntime property (key=" + key + ", value=" + val.getProperty(key) + "): " + thrown.getLocalizedMessage());
                throw thrown;
            }
        }
    }

    private static final void updateSystemProps(Properties val) {
        Properties props = System.getProperties();
        for (String key : val.stringPropertyNames()) {
            try {
                String value;
                if (props.get(key) != null || (value = val.getProperty(key)) == null) continue;
                props.setProperty(key, value);
            }
            catch (RuntimeException thrown) {
                System.err.println("Error updating system property (key=" + key + ", value=" + val.getProperty(key) + "): " + thrown.getLocalizedMessage());
                throw thrown;
            }
        }
    }

    private static final void validateLicensedMaxMemory(License license) {
        block6: {
            try {
                long maxMemory;
                long maxHeap = (long)UtlUnit.parseBytes(license.getProperty("MaxHeap", "0"), UtlUnit.ByteUnit.Gigabytes, UtlUnit.ByteUnit.Bytes);
                if (maxHeap <= 0L || (maxMemory = Runtime.getRuntime().maxMemory()) <= maxHeap) break block6;
                System.err.println("****** X license verification failed [Heap limit exceeded (licensed max=" + maxHeap + " (" + UtlUnit.readableBytesSize(maxHeap) + "), actual=" + maxMemory + "(" + UtlUnit.readableBytesSize(maxMemory) + ")]. Exiting in 5 seconds... ******");
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(1);
            }
            catch (NumberFormatException e) {
                System.err.println("****** X license verification failed [MaxHeap value in license is invalid]. Exiting in 5 seconds... ******");
                e.printStackTrace();
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.exit(1);
            }
        }
    }

    private static final License validateLicense() {
        try {
            License license = LicenseVerifier.locateAndVerify();
            XRuntime.validateLicensedMaxMemory(license);
            if (!license.isPerpetual()) {
                Date expiration = license.getExpiration();
                Calendar calendar = Calendar.getInstance();
                calendar.add(2, 1);
                if (expiration.before(calendar.getTime())) {
                    System.err.println("WARNING: your X Platform license will expire on " + expiration + "!");
                }
            }
            return license;
        }
        catch (LicenseException e) {
            System.err.println("****** X license verification failed [" + e.getMessage() + "]. Exiting... ******");
            System.exit(1);
        }
        catch (Throwable e) {
            System.err.println("Encountered fatal exception during license locate and verify");
            e.printStackTrace();
            System.err.println("Exiting...");
            System.exit(1);
        }
        return null;
    }

    private static final void setAppNameAndGroup(String defaultAppName, String defaultAppGroup) {
        appName = UtlEnv.getValue("nv.app.name", defaultAppName);
        appGroup = UtlEnv.getValue("nv.app.group", defaultAppGroup);
    }

    public static final void setOptimization(Optimization val) {
        optimization = val;
    }

    public static final String getRootDirectory() {
        return UtlEnv.getValue("NVROOT", ".");
    }

    public static final String getBinDirectory() {
        return XRuntime.getRootDirectory() + "/bin";
    }

    public static final String getConfigDirectory() {
        return XRuntime.getRootDirectory() + "/conf";
    }

    @Deprecated
    public static final String getLicenseDirectory() {
        return XRuntime.getRootDirectory() + "/doc/license";
    }

    public static final String getJavaLibDirectory() {
        return XRuntime.getRootDirectory() + "/bin/java/lib";
    }

    public static final String getUnmanagedJavaLibDirectory() {
        return XRuntime.getJavaLibDirectory() + "/unmanaged";
    }

    public static final String getDataDirectory(boolean createIfAbsent) {
        File dir;
        String dirname = UtlEnv.getValue("nv.data.directory");
        if (dirname == null) {
            dirname = XRuntime.getRootDirectory() + "/rdat";
            dir = new File(dirname);
        } else if (new File(dirname).isAbsolute()) {
            dir = new File(dirname);
        } else {
            dir = new File(XRuntime.getRootDirectory(), dirname);
            dirname = dir.getAbsolutePath();
        }
        if (!dir.exists()) {
            if (createIfAbsent) {
                dir.mkdirs();
            }
            return dirname;
        }
        if (!dir.isDirectory()) {
            System.err.println("configured data directory is actually a file!");
            System.exit(1);
        }
        return dirname;
    }

    public static final String getDataDirectory() {
        return XRuntime.getDataDirectory(true);
    }

    public static final String getLogsDirectory(boolean createIfAbsent) {
        File dir;
        String dirname = UtlEnv.getValue("nv.log.directory", null);
        if (dirname == null) {
            dirname = XRuntime.getDataDirectory() + "/logs";
            dir = new File(dirname);
        } else if (new File(dirname).isAbsolute()) {
            dir = new File(dirname);
        } else {
            dir = new File(XRuntime.getDataDirectory(), dirname);
            dirname = dir.getAbsolutePath();
        }
        if (!dir.exists()) {
            if (createIfAbsent) {
                dir.mkdirs();
            }
            return dirname;
        }
        if (!dir.isDirectory()) {
            System.err.println("configured data directory is actually a file!");
            System.exit(1);
        }
        return dirname;
    }

    public static final String getLogsDirectory() {
        return XRuntime.getLogsDirectory(true);
    }

    public static final String getLocalHostNameForDisplay(String defaultValue) {
        return UtlNet.getLocalHostNameForDisplay(defaultValue);
    }

    public static final String getLocalHostName() throws UnknownHostException {
        return UtlNet.getLocalHostName();
    }

    public static final String getLocalHostAddressForDisplay(String defaultValue) {
        return UtlNet.getLocalHostAddressForDisplay(defaultValue);
    }

    public static final String getLocalHostAddress() throws UnknownHostException {
        return UtlNet.getLocalHostAddress();
    }

    public static final String getPid() {
        return UtlProc.getPid();
    }

    public static final void setAppGroup(String val) {
        appGroup = val;
    }

    public static final String getAppGroup() {
        return appGroup;
    }

    public static final void setAppName(String val) {
        appName = val;
    }

    public static final String getAppName() {
        return appName;
    }

    public static final String getFullAppName() {
        return XRuntime.getAppGroup() + ":" + XRuntime.getAppName();
    }

    public static final void updateProps(Properties val) {
        UtlEnv.update(val);
        String optimizationStr = UtlEnv.getValue("nv.optimizefor", null);
        try {
            optimization = optimizationStr != null ? Optimization.valueOf(optimizationStr) : null;
        }
        catch (Exception e) {
            System.err.println("WARNING: Invalid global optimization '" + optimizationStr + "'. Defaulting to none");
        }
        optimizeMemoryUsage = UtlEnv.getValue("nv.optimizeMemoryUsage", false);
        disableWaitStrategyOptimizations = UtlEnv.getValue("nv.disablewaitstrategyoptimizations", false);
        conserveCPU = UtlEnv.getValue("nv.conservecpu", false);
        XRuntime.setAppNameAndGroup(appName, appGroup);
    }

    public static final Properties getProps() {
        return UtlEnv.getEnvProps();
    }

    public static Object getValue(String name) {
        return UtlEnv.getValue(name);
    }

    public static boolean getValue(String name, boolean defValue) {
        return UtlEnv.getValue(name, defValue);
    }

    public static double getValue(String name, double defValue) {
        return UtlEnv.getValue(name, defValue);
    }

    public static float getValue(String name, float defValue) {
        return (float)UtlEnv.getValue(name, defValue);
    }

    public static long getValue(String name, long defValue) {
        return (long)UtlEnv.getValue(name, defValue);
    }

    public static int getValue(String name, int defValue) {
        return UtlEnv.getValue(name, defValue);
    }

    public static short getValue(String name, short defValue) {
        return UtlEnv.getValue(name, defValue);
    }

    public static byte getValue(String name, byte defValue) {
        return (byte)UtlEnv.getValue(name, defValue);
    }

    public static String getValue(String name, String defValue) {
        return UtlEnv.getValue(name, defValue);
    }

    public static final String getPlatform() {
        return UtlEnv.getValue("NVPLATFORM", null);
    }

    public static final boolean isWindowsPlatform() {
        return UtlPlatform.isWindowsPlatform((String)XRuntime.getPlatform());
    }

    public static final WaitStrategy createWaitStrategy(String configuredWaitStrategy, boolean optimize) throws IllegalArgumentException {
        BlockingWaitStrategy waitStrategy;
        String waitStrategyStr;
        String string = waitStrategyStr = configuredWaitStrategy == null ? "Blocking" : configuredWaitStrategy;
        if (XRuntime.conserveCPU()) {
            return new BlockingWaitStrategy();
        }
        if (optimize && configuredWaitStrategy == null && !disableWaitStrategyOptimizations) {
            if (XRuntime.optimizeForLatency()) {
                waitStrategyStr = "BusySpin";
            } else if (XRuntime.optimizeForThroughput()) {
                waitStrategyStr = "Yielding";
            }
        }
        if (waitStrategyStr.equalsIgnoreCase("Blocking")) {
            waitStrategy = new BlockingWaitStrategy();
        } else if (waitStrategyStr.equalsIgnoreCase("Sleeping")) {
            waitStrategy = new SleepingWaitStrategy();
        } else if (waitStrategyStr.equalsIgnoreCase("Yielding")) {
            waitStrategy = new YieldingWaitStrategy();
        } else if (waitStrategyStr.equalsIgnoreCase("BusySpin")) {
            waitStrategy = new BusySpinWaitStrategy();
        } else {
            throw new IllegalArgumentException("invalid wait strategy '" + waitStrategyStr + "'");
        }
        return waitStrategy;
    }

    public static final boolean optimizeForLatency() {
        return optimization == Optimization.latency;
    }

    public static final boolean optimizeForThroughput() {
        return optimization == Optimization.throughput;
    }

    public static final boolean optimizeMemoryUsage() {
        return optimizeMemoryUsage;
    }

    public static final boolean conserveCPU() {
        return conserveCPU;
    }

    static {
        license = XRuntime.validateLicense();
        Properties env = new Properties();
        String propfile = UtlProps.getValue((Properties)System.getProperties(), (String)"nv.app.propfile", (String)System.getenv("nv_app_propfile"));
        if (propfile == null) {
            String nvRootFromEnv = System.getenv("NVROOT");
            String nvRootDirectory = UtlProps.getValue((Properties)System.getProperties(), (String)"NVROOT", (String)(nvRootFromEnv != null ? nvRootFromEnv : "."));
            if (new File(nvRootDirectory + File.separator + DEFAULT_APPLICATION_CONF).exists()) {
                propfile = DEFAULT_APPLICATION_CONF;
            }
        }
        if (propfile != null) {
            try {
                FileInputStream fis = new FileInputStream(propfile);
                Properties newprops = new Properties();
                newprops.load(fis);
                XRuntime.updateSystemProps(newprops);
            }
            catch (Exception fis) {
                // empty catch block
            }
        }
        XRuntime.updateEnv(System.getProperties(), env);
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            env.setProperty(entry.getKey(), entry.getValue());
            env.setProperty(entry.getKey().replace('_', '.'), entry.getValue());
        }
        UtlEnv.initialize(env);
        String optimizationStr = UtlEnv.getValue("nv.optimizefor", null);
        try {
            optimization = optimizationStr != null ? Optimization.valueOf(optimizationStr) : null;
        }
        catch (Exception e) {
            System.err.println("WARNING: Invalid global optimization '" + optimizationStr + "'. Defaulting to none");
        }
        optimizeMemoryUsage = UtlEnv.getValue("nv.optimizeMemoryUsage", false);
        disableWaitStrategyOptimizations = UtlEnv.getValue("nv.disablewaitstrategyoptimizations", false);
        conserveCPU = UtlEnv.getValue("nv.conservecpu", false);
        XRuntime.setAppNameAndGroup(defaultAppName, defaultAppGroup);
    }

    public static enum Optimization {
        latency,
        throughput;

    }
}

