/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import com.google.protobuf.CodedOutputStream;
import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.XbufVariableDateField;
import com.neeve.xbuf.XbufVariableDateListField;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import com.neeve.xbuf.test.unit.XbufVariableDateFieldTest;
import java.nio.ByteOrder;
import java.util.Date;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufVariableDateListFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    public static final Date[] randomArray(int len) {
        Date[] array = new Date[len];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XbufVariableDateFieldTest.randomDate();
        }
        return array;
    }

    public static final void assertEqual(Date[] array1, Date[] array2, boolean array1EmptyIsArray2Null) {
        if (array1 == null) {
            Assert.assertNull((Object)array2);
        } else if (array1.length == 0) {
            if (array1EmptyIsArray2Null) {
                Assert.assertNull((Object)array2);
            } else {
                Assert.assertNotNull((Object)array2);
                Assert.assertTrue((array2.length == 0 ? 1 : 0) != 0);
            }
        } else {
            Assert.assertNotNull((Object)array2);
            Assert.assertEquals((long)array1.length, (long)array2.length);
            for (int i = 0; i < array1.length; ++i) {
                Assert.assertEquals((Object)array1[i], (Object)array2[i]);
            }
        }
    }

    public static final void assertEqual(Date[] array1, Date[] array2) {
        XbufVariableDateListFieldTest.assertEqual(array1, array2, false);
    }

    private final XbufVariableDateField field(XbufVariableDateListField listField, Date val) {
        XbufVariableDateField field = XbufVariableDateField.create(listField.id(), listField.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field).build());
        field.setValue(val);
        return field;
    }

    /*
     * WARNING - void declaration
     */
    private final XbufVariableDateListField testSetClearSyncDesync(XbufVariableDateListField field1) throws Exception {
        void var10_14;
        Date[] values = XbufVariableDateListFieldTest.randomArray(0);
        field1.setValues(values);
        Assert.assertNotNull((Object)field1.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        XbufVariableDateListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)0L, (long)field1.length());
        Date value1 = XbufVariableDateFieldTest.randomDate();
        field1.addValue(value1);
        values = new Date[]{value1};
        Assert.assertNotNull((Object)field1.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)1L, (long)field1.getValues().size());
        XbufVariableDateListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime())), (long)field1.length());
        Date value2 = null;
        field1.addValue(value2);
        values = new Date[]{value1, value2};
        Assert.assertNotNull((Object)field1.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)2L, (long)field1.getValues().size());
        XbufVariableDateListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime()) + CodedOutputStream.computeRawVarint64Size((long)-1L)), (long)field1.length());
        Date value3 = XbufVariableDateFieldTest.randomDate();
        field1.getValuesOrNullIfNotSet().add(value3);
        values = new Date[]{value1, value2, value3};
        Assert.assertNotNull((Object)field1.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)3L, (long)field1.getValues().size());
        XbufVariableDateListFieldTest.assertEqual(values, field1.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime()) + CodedOutputStream.computeRawVarint64Size((long)-1L) + CodedOutputStream.computeRawVarint64Size((long)value3.getTime())), (long)field1.length());
        values = XbufVariableDateListFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValues(values);
        Assert.assertNotNull((Object)field1.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)values.length, (long)field1.getValues().size());
        XbufVariableDateListFieldTest.assertEqual(values, field1.getValuesAsArray());
        int len = 0;
        for (Date date : values) {
            len += this.field(field1, date).headerLength() + (date != null ? CodedOutputStream.computeRawVarint64Size((long)date.getTime()) : CodedOutputStream.computeRawVarint64Size((long)-1L));
        }
        Assert.assertEquals((long)len, (long)field1.length());
        values = XbufVariableDateListFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValues(values);
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.clearValue());
        Assert.assertNull((Object)field1.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)0L, (long)field1.getValues().size());
        Assert.assertEquals((long)0L, (long)field1.getValuesAsArray().length);
        Assert.assertEquals((long)0L, (long)field1.length());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        field1.clearValue();
        Assert.assertEquals((long)0L, (long)field1.sync(buffer1, 23));
        values = XbufVariableDateListFieldTest.randomArray(0);
        field1.setValues(values);
        Assert.assertEquals((long)0L, (long)field1.sync(buffer1, 23));
        value1 = XbufVariableDateFieldTest.randomDate();
        field1.addValue(value1);
        values = new Date[]{value1};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime())), (long)field1.sync(buffer1, 23));
        XbufVariableDateListField field2 = XbufVariableDateListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime())), (long)field2.desync(buffer1, 23));
        Assert.assertNotNull((Object)field2.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)1L, (long)field2.getValues().size());
        XbufVariableDateListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime())), (long)field2.length());
        value2 = null;
        field1.addValue(value2);
        values = new Date[]{value1, value2};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime()) + CodedOutputStream.computeRawVarint64Size((long)-1L)), (long)field1.sync(buffer1, 23));
        field2 = XbufVariableDateListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = field2.desync(buffer1, 23);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime())), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime()) + CodedOutputStream.computeRawVarint64Size((long)-1L)), (long)len);
        Assert.assertNotNull((Object)field2.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)2L, (long)field2.getValues().size());
        XbufVariableDateListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime()) + CodedOutputStream.computeRawVarint64Size((long)-1L)), (long)field2.length());
        value3 = XbufVariableDateFieldTest.randomDate();
        field1.getValuesOrNullIfNotSet().add(value3);
        values = new Date[]{value1, value2, value3};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime()) + CodedOutputStream.computeRawVarint64Size((long)-1L) + CodedOutputStream.computeRawVarint64Size((long)value3.getTime())), (long)field1.sync(buffer1, 23));
        field2 = XbufVariableDateListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = field2.desync(buffer1, 23);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime())), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime()) + CodedOutputStream.computeRawVarint64Size((long)-1L)), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime()) + CodedOutputStream.computeRawVarint64Size((long)-1L) + CodedOutputStream.computeRawVarint64Size((long)value3.getTime())), (long)len);
        Assert.assertNotNull((Object)field2.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)3L, (long)field2.getValues().size());
        XbufVariableDateListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + CodedOutputStream.computeRawVarint64Size((long)value1.getTime()) + CodedOutputStream.computeRawVarint64Size((long)-1L) + CodedOutputStream.computeRawVarint64Size((long)value3.getTime())), (long)field2.length());
        values = XbufVariableDateListFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValues(values);
        int expectedLen = 0;
        for (Date s : values) {
            expectedLen += this.field(field1, s).headerLength() + (s != null ? CodedOutputStream.computeRawVarint64Size((long)s.getTime()) : CodedOutputStream.computeRawVarint64Size((long)-1L));
        }
        Assert.assertEquals((long)expectedLen, (long)field1.sync(buffer1, 23));
        field2 = XbufVariableDateListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = 0;
        boolean bl = false;
        while (var10_14 < values.length) {
            len += field2.desync(buffer1, 23 + len);
            ++var10_14;
        }
        Assert.assertEquals((long)expectedLen, (long)len);
        Assert.assertNotNull((Object)field2.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)values.length, (long)field2.getValues().size());
        XbufVariableDateListFieldTest.assertEqual(values, field2.getValuesAsArray());
        Assert.assertEquals((long)expectedLen, (long)field2.length());
        return field2;
    }

    @Test
    public final void testInitialState() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufVariableDateListField field1 = XbufVariableDateListField.create(id, name);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.VARDATE_LIST), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertTrue((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertEquals(null, (Object)field1.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)0L, (long)field1.getValuesAsArray().length);
        Assert.assertEquals((long)0L, (long)field1.length());
        Assert.assertEquals((Object)false, (Object)field1.getValueIterator().hasNext());
        field1 = XbufVariableDateListField.create(id, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.VARDATE_LIST), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertTrue((boolean)field1.repeating());
        Assert.assertTrue((boolean)field1.variableLength());
        Assert.assertEquals(null, (Object)field1.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)0L, (long)field1.getValuesAsArray().length);
        Assert.assertEquals((long)0L, (long)field1.length());
        Assert.assertEquals((Object)false, (Object)field1.getValueIterator().hasNext());
    }

    @Test
    public final void testInitSetClearSyncDesync_Heap() throws Exception {
        XbufVariableDateListField field1 = XbufVariableDateListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Native() throws Exception {
        XbufVariableDateListField field1 = XbufVariableDateListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testModificationAfterSync() throws Exception {
        XbufVariableDateListField field1 = XbufVariableDateListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer container1 = XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        field1.addValue(this.randomValue());
        container1.sync();
        int origLength = container1.getSerializedLength();
        for (int i = 0; i < 1024; ++i) {
            field1.addValue(this.randomValue());
        }
        int newLength = container1.getSerializedLength();
        Assert.assertTrue((String)("Field container serialized length should have increased orig: " + origLength + " now: " + newLength), (origLength < newLength ? 1 : 0) != 0);
    }

    private final Date randomValue() {
        return new Date(System.currentTimeMillis() + (long)random.nextInt(30000));
    }
}

