/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf.test.unit;

import cern.colt.list.ObjectArrayList;
import com.neeve.pkt.PktBuffer;
import com.neeve.test.UnitTest;
import com.neeve.xbuf.XbufCurrencyField;
import com.neeve.xbuf.XbufCurrencyListField;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufFieldContainer;
import com.neeve.xbuf.XbufListField;
import com.neeve.xbuf.XbufSchema;
import com.neeve.xbuf.test.unit.XbufCurrencyFieldTest;
import com.neeve.xbuf.test.unit.XbufStringFieldTest;
import java.nio.ByteOrder;
import java.util.Currency;
import java.util.Iterator;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class XbufCurrencyListFieldTest
extends UnitTest {
    private static Random random = new Random(System.currentTimeMillis());

    public static final Currency[] randomArray(int len) {
        Currency[] array = new Currency[len];
        for (int i = 0; i < array.length; ++i) {
            array[i] = XbufCurrencyFieldTest.randomCurrency();
        }
        return array;
    }

    public static final void assertEqual(Currency[] array1, ObjectArrayList list) {
        if (array1 == null) {
            Assert.assertNull((Object)list);
        } else {
            Assert.assertNotNull((Object)list);
            Assert.assertEquals((long)array1.length, (long)list.size());
            for (int i = 0; i < array1.length; ++i) {
                Assert.assertEquals((Object)array1[i], (Object)list.get(i));
            }
        }
    }

    public static final void assertEqual(Currency[] array1, Currency[] array2, boolean array1EmptyIsArray2Null) {
        if (array1 == null) {
            Assert.assertNull((Object)array2);
        } else if (array1.length == 0) {
            if (array1EmptyIsArray2Null) {
                Assert.assertNull((Object)array2);
            } else {
                Assert.assertNotNull((Object)array2);
                Assert.assertTrue((array2.length == 0 ? 1 : 0) != 0);
            }
        } else {
            Assert.assertNotNull((Object)array2);
            Assert.assertEquals((long)array1.length, (long)array2.length);
            for (int i = 0; i < array1.length; ++i) {
                Assert.assertEquals((Object)array1[i], (Object)array2[i]);
            }
        }
    }

    public static final void assertEqual(Currency[] array1, Currency[] array2) {
        XbufCurrencyListFieldTest.assertEqual(array1, array2, false);
    }

    public static final void assertEqual(Currency[] array, Iterator<Currency> iterator) {
        if (array == null) {
            Assert.assertNull(iterator);
        } else {
            Assert.assertNotNull(iterator);
            for (int i = 0; i < array.length; ++i) {
                Assert.assertEquals((String)"iterator.hasNext()", (Object)true, (Object)iterator.hasNext());
                Assert.assertEquals((Object)array[i], (Object)iterator.next());
            }
            Assert.assertEquals((String)"iterator.hasNext()", (Object)false, (Object)iterator.hasNext());
        }
    }

    private final XbufCurrencyField field(XbufCurrencyListField listField, Currency val) {
        XbufCurrencyField field = XbufCurrencyField.create(listField.id(), listField.name(), false);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field).build());
        field.setValue(val);
        return field;
    }

    private final int serializedLength(Currency value) throws Exception {
        return value.getCurrencyCode().getBytes("us-ascii").length;
    }

    private final Currency randomValue() {
        return XbufCurrencyFieldTest.randomCurrency();
    }

    /*
     * WARNING - void declaration
     */
    private final XbufCurrencyListField testSetClearSyncDesync(XbufCurrencyListField field1) throws Exception {
        Currency[] currencyArray;
        void var10_14;
        Currency[] values = XbufCurrencyListFieldTest.randomArray(0);
        field1.setValues(values);
        XbufCurrencyListFieldTest.assertEqual(values, field1.getValuesOrNullIfNotSet());
        XbufCurrencyListFieldTest.assertEqual(values, (Currency[])field1.getValuesAsArray());
        XbufCurrencyListFieldTest.assertEqual(values, (Iterator<Currency>)((Object)field1.getValueIterator()));
        Assert.assertEquals((long)0L, (long)field1.length());
        Currency value1 = XbufCurrencyFieldTest.randomCurrency();
        field1.addValue(value1);
        values = new Currency[]{value1};
        XbufCurrencyListFieldTest.assertEqual(values, field1.getValuesOrNullIfNotSet());
        XbufCurrencyListFieldTest.assertEqual(values, (Currency[])field1.getValuesAsArray());
        XbufCurrencyListFieldTest.assertEqual(values, (Iterator<Currency>)((Object)field1.getValueIterator()));
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.serializedLength(value1)), (long)field1.length());
        Currency value2 = null;
        field1.addValue(value2);
        values = new Currency[]{value1, value2};
        XbufCurrencyListFieldTest.assertEqual(values, field1.getValuesOrNullIfNotSet());
        XbufCurrencyListFieldTest.assertEqual(values, (Currency[])field1.getValuesAsArray());
        XbufCurrencyListFieldTest.assertEqual(values, (Iterator<Currency>)((Object)field1.getValueIterator()));
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.serializedLength(value1)), (long)field1.length());
        Currency value3 = XbufCurrencyFieldTest.randomCurrency();
        field1.getValuesOrNullIfNotSet().add((Object)value3);
        values = new Currency[]{value1, value2, value3};
        XbufCurrencyListFieldTest.assertEqual(values, field1.getValuesOrNullIfNotSet());
        XbufCurrencyListFieldTest.assertEqual(values, (Currency[])field1.getValuesAsArray());
        XbufCurrencyListFieldTest.assertEqual(values, (Iterator<Currency>)((Object)field1.getValueIterator()));
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + this.serializedLength(value1) + this.serializedLength(value3)), (long)field1.length());
        values = XbufCurrencyListFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValues(values);
        XbufCurrencyListFieldTest.assertEqual(values, field1.getValuesOrNullIfNotSet());
        XbufCurrencyListFieldTest.assertEqual(values, (Currency[])field1.getValuesAsArray());
        XbufCurrencyListFieldTest.assertEqual(values, (Iterator<Currency>)((Object)field1.getValueIterator()));
        int len = 0;
        for (Currency currency : values) {
            len += this.field(field1, currency).headerLength() + (currency != null ? this.serializedLength(currency) : 0);
        }
        Assert.assertEquals((long)len, (long)field1.length());
        values = XbufCurrencyListFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValues(values);
        Assert.assertTrue((boolean)field1.clearValue());
        Assert.assertFalse((boolean)field1.clearValue());
        Assert.assertEquals(null, (Object)field1.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)0L, (long)((Currency[])field1.getValuesAsArray()).length);
        Assert.assertEquals((Object)false, (Object)field1.getValueIterator().hasNext());
        Assert.assertEquals((long)0L, (long)field1.length());
        PktBuffer buffer1 = PktBuffer.create(null, (int)256, (boolean)false);
        buffer1.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        field1.clearValue();
        Assert.assertEquals((long)0L, (long)field1.sync(buffer1, 23));
        values = XbufCurrencyListFieldTest.randomArray(0);
        field1.setValues(values);
        Assert.assertEquals((long)0L, (long)field1.sync(buffer1, 23));
        value1 = XbufCurrencyFieldTest.randomCurrency();
        field1.addValue(value1);
        values = new Currency[]{value1};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.serializedLength(value1)), (long)field1.sync(buffer1, 23));
        XbufCurrencyListField field2 = XbufCurrencyListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.serializedLength(value1)), (long)field2.desync(buffer1, 23));
        XbufCurrencyListFieldTest.assertEqual(values, field2.getValuesOrNullIfNotSet());
        XbufCurrencyListFieldTest.assertEqual(values, (Currency[])field2.getValuesAsArray());
        XbufCurrencyListFieldTest.assertEqual(values, (Iterator<Currency>)((Object)field2.getValueIterator()));
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.serializedLength(value1)), (long)field2.length());
        value2 = null;
        field1.addValue(value2);
        values = new Currency[]{value1, value2};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.serializedLength(value1)), (long)field1.sync(buffer1, 23));
        field2 = XbufCurrencyListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = field2.desync(buffer1, 23);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.serializedLength(value1)), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.serializedLength(value1)), (long)len);
        XbufCurrencyListFieldTest.assertEqual(values, field2.getValuesOrNullIfNotSet());
        XbufCurrencyListFieldTest.assertEqual(values, (Currency[])field2.getValuesAsArray());
        XbufCurrencyListFieldTest.assertEqual(values, (Iterator<Currency>)((Object)field2.getValueIterator()));
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.serializedLength(value1)), (long)field2.length());
        value3 = XbufCurrencyFieldTest.randomCurrency();
        field1.getValuesOrNullIfNotSet().add((Object)value3);
        values = new Currency[]{value1, value2, value3};
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + this.serializedLength(value1) + this.serializedLength(value3)), (long)field1.sync(buffer1, 23));
        field2 = XbufCurrencyListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = field2.desync(buffer1, 23);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.serializedLength(value1)), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.serializedLength(value1)), (long)len);
        len += field2.desync(buffer1, 23 + len);
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + this.serializedLength(value1) + this.serializedLength(value3)), (long)len);
        XbufCurrencyListFieldTest.assertEqual(values, field2.getValuesOrNullIfNotSet());
        XbufCurrencyListFieldTest.assertEqual(values, (Currency[])field2.getValuesAsArray());
        XbufCurrencyListFieldTest.assertEqual(values, (Iterator<Currency>)((Object)field2.getValueIterator()));
        Assert.assertEquals((long)(this.field(field1, value1).headerLength() + this.field(field1, value2).headerLength() + this.field(field1, value3).headerLength() + this.serializedLength(value1) + this.serializedLength(value3)), (long)field2.length());
        values = XbufCurrencyListFieldTest.randomArray(1 + random.nextInt(20));
        field1.setValues(values);
        int expectedLen = 0;
        for (Currency s : values) {
            expectedLen += this.field(field1, s).headerLength() + (s != null ? this.serializedLength(s) : 0);
        }
        Assert.assertEquals((long)expectedLen, (long)field1.sync(buffer1, 23));
        field2 = XbufCurrencyListField.create(field1.id(), field1.name());
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field2).build());
        len = 0;
        boolean bl = false;
        while (var10_14 < values.length) {
            len += field2.desync(buffer1, 23 + len);
            ++var10_14;
        }
        Assert.assertEquals((long)expectedLen, (long)len);
        XbufCurrencyListFieldTest.assertEqual(values, field2.getValuesOrNullIfNotSet());
        XbufCurrencyListFieldTest.assertEqual(values, (Currency[])field2.getValuesAsArray());
        XbufCurrencyListFieldTest.assertEqual(values, (Iterator<Currency>)((Object)field2.getValueIterator()));
        Assert.assertEquals((long)expectedLen, (long)field2.length());
        for (Currency value : currencyArray = XbufCurrencyListFieldTest.randomArray(1 + random.nextInt(5))) {
            field2.addValue(value);
        }
        Currency[] allValues = new Currency[values.length + currencyArray.length];
        int i = 0;
        for (Currency value : values) {
            allValues[i++] = value;
        }
        for (Currency value : currencyArray) {
            allValues[i++] = value;
        }
        XbufCurrencyListFieldTest.assertEqual(allValues, field2.getValuesOrNullIfNotSet());
        XbufCurrencyListFieldTest.assertEqual(allValues, (Currency[])field2.getValuesAsArray());
        XbufCurrencyListFieldTest.assertEqual(allValues, (Iterator<Currency>)((Object)field2.getValueIterator()));
        XbufCurrencyListFieldTest.assertEqual(currencyArray, (Iterator<Currency>)((Object)field2.getValueIterator(true)));
        IteratedValueNotificationReceiver notificationReceiver = new IteratedValueNotificationReceiver();
        XbufCurrencyListFieldTest.assertEqual(allValues, (Iterator<Currency>)((Object)field2.getValueIterator(false, notificationReceiver)));
        Assert.assertEquals((long)values.length, (long)notificationReceiver.numDesynced);
        Assert.assertEquals((long)currencyArray.length, (long)notificationReceiver.numNotDesyncd);
        notificationReceiver = new IteratedValueNotificationReceiver();
        XbufCurrencyListFieldTest.assertEqual(currencyArray, (Iterator<Currency>)((Object)field2.getValueIterator(true, notificationReceiver)));
        Assert.assertEquals((long)0L, (long)notificationReceiver.numDesynced);
        Assert.assertEquals((long)currencyArray.length, (long)notificationReceiver.numNotDesyncd);
        return field2;
    }

    @Test
    public final void testInitialState() {
        short id = (short)random.nextInt(Short.MAX_VALUE);
        String name = XbufStringFieldTest.randomString();
        XbufCurrencyListField field1 = XbufCurrencyListField.create(id, name);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.CURRENCY_LIST), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertEquals((Object)name, (Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertTrue((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertEquals(null, (Object)field1.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)0L, (long)((Currency[])field1.getValuesAsArray()).length);
        Assert.assertEquals((Object)false, (Object)field1.getValueIterator().hasNext());
        Assert.assertEquals((long)0L, (long)field1.length());
        Assert.assertEquals((Object)false, (Object)field1.getValueIterator().hasNext());
        field1 = XbufCurrencyListField.create(id, null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        Assert.assertEquals((Object)((Object)XbufField.Type.CURRENCY_LIST), (Object)((Object)field1.type()));
        Assert.assertEquals((long)id, (long)field1.id());
        Assert.assertNull((Object)field1.name());
        Assert.assertFalse((boolean)field1.pinned());
        Assert.assertTrue((boolean)field1.repeating());
        Assert.assertFalse((boolean)field1.variableLength());
        Assert.assertEquals(null, (Object)field1.getValuesOrNullIfNotSet());
        Assert.assertEquals((long)0L, (long)((Currency[])field1.getValuesAsArray()).length);
        Assert.assertEquals((Object)false, (Object)field1.getValueIterator().hasNext());
        Assert.assertEquals((long)0L, (long)field1.length());
        Assert.assertEquals((Object)false, (Object)field1.getValueIterator().hasNext());
    }

    @Test
    public final void testInitSetClearSyncDesync_Heap() throws Exception {
        XbufCurrencyListField field1 = XbufCurrencyListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testInitSetClearSyncDesync_Native() throws Exception {
        XbufCurrencyListField field1 = XbufCurrencyListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)true)).setSchema(XbufSchema.builder().add(field1).build());
        this.testSetClearSyncDesync(this.testSetClearSyncDesync(field1));
    }

    @Test
    public final void testModificationAfterSync() throws Exception {
        XbufCurrencyListField field1 = XbufCurrencyListField.create((short)random.nextInt(Short.MAX_VALUE), null);
        XbufFieldContainer container1 = XbufFieldContainer.create(PktBuffer.create(null, (int)256, (boolean)false)).setSchema(XbufSchema.builder().add(field1).build());
        field1.addValue(this.randomValue());
        container1.sync();
        int origLength = container1.getSerializedLength();
        for (int i = 0; i < 1024; ++i) {
            field1.addValue(this.randomValue());
        }
        int newLength = container1.getSerializedLength();
        Assert.assertTrue((String)("Field container serialized length should have increased orig: " + origLength + " now: " + newLength), (origLength < newLength ? 1 : 0) != 0);
    }

    private static final class IteratedValueNotificationReceiver
    implements XbufListField.IteratedValueNotificationReceiver<Currency> {
        int numDesynced;
        int numNotDesyncd;

        private IteratedValueNotificationReceiver() {
        }

        @Override
        public final void handleIteratedValue(Currency value, boolean wasDesyncd) {
            if (wasDesyncd) {
                ++this.numDesynced;
            } else {
                ++this.numNotDesyncd;
            }
        }
    }
}

