/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.google.protobuf.CodedOutputStream;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;

public final class XbufVariableIntField
extends XbufField {
    private final int DEFAULT;
    private final Value value = new Value();

    private XbufVariableIntField(short id, String name, int defval) {
        super(XbufField.Type.VARINTEGER, id, name, false, false);
        this.value.val = this.DEFAULT = defval;
    }

    public static XbufVariableIntField create(short id, String name, int defval) {
        return new XbufVariableIntField(id, name, defval);
    }

    public static XbufVariableIntField create(short id, String name) {
        return XbufVariableIntField.create(id, name, 0);
    }

    final int serializedLength(int val) {
        return CodedOutputStream.computeRawVarint32Size((int)val);
    }

    final int serialize(PktBuffer buffer, int offset, int val) {
        return XbufVariableIntField.syncVarint32(val, buffer, offset);
    }

    final int deserialize(PktBuffer buffer, int offset) {
        return XbufVariableIntField.desyncVarint32(buffer, offset, this.varintDesyncLength);
    }

    final String toString(int val) {
        return String.valueOf(val);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        return this.serialize(buffer, offset, this.getValue());
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        this.value.val = this.deserialize(buffer, offset);
        this.container.setValue(this, this.value);
        return this.varintDesyncLength.value;
    }

    @Override
    protected final int contentLength() {
        return this.serializedLength(this.getValue());
    }

    @Override
    protected final String contentAsString() {
        return this.toString(this.getValue());
    }

    @Override
    protected final boolean contentClear() {
        this.value.val = this.DEFAULT;
        return this.container.clearValue(this);
    }

    public final int getDefault() {
        return this.DEFAULT;
    }

    public final void setValue(int val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        this.value.val = val;
        this.container.setValue(this, this.value);
    }

    public final void setValueFrom(XbufVariableIntField field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        this.value.val = field.getValue();
        this.container.setValue(this, this.value);
    }

    public final int getValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.container.framed[this.index]) {
            return this.deserialize(this.buffer, this.contentOffset);
        }
        Value value = (Value)this.container.fieldValues[this.index];
        return value != null ? value.val : this.DEFAULT;
    }

    static final int serializeField(PktBuffer buffer, int offset, short id, int v) {
        int headerLength = XbufVariableIntField.syncHeader(buffer, offset, id, XbufField.Type.VARINTEGER, CodedOutputStream.computeRawVarint32Size((int)v));
        int valLength = XbufVariableIntField.syncVarint32(v, buffer, offset + headerLength);
        return headerLength + valLength;
    }

    public static int serializedFieldLength(short id, int v) {
        int len = CodedOutputStream.computeRawVarint32Size((int)v);
        return len + XbufVariableIntField.headerLength(id, XbufField.Type.VARINTEGER, len);
    }

    static final int deserializeValue(PktBuffer buffer, int offset, XbufField.VarintDesyncLength varintDesyncLength) {
        return XbufVariableIntField.desyncVarint32(buffer, offset, varintDesyncLength);
    }

    static final int deserializeField(PktBuffer buffer, int offset, short id, XbufField.VarintDesyncLength varintDesyncLength) {
        int tag = XbufVariableIntField.desyncVarint32(buffer, offset, varintDesyncLength);
        int tagLength = varintDesyncLength.value;
        if (id != XbufVariableIntField.fieldId(tag)) {
            throw new IllegalArgumentException("attempt to desync a field using a different field on the wire!");
        }
        int value = XbufVariableIntField.deserializeValue(buffer, offset + tagLength, varintDesyncLength);
        varintDesyncLength.value += tagLength;
        return value;
    }

    private final class Value {
        int val;

        private Value() {
        }
    }
}

