/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.google.protobuf.CodedOutputStream;
import com.neeve.lang.XIntAdapter;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;

public class XbufVariableIntAdaptingField<T>
extends XbufField {
    private final T DEFAULT;
    private final Value value = new Value();
    private final XIntAdapter<T> valueAdapter;

    protected XbufVariableIntAdaptingField(short id, String name, T defval, XIntAdapter<T> valueAdapter) {
        super(XbufField.Type.VARINTEGER, id, name, false, false);
        this.DEFAULT = defval;
        this.value.val = this.DEFAULT;
        this.valueAdapter = valueAdapter;
    }

    public static <T> XbufVariableIntAdaptingField<T> create(short id, String name, T defval, XIntAdapter<T> valueAdapter) {
        return new XbufVariableIntAdaptingField<T>(id, name, defval, valueAdapter);
    }

    public static <T> XbufVariableIntAdaptingField<T> create(short id, String name, XIntAdapter<T> valueAdapter) {
        return XbufVariableIntAdaptingField.create(id, name, null, valueAdapter);
    }

    final int serializedLength(T val) {
        return CodedOutputStream.computeRawVarint32Size((int)this.valueAdapter.adaptTo(val));
    }

    final int serialize(PktBuffer buffer, int offset, T val) {
        return XbufVariableIntAdaptingField.syncVarint32(this.valueAdapter.adaptTo(val), buffer, offset);
    }

    final int deserialize(PktBuffer buffer, int offset) {
        return XbufVariableIntAdaptingField.desyncVarint32(buffer, offset, this.varintDesyncLength);
    }

    final String toString(T val) {
        return String.valueOf(val);
    }

    @Override
    protected final int contentSync(PktBuffer buffer, int offset) {
        return this.serialize(buffer, offset, this.getValue());
    }

    @Override
    protected final int contentDesync(PktBuffer buffer, int offset, int length) {
        int toAdapt = this.deserialize(buffer, offset);
        if (this.valueAdapter.canAdaptFrom(toAdapt)) {
            this.value.val = this.valueAdapter.adaptFrom(toAdapt);
            this.container.setValue(this, this.value);
        }
        return this.varintDesyncLength.value;
    }

    @Override
    protected final int contentLength() {
        return this.serializedLength(this.getValue());
    }

    @Override
    protected final String contentAsString() {
        return this.toString(this.getValue());
    }

    @Override
    protected final boolean contentClear() {
        this.value.val = this.DEFAULT;
        return this.container.clearValue(this);
    }

    public final T getDefault() {
        return this.DEFAULT;
    }

    public final void setValue(T val) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        this.value.val = val;
        this.container.setValue(this, this.value);
    }

    public final void setValueFrom(XbufVariableIntAdaptingField<T> field) {
        if (this.container == null) {
            throw new IllegalStateException("cannot set value for a field not in a container");
        }
        if (field == null) {
            throw new IllegalArgumentException("field cannot be null");
        }
        if (this.container.readOnly[this.index]) {
            throw new IllegalStateException("field is read only");
        }
        this.value.val = field.getValue();
        this.container.setValue(this, this.value);
    }

    public final T getValue() {
        if (this.container == null) {
            throw new IllegalStateException("cannot get value for a field not in a container");
        }
        if (this.container.framed[this.index]) {
            return (T)this.valueAdapter.adaptFrom(this.deserialize(this.buffer, this.contentOffset));
        }
        Value value = (Value)this.container.fieldValues[this.index];
        return value != null ? value.val : this.DEFAULT;
    }

    private final class Value {
        T val;

        private Value() {
        }
    }
}

