/*
 * Decompiled with CFR 0.152.
 */
package com.neeve.xbuf;

import com.neeve.lang.XArrayIterator;
import com.neeve.lang.XIterator;
import com.neeve.pkt.PktBuffer;
import com.neeve.xbuf.XbufField;
import com.neeve.xbuf.XbufVariableLengthField;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.UUID;

public final class XbufUUIDArrayField
extends XbufVariableLengthField<UUID[]> {
    private final Iterator iterator = new Iterator();
    private final boolean allowNullValues;
    private final XbufField.NullValueCheckPolicy nullValueCheckPolicy;

    private XbufUUIDArrayField(short id, String name, boolean allowNullValues, XbufField.NullValueCheckPolicy nullValuePolicy) {
        super(XbufField.Type.UUID_ARRAY, id, name);
        this.allowNullValues = allowNullValues;
        this.nullValueCheckPolicy = nullValuePolicy;
    }

    public static XbufUUIDArrayField create(short id, String name) {
        return new XbufUUIDArrayField(id, name, true, XbufField.NullValueCheckPolicy.Unchecked);
    }

    public static XbufUUIDArrayField create(short id, String name, boolean allowNullValues, XbufField.NullValueCheckPolicy nullValuePolicy) {
        return new XbufUUIDArrayField(id, name, allowNullValues, nullValuePolicy);
    }

    @Override
    protected final int serializedLength(UUID[] val) {
        return val == null ? 0 : val.length * 16;
    }

    @Override
    protected final int serialize(PktBuffer buffer, int offset, UUID[] val) {
        for (int i = 0; i < val.length; ++i) {
            buffer.putLong(offset, val[i] != null ? val[i].getLeastSignificantBits() : -1L);
            buffer.putLong(offset + 8, val[i] != null ? val[i].getMostSignificantBits() : -1L);
            offset += 16;
        }
        return val.length * 16;
    }

    @Override
    protected final UUID[] deserialize(PktBuffer buffer, int offset, int length) {
        UUID[] val = new UUID[length / 16];
        int i = 0;
        int o = offset;
        while (i < val.length) {
            long lsb = buffer.getLong(o);
            long msb = buffer.getLong(o + 8);
            val[i] = lsb != -1L ? new UUID(msb, lsb) : null;
            ++i;
            o += 16;
        }
        return val;
    }

    public final void setValues(UUID[] values) {
        if (this.allowsNullValues() || this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked) {
            super.setValue(values);
        } else {
            this.setValuesFrom((XIterator<UUID>)new XArrayIterator((Object[])values));
        }
    }

    public final UUID[] getValues() {
        return (UUID[])super.getValue();
    }

    public final UUID[] getValuesAsArray() {
        return (UUID[])super.getValue();
    }

    public final void setValuesFrom(XIterator<UUID> val) {
        UUID[] v;
        if (val instanceof Iterator && this.isArrayCopyPossibleFrom((Iterator)val)) {
            v = ((Iterator)val).array();
        } else if (val instanceof XArrayIterator && (this.allowNullValues || this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked)) {
            XArrayIterator a = (XArrayIterator)val;
            v = (UUID[])a.array();
            if (v.length != a.length()) {
                v = new UUID[a.length()];
                System.arraycopy(a.array(), a.offset(), v, 0, a.length());
            }
        } else {
            int size = 0;
            val.toFirst();
            while (val.hasNext()) {
                UUID next = (UUID)val.next();
                if (!this.assertEncodable(next)) continue;
                ++size;
            }
            v = new UUID[size];
            val.toFirst();
            for (int i = 0; i < v.length; ++i) {
                UUID next = (UUID)val.next();
                while (!this.assertEncodable(next)) {
                    next = (UUID)val.next();
                }
                v[i] = next;
            }
        }
        this.setValue(v);
        val.toFirst();
    }

    public final void addValue(UUID val) {
        UUID[] vArray;
        if (!this.assertEncodable(val)) {
            return;
        }
        UUID[] existing = (UUID[])this.getValue();
        if (this.getValue() == null) {
            vArray = new UUID[1];
        } else {
            vArray = new UUID[existing.length + 1];
            System.arraycopy(existing, 0, vArray, 0, existing.length);
            vArray[vArray.length - 1] = val;
        }
        this.setValue(vArray);
    }

    public final Iterator getValueIterator() {
        return this.iterator.toFirst();
    }

    public final boolean allowsNullValues() {
        return this.allowNullValues;
    }

    private final boolean assertEncodable(UUID val) {
        if (this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked) {
            return true;
        }
        if (val != null) {
            return true;
        }
        switch (this.nullValueCheckPolicy) {
            case Ignore: {
                return false;
            }
            case Throw: {
                throw new NullPointerException("Can't add a null value to an array field.");
            }
            case Unchecked: {
                return true;
            }
        }
        return true;
    }

    private final boolean isArrayCopyPossibleFrom(Iterator source) {
        if (this.allowsNullValues()) {
            return true;
        }
        if (!source.allowsNullValues()) {
            switch (source.nullValueCheckPolicy()) {
                case Ignore: 
                case Throw: {
                    return true;
                }
                case Unchecked: {
                    return this.nullValueCheckPolicy == XbufField.NullValueCheckPolicy.Unchecked;
                }
            }
        }
        return false;
    }

    @Override
    protected final String toString(UUID[] val) {
        return Arrays.toString(val);
    }

    public final class Iterator
    implements XIterator<UUID> {
        int current = 0;

        public UUID[] array() {
            return (UUID[])XbufUUIDArrayField.this.getValue();
        }

        public final boolean hasNext() {
            UUID[] value = (UUID[])XbufUUIDArrayField.this.getValue();
            return value != null && this.current < value.length;
        }

        public UUID next() {
            UUID[] val = (UUID[])XbufUUIDArrayField.this.getValue();
            if (val == null) {
                throw new NoSuchElementException();
            }
            return ((UUID[])XbufUUIDArrayField.this.getValue())[this.current++];
        }

        public final void remove() {
            throw new UnsupportedOperationException("remove is not supported for xbuf field iterators.");
        }

        public final Iterator toFirst() {
            this.current = 0;
            return this;
        }

        final short getFieldId() {
            return XbufUUIDArrayField.this.id;
        }

        final boolean allowsNullValues() {
            return XbufUUIDArrayField.this.allowNullValues;
        }

        final XbufField.NullValueCheckPolicy nullValueCheckPolicy() {
            return XbufUUIDArrayField.this.nullValueCheckPolicy;
        }
    }
}

